local shortcut_name = 'alert-toggler-toggle-gui'
local gui_name = 'alert-toggler-gui'
local close_button_name = 'alert-toggler-close-button'

local function close_gui(player)
    if player.gui.screen[gui_name] then
        player.gui.screen[gui_name].destroy()
    end
end

local function open_gui(player)
    local frame =
        player.gui.screen.add(
        {
            name = gui_name,
            type = 'frame',
            caption = {'alert-toggler.gui-title'},
            direction = 'vertical'
        }
    )

    frame.auto_center = true

    local table =
        frame.add(
        {
            type = 'table',
            column_count = 3
        }
    )

    -- table header
    table.add(
        {
            type = 'label',
            caption = {'alert-toggler.alert-type'}
        }
    )
    table.add(
        {
            type = 'label',
            caption = {'alert-toggler.mute'}
        }
    )
    table.add(
        {
            type = 'label',
            caption = {'alert-toggler.disable'}
        }
    )

    -- checkboxes
    local alert_types = defines.alert_type
    for alert_type, alert_type_index in pairs(alert_types) do
        local prefix = 'alert-toggler-' .. alert_type .. '-'

        table.add(
            {
                type = 'label',
                caption = alert_type
            }
        )
        table.add(
            {
                type = 'checkbox',
                state = player.is_alert_muted(alert_type_index),
                name = prefix .. 'mute'
            }
        )
        table.add(
            {
                type = 'checkbox',
                state = not player.is_alert_enabled(alert_type_index),
                name = prefix .. 'disable'
            }
        )
    end

    frame.add(
        {
            type = 'button',
            mouse_button_filter = {'left'},
            caption = {'alert-toggler.close'},
            name = close_button_name
        }
    )
end

local function toggle_gui(event)
    local player = game.players[event.player_index]
    local is_toggled = player.is_shortcut_toggled(shortcut_name)

    if is_toggled then
        close_gui(player)
    else
        player.opened = nil
        open_gui(player)
    end

    player.set_shortcut_toggled(shortcut_name, not is_toggled)
end

local function on_shortcut(event)
    if event.prototype_name ~= shortcut_name then
        return
    end

    toggle_gui(event)
end

-- close alerts gui when other gui opens
local function on_gui_opened(event)
    if event.element and event.element.name == gui_name then
        return
    end

    if game.players[event.player_index].is_shortcut_toggled(shortcut_name) then
        toggle_gui(event)
    end
end

local function on_checkbox_toggle(event)
    local checkbox_name = event.element.name

    if string.find(checkbox_name, 'alert%-toggler-') ~= 1 then
        return
    end

    local player = game.players[event.player_index]
    local is_changing_mute = string.find(checkbox_name, 'mute') ~= nil -- mute or disable
    local state = event.element.state

    local alert_types = defines.alert_type
    for alert_type, alert_type_index in pairs(alert_types) do
        if string.find(checkbox_name, alert_type) ~= nil then
            if is_changing_mute then
                if state then
                    player.mute_alert(alert_type_index)
                else
                    player.unmute_alert(alert_type_index)
                end
            else
                if state then
                    player.disable_alert(alert_type_index)
                else
                    player.enable_alert(alert_type_index)
                end
            end
        end
    end
end

local function on_gui_click(event)
    if event.element and event.element.name == close_button_name then
        toggle_gui(event)
    end
end

script.on_event(defines.events.on_lua_shortcut, on_shortcut)
script.on_event(defines.events.on_gui_opened, on_gui_opened)
script.on_event(defines.events.on_gui_checked_state_changed, on_checkbox_toggle)
script.on_event(defines.events.on_gui_click, on_gui_click)
script.on_event('alert-toggler-toggle-gui-input', toggle_gui)
