#version 330 compatibility

/*
 _______ _________ _______  _______  _
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/

/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////











const int 		shadowMapResolution 	= 4096;
const float 	shadowDistance 			= 120.0; // Shadow distance. Set lower if you prefer nicer close shadows. Set higher if you prefer nicer distant shadows. [80.0 120.0 180.0 240.0]
const float 	shadowIntervalSize 		= 1.0f;
const bool 		shadowHardwareFiltering0 = true;

const bool 		shadowtexMipmap = true;
const bool 		shadowtex1Mipmap = false;
const bool 		shadowtex1Nearest = false;
const bool 		shadowcolor0Mipmap = false;
const bool 		shadowcolor0Nearest = false;
const bool 		shadowcolor1Mipmap = false;
const bool 		shadowcolor1Nearest = false;

const float shadowDistanceRenderMul = 1.0f;

const int 		RGB8 					= 0;
const int 		RGBA8 					= 0;
const int 		RGBA16 					= 0;
const int 		RGBA16F 				= 0;
const int 		RGBA32F 				= 0;
const int 		RG16 					= 0;
const int 		RGB16 					= 0;
const int 		R11F_G11F_B10F 			= 0;
const int 		colortex0Format 			= RGBA8;
const int 		colortex1Format 			= RGBA16;
const int 		colortex2Format 			= RGBA16;
const int 		colortex3Format 			= RGBA16;
const int 		colortex4Format 			= RGBA32F;
const int 		colortex5Format 			= RGBA32F;
const int 		colortex6Format 			= RGBA32F;
const int 		colortex7Format 			= RGBA16F;

const bool colortex3Clear = false;
const bool colortex4Clear = false;
const bool colortex5Clear = false;
const bool colortex6Clear = false;

const int 		superSamplingLevel 		= 0;

const float		sunPathRotation 		= -40.0f;

const int 		noiseTextureResolution  = 64;

const float 	ambientOcclusionLevel 	= 0.06f;



const float wetnessHalflife = 100.0;
const float drynessHalflife = 100.0;




in vec4 texcoord;

in vec3 lightVector;
in vec3 worldLightVector;
in vec3 worldSunVector;

in float timeMidnight;

in vec3 colorSunlight;
in vec3 colorSkylight;
in vec3 colorSkyUp;
in vec3 colorTorchlight;

in vec4 skySHR;
in vec4 skySHG;
in vec4 skySHB;









#include "lib/Uniforms.inc"
#include "lib/Common.inc"
#include "lib/Materials.inc"



/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


// vec4 GetViewPosition(in vec2 coord, in float depth) 
// {	
// 	vec2 tcoord = coord;
// 	TemporalJitterProjPosInv01(tcoord);

// 	vec4 fragposition = gbufferProjectionInverse * vec4(tcoord.s * 2.0f - 1.0f, tcoord.t * 2.0f - 1.0f, 2.0f * depth - 1.0f, 1.0f);
// 		 fragposition /= fragposition.w;

	
// 	return fragposition;
// }




/////////////////////////STRUCTS///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////STRUCTS///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


#include "lib/GBufferData.inc"






/////////////////////////STRUCT FUNCTIONS//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////STRUCT FUNCTIONS//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////




vec2 Texcoord;





vec3 WorldPosToShadowProjPosBias(vec3 worldPos, vec3 worldNormal, out float dist, out float distortFactor)
{
	vec3 sn = normalize((shadowModelView * vec4(worldNormal.xyz, 0.0)).xyz) * vec3(1, 1, -1);

	vec4 sp = (shadowModelView * vec4(worldPos, 1.0));
	sp = shadowProjection * sp;
	sp /= sp.w;

	dist = sqrt(sp.x * sp.x + sp.y * sp.y);
	distortFactor = (1.0f - SHADOW_MAP_BIAS) + dist * SHADOW_MAP_BIAS;

	sp.xyz += sn * 0.002 * distortFactor;
	sp.xy *= 0.95f / distortFactor;
	sp.z = mix(sp.z, 0.5, 0.8);
	sp = sp * 0.5f + 0.5f;		//Transform from shadow space to shadow map coordinates


	//move to quadrant
	sp.xy *= 0.5;
	sp.xy += 0.5;

	return sp.xyz;
}

vec3 CalculateSunlightVisibility(vec4 screenSpacePosition, MaterialMask frnQIYJjVJ, vec3 worldGeoNormal, 
	float parallaxOffset) 
{
	// if (rainStrength >= 0.99f)
		// return vec3(1.0f);



	//if (shadingStruct.directionect > 0.0f) {
		float distance = sqrt(  screenSpacePosition.x * screenSpacePosition.x 	//Get surface distance in meters
							  + screenSpacePosition.y * screenSpacePosition.y
							  + screenSpacePosition.z * screenSpacePosition.z);

		vec4 ssp = screenSpacePosition;

		// if (isEyeInWater > 0.5)
		// {
		// 	ssp.xy *= 0.82;
		// }

		vec3 worldPos = (gbufferModelViewInverse * ssp).xyz;

		// worldPos += worldGeoNormal * 0.04;

		if (frnQIYJjVJ.grass > 0.5)
		{
			worldGeoNormal.xyz = vec3(0, 1, 0);
		}


		float dist;
		float distortFactor;
		vec3 shadowProjPos = WorldPosToShadowProjPosBias(worldPos.xyz, worldGeoNormal, dist, distortFactor);

		// float fademult = 0.15f;
			// shadowMult = clamp((shadowDistance * 1.4f * fademult) - (distance * fademult), 0.0f, 1.0f);	//Calculate shadowMult to fade shadows out

		float shadowMult = 1.0;

		float shading = 0.0;
		vec3 result = vec3(0.0);

		if (shadowMult > 0.0) 
		{

			float diffthresh = dist * 1.0f + 0.10f;
				  diffthresh *= 2.0f / (shadowMapResolution / 2048.0f);
			// diffthresh = 0.0;
				  //diffthresh /= shadingStruct.directionect + 0.1f;


			// shadowProjPos.xyz += shadowNormal * 0.0004 * (dist + 0.5);




			float vpsSpread = 0.105 / distortFactor;

			float avgDepth = 0.0;
			float minDepth = 11.0;
			int c;

			for (int i = -1; i <= 1; i++)
			{
				for (int j = -1; j <= 1; j++)
				{
					vec2 lookupCoord = shadowProjPos.xy + (vec2(i, j) / shadowMapResolution) * 8.0 * vpsSpread;
					//avgDepth += pow(texture2DLod(shadowtex1, lookupCoord, 2).x, 4.1);
					float depthSample = texture2DLod(shadowtex1, lookupCoord, 2).x;
					minDepth = min(minDepth, depthSample);
					avgDepth += pow(min(max(0.0, shadowProjPos.z - depthSample) * 1.0, 0.025), 2.0);
					c++;
				}
			}

			avgDepth /= c;
			avgDepth = pow(avgDepth, 1.0 / 2.0);

			// float penumbraSize = min(abs(shadowProjPos.z - minDepth), 0.15);
			float penumbraSize = avgDepth;

			//if (frnQIYJjVJ.leaves > 0.5)
			//{
				//penumbraSize = 0.02;
			//}

			int count = 0;
			float spread = penumbraSize * 0.055 * vpsSpread + 0.55 / shadowMapResolution;


			vec3 noise = BlueNoiseTemporal(Texcoord.st);

			diffthresh *= 0.5 + avgDepth * 50.0;
			// diffthresh *= 20.0;



			const int latSamples = 5;
			const int lonSamples = 5;

			// shadowProjPos.xyz += shadowNormal * diffthresh * 0.001;
			// shadowProjPos.xyz += shadowNormal * diffthresh * 0.001;

			float dfs = 0.00022 * dist + (noise.z * 0.00005) + 0.00002 + avgDepth * 0.012 + 0.0002 * parallaxOffset;

			for (int i = 0; i < 25; i++)
			{
				float fi = float(i + noise.x) * 0.1;
				float r = float(i + noise.x) * 3.14159265 * 2.0 * 1.61;

				vec2 radialPos = vec2(cos(r), sin(r));
				vec2 coordOffset = radialPos * spread * sqrt(fi) * 2.0;

				
				// shading += shadow2DLod(shadowtex0, vec3(shadowProjPos.st + coordOffset, shadowProjPos.z - 0.0012f * diffthresh - (noise.z * 0.00005)), 0).x;
				shading += shadow2DLod(shadowtex0, vec3(shadowProjPos.st + coordOffset, shadowProjPos.z - dfs), 0).x;
				count += 1;
			}
			shading /= count;

			shading = saturate(shading * (1.0 + avgDepth 
					* 5.0 
					* (1.0 / (abs(dot(worldGeoNormal, worldLightVector)) + 0.001))
					));

			result = vec3(shading);


			// stained glass shadow
			{
				float stainedGlassShadow = shadow2DLod(shadowtex0, vec3(shadowProjPos.st - vec2(0.5, 0.0), shadowProjPos.z - 0.0012 * diffthresh), 2).x;
				vec3 stainedGlassColor = texture2DLod(shadowcolor, vec2(shadowProjPos.st - vec2(0.5, 0.0)), 2).rgb;
				stainedGlassColor *= stainedGlassColor;
				result = mix(result, result * stainedGlassColor, vec3(1.0 - stainedGlassShadow));

				// result = mix(result, vec3(0.0), vec3(1.0 - stainedGlassShadow));
			}

			// CAUSTICS
			// water shadow (caustics)
			{
				// float waterDepth = abs(texture2DLod(shadowcolor1, shadowProjPos.st - vec2(0.0, 0.5), 4).x * 256.0 - (worldPos.y + cameraPosition.y));
				float waterDepth = abs(texture2DLod(shadowcolor1, shadowProjPos.st - vec2(0.0, 0.5), 3).x * 256.0 - (worldPos.y + cameraPosition.y));

				// float caustics = GetCausticsDeferred(worldPos, waterDepth);
				vec3 caustics = vec3(0.0);
				caustics.r = GetCausticsDeferred(worldPos, 										worldLightVector, waterDepth);
				// caustics.g = GetCausticsDeferred(worldPos + vec3(0.003 * waterDepth, 0.0, 0.0), worldLightVector, waterDepth);
				// caustics.b = GetCausticsDeferred(worldPos + vec3(0.006 * waterDepth, 0.0, 0.0), worldLightVector, waterDepth);
				caustics.g = caustics.r;
				caustics.b = caustics.r;

				float waterShadow = shadow2DLod(shadowtex0, vec3(shadowProjPos.st - vec2(0.0, 0.5), shadowProjPos.z - 0.0012 * diffthresh - noise.z * 0.0001), 3).x;
				result = mix(result, 
					// result * caustics * exp(-GetWaterAbsorption() * waterDepth), 
					result * caustics, 
					vec3(1.0 - waterShadow));
			}
		}



		result = mix(vec3(1.0), result, shadowMult);





		return result;
	//} else {
	//	return vec3(0.0f);
	//}
}


vec3 SubsurfaceScatteringSunlight(vec3 worldNormal, vec3 worldPos, vec3 albedo)
{
	vec4 shadowProjPos = shadowModelView * vec4(worldPos.xyz, 1.0);	//Transform from world space to shadow space
	shadowProjPos = shadowProjection * shadowProjPos;
	shadowProjPos /= shadowProjPos.w;

	float dist = sqrt(shadowProjPos.x * shadowProjPos.x + shadowProjPos.y * shadowProjPos.y);
	float distortFactor = (1.0f - SHADOW_MAP_BIAS) + dist * SHADOW_MAP_BIAS;
	shadowProjPos.xy *= 0.95f / distortFactor;
	shadowProjPos.z = mix(shadowProjPos.z, 0.5, 0.8);
	shadowProjPos = shadowProjPos * 0.5f + 0.5f;		//Transform from shadow space to shadow map coordinates

	//move to quadrant
	shadowProjPos.xy *= 0.5;
	shadowProjPos.xy += 0.5;

	float subsurfaceDepth = 0.0;
	float depthThresh = 0.0005;
	float weights = 0.0;

	vec2 dither = BlueNoiseTemporal(Texcoord.st).xy - 0.5;

	for (int i = -1; i <= 1; i++)
	{
		for (int j = -1; j <= 1; j++)
		{
			vec2 coordOffset = vec2(i + dither.x, j + dither.y) * 0.001;
			subsurfaceDepth += max(0.0, (shadowProjPos.z - texture2DLod(shadowtex1, shadowProjPos.xy + coordOffset, 0).x) / depthThresh);
			weights += 1.0;
		}
	}

	subsurfaceDepth /= weights;

	// subsurfaceDepth = exp(-subsurfaceDepth * 10.0);

	vec3 subsurfaceColor = 1.0 - (normalize(albedo.rgb + 0.000001) * 0.3);
	// vec3 subsurfaceColor = 1.0 - (albedo.rgb * 0.5);
	// vec3 subsurfaceColor = 1.0 - (albedo.rgb * 0.8);
	// vec3 subsurfaceColor = 1.0 - vec3(0.7, 0.5, 0.1);
	vec3 sss = exp(-subsurfaceDepth * subsurfaceColor * 6.0) * (1.0 - subsurfaceColor);

	return sss * 24.0 * colorSunlight;
}


float ScreenSpaceShadow(vec3 origin, float depth, vec3 viewDir, vec3 normal, MaterialMask frnQIYJjVJ)
{
	if (frnQIYJjVJ.sky > 0.5)
	{
		return 1.0;
	}
	


	float fov = 2.0*atan( 1.0/gbufferProjection[1][1] ) * 180.0 / 3.14159265;

	vec3 rayPos = origin;
	vec3 rayDir = lightVector 
		* -origin.z
		* 0.000035 * fov
		;


	float NdotL = saturate(dot(lightVector, normal));

	if (frnQIYJjVJ.grass < 0.5 && frnQIYJjVJ.leaves < 0.5) 
	{
		rayPos += normal * 0.00001 * -origin.z * fov * 0.15;
		rayPos += rayDir * 13000.0 * min(ScreenTexel.x, ScreenTexel.y) * 0.15;
		// rayPos += rayDir * 2.0;
	}


	float randomness = rand(Texcoord.st + sin(frameTimeCounter)).x;


	float zThickness = 0.025 * -origin.z;
	float shadow = 1.0;
	float numSamplesf = 64.0;
	int numSamples = int(numSamplesf);
	float absorption = 0.0;
	if (frnQIYJjVJ.grass > 0.5)
	{
		absorption = 0.5;
	}
	if (frnQIYJjVJ.leaves > 0.5)
	{
		absorption = 0.85;
	}
	absorption = pow(absorption, sqrt(length(origin)) * 0.5);



	float ds = 1.0;
	for (int i = 0; i < 12; i++)
	{
		float fi = float(i) / float(12);
		
		rayPos += rayDir * ds;
		ds += 0.3;

		vec3 thisRayPos = rayPos + rayDir * randomness * ds;

		vec2 rayProjPos = ProjectBack(thisRayPos).xy;

		rayProjPos *= 0.5;
		TemporalJitterProjPos01(rayProjPos);
		rayProjPos *= 2.0;
		
		vec3 samplePos = GetViewPositionNoJitter(rayProjPos.xy, GetDepth(DownscaleTexcoord(rayProjPos.xy))).xyz; // half res rendering fix

		float depthDiff = samplePos.z - thisRayPos.z;

		if (depthDiff > 0.0 && depthDiff < zThickness
		)
		{
			shadow *= absorption;
		}
	}

	return shadow;




































}


float OrenNayar(vec3 normal, vec3 eyeDir, vec3 lightDir)
{
	const float PI = 3.14159;
	const float roughness = 0.55;

	// interpolating normals will change the length of the normal, so renormalize the normal.



	// normal = normalize(normal + surface.lightVector * pow(clamp(dot(eyeDir, surface.lightVector), 0.0, 1.0), 5.0) * 0.5);

	// normal = normalize(normal + eyeDir * clamp(dot(normal, eyeDir), 0.0f, 1.0f));

	// calculate intermediary values
	float NdotL = dot(normal, lightDir);
	float NdotV = dot(normal, eyeDir);

	float angleVN = acos(NdotV);
	float angleLN = acos(NdotL);

	float alpha = max(angleVN, angleLN);
	float beta = min(angleVN, angleLN);
	float gamma = dot(eyeDir - normal * dot(eyeDir, normal), lightDir - normal * dot(lightDir, normal));

	float roughnessSquared = roughness * roughness;

	// calculate A and B
	float A = 1.0 - 0.5 * (roughnessSquared / (roughnessSquared + 0.57));

	float B = 0.45 * (roughnessSquared / (roughnessSquared + 0.09));

	float C = sin(alpha) * tan(beta);

	// put it all together
	float L1 = max(0.0, NdotL) * (A + B * max(0.0, gamma) * C);

	//return max(0.0f, surface.NdotL * 0.99f + 0.01f);
	return clamp(L1, 0.0f, 1.0f);
}





float GetCoverage(in float coverage, in float density, in float clouds)
{
	clouds = clamp(clouds - (1.0f - coverage), 0.0f, 1.0f -density) / (1.0f - density);
		clouds = max(0.0f, clouds * 1.1f - 0.1f);
	 clouds = clouds = clouds * clouds * (3.0f - 2.0f * clouds);
	 // clouds = pow(clouds, 1.0f);
	return clouds;
}

float   CalculateSunglow(vec3 npos, vec3 lightVector) {

	float curve = 4.0f;

	vec3 halfVector2 = normalize(-lightVector + npos);
	float factor = 1.0f - dot(halfVector2, npos);

	return factor * factor * factor * factor;
}

float G1V(float dotNV, float k)
{
	return 1.0 / (dotNV * (1.0 - k) + k);
}

vec3 SpecularGGX(vec3 N, vec3 V, vec3 L, float roughness, float F0)
{
	float alpha = roughness * roughness;

	vec3 H = normalize(V + L);

	float dotNL = saturate(dot(N, L));
	float dotNV = saturate(dot(N, V));
	float dotNH = saturate(dot(N, H));
	float dotLH = saturate(dot(L, H));

	float F, D, vis;

	float alphaSqr = alpha * alpha;
	float pi = 3.14159265359;
	float denom = dotNH * dotNH * (alphaSqr - 1.0) + 1.0;
	D = alphaSqr / (pi * denom * denom);

	float dotLH5 = pow(1.0f - dotLH, 5.0);
	F = F0 + (1.0 - F0) * dotLH5;

	float k = alpha / 2.0;
	vis = G1V(dotNL, k) * G1V(dotNV, k);

	vec3 specular = vec3(dotNL * D * F * vis) * colorSunlight;

	//specular = vec3(0.1);
	#ifndef PHYSICALLY_BASED_MAX_ROUGHNESS
	specular *= saturate(pow(1.0 - roughness, 0.7) * 2.0);
	#endif


	return specular;
}




 int f(int v)
 {
   return v-FloorToInt(mod(float(v),2.))-0;
 }
 int t(int v)
 {
   return v-FloorToInt(mod(float(v),2.))-1;
 }
 int f()
 {
   ivec2 v=ivec2(viewWidth,viewHeight);
   int x=v.x*v.y;
   return f(FloorToInt(floor(pow(float(x),.333333))));
 }
 int t()
 {
   ivec2 v=ivec2(2048,2048);
   int x=v.x*v.y;
   return t(FloorToInt(floor(pow(float(x),.333333))));
 }
 vec3 d(vec2 v)
 {
   ivec2 s=ivec2(viewWidth,viewHeight);
   int x=s.x*s.y,z=f();
   ivec2 n=ivec2(v.x*s.x,v.y*s.y);
   float y=float(n.y/z),i=float(int(n.x+mod(s.x*y,z))/z);
   i+=floor(s.x*y/z);
   vec3 m=vec3(0.,0.,i);
   m.x=mod(n.x+mod(s.x*y,z),z);
   m.y=mod(n.y,z);
   m.xyz=floor(m.xyz);
   m/=z;
   m.xyz=m.xzy;
   return m;
 }
 vec2 v(vec3 v)
 {
   ivec2 m=ivec2(viewWidth,viewHeight);
   int x=f();
   vec3 i=v.xzy*x;
   i=floor(i+1e-05);
   float y=i.z;
   vec2 n;
   n.x=mod(i.x+y*x,m.x);
   float s=i.x+y*x;
   n.y=i.y+floor(s/m.x)*x;
   n+=.5;
   n/=m;
   return n;
 }
 vec3 n(vec2 v)
 {
   vec2 i=v;
   i.xy/=.5;
   ivec2 s=ivec2(2048,2048);
   int x=s.x*s.y,z=t();
   ivec2 n=ivec2(i.x*s.x,i.y*s.y);
   float y=float(n.y/z),r=float(int(n.x+mod(s.x*y,z))/z);
   r+=floor(s.x*y/z);
   vec3 f=vec3(0.,0.,r);
   f.x=mod(n.x+mod(s.x*y,z),z);
   f.y=mod(n.y,z);
   f.xyz=floor(f.xyz);
   f/=z;
   f.xyz=f.xzy;
   return f;
 }
 vec2 d(vec3 v,int z)
 {
   v=clamp(v,vec3(0.),vec3(1.));
   vec2 m=vec2(2048,2048);
   vec3 i=v.xzy*z;
   i=floor(i+1e-05);
   float x=i.z;
   vec2 f;
   f.x=mod(i.x+x*z,m.x);
   float s=i.x+x*z;
   f.y=i.y+floor(s/m.x)*z;
   f+=.5;
   f/=m;
   f.xy*=.5;
   return f;
 }
 vec3 f(vec3 v,int z)
 {
   return v*=1./z,v=v+vec3(.5),v=clamp(v,vec3(0.),vec3(1.)),v;
 }
 vec3 n(vec3 v,int z)
 {
   return v*=1./z,v=v+vec3(.5),v;
 }
 vec3 m(vec3 v)
 {
   int x=t();
   v=v-vec3(.5);
   v*=x;
   return v;
 }
 vec3 s(vec3 v)
 {
   int x=f();
   v*=1./x;
   v=v+vec3(.5);
   v=clamp(v,vec3(0.),vec3(1.));
   return v;
 }
 vec3 r(vec3 v)
 {
   int x=f();
   v=v-vec3(.5);
   v*=x;
   return v;
 }
 vec3 d()
 {
   vec3 v=cameraPosition.xyz+.5,x=previousCameraPosition.xyz+.5,z=floor(v-.0001),i=floor(x-.0001);
   return z-i;
 }
 vec3 x(vec3 v)
 {
   vec4 i=vec4(v,1.);
   i=shadowModelView*i;
   i=shadowProjection*i;
   i/=i.w;
   float x=sqrt(i.x*i.x+i.y*i.y),z=1.f-SHADOW_MAP_BIAS+x*SHADOW_MAP_BIAS;
   i.xy*=.95f/z;
   i.z=mix(i.z,.5,.8);
   i=i*.5f+.5f;
   i.xy*=.5;
   i.xy+=.5;
   return i.xyz;
 }
 vec3 d(vec3 v,vec3 i,vec2 s,vec2 n,vec4 f,vec4 x,inout float z,out vec2 r)
 {
   bool y=fract(v.x*2.)>.01&&fract(v.x*2.)<.99||fract(v.y*2.)>.01&&fract(v.y*2.)<.99||fract(v.z*2.)>.01&&fract(v.z*2.)<.99;
   y=!y;
   if(x.x==8||x.x==9||x.x==79||x.x<1.||!y||x.x==20.||x.x==171.||min(abs(i.x),abs(i.z))>.2)
     z=1.;
   if(x.x==50.||x.x==52.||x.x==76.)
     {
       z=0.;
       if(i.y<.5)
         z=1.;
     }
   if(x.x==51||x.x==53)
     z=0.;
   if(x.x>255)
     z=0.;
   vec3 m,c;
   if(i.x>.5)
     m=vec3(0.,0.,-1.),c=vec3(0.,-1.,0.);
   else
      if(i.x<-.5)
       m=vec3(0.,0.,1.),c=vec3(0.,-1.,0.);
     else
        if(i.y>.5)
         m=vec3(1.,0.,0.),c=vec3(0.,0.,1.);
       else
          if(i.y<-.5)
           m=vec3(1.,0.,0.),c=vec3(0.,0.,-1.);
         else
            if(i.z>.5)
             m=vec3(1.,0.,0.),c=vec3(0.,-1.,0.);
           else
              if(i.z<-.5)
               m=vec3(-1.,0.,0.),c=vec3(0.,-1.,0.);
   r=clamp((s.xy-n.xy)*100000.,vec2(0.),vec2(1.));
   float t=.15,w=.15;
   if(x.x==10.||x.x==11.)
     {
       if(abs(i.y)<.01&&y||i.y>.99)
         t=.1,w=.1,z=0.;
       else
          z=1.;
     }
   if(x.x==51||x.x==53)
     t=.5,w=.1;
   if(x.x==76)
     t=.2,w=.2;
   if(x.x-255.+39.>=103.&&x.x-255.+39.<=113.)
     w=.025,t=.025;
   m=normalize(f.xyz);
   c=normalize(cross(m,i.xyz)*sign(f.w));
   vec3 o=v.xyz+mix(m*t,-m*t,vec3(r.x));
   o.xyz+=mix(c*t,-c*t,vec3(r.y));
   o.xyz-=i.xyz*w;
   return o;
 }struct rXuEJcsNQI{vec3 QbpObHBdUl;vec3 QbpObHBdUlOrigin;vec3 ZRrfSsHfvT;vec3 fgCeZiNBHZ;vec3 ZKdJsVHIyK;vec3 frnQIYJjVJ;};
 rXuEJcsNQI e(Ray v)
 {
   rXuEJcsNQI i;
   i.QbpObHBdUl=floor(v.origin);
   i.QbpObHBdUlOrigin=i.QbpObHBdUl;
   i.ZRrfSsHfvT=abs(vec3(length(v.direction))/(v.direction+1e-07));
   i.fgCeZiNBHZ=sign(v.direction);
   i.ZKdJsVHIyK=(sign(v.direction)*(i.QbpObHBdUl-v.origin)+sign(v.direction)*.5+.5)*i.ZRrfSsHfvT;
   i.frnQIYJjVJ=vec3(0.);
   return i;
 }
 void p(inout rXuEJcsNQI v)
 {
   v.frnQIYJjVJ=step(v.ZKdJsVHIyK.xyz,v.ZKdJsVHIyK.yzx)*step(v.ZKdJsVHIyK.xyz,v.ZKdJsVHIyK.zxy),v.ZKdJsVHIyK+=v.frnQIYJjVJ*v.ZRrfSsHfvT,v.QbpObHBdUl+=v.frnQIYJjVJ*v.fgCeZiNBHZ;
 }
 void d(in Ray v,in vec3 i[2],out float f,out float z)
 {
   float x,y,r,n;
   f=(i[v.sign[0]].x-v.origin.x)*v.inv_direction.x;
   z=(i[1-v.sign[0]].x-v.origin.x)*v.inv_direction.x;
   x=(i[v.sign[1]].y-v.origin.y)*v.inv_direction.y;
   y=(i[1-v.sign[1]].y-v.origin.y)*v.inv_direction.y;
   r=(i[v.sign[2]].z-v.origin.z)*v.inv_direction.z;
   n=(i[1-v.sign[2]].z-v.origin.z)*v.inv_direction.z;
   f=max(max(f,x),r);
   z=min(min(z,y),n);
 }
 vec3 d(const vec3 v,const vec3 x,vec3 z)
 {
   const float i=1e-05;
   vec3 y=(x+v)*.5,n=(x-v)*.5,s=z-y,f=vec3(0.);
   f+=vec3(sign(s.x),0.,0.)*step(abs(abs(s.x)-n.x),i);
   f+=vec3(0.,sign(s.y),0.)*step(abs(abs(s.y)-n.y),i);
   f+=vec3(0.,0.,sign(s.z))*step(abs(abs(s.z)-n.z),i);
   return normalize(f);
 }
 bool e(const vec3 v,const vec3 x,Ray i,out vec2 f)
 {
   vec3 z=i.inv_direction*(v-i.origin),s=i.inv_direction*(x-i.origin),n=min(s,z),c=max(s,z);
   vec2 r=max(n.xx,n.yz);
   float m=max(r.x,r.y);
   r=min(c.xx,c.yz);
   float y=min(r.x,r.y);
   f.x=m;
   f.y=y;
   return y>max(m,0.);
 }
 bool d(const vec3 v,const vec3 i,Ray m,inout float z,inout vec3 x)
 {
   vec3 y=m.inv_direction*(v-1e-05-m.origin),s=m.inv_direction*(i+1e-05-m.origin),n=min(s,y),f=max(s,y);
   vec2 r=max(n.xx,n.yz);
   float t=max(r.x,r.y);
   r=min(f.xx,f.yz);
   float c=min(r.x,r.y);
   bool a=c>max(t,0.)&&max(t,0.)<z;
   if(a)
     x=d(v-1e-05,i+1e-05,m.origin+m.direction*t),z=t;
   return a;
 }
 vec3 e(vec3 v,vec3 i,vec3 z,vec3 y,int n)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v+=1.;
   v-=Fract01(cameraPosition+.5);
   vec3 s=x(v);
   float t=.5;
   vec3 f=vec3(1.)*shadow2DLod(shadowtex0,vec3(s.xy,s.z-.0006*t),2).x;
   f*=saturate(dot(i,z));
   {
     vec4 m=texture2DLod(shadowcolor1,s.xy-vec2(0.,.5),4);
     float r=abs(m.x*256.-(v.y+cameraPosition.y)),c=GetCausticsComposite(v,i,r),w=shadow2DLod(shadowtex0,vec3(s.xy-vec2(0.,.5),s.z+1e-06),4).x;
     f=mix(f,f*c,1.-w);
   }
   f=TintUnderwaterDepth(f);
   return f*(1.-rainStrength);
 }
 vec3 f(vec3 v,vec3 i,vec3 z,vec3 y,int n)
 {
   if(rainStrength>.99)
     return vec3(0.);
   vec3 f=m(v);
   f+=1.;
   f-=Fract01(cameraPosition+.5);
   vec3 s=x(f+z*.99);
   float t=.5;
   vec3 r=vec3(1.)*shadow2DLod(shadowtex0,vec3(s.xy,s.z-.0006*t),3).x;
   r*=saturate(dot(i,z));
   r=TintUnderwaterDepth(r);
   #ifdef GI_SUNLIGHT_STAINED_GLASS_TINT
   float w=shadow2DLod(shadowtex0,vec3(s.xy-vec2(.5,0.),s.z-.0006*t),3).x;
   vec3 c=texture2DLod(shadowcolor,vec2(s.xy-vec2(.5,0.)),3).xyz;
   c*=c;
   r=mix(r,r*c,vec3(1.-w));
   #endif
   return r*(1.-rainStrength);
 }
 vec3 m(vec3 v,vec3 i,vec3 z,vec3 y,int n)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v+=1.;
   v-=Fract01(cameraPosition+.5);
   vec3 s=x(v);
   float t=.5;
   vec3 f=vec3(1.)*shadow2DLod(shadowtex0,vec3(s.xy,s.z-.0006*t),2).x;
   f*=saturate(dot(i,z));
   f=TintUnderwaterDepth(f);
   #ifdef GI_SUNLIGHT_STAINED_GLASS_TINT
   float r=shadow2DLod(shadowtex0,vec3(s.xy-vec2(.5,0.),s.z-.0006*t),3).x;
   vec3 m=texture2DLod(shadowcolor,vec2(s.xy-vec2(.5,0.)),3).xyz;
   m*=m;
   f=mix(f,f*m,vec3(1.-r));
   #endif
   return f*(1.-rainStrength);
 }struct awIafiSlNY{float mwtAZpOIMX;float KZGLOOTLva;float yDFXZDbcEk;float cvVAxIXMRt;vec3 jbwXZaPXmq;};
 vec4 h(awIafiSlNY v)
 {
   vec4 i;
   v.jbwXZaPXmq=max(vec3(0.),v.jbwXZaPXmq);
   i.x=v.mwtAZpOIMX;
   v.jbwXZaPXmq=pow(v.jbwXZaPXmq,vec3(.125));
   i.y=PackTwo16BitTo32Bit(v.jbwXZaPXmq.x,v.yDFXZDbcEk);
   i.z=PackTwo16BitTo32Bit(v.jbwXZaPXmq.y,v.cvVAxIXMRt);
   i.w=PackTwo16BitTo32Bit(v.jbwXZaPXmq.z,v.KZGLOOTLva/255.);
   return i;
 }
 awIafiSlNY w(vec4 v)
 {
   awIafiSlNY i;
   vec2 s=UnpackTwo16BitFrom32Bit(v.y),m=UnpackTwo16BitFrom32Bit(v.z),x=UnpackTwo16BitFrom32Bit(v.w);
   i.mwtAZpOIMX=v.x;
   i.yDFXZDbcEk=s.y;
   i.cvVAxIXMRt=m.y;
   i.KZGLOOTLva=x.y*255.;
   i.jbwXZaPXmq=pow(vec3(s.x,m.x,x.x),vec3(8.));
   return i;
 }
 awIafiSlNY i(vec2 v)
 {
   vec2 x=1./vec2(viewWidth,viewHeight),z=vec2(viewWidth,viewHeight);
   v=(floor(v*z)+.5)*x;
   return w(texture2DLod(colortex5,v,0));
 }
 float e(float v,float z)
 {
   float x=1.;
   #ifdef FULL_RT_REFLECTIONS
   x=clamp(pow(v,.125)+z,0.,1.);
   #else
   x=clamp(v*10.-7.,0.,1.);
   #endif
   return x;
 }
 bool d(vec3 v,float x,Ray z,bool i,inout float f,inout vec3 y)
 {
   bool m=false,r=false;
   #if RAYTRACE_GEOMETRY_QUALITY==0
   if(i)
     return false;
   if(x>=67.)
     return false;
   r=d(v,v+vec3(1.,1.,1.),z,f,y);
   m=r;
   #else
   if(x<40.)
     return r=d(v,v+vec3(1.,1.,1.),z,f,y),r;
   if(x==40.||x==41.||x>=43.&&x<=54.)
     {
       float s=.5;
       if(x==41.)
         s=.9375;
       r=d(v+vec3(0.,0.,0.),v+vec3(1.,s,1.),z,f,y);
       m=m||r;
     }
   if(x==42.||x>=55.&&x<=66.)
     r=d(v+vec3(0.,.5,0.),v+vec3(1.,1.,1.),z,f,y),m=m||r;
   if(x==43.||x==46.||x==47.||x==52.||x==53.||x==54.||x==55.||x==58.||x==59.||x==64.||x==65.||x==66.)
     {
       float s=.5;
       if(x==55.||x==58.||x==59.||x==64.||x==65.||x==66.)
         s=0.;
       r=d(v+vec3(0.,s,0.),v+vec3(.5,.5+s,.5),z,f,y);
       m=m||r;
     }
   if(x==43.||x==45.||x==48.||x==51.||x==53.||x==54.||x==55.||x==57.||x==60.||x==63.||x==65.||x==66.)
     {
       float s=.5;
       if(x==55.||x==57.||x==60.||x==63.||x==65.||x==66.)
         s=0.;
       r=d(v+vec3(.5,s,0.),v+vec3(1.,.5+s,.5),z,f,y);
       m=m||r;
     }
   if(x==44.||x==45.||x==49.||x==51.||x==52.||x==54.||x==56.||x==57.||x==61.||x==63.||x==64.||x==66.)
     {
       float s=.5;
       if(x==56.||x==57.||x==61.||x==63.||x==64.||x==66.)
         s=0.;
       r=d(v+vec3(.5,s,.5),v+vec3(1.,.5+s,1.),z,f,y);
       m=m||r;
     }
   if(x==44.||x==46.||x==50.||x==51.||x==52.||x==53.||x==56.||x==58.||x==62.||x==63.||x==64.||x==65.)
     {
       float s=.5;
       if(x==56.||x==58.||x==62.||x==63.||x==64.||x==65.)
         s=0.;
       r=d(v+vec3(0.,s,.5),v+vec3(.5,.5+s,1.),z,f,y);
       m=m||r;
     }
   if(x>=67.&&x<=82.)
     r=d(v+vec3(6.,0.,6.)/16.,v+vec3(10.,16.,10.)/16.,z,f,y),m=m||r;
   if(x==68.||x==69.||x==70.||x==72.||x==73.||x==74.||x==76.||x==77.||x==78.||x==80.||x==81.||x==82.)
     {
       float s=8.,c=8.;
       if(x==68.||x==70.||x==72.||x==74.||x==76.||x==78.||x==80.||x==82.)
         s=0.;
       if(x==69.||x==70.||x==73.||x==74.||x==77.||x==78.||x==81.||x==82.)
         c=16.;
       r=d(v+vec3(s,6.,7.)/16.,v+vec3(c,9.,9.)/16.,z,f,y);
       m=m||r;
       r=d(v+vec3(s,12.,7.)/16.,v+vec3(c,15.,9.)/16.,z,f,y);
       m=m||r;
     }
   if(x>=71.&&x<=82.)
     {
       float s=8.,t=8.;
       if(x>=71.&&x<=74.||x>=79.&&x<=82.)
         t=16.;
       if(x>=75.&&x<=82.)
         s=0.;
       r=d(v+vec3(7.,6.,s)/16.,v+vec3(9.,9.,t)/16.,z,f,y);
       m=m||r;
       r=d(v+vec3(7.,12.,s)/16.,v+vec3(9.,15.,t)/16.,z,f,y);
       m=m||r;
     }
   #if RAYTRACE_GEOMETRY_QUALITY==2
   if(x>=83.&&x<=86.)
     {
       vec3 s=vec3(0),c=vec3(0);
       if(x==83.)
         s=vec3(0,0,0),c=vec3(16,16,3);
       if(x==84.)
         s=vec3(0,0,13),c=vec3(16,16,16);
       if(x==86.)
         s=vec3(0,0,0),c=vec3(3,16,16);
       if(x==85.)
         s=vec3(13,0,0),c=vec3(16,16,16);
       r=d(v+s/16.,v+c/16.,z,f,y);
       m=m||r;
     }
   if(x>=87.&&x<=102.)
     {
       vec3 s=vec3(0.),c=vec3(1.);
       if(x>=87.&&x<=94.)
         {
           float t=0.;
           if(x>=91.&&x<=94.)
             t=13.;
           s=vec3(0.,t,0.)/16.;
           c=vec3(16.,t+3.,16.)/16.;
         }
       if(x>=95.&&x<=98.)
         {
           float t=13.;
           if(x==97.||x==98.)
             t=0.;
           s=vec3(0.,0.,t)/16.;
           c=vec3(16.,16.,t+3.)/16.;
         }
       if(x>=99.&&x<=102.)
         {
           float t=13.;
           if(x==99.||x==100.)
             t=0.;
           s=vec3(t,0.,0.)/16.;
           c=vec3(t+3.,16.,16.)/16.;
         }
       r=d(v+s,v+c,z,f,y);
       m=m||r;
     }
   if(x>=103.&&x<=113.)
     {
       vec3 s=vec3(0.),c=vec3(1.);
       if(x>=103.&&x<=110.)
         {
           float t=float(x)-float(103.)+1.;
           c.y=t*2./16.;
         }
       if(x==111.)
         c.y=.0625;
       if(x==112.)
         s=vec3(1.,0.,1.)/16.,c=vec3(15.,1.,15.)/16.;
       if(x==113.)
         s=vec3(1.,0.,1.)/16.,c=vec3(15.,.5,15.)/16.;
       r=d(v+s,v+c,z,f,y);
       m=m||r;
     }
   #endif
   #endif
   return m;
 }
 vec3 a(vec2 v)
 {
   vec2 x=vec2(v.xy*vec2(viewWidth,viewHeight));
   x*=1./64.;
   const vec2 i[16]=vec2[16](vec2(-1,-1),vec2(0,-.333333),vec2(-.5,.333333),vec2(.5,-.777778),vec2(-.75,-.111111),vec2(.25,.555556),vec2(-.25,-.555556),vec2(.75,.111111),vec2(-.875,.777778),vec2(.125,-.925926),vec2(-.375,-.259259),vec2(.625,.407407),vec2(-.625,-.703704),vec2(.375,-.037037),vec2(-.125,.62963),vec2(.875,-.481482));
   if(v.x<2./viewWidth||v.x>1.-2./viewWidth||v.y<2./viewHeight||v.y>1.-2./viewHeight)
     ;
   x=(floor(x*64.)+.5)/64.;
   vec3 f=texture2D(noisetex,x).xyz,z=vec3(sqrt(.2),sqrt(2.),1.61803);
   f=mod(f+float(frameCounter%64)*z,vec3(1.));
   return f;
 }
 vec3 y(vec3 v)
 {
   float x=fract(frameCounter*.0123456);
   int s=t(),z=f();
   vec3 m=BlueNoiseTemporal(Texcoord.xy).xyz,c=BlueNoiseTemporal(Texcoord.xy+.1).xyz,y=v,i=Fract01(cameraPosition.xyz+.5)+vec3(0.,0.,0.),r=i;
   i=f(i,s);
   Ray n=MakeRay(i*s-vec3(1.),y);
   vec3 w=vec3(1.),a=vec3(0.);
   for(int e=0;e<1;e++)
     {
       vec3 T=vec3(floor(n.origin)),h=abs(vec3(length(n.direction))/(n.direction+.0001)),o=sign(n.direction),p=(sign(n.direction)*(T-n.origin)+sign(n.direction)*.5+.5)*h,Y;
       vec4 F=vec4(0.);
       vec3 l=vec3(0.);
       float G=.5;
       for(int R=0;R<190;R++)
         {
           l=T/float(s);
           vec2 q=d(l,s);
           F=texture2DLod(shadowcolor,q,0);
           if(abs(F.w*255.-130.)<.5)
             a+=.06125*w*colorTorchlight*G;
           else
             {
               if(F.w*255.<254.f&&R!=0)
                 {
                   break;
                 }
             }
           Y=step(p.xyz,p.yzx)*step(p.xyz,p.zxy);
           p+=Y*h;
           T+=Y*o;
           G=1.;
         }
       a+=F.xyz;
     }
   a*=1.;
   return a;
 }
 vec3 a(vec3 x,vec3 z)
 {
   x+=Fract01(cameraPosition.xyz+.5)-.5;
   vec3 y=s(x+z*.1),f=i(v(y)).jbwXZaPXmq;
   return f;
 }
 vec3 a(vec2 v,vec3 z,float f,vec3 y)
 {
   vec3 x=texture2DLod(colortex7,v+vec2(0.,HalfScreen.y),0).xyz;
   return x;
 }
 void main()
 {
   Texcoord=texcoord.xy;
   GBufferData v=GetGBufferData(Texcoord);
   MaterialMask x=CalculateMasks(v.materialID,Texcoord);
   vec4 s=GetViewPosition(Texcoord.xy,v.depth),z=gbufferModelViewInverse*vec4(s.xyz,1.),i=gbufferModelViewInverse*vec4(s.xyz,0.);
   vec3 f=normalize(s.xyz),m=normalize(i.xyz),y=normalize((gbufferModelViewInverse*vec4(v.normal,0.)).xyz),c=normalize((gbufferModelViewInverse*vec4(v.geoNormal,0.)).xyz);
   float r=length(s.xyz);
   vec3 n=vec3(0.),t=y;
   if(x.grass>.5)
     y=vec3(0.,1.,0.);
   vec3 w=a(Texcoord.xy,v.normal,v.depth,s.xyz)*10.,T=w*v.albedo.xyz;
   const float h=75.;
   if(r>h)
     {
       vec3 F=FromSH(skySHR,skySHG,skySHB,y);
       F*=pow(v.mcLightmap.y,.5);
       vec3 R=F*v.albedo.xyz*4.5;
       const float G=3.7;
       R+=v.mcLightmap.x*colorTorchlight*v.albedo.xyz*.025*G;
       vec3 Y=normalize(v.albedo.xyz+.0001)*pow(length(v.albedo.xyz),1.)*colorSunlight*.13*v.mcLightmap.y;
       R+=Y*v.albedo.xyz*5.;
       float q=.3;
       T=mix(T,R,vec3(saturate(r*q-h*q)));
     }
   n.xyz=T+v.albedo.xyz*1e-05;
   #ifdef HELD_LIGHT
   {
     float G=float(heldBlockLightValue+heldBlockLightValue2)/16.,Y=OrenNayar(t,-m,-m),o=1./(dot(i.xyz,i.xyz)+.3);
     n+=v.albedo.xyz*G*o*Y*colorTorchlight*.3;
   }
   #endif
   #ifdef VISUALIZE_DANGEROUS_LIGHT_LEVEL
   {
     float G=BlockLightTorchLinear(v.mcLightmap.x)*16.;
     G=G;
     n.x+=G<=6.75?1.:0.;
   }
   #endif
   float G=24.*(1.-sqrt(wetness)),o=dot(y,worldLightVector),l=OrenNayar(y,-m,worldLightVector);
   if(x.leaves>.5)
     l=mix(l,.5,.5);
   if(x.grass>.5)
     v.metalness=0.;
   vec3 Y=CalculateSunlightVisibility(s,x,c,v.parallaxOffset);
   #ifdef SUNLIGHT_LEAK_FIX
   float F=saturate(v.mcLightmap.y*100.);
   if(isEyeInWater<1)
     Y*=F;
   #endif
   Y*=ScreenSpaceShadow(s.xyz,v.depth,f.xyz,v.geoNormal.xyz,x);
   n+=TintUnderwaterDepth(DoNightEyeAtNight(l*v.albedo.xyz*Y*G*colorSunlight,timeMidnight));
   vec3 R=SpecularGGX(y,-m,worldLightVector,1.-v.smoothness,v.metalness*.96+.04)*G*Y;
   R*=mix(vec3(1.),v.albedo.xyz,vec3(v.metalness));
   R*=mix(1.,.5,x.grass);
   if(isEyeInWater<.5)
     n*=1.-e(v.smoothness,v.metalness)*v.metalness,n+=DoNightEyeAtNight(R,timeMidnight);
   if(x.sky>.5||v.depth>1.)
     {
       vec3 p=m.xyz;
       if(isEyeInWater>0)
         p.xyz=refract(p.xyz,vec3(0.,-1.,0.),1.2533);
       vec3 q=SkyShading(p.xyz,worldSunVector.xyz,rainStrength);
       n=q;
       vec3 J=AtmosphereAbsorption(p.xyz,AtmosphereExtent);
       n+=v.albedo.xyz*J*.5;
       n+=RenderSunDisc(p,worldSunVector,colorSunlight)*J*2000.;
       CloudPlane(n,-p,worldLightVector,worldSunVector,colorSunlight,colorSkyUp,q,timeMidnight,true);
     }
   if(x.glowstone>.5)
     n.xyz+=v.albedo.xyz*GI_LIGHT_BLOCK_INTENSITY;
   if(x.torch>.5)
     n.xyz+=v.albedo.xyz*pow(length(v.albedo.xyz),2.)*.5*GI_LIGHT_TORCH_INTENSITY;
   if(x.lava>.5)
     n+=v.albedo.xyz*.75*GI_LIGHT_BLOCK_INTENSITY;
   if(x.fire>.5)
     n+=v.albedo.xyz*3.*GI_LIGHT_TORCH_INTENSITY;
   if(x.litFurnace>.5)
     {
       float q=saturate(v.albedo.x-(v.albedo.y+v.albedo.z)*.5-.2);
       n+=v.albedo.xyz*q*2.*GI_LIGHT_TORCH_INTENSITY*vec3(2.,.35,.025);
     }
   float q=0.;
   n*=.001;
   n=LinearToGamma(n);
   n+=rand(Texcoord.xy+sin(frameTimeCounter))*(1./65535.);
   gl_FragData[0]=vec4(n.xyz,1.);
 };




/* DRAWBUFFERS:1 */
