/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.client.inventory;

import de.siphalor.mousewheelie.MWConfig;
import de.siphalor.mousewheelie.client.MWClient;
import de.siphalor.mousewheelie.client.network.InteractionManager;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2596;
import net.minecraft.class_2838;
import net.minecraft.class_2868;

@Environment(value=EnvType.CLIENT)
public class SlotRefiller {
    private static class_1661 playerInventory;
    private static class_1799 stack;
    private static final ConcurrentLinkedDeque<Rule> rules;

    public static void set(class_1661 playerInventory, class_1799 stack) {
        SlotRefiller.playerInventory = playerInventory;
        SlotRefiller.stack = stack;
    }

    public static boolean refill() {
        Iterator<Rule> iterator = rules.descendingIterator();
        while (iterator.hasNext()) {
            int slot;
            Rule rule = iterator.next();
            if (!rule.matches(stack) || (slot = rule.findMatchingStack(playerInventory, stack)) == -1) continue;
            if (slot == SlotRefiller.playerInventory.field_7545) {
                return true;
            }
            if (slot < 9) {
                SlotRefiller.playerInventory.field_7545 = slot;
                InteractionManager.push(new InteractionManager.PacketEvent((class_2596<?>)new class_2868(slot)));
            } else {
                InteractionManager.push(new InteractionManager.PacketEvent((class_2596<?>)new class_2838(slot), triggerType -> triggerType == InteractionManager.TriggerType.CONTAINER_SLOT_UPDATE && MWClient.lastUpdatedSlot >= 36 && MWClient.lastUpdatedSlot < 45));
            }
            return true;
        }
        return false;
    }

    static {
        rules = new ConcurrentLinkedDeque();
        rules.add(new BlockRule());
        rules.add(new ItemGroupRule());
        rules.add(new ItemHierarchyRule());
        rules.add(new BlockHierarchyRule());
        rules.add(new FoodRule());
        rules.add(new EqualItemRule());
        rules.add(new EqualStackRule());
    }

    public static abstract class Rule {
        public Rule() {
            rules.add(this);
        }

        abstract boolean matches(class_1799 var1);

        abstract int findMatchingStack(class_1661 var1, class_1799 var2);

        protected int iterateInventory(class_1661 playerInventory, Function<class_1799, Boolean> consumer) {
            for (int i = 0; i < playerInventory.field_7547.size(); ++i) {
                if (!consumer.apply((class_1799)playerInventory.field_7547.get(i)).booleanValue()) continue;
                return i;
            }
            return -1;
        }
    }

    public static class BlockRule
    extends Rule {
        @Override
        boolean matches(class_1799 oldStack) {
            return MWConfig.refill.rules.anyBlock && oldStack.method_7909() instanceof class_1747;
        }

        @Override
        int findMatchingStack(class_1661 playerInventory, class_1799 oldStack) {
            return this.iterateInventory(playerInventory, stack -> stack.method_7909() instanceof class_1747);
        }
    }

    public static class ItemGroupRule
    extends Rule {
        @Override
        boolean matches(class_1799 oldStack) {
            return MWConfig.refill.rules.itemgroup && oldStack.method_7909().method_7859() != null;
        }

        @Override
        int findMatchingStack(class_1661 playerInventory, class_1799 oldStack) {
            class_1761 group = oldStack.method_7909().method_7859();
            return this.iterateInventory(playerInventory, stack -> stack.method_7909().method_7859() == group);
        }
    }

    public static class ItemHierarchyRule
    extends Rule {
        @Override
        boolean matches(class_1799 oldStack) {
            return MWConfig.refill.rules.itemHierarchy && oldStack.method_7909().getClass() != class_1792.class && !(oldStack.method_7909() instanceof class_1747);
        }

        @Override
        int findMatchingStack(class_1661 playerInventory, class_1799 oldStack) {
            Class<?> clazz;
            int currentRank = 0;
            ConcurrentLinkedQueue classes = new ConcurrentLinkedQueue();
            for (clazz = oldStack.method_7909().getClass(); clazz != class_1792.class; clazz = clazz.getSuperclass()) {
                classes.add(clazz);
            }
            int classesSize = classes.size();
            if (classesSize == 0) {
                return -1;
            }
            int index = -1;
            class_2371 mainInv = playerInventory.field_7547;
            block1: for (int i = 0; i < mainInv.size(); ++i) {
                for (clazz = ((class_1799)mainInv.get(i)).method_7909().getClass(); clazz != class_1792.class; clazz = clazz.getSuperclass()) {
                    Iterator iterator = classes.iterator();
                    for (int classRank = classesSize; iterator.hasNext() && classRank > 0; --classRank) {
                        if (classRank <= currentRank) continue block1;
                        if (!clazz.equals(iterator.next())) continue;
                        if (classRank >= classesSize) {
                            return i;
                        }
                        currentRank = classRank;
                        index = i;
                        continue block1;
                    }
                }
            }
            return index;
        }
    }

    public static class BlockHierarchyRule
    extends Rule {
        @Override
        boolean matches(class_1799 oldStack) {
            return MWConfig.refill.rules.blockHierarchy && oldStack.method_7909() instanceof class_1747;
        }

        @Override
        int findMatchingStack(class_1661 playerInventory, class_1799 oldStack) {
            Class<?> clazz;
            int currentRank = 0;
            ConcurrentLinkedQueue classes = new ConcurrentLinkedQueue();
            for (clazz = ((class_1747)oldStack.method_7909()).method_7711().getClass(); clazz != class_2248.class; clazz = clazz.getSuperclass()) {
                classes.add(clazz);
            }
            int classesSize = classes.size();
            if (classesSize == 0) {
                return -1;
            }
            int index = -1;
            class_2371 mainInv = playerInventory.field_7547;
            block1: for (int i = 0; i < mainInv.size(); ++i) {
                if (!(((class_1799)mainInv.get(i)).method_7909() instanceof class_1747)) continue;
                for (clazz = ((class_1747)((class_1799)mainInv.get(i)).method_7909()).method_7711().getClass(); clazz != class_2248.class; clazz = clazz.getSuperclass()) {
                    Iterator iterator = classes.iterator();
                    for (int classRank = classesSize; iterator.hasNext() && classRank > 0; --classRank) {
                        if (classRank <= currentRank) continue block1;
                        if (!clazz.equals(iterator.next())) continue;
                        if (classRank >= classesSize) {
                            return i;
                        }
                        currentRank = classRank;
                        index = i;
                        continue block1;
                    }
                }
            }
            return index;
        }
    }

    public static class FoodRule
    extends Rule {
        @Override
        boolean matches(class_1799 oldStack) {
            return MWConfig.refill.rules.food && oldStack.method_19267();
        }

        @Override
        int findMatchingStack(class_1661 playerInventory, class_1799 oldStack) {
            return this.iterateInventory(playerInventory, class_1799::method_19267);
        }
    }

    public static class EqualItemRule
    extends Rule {
        @Override
        boolean matches(class_1799 oldStack) {
            return MWConfig.refill.rules.equalItems;
        }

        @Override
        int findMatchingStack(class_1661 playerInventory, class_1799 oldStack) {
            class_1792 item = oldStack.method_7909();
            return this.iterateInventory(playerInventory, stack -> stack.method_7909() == item);
        }
    }

    public static class EqualStackRule
    extends Rule {
        @Override
        boolean matches(class_1799 oldStack) {
            return MWConfig.refill.rules.equalStacks;
        }

        @Override
        int findMatchingStack(class_1661 playerInventory, class_1799 oldStack) {
            return playerInventory.method_7371(oldStack);
        }
    }
}

