/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.radar.category;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.radar.category.serialization.EntityRadarCategorySerializationHandler;
import xaero.common.misc.Misc;

public final class EntityRadarCategoryFileIO {
    private final Path saveLocationPath;
    private final EntityRadarCategorySerializationHandler serializationHandler;

    private EntityRadarCategoryFileIO(@Nonnull Path saveLocationPath, @Nonnull EntityRadarCategorySerializationHandler serializationHandler) {
        this.saveLocationPath = saveLocationPath;
        this.serializationHandler = serializationHandler;
    }

    public void saveRootCategory(EntityRadarCategory category) {
        Path saveLocationTempPath = this.saveLocationPath.resolveSibling(this.saveLocationPath.getFileName().toString() + ".temp");
        String serializedData = this.serializationHandler.serialize(category);
        this.saveRootCategory(saveLocationTempPath, serializedData, 10);
    }

    public void saveRootCategory(Path saveLocationTempPath, String serializedData, int attempts) {
        try (FileOutputStream fileOutput = new FileOutputStream(saveLocationTempPath.toFile());
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutput, StandardCharsets.UTF_8);){
            writer.write(serializedData);
            writer.close();
            Misc.safeMoveAndReplace(saveLocationTempPath, this.saveLocationPath, true);
        }
        catch (IOException e) {
            if (attempts > 0) {
                System.out.println("Failed to save entity radar categories. Retrying... " + attempts);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.saveRootCategory(saveLocationTempPath, serializedData, --attempts);
            } else {
                e.printStackTrace();
            }
            return;
        }
    }

    public EntityRadarCategory loadRootCategory() throws IOException {
        String serializedData;
        try (FileInputStream fileInput = new FileInputStream(this.saveLocationPath.toFile());
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fileInput, "UTF8"));){
            StringBuilder stringBuilder = new StringBuilder();
            reader.lines().forEach(line -> {
                stringBuilder.append((String)line);
                stringBuilder.append('\n');
            });
            serializedData = stringBuilder.toString();
        }
        return (EntityRadarCategory)this.serializationHandler.deserialize(serializedData);
    }

    public static final class Builder {
        private Path saveLocationPath;
        private final EntityRadarCategorySerializationHandler.Builder serializationHandlerBuilder;

        public Builder(EntityRadarCategorySerializationHandler.Builder serializationHandlerBuilder) {
            this.serializationHandlerBuilder = serializationHandlerBuilder;
        }

        private Builder setDefault() {
            this.saveLocationPath = null;
            return this;
        }

        public Builder setSaveLocationPath(Path saveLocationPath) {
            this.saveLocationPath = saveLocationPath;
            return this;
        }

        public EntityRadarCategoryFileIO build() {
            if (this.saveLocationPath == null || this.serializationHandlerBuilder == null) {
                throw new IllegalStateException("required fields not set!");
            }
            return new EntityRadarCategoryFileIO(this.saveLocationPath, (EntityRadarCategorySerializationHandler)this.serializationHandlerBuilder.build());
        }

        public static Builder getDefault(EntityRadarCategorySerializationHandler.Builder serializationHandlerBuilder) {
            return new Builder(serializationHandlerBuilder).setDefault();
        }
    }
}

