/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.radar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_270;
import net.minecraft.class_638;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.category.rule.resolver.ObjectCategoryRuleResolver;
import xaero.common.effect.Effects;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.radar.MinimapRadarList;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.radar.category.EntityRadarCategoryManager;
import xaero.common.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.common.settings.ModSettings;

public class MinimapRadar {
    public static final int radarPlayers = -1;
    public static final int radarShadow = -16777216;
    private AXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private EntityRadarCategoryManager entityCategoryManager;
    private class_1297 lastRenderViewEntity;
    private EntityRadarCategory listsGeneratedForConfig;
    private List<MinimapRadarList> radarLists;
    private Map<EntityRadarCategory, MinimapRadarList> middleRadarListMap;

    public MinimapRadar(AXaeroMinimap modMain, XaeroMinimapSession minimapSession, EntityRadarCategoryManager entityCategoryManager) throws IOException {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.entityCategoryManager = entityCategoryManager;
        this.radarLists = new ArrayList<MinimapRadarList>();
        this.middleRadarListMap = new HashMap<EntityRadarCategory, MinimapRadarList>();
    }

    private void ensureCategories(EntityRadarCategory rootCategory, List<MinimapRadarList> radarLists, Map<EntityRadarCategory, MinimapRadarList> middleRadarListMap) {
        if (this.listsGeneratedForConfig != rootCategory) {
            middleRadarListMap.clear();
            radarLists.clear();
            this.traceAddCategories(rootCategory, middleRadarListMap, radarLists);
            Collections.sort(radarLists);
            this.listsGeneratedForConfig = rootCategory;
        }
    }

    private void traceAddCategories(EntityRadarCategory category, Map<EntityRadarCategory, MinimapRadarList> middleRadarListMap, List<MinimapRadarList> radarLists) {
        category.getDirectSubCategoryIterator().forEachRemaining(sb -> this.traceAddCategories((EntityRadarCategory)sb, middleRadarListMap, radarLists));
        MinimapRadarList radarList = MinimapRadarList.Builder.getDefault().build().setCategory(category);
        middleRadarListMap.put(category, radarList);
        radarLists.add(radarList);
    }

    public void updateRadar(class_638 world, class_1657 p, class_1297 renderEntity, MinimapProcessor minimap) {
        if (renderEntity == null) {
            renderEntity = this.lastRenderViewEntity;
        }
        List<MinimapRadarList> radarLists = this.radarLists;
        Map<EntityRadarCategory, MinimapRadarList> middleRadarListMap = this.middleRadarListMap;
        EntityRadarCategoryManager entityCategoryManager = this.entityCategoryManager;
        EntityRadarCategory rootCategory = entityCategoryManager.getRootCategory();
        this.ensureCategories(rootCategory, radarLists, middleRadarListMap);
        radarLists.forEach(l -> l.getEntities().clear());
        if (!this.modMain.getSettings().getEntityRadar() || world == null || p == null || renderEntity == null || p.method_6059(Effects.NO_RADAR) || p.method_6059(Effects.NO_RADAR_BENEFICIAL) || p.method_6059(Effects.NO_RADAR_HARMFUL)) {
            return;
        }
        ObjectCategoryRuleResolver categoryRuleResolver = entityCategoryManager.getRuleResolver();
        Iterable worldEntities = world.method_18112();
        int cullingSize = minimap.getMinimapSize() / 2 + 48;
        double maxDistance = (double)(cullingSize * cullingSize) / (minimap.getMinimapZoom() * minimap.getMinimapZoom());
        for (class_1297 e : worldEntities) {
            if (e.field_6012 <= 0) continue;
            try {
                int heightLimit;
                double offh;
                double offheight2;
                EntityRadarCategory entityCategory;
                double offy;
                double offy2;
                double offx = e.method_23317() - renderEntity.method_23317();
                double offx2 = offx * offx;
                if (offx2 > maxDistance || (offy2 = (offy = e.method_23321() - renderEntity.method_23321()) * offy) > maxDistance || (entityCategory = categoryRuleResolver.resolve(rootCategory, e, p)) == null || !entityCategory.getSettingValue(EntityRadarCategorySettings.DISPLAYED).booleanValue() || (offheight2 = (offh = renderEntity.method_23318() - e.method_23318()) * offh) > (double)((heightLimit = entityCategory.getSettingValue(EntityRadarCategorySettings.HEIGHT_LIMIT).intValue()) * heightLimit)) continue;
                List<class_1297> typeList = middleRadarListMap.get(entityCategory).getEntities();
                int entityAmount = entityCategory.getSettingValue(EntityRadarCategorySettings.ENTITY_NUMBER).intValue();
                if (entityAmount != 0 && typeList.size() >= entityAmount) continue;
                typeList.add(e);
            }
            catch (Exception ex) {}
        }
    }

    public double getEntityX(class_1297 e, float partial) {
        return e.field_6038 + (e.method_23317() - e.field_6038) * (double)partial;
    }

    public double getEntityY(class_1297 e, float partial) {
        return e.field_5971 + (e.method_23318() - e.field_5971) * (double)partial;
    }

    public double getEntityZ(class_1297 e, float partial) {
        return e.field_5989 + (e.method_23321() - e.field_5989) * (double)partial;
    }

    public boolean shouldRenderEntity(class_1297 e, class_1297 renderEntity) {
        return e == renderEntity || !e.method_5715() && !e.method_5767();
    }

    public int getTeamColour(class_1297 e) {
        Integer teamColour = null;
        class_270 team = e.method_5781();
        if (team != null) {
            teamColour = team.method_1202().method_532();
        }
        return teamColour == null ? -1 : teamColour;
    }

    public int getEntityColour(class_1657 p, class_1297 e, float offh, boolean cave, EntityRadarCategory category, int heightLimit, boolean heightBasedFade, int colorIndex) {
        float brightness;
        int color = -1;
        if (colorIndex == -1) {
            int entityTeamColour = this.getTeamColour(e);
            if (entityTeamColour != -1) {
                color = 0xFF000000 | entityTeamColour;
            } else {
                EntityRadarCategory fallbackCategory = category;
                while (colorIndex == -1) {
                    if ((fallbackCategory = (EntityRadarCategory)fallbackCategory.getSuperCategory()) == null) {
                        colorIndex = 15;
                        continue;
                    }
                    colorIndex = fallbackCategory.getSettingValue(EntityRadarCategorySettings.COLOR).intValue();
                }
            }
        }
        if (colorIndex != -1) {
            color = ModSettings.COLORS[colorIndex];
        }
        if ((brightness = this.getEntityBrightness(offh, heightLimit, heightBasedFade)) < 1.0f) {
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int a = 255;
            if (cave) {
                a = (int)((float)a * brightness);
            } else {
                r = (int)((float)r * brightness);
                g = (int)((float)g * brightness);
                b = (int)((float)b * brightness);
            }
            color = a << 24 | r << 16 | g << 8 | b;
        }
        return color;
    }

    public float getEntityBrightness(float offh, int heightLimit, boolean heightBasedFade) {
        float level = (float)heightLimit - offh;
        if (level < 0.0f) {
            level = 0.0f;
        }
        float brightness = 1.0f;
        if (level <= (float)(heightLimit / 2) && heightBasedFade) {
            brightness = 0.25f + 0.5f * level / (float)heightLimit;
        }
        return brightness;
    }

    public void setLastRenderViewEntity(class_1297 lastRenderViewEntity) {
        this.lastRenderViewEntity = lastRenderViewEntity;
    }

    public EntityRadarCategoryManager getEntityCategoryManager() {
        return this.entityCategoryManager;
    }

    public Iterator<MinimapRadarList> getRadarListsIterator() {
        return this.radarLists.iterator();
    }
}

