/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.model.ExtraModelProvider;
import net.fabricmc.fabric.api.client.model.ModelAppender;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.model.ModelProviderContext;
import net.fabricmc.fabric.api.client.model.ModelProviderException;
import net.fabricmc.fabric.api.client.model.ModelResourceProvider;
import net.fabricmc.fabric.api.client.model.ModelVariantProvider;
import net.fabricmc.fabric.impl.client.model.ModelLoaderHooks;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ModelLoadingRegistryImpl
implements ModelLoadingRegistry {
    private static final boolean DEBUG_MODEL_LOADING = FabricLoader.getInstance().isDevelopmentEnvironment() || Boolean.valueOf(System.getProperty("fabric.debugModelLoading", "false")) != false;
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ModelLoadingRegistryImpl INSTANCE = new ModelLoadingRegistryImpl();
    private final List<Function<class_3300, ModelVariantProvider>> variantProviderSuppliers = new ArrayList<Function<class_3300, ModelVariantProvider>>();
    private final List<Function<class_3300, ModelResourceProvider>> resourceProviderSuppliers = new ArrayList<Function<class_3300, ModelResourceProvider>>();
    private final List<ExtraModelProvider> appenders = new ArrayList<ExtraModelProvider>();

    @Override
    public void registerModelProvider(ExtraModelProvider appender) {
        this.appenders.add(appender);
    }

    @Override
    public void registerAppender(ModelAppender appender) {
        this.registerModelProvider((manager, consumer) -> appender.appendAll(manager, consumer::accept));
    }

    @Override
    public void registerResourceProvider(Function<class_3300, ModelResourceProvider> providerSupplier) {
        this.resourceProviderSuppliers.add(providerSupplier);
    }

    @Override
    public void registerVariantProvider(Function<class_3300, ModelVariantProvider> providerSupplier) {
        this.variantProviderSuppliers.add(providerSupplier);
    }

    public static LoaderInstance begin(class_1088 loader, class_3300 manager) {
        return new LoaderInstance(INSTANCE, loader, manager);
    }

    public static class LoaderInstance
    implements ModelProviderContext {
        private final Logger logger = LOGGER;
        private final class_3300 manager;
        private final List<ModelVariantProvider> modelVariantProviders;
        private final List<ModelResourceProvider> modelResourceProviders;
        private final List<ExtraModelProvider> modelAppenders;
        private class_1088 loader;

        private LoaderInstance(ModelLoadingRegistryImpl i, class_1088 loader, class_3300 manager) {
            this.loader = loader;
            this.manager = manager;
            this.modelVariantProviders = i.variantProviderSuppliers.stream().map(s -> (ModelVariantProvider)s.apply(manager)).collect(Collectors.toList());
            this.modelResourceProviders = i.resourceProviderSuppliers.stream().map(s -> (ModelResourceProvider)s.apply(manager)).collect(Collectors.toList());
            this.modelAppenders = i.appenders;
        }

        @Override
        public class_1100 loadModel(class_2960 id) {
            if (this.loader == null) {
                throw new RuntimeException("Called loadModel too late!");
            }
            return ((ModelLoaderHooks)this.loader).fabric_loadModel(id);
        }

        public void onModelPopulation(Consumer<class_2960> addModel) {
            for (ExtraModelProvider appender : this.modelAppenders) {
                appender.provideExtraModels(this.manager, addModel);
            }
        }

        private <T> class_1100 loadCustomModel(CustomModelItf<T> function, Collection<T> loaders, String debugName) {
            if (!DEBUG_MODEL_LOADING) {
                for (T provider : loaders) {
                    try {
                        class_1100 model = function.load(provider);
                        if (model == null) continue;
                        return model;
                    }
                    catch (ModelProviderException e) {
                        this.logger.error((Object)e);
                        return null;
                    }
                }
                return null;
            }
            class_1100 modelLoaded = null;
            Object providerUsed = null;
            List providersApplied = null;
            for (T provider : loaders) {
                try {
                    class_1100 model = function.load(provider);
                    if (model == null) continue;
                    if (providersApplied != null) {
                        providersApplied.add(provider);
                        continue;
                    }
                    if (providerUsed != null) {
                        providersApplied = Lists.newArrayList((Object[])new Object[]{providerUsed, provider});
                        continue;
                    }
                    modelLoaded = model;
                    providerUsed = provider;
                }
                catch (ModelProviderException e) {
                    this.logger.error((Object)e);
                    return null;
                }
            }
            if (providersApplied != null) {
                StringBuilder builder = new StringBuilder("Conflict - multiple " + debugName + "s claimed the same unbaked model:");
                for (Object loader : providersApplied) {
                    builder.append("\n\t - ").append(loader.getClass().getName());
                }
                this.logger.error(builder.toString());
                return null;
            }
            return modelLoaded;
        }

        @Nullable
        public class_1100 loadModelFromResource(class_2960 resourceId) {
            return this.loadCustomModel(r -> r.loadModelResource(resourceId, this), this.modelResourceProviders, "resource provider");
        }

        @Nullable
        public class_1100 loadModelFromVariant(class_2960 variantId) {
            class_2960 resourceId;
            if (!(variantId instanceof class_1091)) {
                return this.loadModelFromResource(variantId);
            }
            class_1091 modelId = (class_1091)variantId;
            class_1100 model = this.loadCustomModel(r -> r.loadModelVariant((class_1091)variantId, this), this.modelVariantProviders, "resource provider");
            if (model != null) {
                return model;
            }
            if (Objects.equals(modelId.method_4740(), "inventory") && (model = this.loadModelFromResource(resourceId = new class_2960(modelId.method_12836(), "item/" + modelId.method_12832()))) != null) {
                return model;
            }
            return null;
        }

        public void finish() {
            this.loader = null;
        }
    }

    @FunctionalInterface
    private static interface CustomModelItf<T> {
        public class_1100 load(T var1) throws ModelProviderException;
    }
}

