/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.networking.v1;

import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.fabricmc.fabric.impl.networking.client.ClientPlayNetworkAddon;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ClientPlayNetworking {
    public static boolean registerGlobalReceiver(class_2960 channelName, PlayChannelHandler channelHandler) {
        return ClientNetworkingImpl.PLAY.registerGlobalReceiver(channelName, channelHandler);
    }

    @Nullable
    public static PlayChannelHandler unregisterGlobalReceiver(class_2960 channelName) {
        return ClientNetworkingImpl.PLAY.unregisterGlobalReceiver(channelName);
    }

    public static Set<class_2960> getGlobalReceivers() {
        return ClientNetworkingImpl.PLAY.getChannels();
    }

    public static boolean registerReceiver(class_2960 channelName, PlayChannelHandler channelHandler) {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.registerChannel(channelName, channelHandler);
        }
        throw new IllegalStateException("Cannot register receiver while not in game!");
    }

    @Nullable
    public static PlayChannelHandler unregisterReceiver(class_2960 channelName) throws IllegalStateException {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return (PlayChannelHandler)addon.unregisterChannel(channelName);
        }
        throw new IllegalStateException("Cannot unregister receiver while not in game!");
    }

    public static Set<class_2960> getReceived() throws IllegalStateException {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.getReceivableChannels();
        }
        throw new IllegalStateException("Cannot get a list of channels the client can receive packets on while not in game!");
    }

    public static Set<class_2960> getSendable() throws IllegalStateException {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.getSendableChannels();
        }
        throw new IllegalStateException("Cannot get a list of channels the server can receive packets on while not in game!");
    }

    public static boolean canSend(class_2960 channelName) throws IllegalArgumentException {
        if (class_310.method_1551().method_1562() != null) {
            return ClientNetworkingImpl.getAddon(class_310.method_1551().method_1562()).getSendableChannels().contains(channelName);
        }
        return false;
    }

    public static class_2596<?> createC2SPacket(class_2960 channelName, class_2540 buf) {
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(buf, "Buf cannot be null");
        return ClientNetworkingImpl.createPlayC2SPacket(channelName, buf);
    }

    public static PacketSender getSender() throws IllegalStateException {
        if (class_310.method_1551().method_1562() != null) {
            return ClientNetworkingImpl.getAddon(class_310.method_1551().method_1562());
        }
        throw new IllegalStateException("Cannot get packet sender when not in game!");
    }

    public static void send(class_2960 channelName, class_2540 buf) throws IllegalStateException {
        if (class_310.method_1551().method_1562() != null) {
            class_310.method_1551().method_1562().method_2883(ClientPlayNetworking.createC2SPacket(channelName, buf));
            return;
        }
        throw new IllegalStateException("Cannot send packets when not in game!");
    }

    private ClientPlayNetworking() {
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface PlayChannelHandler {
        public void receive(class_310 var1, class_634 var2, class_2540 var3, PacketSender var4);
    }
}

