/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.networking.v1;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.fabric.mixin.networking.accessor.EntityTrackerAccessor;
import net.fabricmc.fabric.mixin.networking.accessor.ThreadedAnvilChunkStorageAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2802;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import net.minecraft.class_5629;
import net.minecraft.server.MinecraftServer;

public final class PlayerLookup {
    public static Collection<class_3222> all(MinecraftServer server) {
        Objects.requireNonNull(server, "The server cannot be null");
        if (server.method_3760() != null) {
            return Collections.unmodifiableCollection(server.method_3760().method_14571());
        }
        return Collections.emptyList();
    }

    public static Collection<class_3222> world(class_3218 world) {
        Objects.requireNonNull(world, "The world cannot be null");
        return Collections.unmodifiableCollection(world.method_18456());
    }

    public static Collection<class_3222> tracking(class_3218 world, class_1923 pos) {
        Objects.requireNonNull(world, "The world cannot be null");
        Objects.requireNonNull(pos, "The chunk pos cannot be null");
        return world.method_14178().field_17254.method_17210(pos, false).collect(Collectors.toList());
    }

    public static Collection<class_3222> tracking(class_1297 entity) {
        Objects.requireNonNull(entity, "Entity cannot be null");
        class_2802 manager = entity.field_6002.method_8398();
        if (manager instanceof class_3215) {
            class_3898 storage = ((class_3215)manager).field_17254;
            EntityTrackerAccessor tracker = (EntityTrackerAccessor)((ThreadedAnvilChunkStorageAccessor)storage).getEntityTrackers().get(entity.method_5628());
            if (tracker != null) {
                return Collections.unmodifiableCollection(tracker.getPlayersTracking().stream().map(class_5629::method_32311).collect(Collectors.toSet()));
            }
            return Collections.emptySet();
        }
        throw new IllegalArgumentException("Only supported on server worlds!");
    }

    public static Collection<class_3222> tracking(class_2586 blockEntity) {
        Objects.requireNonNull(blockEntity, "BlockEntity cannot be null");
        if (!blockEntity.method_11002() || blockEntity.method_10997().method_8608()) {
            throw new IllegalArgumentException("Only supported on server worlds!");
        }
        return PlayerLookup.tracking((class_3218)blockEntity.method_10997(), blockEntity.method_11016());
    }

    public static Collection<class_3222> tracking(class_3218 world, class_2338 pos) {
        Objects.requireNonNull(pos, "BlockPos cannot be null");
        return PlayerLookup.tracking(world, new class_1923(pos));
    }

    public static Collection<class_3222> around(class_3218 world, class_243 pos, double radius) {
        double radiusSq = radius * radius;
        return PlayerLookup.world(world).stream().filter(p -> p.method_5707(pos) <= radiusSq).collect(Collectors.toList());
    }

    public static Collection<class_3222> around(class_3218 world, class_2382 pos, double radius) {
        double radiusSq = radius * radius;
        return PlayerLookup.world(world).stream().filter(p -> p.method_5649((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()) <= radiusSq).collect(Collectors.toList());
    }

    private PlayerLookup() {
    }
}

