/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_3298;
import net.minecraft.class_5912;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class class_3268
implements class_3262,
class_5912 {
    public static Path field_14196;
    private static final Logger field_14195;
    public static Class<?> field_14194;
    private static final Map<class_3264, Path> field_17917;
    public final class_3272 field_26938;
    public final Set<String> field_14193;

    private static Path method_37454(URI uRI) throws IOException {
        try {
            return Paths.get(uRI);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
        }
        catch (Throwable throwable) {
            field_14195.warn("Unable to get path for: {}", (Object)uRI, (Object)throwable);
        }
        try {
            FileSystems.newFileSystem(uRI, Collections.emptyMap());
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            // empty catch block
        }
        return Paths.get(uRI);
    }

    public class_3268(class_3272 class_32722, String ... stringArray) {
        this.field_26938 = class_32722;
        this.field_14193 = ImmutableSet.copyOf((Object[])stringArray);
    }

    @Override
    public InputStream method_14410(String string) throws IOException {
        if (string.contains("/") || string.contains("\\")) {
            throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
        }
        if (field_14196 != null && Files.exists(\u00e2\u02dc\u0192 = field_14196.resolve(string), new LinkOption[0])) {
            return Files.newInputStream(\u00e2\u02dc\u0192, new OpenOption[0]);
        }
        return this.method_14417(string);
    }

    @Override
    public InputStream method_14405(class_3264 class_32642, class_2960 class_29602) throws IOException {
        InputStream inputStream = this.method_14416(class_32642, class_29602);
        if (inputStream != null) {
            return inputStream;
        }
        throw new FileNotFoundException(class_29602.method_12832());
    }

    @Override
    public Collection<class_2960> method_14408(class_3264 class_326422, String string, String string2, int n, Predicate<String> predicate) {
        Object \u00e2\u02dc\u019222;
        HashSet hashSet = Sets.newHashSet();
        if (field_14196 != null) {
            try {
                class_3268.method_14418(hashSet, n, string, field_14196.resolve(class_326422.method_14413()), string2, predicate);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (class_326422 == class_3264.field_14188) {
                \u00e2\u02dc\u019222 = null;
                try {
                    \u00e2\u02dc\u019222 = field_14194.getClassLoader().getResources(class_326422.method_14413() + "/");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                while (\u00e2\u02dc\u019222 != null && \u00e2\u02dc\u019222.hasMoreElements()) {
                    try {
                        URI uRI = ((URL)\u00e2\u02dc\u019222.nextElement()).toURI();
                        if (!"file".equals(uRI.getScheme())) continue;
                        class_3268.method_14418(hashSet, n, string, Paths.get(uRI), string2, predicate);
                    }
                    catch (IOException | URISyntaxException exception) {}
                }
            }
        }
        try {
            class_3264 class_326422;
            \u00e2\u02dc\u019222 = field_17917.get((Object)class_326422);
            if (\u00e2\u02dc\u019222 != null) {
                class_3268.method_14418(hashSet, n, string, (Path)\u00e2\u02dc\u019222, string2, predicate);
            } else {
                field_14195.error("Can't access assets root for type: {}", (Object)class_326422);
            }
        }
        catch (FileNotFoundException | NoSuchFileException \u00e2\u02dc\u019222) {
        }
        catch (IOException iOException) {
            field_14195.error("Couldn't get a list of all vanilla resources", (Throwable)iOException);
        }
        return hashSet;
    }

    private static void method_14418(Collection<class_2960> collection, int n, String string, Path path3, String string2, Predicate<String> predicate) throws IOException {
        Path path4 = path3.resolve(string);
        try (Stream<Path> \u00e2\u02dc\u01922 = Files.walk(path4.resolve(string2), n, new FileVisitOption[0]);){
            \u00e2\u02dc\u01922.filter(path -> !path.endsWith(".mcmeta") && Files.isRegularFile(path, new LinkOption[0]) && predicate.test(path.getFileName().toString())).map(path2 -> new class_2960(string, path4.relativize((Path)path2).toString().replaceAll("\\\\", "/"))).forEach(collection::add);
        }
    }

    @Nullable
    protected InputStream method_14416(class_3264 class_32642, class_2960 class_29602) {
        String string = class_3268.method_20729(class_32642, class_29602);
        if (field_14196 != null && Files.exists((Path)(object = field_14196.resolve(class_32642.method_14413() + "/" + class_29602.method_12836() + "/" + class_29602.method_12832())), new LinkOption[0])) {
            try {
                return Files.newInputStream((Path)object, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            Object object = class_3268.class.getResource(string);
            if (class_3268.method_20728(string, (URL)object)) {
                return ((URL)object).openStream();
            }
        }
        catch (IOException iOException) {
            return class_3268.class.getResourceAsStream(string);
        }
        return null;
    }

    private static String method_20729(class_3264 class_32642, class_2960 class_29602) {
        return "/" + class_32642.method_14413() + "/" + class_29602.method_12836() + "/" + class_29602.method_12832();
    }

    private static boolean method_20728(String string, @Nullable URL uRL) throws IOException {
        return uRL != null && (uRL.getProtocol().equals("jar") || class_3259.method_14402(new File(uRL.getFile()), string));
    }

    @Nullable
    protected InputStream method_14417(String string) {
        return class_3268.class.getResourceAsStream("/" + string);
    }

    @Override
    public boolean method_14411(class_3264 class_32642, class_2960 class_29602) {
        String string = class_3268.method_20729(class_32642, class_29602);
        if (field_14196 != null && Files.exists((Path)(object = field_14196.resolve(class_32642.method_14413() + "/" + class_29602.method_12836() + "/" + class_29602.method_12832())), new LinkOption[0])) {
            return true;
        }
        try {
            Object object = class_3268.class.getResource(string);
            return class_3268.method_20728(string, (URL)object);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public Set<String> method_14406(class_3264 class_32642) {
        return this.field_14193;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public <T> T method_14407(class_3270<T> class_327022) throws IOException {
        try (InputStream inputStream = this.method_14410("pack.mcmeta");){
            T t2;
            if (inputStream != null && (t2 = class_3255.method_14392(class_327022, inputStream)) != null) {
                T t = t2;
                return t;
            }
        }
        catch (FileNotFoundException | RuntimeException exception) {
            // empty catch block
        }
        if (class_327022 != class_3272.field_14202) return null;
        return (T)this.field_26938;
    }

    @Override
    public String method_14409() {
        return "Default";
    }

    @Override
    public void close() {
    }

    @Override
    public class_3298 method_14486(final class_2960 class_29602) throws IOException {
        return new class_3298(){
            @Nullable
            InputStream field_29185;

            @Override
            public void close() throws IOException {
                if (this.field_29185 != null) {
                    this.field_29185.close();
                }
            }

            @Override
            public class_2960 method_14483() {
                return class_29602;
            }

            @Override
            public InputStream method_14482() {
                try {
                    this.field_29185 = class_3268.this.method_14405(class_3264.field_14188, class_29602);
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException("Could not get client resource from vanilla pack", iOException);
                }
                return this.field_29185;
            }

            @Override
            public boolean method_14484() {
                return false;
            }

            @Override
            @Nullable
            public <T> T method_14481(class_3270<T> class_32702) {
                return null;
            }

            @Override
            public String method_14480() {
                return class_29602.toString();
            }
        };
    }

    static {
        field_14195 = LogManager.getLogger();
        field_17917 = (Map)class_156.method_656(() -> {
            Class<class_3268> clazz = class_3268.class;
            synchronized (class_3268.class) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (class_3264 class_32642 : class_3264.values()) {
                    String string = "/" + class_32642.method_14413() + "/.mcassetsroot";
                    URL \u00e2\u02dc\u01922 = class_3268.class.getResource(string);
                    if (\u00e2\u02dc\u01922 == null) {
                        field_14195.error("File {} does not exist in classpath", (Object)string);
                        continue;
                    }
                    try {
                        URI uRI = \u00e2\u02dc\u01922.toURI();
                        String \u00e2\u02dc\u01923 = uRI.getScheme();
                        if (!"jar".equals(\u00e2\u02dc\u01923) && !"file".equals(\u00e2\u02dc\u01923)) {
                            field_14195.warn("Assets URL '{}' uses unexpected schema", (Object)uRI);
                        }
                        Path \u00e2\u02dc\u01924 = class_3268.method_37454(uRI);
                        builder.put((Object)class_32642, (Object)\u00e2\u02dc\u01924.getParent());
                    }
                    catch (Exception exception) {
                        field_14195.error("Couldn't resolve path to vanilla assets", (Throwable)exception);
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return builder.build();
            }
        });
    }
}

