/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.mod;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipError;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import me.modmuss50.optifabric.mod.OptifabricError;
import me.modmuss50.optifabric.mod.OptifineVersion;
import me.modmuss50.optifabric.patcher.ClassCache;
import me.modmuss50.optifabric.patcher.LambdaRebuilder;
import me.modmuss50.optifabric.util.ASMUtils;
import me.modmuss50.optifabric.util.ZipUtils;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.fabricmc.loader.util.UrlConversionException;
import net.fabricmc.loader.util.UrlUtil;
import net.fabricmc.loader.util.mappings.TinyRemapperMappingsHelper;
import net.fabricmc.mapping.tree.ClassDef;
import net.fabricmc.mapping.tree.TinyTree;
import net.fabricmc.tinyremapper.IMappingProvider;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class OptifineSetup {
    public static Pair<File, ClassCache> getRuntime() throws IOException {
        boolean extract;
        byte[] modHash;
        File workingDir = new File(FabricLoader.getInstance().getGameDirectory(), ".optifine");
        if (!workingDir.exists()) {
            FileUtils.forceMkdir((File)workingDir);
        }
        File optifineModJar = OptifineVersion.findOptifineJar();
        try (FileInputStream in = new FileInputStream(optifineModJar);){
            modHash = DigestUtils.md5((InputStream)in);
        }
        File versionDir = new File(workingDir, OptifineVersion.version);
        if (!versionDir.exists()) {
            FileUtils.forceMkdir((File)versionDir);
        }
        File remappedJar = new File(versionDir, "Optifine-mapped.jar");
        File optifinePatches = new File(versionDir, "Optifine.classes.gz");
        if (remappedJar.exists() && optifinePatches.exists()) {
            ClassCache classCache = ClassCache.read(optifinePatches);
            if (Arrays.equals(classCache.getHash(), modHash)) {
                System.out.println("Found existing patched optifine jar, using that");
                if (classCache.isConverted()) {
                    classCache.save(optifinePatches);
                }
                return Pair.of((Object)remappedJar, (Object)classCache);
            }
            System.out.println("Class cache is from a different optifine jar, deleting and re-generating");
            optifinePatches.delete();
        } else {
            System.out.println("Setting up optifine for the first time, this may take a few seconds.");
        }
        Path minecraftJar = OptifineSetup.getMinecraftJar();
        if (OptifineVersion.jarType == OptifineVersion.JarType.OPTIFINE_INSTALLER) {
            File optifineMod;
            block27: {
                optifineMod = new File(versionDir, "Optifine-mod.jar");
                if (!optifineMod.exists()) {
                    for (int attempt = 1; attempt <= 3; ++attempt) {
                        OptifineSetup.runInstaller(optifineModJar, optifineMod, minecraftJar.toFile());
                        try {
                            new ZipFile(optifineMod).close();
                            break block27;
                        }
                        catch (ZipError | ZipException e) {
                            optifineMod.delete();
                            continue;
                        }
                    }
                    OptifineVersion.jarType = OptifineVersion.JarType.CORRUPT_ZIP;
                    OptifabricError.setError("OptiFine installer keeps producing corrupt jars!\nRan: %s 3 times\nMinecraft jar: %s", optifineModJar, minecraftJar);
                    throw new ZipException("Ran OptiFine installer (" + optifineModJar + ") three times without a valid jar produced");
                }
            }
            optifineModJar = optifineMod;
        }
        File jarOfTheFree = new File(versionDir, "Optifine-jarofthefree.jar");
        final LambdaRebuilder rebuilder = new LambdaRebuilder(minecraftJar.toFile());
        System.out.println("De-Volderfiying jar");
        ZipUtils.transform(optifineModJar, new ZipUtils.ZipTransformer(){

            private boolean keep(String name) {
                if (name.startsWith("com/mojang/blaze3d/platform/")) {
                    int split = name.indexOf(36);
                    return split <= 0 || name.length() - split <= 8;
                }
                return !name.startsWith("srg/") && !name.startsWith("net/minecraft/");
            }

            @Override
            public InputStream apply(ZipFile zip, ZipEntry entry) throws IOException {
                String name = entry.getName();
                if (this.keep(name)) {
                    if (name.endsWith(".class") && !name.startsWith("net/") && !name.startsWith("optifine/") && !name.startsWith("javax/")) {
                        ClassNode node = ASMUtils.readClass(zip, entry);
                        rebuilder.findLambdas(node);
                        ClassWriter writer = new ClassWriter(0);
                        node.accept((ClassVisitor)writer);
                        return new ByteArrayInputStream(writer.toByteArray());
                    }
                    return zip.getInputStream(entry);
                }
                return null;
            }
        }, jarOfTheFree);
        rebuilder.close();
        String namespace = FabricLoader.getInstance().getMappingResolver().getCurrentRuntimeNamespace();
        System.out.println("Remapping optifine from official to " + namespace);
        OptifineSetup.remapOptifine(jarOfTheFree, OptifineSetup.getLibs(minecraftJar), remappedJar, OptifineSetup.createMappings("official", namespace, rebuilder));
        jarOfTheFree.delete();
        if (OptifineVersion.jarType == OptifineVersion.JarType.OPTIFINE_INSTALLER) {
            optifineModJar.delete();
        }
        if (extract = Boolean.getBoolean("optifabric.extract")) {
            System.out.println("Extracting optifine classes");
            File optifineClasses = new File(versionDir, "optifine-classes");
            if (optifineClasses.exists()) {
                FileUtils.deleteDirectory((File)optifineClasses);
            }
            ZipUtils.extract(remappedJar, optifineClasses);
        }
        return Pair.of((Object)remappedJar, (Object)OptifineSetup.generateClassCache(remappedJar, optifinePatches, modHash, extract));
    }

    private static void runInstaller(File installer, File output, File minecraftJar) throws IOException {
        System.out.println("Running optifine patcher");
        try (URLClassLoader classLoader = new URLClassLoader(new URL[]{installer.toURI().toURL()}, OptifineSetup.class.getClassLoader());){
            Class<?> clazz = classLoader.loadClass("optifine.Patcher");
            Method method = clazz.getDeclaredMethod("process", File.class, File.class, File.class);
            method.invoke(null, minecraftJar, installer, output);
        }
        catch (ReflectiveOperationException | MalformedURLException e) {
            throw new RuntimeException("Error running OptiFine patcher at " + installer + " on " + minecraftJar, e);
        }
    }

    private static void remapOptifine(File input, Path[] libraries, File output, IMappingProvider mappings) throws IOException {
        OptifineSetup.remapOptifine(input.toPath(), libraries, output.toPath(), mappings);
    }

    private static void remapOptifine(Path input, Path[] libraries, Path output, IMappingProvider mappings) throws IOException {
        Files.deleteIfExists(output);
        TinyRemapper remapper = TinyRemapper.newRemapper().withMappings(mappings).skipLocalVariableMapping(true).renameInvalidLocals(FabricLoader.getInstance().isDevelopmentEnvironment()).rebuildSourceFilenames(true).build();
        try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(output).assumeArchive(true).build();){
            outputConsumer.addNonClassFiles(input);
            remapper.readInputs(new Path[]{input});
            remapper.readClassPath(libraries);
            remapper.apply((BiConsumer)outputConsumer);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to remap jar", e);
        }
        finally {
            remapper.finish();
        }
    }

    private static IMappingProvider createMappings(String from, String to, IMappingProvider extra) {
        TinyTree normalMappings = FabricLauncherBase.getLauncher().getMappingConfiguration().getMappings();
        Map nameToClass = normalMappings.getClasses().stream().collect(Collectors.toMap(clazz -> clazz.getName("intermediary"), Function.identity()));
        HashMap<IMappingProvider.Member, String> extraMethods = new HashMap<IMappingProvider.Member, String>();
        HashMap<IMappingProvider.Member, String> extraFields = new HashMap<IMappingProvider.Member, String>();
        ClassDef rebuildTask = (ClassDef)nameToClass.get("net/minecraft/class_846$class_851$class_4578");
        ClassDef builtChunk = (ClassDef)nameToClass.get("net/minecraft/class_846$class_851");
        extraFields.put(new IMappingProvider.Member(rebuildTask.getName(from), "this$1", 'L' + builtChunk.getName(from) + ';'), "field_20839");
        ClassDef particleManager = (ClassDef)nameToClass.get("net/minecraft/class_702");
        particleManager.getFields().stream().filter(field -> "field_3835".equals(field.getName("intermediary"))).forEach(field -> extraFields.put(new IMappingProvider.Member(particleManager.getName(from), field.getName(from), "Ljava/util/Map;"), field.getName(to)));
        ClassDef clientEntityHandler = (ClassDef)nameToClass.get("net/minecraft/class_638$class_5612");
        if (clientEntityHandler != null) {
            ClassDef clientWorld = (ClassDef)nameToClass.get("net/minecraft/class_638");
            extraFields.put(new IMappingProvider.Member(clientEntityHandler.getName(from), "this$0", 'L' + clientWorld.getName(from) + ';'), "field_27735");
        }
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            ClassDef option = (ClassDef)nameToClass.get("net/minecraft/class_316");
            ClassDef cyclingOption = (ClassDef)nameToClass.get("net/minecraft/class_4064");
            extraFields.put(new IMappingProvider.Member(option.getName(from), "CLOUDS", 'L' + cyclingOption.getName(from) + ';'), "CLOUDS_OF");
            ClassDef worldRenderer = (ClassDef)nameToClass.get("net/minecraft/class_761");
            extraFields.put(new IMappingProvider.Member(worldRenderer.getName(from), "renderDistance", "I"), "renderDistance_OF");
            ClassDef threadExecutor = (ClassDef)nameToClass.get("net/minecraft/class_1255");
            extraMethods.put(new IMappingProvider.Member(threadExecutor.getName(from), "getTaskCount", "()I"), "getTaskCount_OF");
            ClassDef vertexBuffer = (ClassDef)nameToClass.get("net/minecraft/class_291");
            extraFields.put(new IMappingProvider.Member(vertexBuffer.getName(from), "vertexCount", "I"), "vertexCount_OF");
            String modelPart = ((ClassDef)nameToClass.get("net/minecraft/class_630")).getName(from);
            extraMethods.put(new IMappingProvider.Member(modelPart, "getChild", "(Ljava/lang/String;)L" + modelPart + ';'), "getChild_OF");
        }
        return out -> {
            TinyRemapperMappingsHelper.create((TinyTree)normalMappings, (String)from, (String)to).load(out);
            extraMethods.forEach((arg_0, arg_1) -> ((IMappingProvider.MappingAcceptor)out).acceptMethod(arg_0, arg_1));
            extraFields.forEach((arg_0, arg_1) -> ((IMappingProvider.MappingAcceptor)out).acceptField(arg_0, arg_1));
            extra.load(out);
        };
    }

    private static Path[] getLibs(Path minecraftJar) {
        Object[] libs;
        block2: {
            libs = (Path[])FabricLauncherBase.getLauncher().getLoadTimeDependencies().stream().map(url -> {
                try {
                    return UrlUtil.asPath((URL)url);
                }
                catch (UrlConversionException e) {
                    throw new RuntimeException(e);
                }
            }).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).toArray(Path[]::new);
            if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                Path launchJar = OptifineSetup.getLaunchMinecraftJar();
                int end = libs.length;
                for (int i = 0; i < end; ++i) {
                    Path lib = libs[i];
                    if (!launchJar.equals(lib)) continue;
                    libs[i] = minecraftJar;
                    break block2;
                }
                throw new IllegalStateException("Unable to find Minecraft jar (at " + launchJar + ") in classpath: " + Arrays.toString(libs));
            }
        }
        return libs;
    }

    private static Path getMinecraftJar() {
        String givenJar = System.getProperty("optifabric.mc-jar");
        if (givenJar != null) {
            File givenJarFile = new File(givenJar);
            if (givenJarFile.exists()) {
                return givenJarFile.toPath();
            }
            System.err.println("Supplied Minecraft jar at " + givenJar + " doesn't exist, falling back");
        }
        Path minecraftJar = OptifineSetup.getLaunchMinecraftJar();
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            Path officialNames = minecraftJar.resolveSibling(String.format("minecraft-%s-client.jar", OptifineVersion.minecraftVersion));
            if (Files.notExists(officialNames, new LinkOption[0])) {
                Path parent = minecraftJar.getParent().resolveSibling(String.format("minecraft-%s-client.jar", OptifineVersion.minecraftVersion));
                if (Files.notExists(parent, new LinkOption[0])) {
                    throw new AssertionError((Object)("Unable to find Minecraft dev jar! Tried " + officialNames + " and " + parent));
                }
                officialNames = parent;
            }
            minecraftJar = officialNames;
        }
        return minecraftJar;
    }

    private static Path getLaunchMinecraftJar() {
        List contextJars = ((net.fabricmc.loader.FabricLoader)FabricLoader.getInstance()).getGameProvider().getGameContextJars();
        if (contextJars.isEmpty()) {
            throw new IllegalStateException("Start has no context?");
        }
        return (Path)contextJars.get(0);
    }

    private static ClassCache generateClassCache(File from, File to, byte[] hash, boolean extractClasses) throws IOException {
        File classesDir = new File(to.getParent(), "classes");
        if (extractClasses) {
            if (classesDir.exists()) {
                FileUtils.cleanDirectory((File)classesDir);
            } else {
                FileUtils.forceMkdir((File)classesDir);
            }
        }
        ClassCache classCache = new ClassCache(hash);
        ZipUtils.filterInPlace(from, (jarFile, entry) -> {
            String name = entry.getName();
            if ((name.startsWith("net/minecraft/") || name.startsWith("com/mojang/")) && name.endsWith(".class")) {
                try (InputStream in = jarFile.getInputStream(entry);){
                    byte[] bytes = IOUtils.toByteArray((InputStream)in);
                    classCache.addClass(name.substring(0, name.length() - 6), bytes);
                    if (extractClasses) {
                        FileUtils.writeByteArrayToFile((File)new File(classesDir, name), (byte[])bytes);
                    }
                }
                return false;
            }
            return true;
        });
        System.out.println("Found " + classCache.getClasses().size() + " patched classes");
        classCache.save(to);
        return classCache;
    }
}

