/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.compat.fabricrendererapi;

import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import me.modmuss50.optifabric.compat.EmptyMixinPlugin;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;

public class RendererMixinPlugin
extends EmptyMixinPlugin {
    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        switch (mixinInfo.getName()) {
            case "BlockModelRendererMixin": 
            case "BlockRenderManagerMixin": {
                ClassInfo info = ClassInfo.forName((String)targetClassName);
                Set known = info.getMethods().stream().map(method -> method.getName().concat(method.getDesc())).collect(Collectors.toSet());
                ArrayList<ClassInfo.Method> extra = new ArrayList<ClassInfo.Method>();
                for (MethodNode method2 : targetClass.methods) {
                    if (known.contains(method2.name.concat(method2.desc)) || method2.name.charAt(0) == '<') continue;
                    ClassInfo classInfo = info;
                    classInfo.getClass();
                    extra.add(new ClassInfo.Method(classInfo, method2));
                }
                if (extra.isEmpty()) break;
                try {
                    Set methods = (Set)FieldUtils.readDeclaredField((Object)info, (String)"methods", (boolean)true);
                    methods.addAll(extra);
                    break;
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("Unable to add extra " + extra.size() + " methods to " + info + "'s class info", e);
                }
            }
        }
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

