/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.entity.event.v1;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public final class EntitySleepEvents {
    public static final Event<AllowSleeping> ALLOW_SLEEPING = EventFactory.createArrayBacked(AllowSleeping.class, callbacks -> (player, sleepingPos) -> {
        for (AllowSleeping callback : callbacks) {
            class_1657.class_1658 reason = callback.allowSleep(player, sleepingPos);
            if (reason == null) continue;
            return reason;
        }
        return null;
    });
    public static final Event<StartSleeping> START_SLEEPING = EventFactory.createArrayBacked(StartSleeping.class, callbacks -> (entity, sleepingPos) -> {
        for (StartSleeping callback : callbacks) {
            callback.onStartSleeping(entity, sleepingPos);
        }
    });
    public static final Event<StopSleeping> STOP_SLEEPING = EventFactory.createArrayBacked(StopSleeping.class, callbacks -> (entity, sleepingPos) -> {
        for (StopSleeping callback : callbacks) {
            callback.onStopSleeping(entity, sleepingPos);
        }
    });
    public static final Event<AllowBed> ALLOW_BED = EventFactory.createArrayBacked(AllowBed.class, callbacks -> (entity, sleepingPos, state, vanillaResult) -> {
        for (AllowBed callback : callbacks) {
            class_1269 result = callback.allowBed(entity, sleepingPos, state, vanillaResult);
            if (result == class_1269.field_5811) continue;
            return result;
        }
        return class_1269.field_5811;
    });
    public static final Event<AllowSleepTime> ALLOW_SLEEP_TIME = EventFactory.createArrayBacked(AllowSleepTime.class, callbacks -> (player, sleepingPos, vanillaResult) -> {
        for (AllowSleepTime callback : callbacks) {
            class_1269 result = callback.allowSleepTime(player, sleepingPos, vanillaResult);
            if (result == class_1269.field_5811) continue;
            return result;
        }
        return class_1269.field_5811;
    });
    public static final Event<AllowNearbyMonsters> ALLOW_NEARBY_MONSTERS = EventFactory.createArrayBacked(AllowNearbyMonsters.class, callbacks -> (player, sleepingPos, vanillaResult) -> {
        for (AllowNearbyMonsters callback : callbacks) {
            class_1269 result = callback.allowNearbyMonsters(player, sleepingPos, vanillaResult);
            if (result == class_1269.field_5811) continue;
            return result;
        }
        return class_1269.field_5811;
    });
    public static final Event<AllowResettingTime> ALLOW_RESETTING_TIME = EventFactory.createArrayBacked(AllowResettingTime.class, callbacks -> player -> {
        for (AllowResettingTime callback : callbacks) {
            if (callback.allowResettingTime(player)) continue;
            return false;
        }
        return true;
    });
    public static final Event<ModifySleepingDirection> MODIFY_SLEEPING_DIRECTION = EventFactory.createArrayBacked(ModifySleepingDirection.class, callbacks -> (entity, sleepingPos, sleepingDirection) -> {
        for (ModifySleepingDirection callback : callbacks) {
            sleepingDirection = callback.modifySleepDirection(entity, sleepingPos, sleepingDirection);
        }
        return sleepingDirection;
    });
    public static final Event<AllowSettingSpawn> ALLOW_SETTING_SPAWN = EventFactory.createArrayBacked(AllowSettingSpawn.class, callbacks -> (player, sleepingPos) -> {
        for (AllowSettingSpawn callback : callbacks) {
            if (callback.allowSettingSpawn(player, sleepingPos)) continue;
            return false;
        }
        return true;
    });

    private EntitySleepEvents() {
    }

    @FunctionalInterface
    public static interface AllowSettingSpawn {
        public boolean allowSettingSpawn(class_1657 var1, class_2338 var2);
    }

    @FunctionalInterface
    public static interface ModifySleepingDirection {
        @Nullable
        public class_2350 modifySleepDirection(class_1309 var1, class_2338 var2, @Nullable class_2350 var3);
    }

    @FunctionalInterface
    public static interface AllowResettingTime {
        public boolean allowResettingTime(class_1657 var1);
    }

    @FunctionalInterface
    public static interface AllowNearbyMonsters {
        public class_1269 allowNearbyMonsters(class_1657 var1, class_2338 var2, boolean var3);
    }

    @FunctionalInterface
    public static interface AllowSleepTime {
        public class_1269 allowSleepTime(class_1657 var1, class_2338 var2, boolean var3);
    }

    @FunctionalInterface
    public static interface AllowBed {
        public class_1269 allowBed(class_1309 var1, class_2338 var2, class_2680 var3, boolean var4);
    }

    @FunctionalInterface
    public static interface StopSleeping {
        public void onStopSleeping(class_1309 var1, class_2338 var2);
    }

    @FunctionalInterface
    public static interface StartSleeping {
        public void onStartSleeping(class_1309 var1, class_2338 var2);
    }

    @FunctionalInterface
    public static interface AllowSleeping {
        @Nullable
        public class_1657.class_1658 allowSleep(class_1657 var1, class_2338 var2);
    }
}

