/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed.data.serializer;

import com.mojang.datafixers.util.Pair;
import de.siphalor.tweed.Tweed;
import de.siphalor.tweed.data.DataList;
import de.siphalor.tweed.data.DataObject;
import de.siphalor.tweed.data.DataValue;
import de.siphalor.tweed.data.serializer.ConfigDataSerializer;
import de.siphalor.tweed.shadow.blue.endless.jankson.Jankson;
import de.siphalor.tweed.shadow.blue.endless.jankson.JsonArray;
import de.siphalor.tweed.shadow.blue.endless.jankson.JsonElement;
import de.siphalor.tweed.shadow.blue.endless.jankson.JsonObject;
import de.siphalor.tweed.shadow.blue.endless.jankson.JsonPrimitive;
import de.siphalor.tweed.shadow.blue.endless.jankson.impl.SyntaxError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class JanksonSerializer
implements ConfigDataSerializer<JsonElement> {
    public static final JanksonSerializer INSTANCE = new JanksonSerializer();

    @Override
    public DataObject<JsonElement> newObject() {
        return new JanksonObject(new JsonObject(), comment -> {}, () -> "", clazz -> null);
    }

    @Override
    public DataObject<JsonElement> read(InputStream inputStream) {
        try {
            JsonObject jsonObject = Jankson.builder().build().load(inputStream);
            return new JanksonObject(jsonObject, comment -> {}, () -> "", clazz -> null);
        }
        catch (SyntaxError | IOException e) {
            Tweed.LOGGER.error("Failed to read jankson config file");
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void write(OutputStream outputStream, DataObject<JsonElement> dataObject) {
        try {
            outputStream.write(((JsonElement)dataObject.getRaw()).toJson(true, true).getBytes());
        }
        catch (IOException e) {
            Tweed.LOGGER.error("Failed to write jankson config file");
            e.printStackTrace();
        }
    }

    @Override
    public String getFileExtension() {
        return "jankson";
    }

    static class JanksonList
    extends JanksonValue
    implements DataList<JsonElement> {
        JsonArray self;

        JanksonList(JsonElement jsonElement, Consumer<String> setComment, Supplier<String> getComment, Function<Class<?>, Object> as) {
            super(jsonElement, setComment, getComment, as);
            this.self = (JsonArray)jsonElement;
        }

        @Override
        public int size() {
            return this.self.size();
        }

        @Override
        public DataValue<JsonElement> get(Integer index) {
            return this.createDataValue(this.self.get(index), index);
        }

        @Override
        public DataValue<JsonElement> set(Integer index, byte value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(value);
            this.self.add(jsonPrimitive);
            return this.createDataValue(jsonPrimitive, this.self.size() - 1);
        }

        @Override
        public DataValue<JsonElement> set(Integer index, short value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(value);
            this.self.add(jsonPrimitive);
            return this.createDataValue(jsonPrimitive, this.self.size() - 1);
        }

        @Override
        public DataValue<JsonElement> set(Integer index, int value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(value);
            this.self.add(jsonPrimitive);
            return this.createDataValue(jsonPrimitive, this.self.size() - 1);
        }

        @Override
        public DataValue<JsonElement> set(Integer index, long value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(value);
            this.self.add(jsonPrimitive);
            return this.createDataValue(jsonPrimitive, this.self.size() - 1);
        }

        @Override
        public DataValue<JsonElement> set(Integer index, float value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(Float.valueOf(value));
            this.self.add(jsonPrimitive);
            return this.createDataValue(jsonPrimitive, this.self.size() - 1);
        }

        @Override
        public DataValue<JsonElement> set(Integer index, double value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(value);
            this.self.add(jsonPrimitive);
            return this.createDataValue(jsonPrimitive, this.self.size() - 1);
        }

        @Override
        public DataValue<JsonElement> set(Integer index, char value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(Character.valueOf(value));
            this.self.add(jsonPrimitive);
            return this.createDataValue(jsonPrimitive, this.self.size() - 1);
        }

        @Override
        public DataValue<JsonElement> set(Integer index, String value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(value);
            this.self.add(jsonPrimitive);
            return this.createDataValue(jsonPrimitive, this.self.size() - 1);
        }

        @Override
        public DataValue<JsonElement> set(Integer index, boolean value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(value);
            this.self.add(jsonPrimitive);
            return this.createDataValue(jsonPrimitive, this.self.size() - 1);
        }

        @Override
        public DataValue<JsonElement> set(Integer index, DataValue<JsonElement> value) {
            this.self.add(value.getRaw());
            return this.createDataValue(value.getRaw(), this.self.size() - 1);
        }

        @Override
        public DataObject<JsonElement> addObject(Integer index) {
            JsonObject jsonObject = new JsonObject();
            this.self.add(jsonObject);
            return this.createDataValue(jsonObject, this.self.size() - 1).asObject();
        }

        @Override
        public DataList<JsonElement> addList(Integer index) {
            JsonArray jsonArray = new JsonArray();
            this.self.add(jsonArray);
            return this.createDataValue(jsonArray, this.self.size() - 1).asList();
        }

        @Override
        public void remove(Integer index) {
            this.self.remove(this.self.get(index));
        }

        @Override
        @NotNull
        public Iterator<DataValue<JsonElement>> iterator() {
            JsonElement[] elements = this.self.toArray();
            DataValue[] results = new DataValue[this.size()];
            for (int i = 0; i < elements.length; ++i) {
                results[i] = this.createDataValue(elements[i], i);
            }
            return Arrays.stream(results).iterator();
        }

        DataValue<JsonElement> createDataValue(JsonElement jsonElement, int index) {
            return new JanksonValue(jsonElement, comment -> {}, () -> this.self.getComment(index), clazz -> this.self.get(clazz, index));
        }
    }

    static class JanksonObject
    extends JanksonValue
    implements DataObject<JsonElement> {
        JsonObject self;

        JanksonObject(JsonElement jsonElement, Consumer<String> setComment, Supplier<String> getComment, Function<Class<?>, Object> as) {
            super(jsonElement, setComment, getComment, as);
            this.self = (JsonObject)this.element;
        }

        @Override
        public boolean has(String key) {
            return this.self.containsKey(key);
        }

        @Override
        public int size() {
            return this.self.size();
        }

        @Override
        public DataValue<JsonElement> get(String key) {
            return this.createDataValue(this.self.get(key), key);
        }

        @Override
        public DataValue<JsonElement> set(String key, int value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(value);
            this.self.put(key, jsonPrimitive);
            return this.createDataValue(jsonPrimitive, key);
        }

        @Override
        public DataValue<JsonElement> set(String key, short value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(value);
            this.self.put(key, jsonPrimitive);
            return this.createDataValue(jsonPrimitive, key);
        }

        @Override
        public DataValue<JsonElement> set(String key, byte value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(value);
            this.self.put(key, jsonPrimitive);
            return this.createDataValue(jsonPrimitive, key);
        }

        @Override
        public DataValue<JsonElement> set(String key, float value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(Float.valueOf(value));
            this.self.put(key, jsonPrimitive);
            return this.createDataValue(jsonPrimitive, key);
        }

        @Override
        public DataValue<JsonElement> set(String key, long value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(value);
            this.self.put(key, jsonPrimitive);
            return this.createDataValue(jsonPrimitive, key);
        }

        @Override
        public DataValue<JsonElement> set(String key, String value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(value);
            this.self.put(key, jsonPrimitive);
            return this.createDataValue(jsonPrimitive, key);
        }

        @Override
        public DataValue<JsonElement> set(String key, char value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(Character.valueOf(value));
            this.self.put(key, jsonPrimitive);
            return this.createDataValue(jsonPrimitive, key);
        }

        @Override
        public DataValue<JsonElement> set(String key, double value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(value);
            this.self.put(key, jsonPrimitive);
            return this.createDataValue(jsonPrimitive, key);
        }

        @Override
        public DataValue<JsonElement> set(String key, boolean value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(value);
            this.self.put(key, jsonPrimitive);
            return this.createDataValue(jsonPrimitive, key);
        }

        @Override
        public DataValue<JsonElement> set(String key, DataValue<JsonElement> value) {
            this.self.put(key, value.getRaw());
            return this.createDataValue(value.getRaw(), key);
        }

        @Override
        public DataObject<JsonElement> addObject(String key) {
            JsonObject jsonObject = new JsonObject();
            this.self.put(key, jsonObject);
            return this.createDataValue(jsonObject, key).asObject();
        }

        @Override
        public DataList<JsonElement> addList(String key) {
            JsonArray jsonArray = new JsonArray();
            this.self.put(key, jsonArray);
            return this.createDataValue(jsonArray, key).asList();
        }

        @Override
        public void remove(String key) {
            this.self.remove(key);
        }

        @Override
        @NotNull
        public Iterator<Pair<String, DataValue<JsonElement>>> iterator() {
            return this.self.entrySet().stream().map(entry -> new Pair((Object)((String)entry.getKey()), this.createDataValue((JsonElement)entry.getValue(), (String)entry.getKey()))).iterator();
        }

        DataValue<JsonElement> createDataValue(JsonElement jsonElement, String key) {
            return new JanksonValue(jsonElement, comment -> this.self.setComment(key, (String)comment), () -> this.self.getComment(key), clazz -> this.self.get(clazz, key));
        }
    }

    static class JanksonValue
    implements DataValue<JsonElement> {
        JsonElement element;
        Consumer<String> setComment;
        Supplier<String> getComment;
        Function<Class<?>, Object> as;

        JanksonValue(JsonElement jsonElement, Consumer<String> setComment, Supplier<String> getComment, Function<Class<?>, Object> as) {
            this.element = jsonElement;
            this.setComment = setComment;
            this.getComment = getComment;
            this.as = as;
        }

        @Override
        public void setComment(String comment) {
            this.setComment.accept(comment);
        }

        @Override
        public String getComment() {
            return this.getComment.get();
        }

        @Override
        public boolean isNumber() {
            return this.element instanceof JsonPrimitive && ((JsonPrimitive)this.element).getValue() instanceof Number;
        }

        @Override
        public boolean isCharacter() {
            return this.element instanceof JsonPrimitive && (((JsonPrimitive)this.element).getValue() instanceof String && ((String)((JsonPrimitive)this.element).getValue()).length() == 1 || ((JsonPrimitive)this.element).getValue() instanceof Character);
        }

        @Override
        public boolean isString() {
            return this.element instanceof JsonPrimitive && ((JsonPrimitive)this.element).getValue() instanceof String;
        }

        @Override
        public boolean isBoolean() {
            return this.element instanceof JsonPrimitive && ((JsonPrimitive)this.element).getValue() instanceof Boolean;
        }

        @Override
        public boolean isObject() {
            return this.element instanceof JsonObject;
        }

        @Override
        public boolean isList() {
            return this.element instanceof JsonArray;
        }

        @Override
        public byte asByte() {
            return (Byte)this.as.apply(Byte.TYPE);
        }

        @Override
        public short asShort() {
            return (Short)this.as.apply(Short.TYPE);
        }

        @Override
        public int asInt() {
            return (Integer)this.as.apply(Integer.TYPE);
        }

        @Override
        public long asLong() {
            return (Long)this.as.apply(Long.TYPE);
        }

        @Override
        public float asFloat() {
            return ((Float)this.as.apply(Float.TYPE)).floatValue();
        }

        @Override
        public double asDouble() {
            return (Double)this.as.apply(Double.TYPE);
        }

        @Override
        public char asCharacter() {
            return ((Character)this.as.apply(Character.TYPE)).charValue();
        }

        @Override
        public String asString() {
            return (String)this.as.apply(String.class);
        }

        @Override
        public boolean asBoolean() {
            return (Boolean)this.as.apply(Boolean.TYPE);
        }

        @Override
        public DataObject<JsonElement> asObject() {
            return new JanksonObject(this.element, this.setComment, this.getComment, this.as);
        }

        @Override
        public DataList<JsonElement> asList() {
            return new JanksonList(this.element, this.setComment, this.getComment, this.as);
        }

        @Override
        public JsonElement getRaw() {
            return this.element;
        }
    }
}

