/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed.config.value.serializer;

import de.siphalor.tweed.config.value.serializer.ConfigValueSerializer;
import de.siphalor.tweed.data.DataContainer;
import de.siphalor.tweed.data.DataValue;
import java.util.Locale;
import net.minecraft.class_2540;

public class EnumSerializer<E extends Enum<?>>
extends ConfigValueSerializer<E> {
    E fallback;

    public EnumSerializer(E fallback) {
        this.fallback = fallback;
    }

    @Override
    public E read(DataValue<?> data) {
        if (data.isString()) {
            String str = data.asString().toLowerCase(Locale.ENGLISH);
            for (Enum value : (Enum[])this.fallback.getClass().getEnumConstants()) {
                if (!value.name().toLowerCase(Locale.ENGLISH).equals(str)) continue;
                return (E)value;
            }
        }
        return this.fallback;
    }

    @Override
    public <Key> void write(DataContainer<?, Key> dataContainer, Key key, E value) {
        dataContainer.set(key, ((Enum)value).name());
    }

    @Override
    public E read(class_2540 packetByteBuf) {
        String str = packetByteBuf.method_10800(Short.MAX_VALUE);
        for (Enum value : (Enum[])this.fallback.getClass().getEnumConstants()) {
            if (!value.name().toLowerCase(Locale.ENGLISH).equals(str)) continue;
            return (E)value;
        }
        return this.fallback;
    }

    @Override
    public void write(class_2540 packetByteBuf, E value) {
        packetByteBuf.method_10814(((Enum)value).name().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public String asString(E value) {
        return ((Enum)value).name();
    }

    @Override
    public Class<E> getType() {
        return this.fallback.getClass();
    }
}

