/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed.config;

import com.google.common.base.CaseFormat;
import de.siphalor.tweed.Tweed;
import de.siphalor.tweed.config.ConfigCategory;
import de.siphalor.tweed.config.ConfigFile;
import de.siphalor.tweed.config.TweedRegistry;
import de.siphalor.tweed.config.annotated.AConfigBackground;
import de.siphalor.tweed.config.annotated.AConfigConstraint;
import de.siphalor.tweed.config.annotated.AConfigEntry;
import de.siphalor.tweed.config.annotated.AConfigExclude;
import de.siphalor.tweed.config.annotated.AConfigFixer;
import de.siphalor.tweed.config.annotated.AConfigListener;
import de.siphalor.tweed.config.annotated.AConfigTransitive;
import de.siphalor.tweed.config.annotated.ATweedConfig;
import de.siphalor.tweed.config.constraints.AnnotationConstraint;
import de.siphalor.tweed.config.entry.AbstractBasicEntry;
import de.siphalor.tweed.config.entry.ConfigEntry;
import de.siphalor.tweed.config.entry.ValueConfigEntry;
import de.siphalor.tweed.config.fixers.ConfigEntryFixer;
import de.siphalor.tweed.config.value.ConfigValue;
import de.siphalor.tweed.config.value.ReferenceConfigValue;
import de.siphalor.tweed.config.value.serializer.ConfigValueSerializer;
import de.siphalor.tweed.data.DataObject;
import de.siphalor.tweed.data.serializer.ConfigDataSerializer;
import de.siphalor.tweed.data.serializer.HjsonSerializer;
import de.siphalor.tweed.tailor.Tailor;
import de.siphalor.tweed.util.ReflectionUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3545;

public class POJOConverter {
    private static final Map<Class<?>, ConfigValueSerializer<?>> SERIALIZER_MAP = new HashMap();

    public static void registerSerializer(Class<?> clazz, ConfigValueSerializer<?> serializer) {
        SERIALIZER_MAP.put(clazz, serializer);
    }

    public static ConfigFile toConfigFile(final Object pojo, String fallbackFileName) throws RuntimeException {
        ATweedConfig tweedConfig = pojo.getClass().getAnnotation(ATweedConfig.class);
        if (tweedConfig == null) {
            throw new RuntimeException("Tweed POJOs need the ATweedConfig annotation!");
        }
        ConfigCategory rootCategory = POJOConverter.toCategory(pojo, tweedConfig.casing());
        rootCategory.setScope(tweedConfig.scope());
        rootCategory.setEnvironment(tweedConfig.environment());
        String file = tweedConfig.file();
        if (file.isEmpty()) {
            file = fallbackFileName;
        }
        ConfigDataSerializer serializer = TweedRegistry.SERIALIZERS.method_17966(new class_2960(tweedConfig.serializer())).orElse(HjsonSerializer.INSTANCE);
        ConfigFile configFile = new ConfigFile(file, serializer, rootCategory);
        for (final Method method : pojo.getClass().getDeclaredMethods()) {
            Class<?>[] args;
            AConfigFixer configFixer = method.getAnnotation(AConfigFixer.class);
            if (configFixer == null || method.getParameterCount() != 2 || (args = method.getParameterTypes())[0] != DataObject.class || args[1] != DataObject.class) continue;
            method.setAccessible(true);
            ConfigEntryFixer configEntryFixer = new ConfigEntryFixer(){

                @Override
                public void fix(DataObject<?> dataObject, String propertyName, DataObject<?> mainCompound) {
                    try {
                        method.invoke(pojo, dataObject, mainCompound);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            };
            configFile.register(configFixer.value().isEmpty() ? "" : configFixer.value() + '.' + "_", configEntryFixer);
        }
        configFile.addTailorAnnotations(pojo.getClass().getAnnotations());
        for (String tailorId : tweedConfig.tailors()) {
            Tailor tailor = (Tailor)TweedRegistry.TAILORS.method_10223(new class_2960(tailorId));
            if (tailor == null) continue;
            tailor.process(configFile);
        }
        return configFile;
    }

    public static ConfigCategory toCategory(Object pojo, CaseFormat casing) {
        String tex;
        ConfigCategory configCategory = new ConfigCategory();
        if (pojo.getClass().isAnnotationPresent(AConfigBackground.class) && !"".equals(tex = pojo.getClass().getAnnotation(AConfigBackground.class).value())) {
            configCategory.setBackgroundTexture(new class_2960(tex));
        }
        for (Field field : ReflectionUtil.getAllDeclaredFields(pojo.getClass())) {
            try {
                POJOConverter.addToCategory(configCategory, pojo, field, casing);
            }
            catch (StackOverflowError e) {
                Tweed.LOGGER.error("Failed to unwrap unknown object of type \"" + field.getType() + "\" in field \"" + field.getName() + "\". This usually indicates recursively nested types without serializers.");
            }
        }
        for (AccessibleObject accessibleObject : ReflectionUtil.getAllDeclaredMethods(pojo.getClass())) {
            AConfigListener configListener = ((Method)accessibleObject).getAnnotation(AConfigListener.class);
            if (configListener == null) continue;
            if (((Method)accessibleObject).getParameterCount() > 0) {
                Tweed.LOGGER.error("Method " + ((Method)accessibleObject).getName() + " on " + pojo.getClass().getCanonicalName() + " must have no parameters to be a listener!");
                continue;
            }
            if (configListener.value().isEmpty()) {
                ((Method)accessibleObject).setAccessible(true);
                configCategory.setReloadListener(() -> POJOConverter.lambda$toCategory$0((Method)accessibleObject, pojo));
                continue;
            }
            ConfigEntry<?> configEntry = configCategory.get(configListener.value());
            if (configEntry != null) {
                if (configEntry instanceof ConfigCategory) {
                    ((ConfigCategory)configEntry).setReloadListener(() -> POJOConverter.lambda$toCategory$1((Method)accessibleObject, pojo));
                    continue;
                }
                if (configEntry instanceof ValueConfigEntry) {
                    ((ValueConfigEntry)configEntry).setReloadListener(arg_0 -> POJOConverter.lambda$toCategory$2((Method)accessibleObject, pojo, arg_0));
                    continue;
                }
                Tweed.LOGGER.error("Couldn't bind config reload listener on " + pojo.getClass().getCanonicalName() + " for " + configListener.value() + " to an entry.");
                continue;
            }
            Tweed.LOGGER.error("Couldn't find a config entry to bind the reload listener to in " + pojo.getClass().getCanonicalName());
        }
        return configCategory;
    }

    public static void addToCategory(ConfigCategory configCategory, Object pojo, Field field, CaseFormat casing) {
        if (pojo.getClass() == field.getGenericType()) {
            Tweed.LOGGER.error("Found recursively nested type in config entry, skipping this field: " + field.getName() + " in " + pojo.getClass());
            return;
        }
        field.setAccessible(true);
        if (field.isAnnotationPresent(AConfigExclude.class)) {
            return;
        }
        if (field.isAnnotationPresent(AConfigTransitive.class)) {
            try {
                Object o = field.get(pojo);
                if (o == null) {
                    try {
                        Constructor<?> constructor = field.getType().getConstructor(new Class[0]);
                        o = constructor.newInstance(new Object[0]);
                        field.set(pojo, o);
                    }
                    catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        e.printStackTrace();
                        return;
                    }
                }
                Object finalO = o;
                Arrays.stream(ReflectionUtil.getAllDeclaredFields(o.getClass())).forEach(field1 -> POJOConverter.addToCategory(configCategory, finalO, field1, casing));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            class_3545<String, ConfigEntry<?>> converted = POJOConverter.toEntry(pojo, field, casing);
            if (converted == null) {
                return;
            }
            configCategory.register((String)converted.method_15442(), (ConfigEntry)converted.method_15441());
        }
    }

    public static class_3545<String, ConfigEntry<?>> toEntry(Object pojo, Field field, CaseFormat casing) {
        try {
            AbstractBasicEntry basicEntry;
            Object entryObject = field.get(pojo);
            ConfigValueSerializer<?> valueSerializer = ConfigValue.serializer(entryObject, field.getType());
            if (valueSerializer == null) {
                valueSerializer = SERIALIZER_MAP.get(field.getType());
            }
            if (valueSerializer == null) {
                if (entryObject == null) {
                    try {
                        Constructor<?> constructor = field.getType().getConstructor(new Class[0]);
                        entryObject = constructor.newInstance(new Object[0]);
                        field.set(pojo, entryObject);
                    }
                    catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                basicEntry = POJOConverter.toCategory(entryObject, casing);
            } else {
                basicEntry = new ValueConfigEntry(new ReferenceConfigValue(pojo, field), valueSerializer);
            }
            String name = CaseFormat.LOWER_CAMEL.to(casing, field.getName());
            if (field.isAnnotationPresent(AConfigEntry.class)) {
                AConfigEntry configData = field.getAnnotation(AConfigEntry.class);
                if (!"".equals(configData.name())) {
                    name = configData.name();
                }
                basicEntry.setComment(configData.comment());
                basicEntry.setScope(configData.scope());
                basicEntry.setEnvironment(configData.environment());
                if (basicEntry instanceof ValueConfigEntry) {
                    for (AConfigConstraint aConstraint : configData.constraints()) {
                        Class<?> clazz = aConstraint.value();
                        if (!AnnotationConstraint.class.isAssignableFrom(clazz)) continue;
                        try {
                            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                            constructor.setAccessible(true);
                            AnnotationConstraint constraint = (AnnotationConstraint)constructor.newInstance(new Object[0]);
                            constraint.fromAnnotationParam(aConstraint.param(), ((ValueConfigEntry)basicEntry).getType());
                            ((ValueConfigEntry)basicEntry).addConstraint(constraint);
                        }
                        catch (InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                            // empty catch block
                        }
                    }
                }
            }
            return new class_3545((Object)name, (Object)basicEntry);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static /* synthetic */ void lambda$toCategory$2(Method method, Object pojo, Object o) {
        try {
            method.invoke(pojo, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void lambda$toCategory$1(Method method, Object pojo) {
        try {
            method.invoke(pojo, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void lambda$toCategory$0(Method method, Object pojo) {
        try {
            method.invoke(pojo, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

