/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.gui;

import net.minecraft.class_1074;
import net.minecraft.class_2585;
import net.minecraft.class_315;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.optifine.Config;
import net.optifine.Lang;
import net.optifine.gui.GuiButtonOF;
import net.optifine.gui.GuiScreenOF;
import net.optifine.gui.TooltipManager;
import net.optifine.gui.TooltipProviderShaderOptions;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.config.ShaderOption;
import net.optifine.shaders.config.ShaderOptionProfile;
import net.optifine.shaders.config.ShaderOptionScreen;
import net.optifine.shaders.gui.GuiButtonShaderOption;
import net.optifine.shaders.gui.GuiSliderShaderOption;

public class GuiShaderOptions
extends GuiScreenOF {
    private class_437 prevScreen;
    private class_315 settings;
    private TooltipManager tooltipManager = new TooltipManager(this, new TooltipProviderShaderOptions());
    private String screenName = null;
    private String screenText = null;
    private boolean changed = false;
    public static final String OPTION_PROFILE = "<profile>";
    public static final String OPTION_EMPTY = "<empty>";
    public static final String OPTION_REST = "*";

    public GuiShaderOptions(class_437 guiscreen, class_315 gamesettings) {
        super(new class_2585(class_1074.method_4662("of.options.shaderOptionsTitle", new Object[0])));
        this.prevScreen = guiscreen;
        this.settings = gamesettings;
    }

    public GuiShaderOptions(class_437 guiscreen, class_315 gamesettings, String screenName) {
        this(guiscreen, gamesettings);
        this.screenName = screenName;
        if (screenName != null) {
            this.screenText = Shaders.translate("screen." + screenName, screenName);
        }
    }

    @Override
    public void method_25426() {
        int baseId = 100;
        int baseX = 0;
        int baseY = 30;
        int stepY = 20;
        int btnWidth = 120;
        int btnHeight = 20;
        int columns = Shaders.getShaderPackColumns(this.screenName, 2);
        ShaderOption[] ops = Shaders.getShaderPackOptions(this.screenName);
        if (ops != null) {
            int colsMin = class_3532.method_15384((double)ops.length / 9.0);
            if (columns < colsMin) {
                columns = colsMin;
            }
            for (int i = 0; i < ops.length; ++i) {
                ShaderOption so = ops[i];
                if (so == null || !so.isVisible()) continue;
                int col = i % columns;
                int row = i / columns;
                int colWidth = Math.min(this.field_22789 / columns, 200);
                baseX = (this.field_22789 - colWidth * columns) / 2;
                int x = col * colWidth + 5 + baseX;
                int y = baseY + row * stepY;
                int w = colWidth - 10;
                int h = btnHeight;
                String text = GuiShaderOptions.getButtonText(so, w);
                GuiButtonShaderOption btn = Shaders.isShaderPackOptionSlider(so.getName()) ? new GuiSliderShaderOption(baseId + i, x, y, w, h, so, text) : new GuiButtonShaderOption(baseId + i, x, y, w, h, so, text);
                btn.field_22763 = so.isEnabled();
                this.method_37063(btn);
            }
        }
        this.method_37063(new GuiButtonOF(201, this.field_22789 / 2 - btnWidth - 20, this.field_22790 / 6 + 168 + 11, btnWidth, btnHeight, class_1074.method_4662("controls.reset", new Object[0])));
        this.method_37063(new GuiButtonOF(200, this.field_22789 / 2 + 20, this.field_22790 / 6 + 168 + 11, btnWidth, btnHeight, class_1074.method_4662("gui.done", new Object[0])));
    }

    public static String getButtonText(ShaderOption so, int btnWidth) {
        String labelName = so.getNameText();
        if (so instanceof ShaderOptionScreen) {
            ShaderOptionScreen soScr = (ShaderOptionScreen)so;
            return labelName + "...";
        }
        class_327 fr = Config.getMinecraft().field_1772;
        int lenSuffix = fr.method_1727(": " + Lang.getOff()) + 5;
        while (fr.method_1727(labelName) + lenSuffix >= btnWidth && labelName.length() > 0) {
            labelName = labelName.substring(0, labelName.length() - 1);
        }
        String col = so.isChanged() ? so.getValueColor(so.getValue()) : "";
        String labelValue = so.getValueText(so.getValue());
        return labelName + ": " + col + labelValue;
    }

    @Override
    protected void actionPerformed(class_339 guiElement) {
        if (!(guiElement instanceof GuiButtonOF)) {
            return;
        }
        GuiButtonOF guibutton = (GuiButtonOF)guiElement;
        if (!guibutton.field_22763) {
            return;
        }
        if (guibutton.id < 200 && guibutton instanceof GuiButtonShaderOption) {
            GuiButtonShaderOption btnSo = (GuiButtonShaderOption)guibutton;
            ShaderOption so = btnSo.getShaderOption();
            if (so instanceof ShaderOptionScreen) {
                String screenName = so.getName();
                GuiShaderOptions scr = new GuiShaderOptions(this, this.settings, screenName);
                this.field_22787.method_1507(scr);
                return;
            }
            if (GuiShaderOptions.method_25442()) {
                so.resetValue();
            } else if (btnSo.isSwitchable()) {
                so.nextValue();
            }
            this.updateAllButtons();
            this.changed = true;
        }
        if (guibutton.id == 201) {
            ShaderOption[] opts = Shaders.getChangedOptions(Shaders.getShaderPackOptions());
            for (int i = 0; i < opts.length; ++i) {
                ShaderOption opt = opts[i];
                opt.resetValue();
                this.changed = true;
            }
            this.updateAllButtons();
        }
        if (guibutton.id == 200) {
            if (this.changed) {
                Shaders.saveShaderPackOptions();
                this.changed = false;
                Shaders.uninit();
            }
            this.field_22787.method_1507(this.prevScreen);
        }
    }

    @Override
    public void method_25432() {
        if (this.changed) {
            Shaders.saveShaderPackOptions();
            this.changed = false;
            Shaders.uninit();
        }
        super.method_25432();
    }

    @Override
    protected void actionPerformedRightClick(class_339 guiElement) {
        if (guiElement instanceof GuiButtonShaderOption) {
            GuiButtonShaderOption btnSo = (GuiButtonShaderOption)guiElement;
            ShaderOption so = btnSo.getShaderOption();
            if (GuiShaderOptions.method_25442()) {
                so.resetValue();
            } else if (btnSo.isSwitchable()) {
                so.prevValue();
            }
            this.updateAllButtons();
            this.changed = true;
        }
    }

    private void updateAllButtons() {
        for (class_4185 class_41852 : this.getButtonList()) {
            if (!(class_41852 instanceof GuiButtonShaderOption)) continue;
            GuiButtonShaderOption gbso = (GuiButtonShaderOption)class_41852;
            ShaderOption opt = gbso.getShaderOption();
            if (opt instanceof ShaderOptionProfile) {
                ShaderOptionProfile optProf = (ShaderOptionProfile)opt;
                optProf.updateProfile();
            }
            gbso.setMessage(GuiShaderOptions.getButtonText(opt, gbso.method_25368()));
            gbso.valueChanged();
        }
    }

    @Override
    public void method_25394(class_4587 matrixStackIn, int x, int y, float partialTicks) {
        this.method_25420(matrixStackIn);
        if (this.screenText != null) {
            GuiShaderOptions.method_25300(matrixStackIn, this.fontRenderer, this.screenText, this.field_22789 / 2, 15, 0xFFFFFF);
        } else {
            GuiShaderOptions.method_27534(matrixStackIn, this.fontRenderer, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        }
        super.method_25394(matrixStackIn, x, y, partialTicks);
        this.tooltipManager.drawTooltips(matrixStackIn, x, y, this.getButtonList());
    }
}

