/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraft.class_2338;
import net.optifine.BlockPosM;

public class IteratorAxis
implements Iterator<class_2338> {
    private double yDelta;
    private double zDelta;
    private int xStart;
    private int xEnd;
    private double yStart;
    private double yEnd;
    private double zStart;
    private double zEnd;
    private int xNext;
    private double yNext;
    private double zNext;
    private BlockPosM pos = new BlockPosM(0, 0, 0);
    private boolean hasNext = false;

    public IteratorAxis(class_2338 posStart, class_2338 posEnd, double yDelta, double zDelta) {
        this.yDelta = yDelta;
        this.zDelta = zDelta;
        this.xStart = posStart.method_10263();
        this.xEnd = posEnd.method_10263();
        this.yStart = posStart.method_10264();
        this.yEnd = (double)posEnd.method_10264() - 0.5;
        this.zStart = posStart.method_10260();
        this.zEnd = (double)posEnd.method_10260() - 0.5;
        this.xNext = this.xStart;
        this.yNext = this.yStart;
        this.zNext = this.zStart;
        this.hasNext = this.xNext < this.xEnd && this.yNext < this.yEnd && this.zNext < this.zEnd;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public class_2338 next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        this.pos.setXyz((double)this.xNext, this.yNext, this.zNext);
        this.nextPos();
        this.hasNext = this.xNext < this.xEnd && this.yNext < this.yEnd && this.zNext < this.zEnd;
        return this.pos;
    }

    private void nextPos() {
        this.zNext += 1.0;
        if (this.zNext < this.zEnd) {
            return;
        }
        this.zNext = this.zStart;
        this.yNext += 1.0;
        if (this.yNext < this.yEnd) {
            return;
        }
        this.yNext = this.yStart;
        this.yStart += this.yDelta;
        this.yEnd += this.yDelta;
        this.yNext = this.yStart;
        this.zStart += this.zDelta;
        this.zEnd += this.zDelta;
        this.zNext = this.zStart;
        ++this.xNext;
        if (this.xNext < this.xEnd) {
            return;
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }

    public static void main(String[] args) throws Exception {
        class_2338 posStart = new class_2338(-2, 10, 20);
        class_2338 posEnd = new class_2338(2, 12, 22);
        double yDelta = -0.5;
        double zDelta = 0.5;
        IteratorAxis it = new IteratorAxis(posStart, posEnd, yDelta, zDelta);
        System.out.println("Start: " + posStart + ", end: " + posEnd + ", yDelta: " + yDelta + ", zDelta: " + zDelta);
        while (it.hasNext()) {
            class_2338 blockPos = it.next();
            System.out.println("" + blockPos);
        }
    }
}

