/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import net.optifine.util.TextureUtils;

public abstract class SlotGui
extends class_362
implements class_4068,
class_6379 {
    public static final class_2960 WHITE_TEXTURE_LOCATION = TextureUtils.WHITE_TEXTURE_LOCATION;
    protected static final int NO_DRAG = -1;
    protected static final int DRAG_OUTSIDE = -2;
    protected final class_310 minecraft;
    protected int width;
    protected int height;
    protected int y0;
    protected int y1;
    protected int x1;
    protected int x0;
    protected final int itemHeight;
    protected boolean centerListVertically = true;
    protected int yDrag = -2;
    protected double yo;
    protected boolean visible = true;
    protected boolean renderSelection = true;
    protected boolean renderHeader;
    protected int headerHeight;
    private boolean scrolling;

    public SlotGui(class_310 mcIn, int width, int height, int topIn, int bottomIn, int slotHeightIn) {
        this.minecraft = mcIn;
        this.width = width;
        this.height = height;
        this.y0 = topIn;
        this.y1 = bottomIn;
        this.itemHeight = slotHeightIn;
        this.x0 = 0;
        this.x1 = width;
    }

    public void updateSize(int p_updateSize_1_, int p_updateSize_2_, int p_updateSize_3_, int p_updateSize_4_) {
        this.width = p_updateSize_1_;
        this.height = p_updateSize_2_;
        this.y0 = p_updateSize_3_;
        this.y1 = p_updateSize_4_;
        this.x0 = 0;
        this.x1 = p_updateSize_1_;
    }

    public void setRenderSelection(boolean p_setRenderSelection_1_) {
        this.renderSelection = p_setRenderSelection_1_;
    }

    protected void setRenderHeader(boolean p_setRenderHeader_1_, int p_setRenderHeader_2_) {
        this.renderHeader = p_setRenderHeader_1_;
        this.headerHeight = p_setRenderHeader_2_;
        if (!p_setRenderHeader_1_) {
            this.headerHeight = 0;
        }
    }

    public void setVisible(boolean p_setVisible_1_) {
        this.visible = p_setVisible_1_;
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected abstract int getItemCount();

    @Override
    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }

    protected boolean selectItem(int p_selectItem_1_, int p_selectItem_2_, double p_selectItem_3_, double p_selectItem_5_) {
        return true;
    }

    protected abstract boolean isSelectedItem(int var1);

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected abstract void renderBackground();

    protected void updateItemPosition(int p_updateItemPosition_1_, int p_updateItemPosition_2_, int p_updateItemPosition_3_, float p_updateItemPosition_4_) {
    }

    protected abstract void renderItem(class_4587 var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);

    protected void renderHeader(int p_renderHeader_1_, int p_renderHeader_2_, class_289 p_renderHeader_3_) {
    }

    protected void clickedHeader(int p_clickedHeader_1_, int p_clickedHeader_2_) {
    }

    protected void renderDecorations(int p_renderDecorations_1_, int p_renderDecorations_2_) {
    }

    public int getItemAtPosition(double p_getItemAtPosition_1_, double p_getItemAtPosition_3_) {
        int i = this.x0 + this.width / 2 - this.getRowWidth() / 2;
        int j = this.x0 + this.width / 2 + this.getRowWidth() / 2;
        int k = class_3532.method_15357(p_getItemAtPosition_3_ - (double)this.y0) - this.headerHeight + (int)this.yo - 4;
        int l = k / this.itemHeight;
        return p_getItemAtPosition_1_ < (double)this.getScrollbarPosition() && p_getItemAtPosition_1_ >= (double)i && p_getItemAtPosition_1_ <= (double)j && l >= 0 && k >= 0 && l < this.getItemCount() ? l : -1;
    }

    protected void capYPosition() {
        this.yo = class_3532.method_15350(this.yo, 0.0, this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    public void centerScrollOn(int p_centerScrollOn_1_) {
        this.yo = p_centerScrollOn_1_ * this.itemHeight + this.itemHeight / 2 - (this.y1 - this.y0) / 2;
        this.capYPosition();
    }

    public int getScroll() {
        return (int)this.yo;
    }

    public boolean isMouseInList(double p_isMouseInList_1_, double p_isMouseInList_3_) {
        return p_isMouseInList_3_ >= (double)this.y0 && p_isMouseInList_3_ <= (double)this.y1 && p_isMouseInList_1_ >= (double)this.x0 && p_isMouseInList_1_ <= (double)this.x1;
    }

    public int getScrollBottom() {
        return (int)this.yo - this.height - this.headerHeight;
    }

    public void scroll(int p_scroll_1_) {
        this.yo += (double)p_scroll_1_;
        this.capYPosition();
        this.yDrag = -2;
    }

    @Override
    public void method_25394(class_4587 matrixStackIn, int p_render_1_, int p_render_2_, float p_render_3_) {
        if (this.visible) {
            this.renderBackground();
            int i = this.getScrollbarPosition();
            int j = i + 6;
            this.capYPosition();
            class_289 tessellator = class_289.method_1348();
            class_287 bufferbuilder = tessellator.method_1349();
            RenderSystem.setShader(class_757::method_34543);
            RenderSystem.setShaderTexture(0, class_332.field_22735);
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            float f = 32.0f;
            bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            bufferbuilder.method_22912(this.x0, this.y1, 0.0).method_22913((float)this.x0 / 32.0f, (float)(this.y1 + (int)this.yo) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            bufferbuilder.method_22912(this.x1, this.y1, 0.0).method_22913((float)this.x1 / 32.0f, (float)(this.y1 + (int)this.yo) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            bufferbuilder.method_22912(this.x1, this.y0, 0.0).method_22913((float)this.x1 / 32.0f, (float)(this.y0 + (int)this.yo) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            bufferbuilder.method_22912(this.x0, this.y0, 0.0).method_22913((float)this.x0 / 32.0f, (float)(this.y0 + (int)this.yo) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            tessellator.method_1350();
            int k = this.x0 + this.width / 2 - this.getRowWidth() / 2 + 2;
            int l = this.y0 + 4 - (int)this.yo;
            if (this.renderHeader) {
                this.renderHeader(k, l, tessellator);
            }
            this.renderList(matrixStackIn, k, l, p_render_1_, p_render_2_, p_render_3_);
            RenderSystem.disableDepthTest();
            this.renderHoleBackground(0, this.y0, 255, 255);
            this.renderHoleBackground(this.y1, this.height, 255, 255);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate(GlStateManager.class_4535.SRC_ALPHA, GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, GlStateManager.class_4535.ZERO, GlStateManager.class_4534.ONE);
            RenderSystem.setShader(class_757::method_34543);
            RenderSystem.setShaderTexture(0, WHITE_TEXTURE_LOCATION);
            RenderSystem.disableTexture();
            int i1 = 4;
            bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            bufferbuilder.method_22912(this.x0, this.y0 + 4, 0.0).method_22913(0.0f, 1.0f).method_1336(0, 0, 0, 0).method_1344();
            bufferbuilder.method_22912(this.x1, this.y0 + 4, 0.0).method_22913(1.0f, 1.0f).method_1336(0, 0, 0, 0).method_1344();
            bufferbuilder.method_22912(this.x1, this.y0, 0.0).method_22913(1.0f, 0.0f).method_1336(0, 0, 0, 255).method_1344();
            bufferbuilder.method_22912(this.x0, this.y0, 0.0).method_22913(0.0f, 0.0f).method_1336(0, 0, 0, 255).method_1344();
            tessellator.method_1350();
            bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            bufferbuilder.method_22912(this.x0, this.y1, 0.0).method_22913(0.0f, 1.0f).method_1336(0, 0, 0, 255).method_1344();
            bufferbuilder.method_22912(this.x1, this.y1, 0.0).method_22913(1.0f, 1.0f).method_1336(0, 0, 0, 255).method_1344();
            bufferbuilder.method_22912(this.x1, this.y1 - 4, 0.0).method_22913(1.0f, 0.0f).method_1336(0, 0, 0, 0).method_1344();
            bufferbuilder.method_22912(this.x0, this.y1 - 4, 0.0).method_22913(0.0f, 0.0f).method_1336(0, 0, 0, 0).method_1344();
            tessellator.method_1350();
            int j1 = this.getMaxScroll();
            if (j1 > 0) {
                int k1 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
                int l1 = (int)this.yo * (this.y1 - this.y0 - (k1 = class_3532.method_15340(k1, 32, this.y1 - this.y0 - 8))) / j1 + this.y0;
                if (l1 < this.y0) {
                    l1 = this.y0;
                }
                bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
                bufferbuilder.method_22912(i, this.y1, 0.0).method_22913(0.0f, 1.0f).method_1336(0, 0, 0, 255).method_1344();
                bufferbuilder.method_22912(j, this.y1, 0.0).method_22913(1.0f, 1.0f).method_1336(0, 0, 0, 255).method_1344();
                bufferbuilder.method_22912(j, this.y0, 0.0).method_22913(1.0f, 0.0f).method_1336(0, 0, 0, 255).method_1344();
                bufferbuilder.method_22912(i, this.y0, 0.0).method_22913(0.0f, 0.0f).method_1336(0, 0, 0, 255).method_1344();
                tessellator.method_1350();
                bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
                bufferbuilder.method_22912(i, l1 + k1, 0.0).method_22913(0.0f, 1.0f).method_1336(128, 128, 128, 255).method_1344();
                bufferbuilder.method_22912(j, l1 + k1, 0.0).method_22913(1.0f, 1.0f).method_1336(128, 128, 128, 255).method_1344();
                bufferbuilder.method_22912(j, l1, 0.0).method_22913(1.0f, 0.0f).method_1336(128, 128, 128, 255).method_1344();
                bufferbuilder.method_22912(i, l1, 0.0).method_22913(0.0f, 0.0f).method_1336(128, 128, 128, 255).method_1344();
                tessellator.method_1350();
                bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
                bufferbuilder.method_22912(i, l1 + k1 - 1, 0.0).method_22913(0.0f, 1.0f).method_1336(192, 192, 192, 255).method_1344();
                bufferbuilder.method_22912(j - 1, l1 + k1 - 1, 0.0).method_22913(1.0f, 1.0f).method_1336(192, 192, 192, 255).method_1344();
                bufferbuilder.method_22912(j - 1, l1, 0.0).method_22913(1.0f, 0.0f).method_1336(192, 192, 192, 255).method_1344();
                bufferbuilder.method_22912(i, l1, 0.0).method_22913(0.0f, 0.0f).method_1336(192, 192, 192, 255).method_1344();
                tessellator.method_1350();
            }
            this.renderDecorations(p_render_1_, p_render_2_);
            RenderSystem.enableTexture();
            RenderSystem.disableBlend();
        }
    }

    protected void updateScrollingState(double p_updateScrollingState_1_, double p_updateScrollingState_3_, int p_updateScrollingState_5_) {
        this.scrolling = p_updateScrollingState_5_ == 0 && p_updateScrollingState_1_ >= (double)this.getScrollbarPosition() && p_updateScrollingState_1_ < (double)(this.getScrollbarPosition() + 6);
    }

    @Override
    public boolean method_25402(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        this.updateScrollingState(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        if (this.isVisible() && this.isMouseInList(p_mouseClicked_1_, p_mouseClicked_3_)) {
            int i = this.getItemAtPosition(p_mouseClicked_1_, p_mouseClicked_3_);
            if (i == -1 && p_mouseClicked_5_ == 0) {
                this.clickedHeader((int)(p_mouseClicked_1_ - (double)(this.x0 + this.width / 2 - this.getRowWidth() / 2)), (int)(p_mouseClicked_3_ - (double)this.y0) + (int)this.yo - 4);
                return true;
            }
            if (i != -1 && this.selectItem(i, p_mouseClicked_5_, p_mouseClicked_1_, p_mouseClicked_3_)) {
                if (this.method_25396().size() > i) {
                    this.method_25395(this.method_25396().get(i));
                }
                this.method_25398(true);
                return true;
            }
            return this.scrolling;
        }
        return false;
    }

    @Override
    public boolean method_25406(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        if (this.method_25399() != null) {
            this.method_25399().method_25406(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        }
        return false;
    }

    @Override
    public boolean method_25403(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (super.method_25403(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_)) {
            return true;
        }
        if (this.isVisible() && p_mouseDragged_5_ == 0 && this.scrolling) {
            if (p_mouseDragged_3_ < (double)this.y0) {
                this.yo = 0.0;
            } else if (p_mouseDragged_3_ > (double)this.y1) {
                this.yo = this.getMaxScroll();
            } else {
                double d0 = this.getMaxScroll();
                if (d0 < 1.0) {
                    d0 = 1.0;
                }
                int i = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
                double d1 = d0 / (double)(this.y1 - this.y0 - (i = class_3532.method_15340(i, 32, this.y1 - this.y0 - 8)));
                if (d1 < 1.0) {
                    d1 = 1.0;
                }
                this.yo += p_mouseDragged_8_ * d1;
                this.capYPosition();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25401(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (!this.isVisible()) {
            return false;
        }
        this.yo -= p_mouseScrolled_5_ * (double)this.itemHeight / 2.0;
        return true;
    }

    @Override
    public boolean method_25404(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (!this.isVisible()) {
            return false;
        }
        if (super.method_25404(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        if (p_keyPressed_1_ == 264) {
            this.moveSelection(1);
            return true;
        }
        if (p_keyPressed_1_ == 265) {
            this.moveSelection(-1);
            return true;
        }
        return false;
    }

    protected void moveSelection(int p_moveSelection_1_) {
    }

    @Override
    public boolean method_25400(char p_charTyped_1_, int p_charTyped_2_) {
        return !this.isVisible() ? false : super.method_25400(p_charTyped_1_, p_charTyped_2_);
    }

    @Override
    public boolean method_25405(double p_isMouseOver_1_, double p_isMouseOver_3_) {
        return this.isMouseInList(p_isMouseOver_1_, p_isMouseOver_3_);
    }

    public int getRowWidth() {
        return 220;
    }

    protected void renderList(class_4587 matrixStackIn, int p_renderList_1_, int p_renderList_2_, int p_renderList_3_, int p_renderList_4_, float p_renderList_5_) {
        int i = this.getItemCount();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        for (int j = 0; j < i; ++j) {
            int k = p_renderList_2_ + j * this.itemHeight + this.headerHeight;
            int l = this.itemHeight - 4;
            if (k > this.y1 || k + l < this.y0) {
                this.updateItemPosition(j, p_renderList_1_, k, p_renderList_5_);
            }
            if (this.renderSelection && this.isSelectedItem(j)) {
                int i1 = this.x0 + this.width / 2 - this.getRowWidth() / 2;
                int j1 = this.x0 + this.width / 2 + this.getRowWidth() / 2;
                RenderSystem.disableTexture();
                RenderSystem.setShader(class_757::method_34539);
                float f = this.isFocused() ? 1.0f : 0.5f;
                RenderSystem.setShaderColor(f, f, f, 1.0f);
                bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
                bufferbuilder.method_22912(i1, k + l + 2, 0.0).method_1344();
                bufferbuilder.method_22912(j1, k + l + 2, 0.0).method_1344();
                bufferbuilder.method_22912(j1, k - 2, 0.0).method_1344();
                bufferbuilder.method_22912(i1, k - 2, 0.0).method_1344();
                tessellator.method_1350();
                RenderSystem.setShaderColor(0.0f, 0.0f, 0.0f, 1.0f);
                bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
                bufferbuilder.method_22912(i1 + 1, k + l + 1, 0.0).method_1344();
                bufferbuilder.method_22912(j1 - 1, k + l + 1, 0.0).method_1344();
                bufferbuilder.method_22912(j1 - 1, k - 1, 0.0).method_1344();
                bufferbuilder.method_22912(i1 + 1, k - 1, 0.0).method_1344();
                tessellator.method_1350();
                RenderSystem.enableTexture();
            }
            if (k + this.itemHeight < this.y0 || k > this.y1) continue;
            this.renderItem(matrixStackIn, j, p_renderList_1_, k, l, p_renderList_3_, p_renderList_4_, p_renderList_5_);
        }
    }

    protected boolean isFocused() {
        return false;
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    protected void renderHoleBackground(int p_renderHoleBackground_1_, int p_renderHoleBackground_2_, int p_renderHoleBackground_3_, int p_renderHoleBackground_4_) {
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture(0, class_332.field_22735);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        float f = 32.0f;
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferbuilder.method_22912(this.x0, p_renderHoleBackground_2_, 0.0).method_22913(0.0f, (float)p_renderHoleBackground_2_ / 32.0f).method_1336(64, 64, 64, p_renderHoleBackground_4_).method_1344();
        bufferbuilder.method_22912(this.x0 + this.width, p_renderHoleBackground_2_, 0.0).method_22913((float)this.width / 32.0f, (float)p_renderHoleBackground_2_ / 32.0f).method_1336(64, 64, 64, p_renderHoleBackground_4_).method_1344();
        bufferbuilder.method_22912(this.x0 + this.width, p_renderHoleBackground_1_, 0.0).method_22913((float)this.width / 32.0f, (float)p_renderHoleBackground_1_ / 32.0f).method_1336(64, 64, 64, p_renderHoleBackground_3_).method_1344();
        bufferbuilder.method_22912(this.x0, p_renderHoleBackground_1_, 0.0).method_22913(0.0f, (float)p_renderHoleBackground_1_ / 32.0f).method_1336(64, 64, 64, p_renderHoleBackground_3_).method_1344();
        tessellator.method_1350();
    }

    public void setLeftPos(int p_setLeftPos_1_) {
        this.x0 = p_setLeftPos_1_;
        this.x1 = p_setLeftPos_1_ + this.width;
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    @Override
    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33785;
    }

    @Override
    public void method_37020(class_6382 output) {
    }
}

