/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model.anim;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_824;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_922;
import net.optifine.expr.IExpressionFloat;

public enum RenderEntityParameterFloat implements IExpressionFloat
{
    LIMB_SWING("limb_swing"),
    LIMB_SWING_SPEED("limb_speed"),
    AGE("age"),
    HEAD_YAW("head_yaw"),
    HEAD_PITCH("head_pitch"),
    HEALTH("health"),
    HURT_TIME("hurt_time"),
    IDLE_TIME("idle_time"),
    MAX_HEALTH("max_health"),
    MOVE_FORWARD("move_forward"),
    MOVE_STRAFING("move_strafing"),
    PARTIAL_TICKS("partial_ticks"),
    POS_X("pos_x", true),
    POS_Y("pos_y", true),
    POS_Z("pos_z", true),
    REVENGE_TIME("revenge_time"),
    SWING_PROGRESS("swing_progress");

    private String name;
    private boolean blockEntity;
    private class_898 renderManager;
    private static final RenderEntityParameterFloat[] VALUES;

    private RenderEntityParameterFloat(String name) {
        this(name, false);
    }

    private RenderEntityParameterFloat(String name, boolean blockEntity) {
        this.name = name;
        this.blockEntity = blockEntity;
        this.renderManager = class_310.method_1551().method_1561();
    }

    public String getName() {
        return this.name;
    }

    public boolean isBlockEntity() {
        return this.blockEntity;
    }

    @Override
    public float eval() {
        class_897 render;
        class_2586 blockEntity = class_824.tileEntityRendered;
        if (blockEntity != null) {
            switch (this) {
                case POS_X: {
                    return blockEntity.method_11016().method_10263();
                }
                case POS_Y: {
                    return blockEntity.method_11016().method_10264();
                }
                case POS_Z: {
                    return blockEntity.method_11016().method_10260();
                }
            }
        }
        if ((render = this.renderManager.renderRender) == null) {
            return 0.0f;
        }
        class_1297 entity = this.renderManager.renderEntity;
        if (entity == null) {
            return 0.0f;
        }
        if (render instanceof class_922) {
            class_922 rlb = (class_922)render;
            switch (this) {
                case LIMB_SWING: {
                    return rlb.renderLimbSwing;
                }
                case LIMB_SWING_SPEED: {
                    return rlb.renderLimbSwingAmount;
                }
                case AGE: {
                    return rlb.renderAgeInTicks;
                }
                case HEAD_YAW: {
                    return rlb.renderHeadYaw;
                }
                case HEAD_PITCH: {
                    return rlb.renderHeadPitch;
                }
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                switch (this) {
                    case HEALTH: {
                        return livingEntity.method_6032();
                    }
                    case HURT_TIME: {
                        return livingEntity.field_6235;
                    }
                    case IDLE_TIME: {
                        return livingEntity.method_6131();
                    }
                    case MAX_HEALTH: {
                        return livingEntity.method_6063();
                    }
                    case MOVE_FORWARD: {
                        return livingEntity.field_6250;
                    }
                    case MOVE_STRAFING: {
                        return livingEntity.field_6212;
                    }
                    case REVENGE_TIME: {
                        return livingEntity.method_6117();
                    }
                    case SWING_PROGRESS: {
                        return livingEntity.method_6055(rlb.renderPartialTicks);
                    }
                }
            }
        }
        switch (this) {
            case POS_X: {
                return (float)entity.method_23317();
            }
            case POS_Y: {
                return (float)entity.method_23318();
            }
            case POS_Z: {
                return (float)entity.method_23321();
            }
        }
        return 0.0f;
    }

    public static RenderEntityParameterFloat parse(String str) {
        if (str == null) {
            return null;
        }
        for (int i = 0; i < VALUES.length; ++i) {
            RenderEntityParameterFloat type = VALUES[i];
            if (!type.getName().equals(str)) continue;
            return type;
        }
        return null;
    }

    static {
        VALUES = RenderEntityParameterFloat.values();
    }
}

