/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.ArrayList;
import net.minecraft.class_1299;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_5601;
import net.minecraft.class_630;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.util.Either;

public abstract class ModelAdapter {
    private Either<class_1299, class_2591> type;
    private String name;
    private float shadowSize;
    private String[] aliases;

    public ModelAdapter(class_1299 entityType, String name, float shadowSize) {
        this(Either.makeLeft(entityType), name, shadowSize, null);
    }

    public ModelAdapter(class_1299 entityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeLeft(entityType), name, shadowSize, aliases);
    }

    public ModelAdapter(class_2591 tileEntityType, String name, float shadowSize) {
        this(Either.makeRight(tileEntityType), name, shadowSize, null);
    }

    public ModelAdapter(class_2591 tileEntityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeRight(tileEntityType), name, shadowSize, aliases);
    }

    public ModelAdapter(Either<class_1299, class_2591> type, String name, float shadowSize, String[] aliases) {
        this.type = type;
        this.name = name;
        this.shadowSize = shadowSize;
        this.aliases = aliases;
    }

    public Either<class_1299, class_2591> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public float getShadowSize() {
        return this.shadowSize;
    }

    public abstract class_3879 makeModel();

    public abstract class_630 getModelRenderer(class_3879 var1, String var2);

    public abstract String[] getModelRendererNames();

    public abstract IEntityRenderer makeEntityRender(class_3879 var1, float var2);

    public boolean setTextureLocation(IEntityRenderer er, class_2960 textureLocation) {
        return false;
    }

    public class_630[] getModelRenderers(class_3879 model) {
        String[] names = this.getModelRendererNames();
        ArrayList<class_630> list = new ArrayList<class_630>();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            class_630 mr = this.getModelRenderer(model, name);
            if (mr == null) continue;
            list.add(mr);
        }
        class_630[] mrs = list.toArray(new class_630[list.size()]);
        return mrs;
    }

    public static class_630 bakeModelLayer(class_5601 loc) {
        return class_310.method_1551().method_1561().getContext().method_32167(loc);
    }
}

