/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_777;
import net.optifine.Config;
import net.optifine.render.RenderUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.TextureUtils;

public class EmissiveTextures {
    private static String suffixEmissive = null;
    private static String suffixEmissivePng = null;
    private static boolean active = false;
    private static boolean render = false;
    private static boolean hasEmissive = false;
    private static boolean renderEmissive = false;
    private static final String SUFFIX_PNG = ".png";
    private static final class_2960 LOCATION_TEXTURE_EMPTY = TextureUtils.LOCATION_TEXTURE_EMPTY;
    private static final class_2960 LOCATION_SPRITE_EMPTY = TextureUtils.LOCATION_SPRITE_EMPTY;
    private static class_1060 textureManager;
    private static int countRecursive;

    public static boolean isActive() {
        return active;
    }

    public static String getSuffixEmissive() {
        return suffixEmissive;
    }

    public static void beginRender() {
        if (render) {
            ++countRecursive;
            return;
        }
        render = true;
        hasEmissive = false;
    }

    public static class_2960 getEmissiveTexture(class_2960 locationIn) {
        if (!render) {
            return locationIn;
        }
        class_1044 texture = textureManager.method_4619(locationIn);
        if (texture instanceof class_1059) {
            return locationIn;
        }
        class_2960 locationEmissive = null;
        if (texture instanceof class_1049) {
            locationEmissive = ((class_1049)texture).locationEmissive;
        }
        if (!renderEmissive) {
            if (locationEmissive != null) {
                hasEmissive = true;
            }
            return locationIn;
        }
        if (locationEmissive == null) {
            locationEmissive = LOCATION_TEXTURE_EMPTY;
        }
        return locationEmissive;
    }

    public static class_1058 getEmissiveSprite(class_1058 sprite) {
        if (!render) {
            return sprite;
        }
        class_1058 spriteEmissive = sprite.spriteEmissive;
        if (!renderEmissive) {
            if (spriteEmissive != null) {
                hasEmissive = true;
            }
            return sprite;
        }
        if (spriteEmissive == null) {
            spriteEmissive = sprite.method_24119().method_4608(LOCATION_SPRITE_EMPTY);
        }
        return spriteEmissive;
    }

    public static class_777 getEmissiveQuad(class_777 quad) {
        if (!render) {
            return quad;
        }
        class_777 quadEmissive = quad.getQuadEmissive();
        if (!renderEmissive) {
            if (quadEmissive != null) {
                hasEmissive = true;
            }
            return quad;
        }
        return quadEmissive;
    }

    public static boolean hasEmissive() {
        if (countRecursive > 0) {
            return false;
        }
        return hasEmissive;
    }

    public static void beginRenderEmissive() {
        renderEmissive = true;
    }

    public static boolean isRenderEmissive() {
        return renderEmissive;
    }

    public static void endRenderEmissive() {
        RenderUtils.flushRenderBuffers();
        renderEmissive = false;
    }

    public static void endRender() {
        if (countRecursive > 0) {
            --countRecursive;
            return;
        }
        render = false;
        hasEmissive = false;
    }

    public static void update() {
        textureManager = class_310.method_1551().method_1531();
        active = false;
        suffixEmissive = null;
        suffixEmissivePng = null;
        if (!Config.isEmissiveTextures()) {
            return;
        }
        try {
            String fileName = "optifine/emissive.properties";
            class_2960 loc = new class_2960(fileName);
            InputStream in = Config.getResourceStream(loc);
            if (in == null) {
                return;
            }
            EmissiveTextures.dbg("Loading " + fileName);
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            suffixEmissive = props.getProperty("suffix.emissive");
            if (suffixEmissive != null) {
                suffixEmissivePng = suffixEmissive + SUFFIX_PNG;
            }
            active = suffixEmissive != null;
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void updateIcons(class_1059 textureMap, Set<class_2960> locations) {
        if (!active) {
            return;
        }
        for (class_2960 loc : locations) {
            EmissiveTextures.checkEmissive(textureMap, loc);
        }
    }

    private static void checkEmissive(class_1059 textureMap, class_2960 locSprite) {
        String suffixEm = EmissiveTextures.getSuffixEmissive();
        if (suffixEm == null) {
            return;
        }
        if (locSprite.method_12832().endsWith(suffixEm)) {
            return;
        }
        class_2960 locSpriteEm = new class_2960(locSprite.method_12836(), locSprite.method_12832() + suffixEm);
        class_2960 locPngEm = textureMap.method_4603(locSpriteEm);
        if (!Config.hasResource(locPngEm)) {
            return;
        }
        class_1058 sprite = textureMap.registerSprite(locSprite);
        class_1058 spriteEmissive = textureMap.registerSprite(locSpriteEm);
        spriteEmissive.isSpriteEmissive = true;
        sprite.spriteEmissive = spriteEmissive;
        textureMap.registerSprite(LOCATION_SPRITE_EMPTY);
    }

    public static void refreshIcons(class_1059 textureMap) {
        Collection<class_1058> sprites = textureMap.getRegisteredSprites();
        for (class_1058 sprite : sprites) {
            EmissiveTextures.refreshIcon(sprite, textureMap);
        }
    }

    private static void refreshIcon(class_1058 sprite, class_1059 textureMap) {
        if (sprite.spriteEmissive == null) {
            return;
        }
        class_1058 spriteNew = textureMap.getUploadedSprite(sprite.method_4598());
        if (spriteNew == null) {
            return;
        }
        class_1058 spriteEmissiveNew = textureMap.getUploadedSprite(sprite.spriteEmissive.method_4598());
        if (spriteEmissiveNew == null) {
            return;
        }
        spriteEmissiveNew.isSpriteEmissive = true;
        spriteNew.spriteEmissive = spriteEmissiveNew;
    }

    private static void dbg(String str) {
        Config.dbg("EmissiveTextures: " + str);
    }

    private static void warn(String str) {
        Config.warn("EmissiveTextures: " + str);
    }

    public static boolean isEmissive(class_2960 loc) {
        if (suffixEmissivePng == null) {
            return false;
        }
        return loc.method_12832().endsWith(suffixEmissivePng);
    }

    public static void loadTexture(class_2960 loc, class_1049 tex) {
        if (loc == null || tex == null) {
            return;
        }
        tex.isEmissive = false;
        tex.locationEmissive = null;
        if (suffixEmissivePng == null) {
            return;
        }
        String path = loc.method_12832();
        if (!path.endsWith(SUFFIX_PNG)) {
            return;
        }
        if (path.endsWith(suffixEmissivePng)) {
            tex.isEmissive = true;
            return;
        }
        String pathEmPng = path.substring(0, path.length() - SUFFIX_PNG.length()) + suffixEmissivePng;
        class_2960 locEmPng = new class_2960(loc.method_12836(), pathEmPng);
        if (!Config.hasResource(locEmPng)) {
            return;
        }
        tex.locationEmissive = locEmPng;
    }

    static {
        countRecursive = 0;
    }
}

