/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.optifine.Config;
import net.optifine.CustomColors;

public class PotionUtils {
    public static final String f_305387_ = "CustomPotionEffects";
    public static final String f_305388_ = "CustomPotionColor";
    public static final String f_305389_ = "Potion";
    private static final int f_305390_ = 0xF800F8;
    private static final Component f_43545_ = new TranslatableComponent("effect.none").m_130940_(ChatFormatting.GRAY);

    public static List<MobEffectInstance> m_43547_(ItemStack stack) {
        return PotionUtils.m_43566_(stack.m_41783_());
    }

    public static List<MobEffectInstance> m_43561_(Potion potionIn, Collection<MobEffectInstance> effects) {
        ArrayList list = Lists.newArrayList();
        list.addAll(potionIn.m_43488_());
        list.addAll(effects);
        return list;
    }

    public static List<MobEffectInstance> m_43566_(@Nullable CompoundTag tag) {
        ArrayList list = Lists.newArrayList();
        list.addAll(PotionUtils.m_43577_(tag).m_43488_());
        PotionUtils.m_43568_(tag, list);
        return list;
    }

    public static List<MobEffectInstance> m_43571_(ItemStack itemIn) {
        return PotionUtils.m_43573_(itemIn.m_41783_());
    }

    public static List<MobEffectInstance> m_43573_(@Nullable CompoundTag tag) {
        ArrayList list = Lists.newArrayList();
        PotionUtils.m_43568_(tag, list);
        return list;
    }

    public static void m_43568_(@Nullable CompoundTag tag, List<MobEffectInstance> effectList) {
        if (tag != null && tag.m_128425_(f_305387_, 9)) {
            ListTag listtag = tag.m_128437_(f_305387_, 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.m_128728_(i);
                MobEffectInstance mobeffectinstance = MobEffectInstance.m_19560_((CompoundTag)compoundtag);
                if (mobeffectinstance == null) continue;
                effectList.add(mobeffectinstance);
            }
        }
    }

    public static int m_43575_(ItemStack itemStackIn) {
        CompoundTag compoundtag = itemStackIn.m_41783_();
        if (compoundtag != null && compoundtag.m_128425_(f_305388_, 99)) {
            return compoundtag.m_128451_(f_305388_);
        }
        return PotionUtils.m_43579_(itemStackIn) == Potions.f_43598_ ? 0xF800F8 : PotionUtils.m_43564_(PotionUtils.m_43547_(itemStackIn));
    }

    public static int m_43559_(Potion potionIn) {
        return potionIn == Potions.f_43598_ ? 0xF800F8 : PotionUtils.m_43564_(potionIn.m_43488_());
    }

    public static int m_43564_(Collection<MobEffectInstance> effects) {
        int i = 3694022;
        if (effects.isEmpty()) {
            if (Config.isCustomColors()) {
                return CustomColors.getPotionColor(null, (int)i);
            }
            return 3694022;
        }
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int j = 0;
        for (MobEffectInstance mobeffectinstance : effects) {
            if (!mobeffectinstance.m_19572_()) continue;
            int k = mobeffectinstance.m_19544_().m_19484_();
            if (Config.isCustomColors()) {
                k = CustomColors.getPotionColor((MobEffect)mobeffectinstance.m_19544_(), (int)k);
            }
            int l = mobeffectinstance.m_19564_() + 1;
            f += (float)(l * (k >> 16 & 0xFF)) / 255.0f;
            f1 += (float)(l * (k >> 8 & 0xFF)) / 255.0f;
            f2 += (float)(l * (k >> 0 & 0xFF)) / 255.0f;
            j += l;
        }
        if (j == 0) {
            return 0;
        }
        f = f / (float)j * 255.0f;
        f1 = f1 / (float)j * 255.0f;
        f2 = f2 / (float)j * 255.0f;
        return (int)f << 16 | (int)f1 << 8 | (int)f2;
    }

    public static Potion m_43579_(ItemStack itemIn) {
        return PotionUtils.m_43577_(itemIn.m_41783_());
    }

    public static Potion m_43577_(@Nullable CompoundTag tag) {
        return tag == null ? Potions.f_43598_ : Potion.m_43489_((String)tag.m_128461_(f_305389_));
    }

    public static ItemStack m_43549_(ItemStack itemIn, Potion potionIn) {
        ResourceLocation resourcelocation = Registry.f_122828_.m_7981_((Object)potionIn);
        if (potionIn == Potions.f_43598_) {
            itemIn.m_41749_(f_305389_);
        } else {
            itemIn.m_41784_().m_128359_(f_305389_, resourcelocation.toString());
        }
        return itemIn;
    }

    public static ItemStack m_43552_(ItemStack itemIn, Collection<MobEffectInstance> effects) {
        if (effects.isEmpty()) {
            return itemIn;
        }
        CompoundTag compoundtag = itemIn.m_41784_();
        ListTag listtag = compoundtag.m_128437_(f_305387_, 9);
        for (MobEffectInstance mobeffectinstance : effects) {
            listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
        }
        compoundtag.m_128365_(f_305387_, (Tag)listtag);
        return itemIn;
    }

    public static void m_43555_(ItemStack itemIn, List<Component> lores, float durationFactor) {
        List<MobEffectInstance> list = PotionUtils.m_43547_(itemIn);
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            lores.add(f_43545_);
        } else {
            for (MobEffectInstance mobeffectinstance : list) {
                TranslatableComponent mutablecomponent = new TranslatableComponent(mobeffectinstance.m_19576_());
                MobEffect mobeffect = mobeffectinstance.m_19544_();
                Map map = mobeffect.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), mobeffect.m_7048_(mobeffectinstance.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                        list1.add(new Pair(entry.getKey(), (Object)attributemodifier1));
                    }
                }
                if (mobeffectinstance.m_19564_() > 0) {
                    mutablecomponent = new TranslatableComponent("potion.withAmplifier", new Object[]{mutablecomponent, new TranslatableComponent("potion.potency." + mobeffectinstance.m_19564_())});
                }
                if (mobeffectinstance.m_19557_() > 20) {
                    mutablecomponent = new TranslatableComponent("potion.withDuration", new Object[]{mutablecomponent, MobEffectUtil.m_19581_((MobEffectInstance)mobeffectinstance, (float)durationFactor)});
                }
                lores.add((Component)mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_()));
            }
        }
        if (!list1.isEmpty()) {
            lores.add(TextComponent.f_131282_);
            lores.add((Component)new TranslatableComponent("potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.m_22218_();
                double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                if (d0 > 0.0) {
                    lores.add((Component)new TranslatableComponent("attribute.modifier.plus." + attributemodifier2.m_22217_().m_22235_(), new Object[]{ItemStack.f_41584_.format(d1), new TranslatableComponent(((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lores.add((Component)new TranslatableComponent("attribute.modifier.take." + attributemodifier2.m_22217_().m_22235_(), new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), new TranslatableComponent(((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

