/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.optifine.util.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GoalSelector {
    private static final Logger f_25342_ = LogManager.getLogger();
    private static final WrappedGoal f_25343_ = new WrappedGoal(Integer.MAX_VALUE, new Goal(){

        public boolean m_8036_() {
            return false;
        }
    }){

        public boolean m_7620_() {
            return false;
        }
    };
    private final Map<Goal.Flag, WrappedGoal> f_25344_ = new EnumMap<Goal.Flag, WrappedGoal>(Goal.Flag.class);
    private final Set<WrappedGoal> f_25345_ = Sets.newLinkedHashSet();
    private final Supplier<ProfilerFiller> f_25346_;
    private final EnumSet<Goal.Flag> f_25347_ = EnumSet.noneOf(Goal.Flag.class);
    private int f_303698_;
    private int f_25348_ = 3;

    public GoalSelector(Supplier<ProfilerFiller> profilerSupplierIn) {
        this.f_25346_ = profilerSupplierIn;
    }

    public void m_25352_(int priority, Goal task) {
        this.f_25345_.add(new WrappedGoal(priority, task));
    }

    @VisibleForTesting
    public void m_303699_() {
        this.f_25345_.clear();
    }

    public void m_25363_(Goal task) {
        this.f_25345_.stream().filter(p_25376_1_ -> p_25376_1_.m_26015_() == task).filter(WrappedGoal::m_7620_).forEach(WrappedGoal::m_8041_);
        this.f_25345_.removeIf(p_25365_1_ -> p_25365_1_.m_26015_() == task);
    }

    public void m_25373_() {
        ProfilerFiller profilerfiller = this.f_25346_.get();
        profilerfiller.m_6180_("goalCleanup");
        if (this.f_25345_.size() > 0) {
            for (WrappedGoal goal : this.f_25345_) {
                if (!goal.m_7620_() || goal.m_7620_() && !CollectionUtils.anyMatch(goal.m_7684_(), this.f_25347_) && goal.m_8045_()) continue;
                goal.m_8041_();
            }
        }
        if (this.f_25344_.size() > 0) {
            this.f_25344_.forEach((p_25357_1_, p_25357_2_) -> {
                if (!p_25357_2_.m_7620_()) {
                    this.f_25344_.remove(p_25357_1_);
                }
            });
        }
        profilerfiller.m_7238_();
        profilerfiller.m_6180_("goalUpdate");
        if (this.f_25345_.size() > 0) {
            for (WrappedGoal goal : this.f_25345_) {
                if (goal.m_7620_() || !CollectionUtils.noneMatch(goal.m_7684_(), this.f_25347_) || !GoalSelector.allPreemptedBy(goal, goal.m_7684_(), this.f_25344_) || !goal.m_8036_()) continue;
                GoalSelector.resetTasks(goal, goal.m_7684_(), this.f_25344_);
                goal.m_8056_();
            }
        }
        profilerfiller.m_7238_();
        profilerfiller.m_6180_("goalTick");
        if (this.f_25345_.size() > 0) {
            for (WrappedGoal goal : this.f_25345_) {
                if (!goal.m_7620_()) continue;
                goal.m_8037_();
            }
        }
        profilerfiller.m_7238_();
    }

    private static boolean allPreemptedBy(WrappedGoal goal, EnumSet<Goal.Flag> flags, Map<Goal.Flag, WrappedGoal> flagGoals) {
        if (flags.isEmpty()) {
            return true;
        }
        for (Goal.Flag flag : flags) {
            WrappedGoal pg = flagGoals.getOrDefault(flag, f_25343_);
            if (pg.m_26002_(goal)) continue;
            return false;
        }
        return true;
    }

    private static void resetTasks(WrappedGoal goal, EnumSet<Goal.Flag> flags, Map<Goal.Flag, WrappedGoal> flagGoals) {
        if (flags.isEmpty()) {
            return;
        }
        for (Goal.Flag flag : flags) {
            WrappedGoal pg = flagGoals.getOrDefault(flag, f_25343_);
            pg.m_8041_();
            flagGoals.put(flag, goal);
        }
    }

    public Set<WrappedGoal> m_303708_() {
        return this.f_25345_;
    }

    public Stream<WrappedGoal> m_25386_() {
        return this.f_25345_.stream().filter(WrappedGoal::m_7620_);
    }

    public void m_303700_(int tickRateIn) {
        this.f_25348_ = tickRateIn;
    }

    public void m_25355_(Goal.Flag p_25355_1_) {
        this.f_25347_.add(p_25355_1_);
    }

    public void m_25374_(Goal.Flag p_25374_1_) {
        this.f_25347_.remove(p_25374_1_);
    }

    public void m_25360_(Goal.Flag p_25360_1_, boolean p_25360_2_) {
        if (p_25360_2_) {
            this.m_25374_(p_25360_1_);
        } else {
            this.m_25355_(p_25360_1_);
        }
    }
}

