/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensing;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.LootContext;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;

public abstract class Mob
extends LivingEntity {
    private static final EntityDataAccessor<Byte> f_21340_ = SynchedEntityData.m_135353_(Mob.class, EntityDataSerializers.f_135027_);
    private static final int f_303060_ = 1;
    private static final int f_303061_ = 2;
    private static final int f_303062_ = 4;
    public static final float f_303063_ = 0.15f;
    public static final float f_303055_ = 0.55f;
    public static final float f_303056_ = 0.5f;
    public static final float f_303057_ = 0.25f;
    public static final String f_303058_ = "Leash";
    private static final int f_303059_ = 1;
    public static final float f_320817_ = 0.085f;
    public int f_21363_;
    protected int f_21364_;
    protected LookControl f_21365_;
    protected MoveControl f_21342_;
    protected JumpControl f_21343_;
    private final BodyRotationControl f_21361_;
    protected PathNavigation f_21344_;
    protected final GoalSelector f_21345_;
    protected final GoalSelector f_21346_;
    private LivingEntity f_21362_;
    private final Sensing f_21349_;
    private final NonNullList<ItemStack> f_21350_ = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    protected final float[] f_21347_ = new float[2];
    private final NonNullList<ItemStack> f_21351_ = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    protected final float[] f_21348_ = new float[4];
    private boolean f_21352_;
    private boolean f_21353_;
    private final Map<BlockPathTypes, Float> f_21354_ = Maps.newEnumMap(BlockPathTypes.class);
    private ResourceLocation f_21355_;
    private long f_21356_;
    @Nullable
    private Entity f_21357_;
    private int f_21358_;
    @Nullable
    private CompoundTag f_21359_;
    private BlockPos f_21360_ = BlockPos.f_121853_;
    private float f_21341_ = -1.0f;

    protected Mob(EntityType<? extends Mob> type, Level worldIn) {
        super(type, worldIn);
        this.f_21345_ = new GoalSelector(worldIn.m_46658_());
        this.f_21346_ = new GoalSelector(worldIn.m_46658_());
        this.f_21365_ = new LookControl(this);
        this.f_21342_ = new MoveControl(this);
        this.f_21343_ = new JumpControl(this);
        this.f_21361_ = this.m_7560_();
        this.f_21344_ = this.m_6037_(worldIn);
        this.f_21349_ = new Sensing(this);
        Arrays.fill(this.f_21348_, 0.085f);
        Arrays.fill(this.f_21347_, 0.085f);
        if (worldIn != null && !worldIn.f_46443_) {
            this.m_8099_();
        }
    }

    protected void m_8099_() {
    }

    public static AttributeSupplier.Builder m_21552_() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 16.0).m_22266_(Attributes.f_22282_);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new GroundPathNavigation(this, worldIn);
    }

    protected boolean m_8091_() {
        return false;
    }

    public float m_21439_(BlockPathTypes nodeType) {
        Mob mob = this.m_20202_() instanceof Mob && ((Mob)this.m_20202_()).m_8091_() ? (Mob)this.m_20202_() : this;
        Float f = mob.f_21354_.get(nodeType);
        return f == null ? nodeType.m_77124_() : f.floatValue();
    }

    public void m_21441_(BlockPathTypes nodeType, float priority) {
        this.f_21354_.put(nodeType, Float.valueOf(priority));
    }

    public boolean m_21481_(BlockPathTypes p_21481_1_) {
        return p_21481_1_ != BlockPathTypes.DANGER_FIRE && p_21481_1_ != BlockPathTypes.DANGER_CACTUS && p_21481_1_ != BlockPathTypes.DANGER_OTHER && p_21481_1_ != BlockPathTypes.WALKABLE_DOOR;
    }

    protected BodyRotationControl m_7560_() {
        return new BodyRotationControl(this);
    }

    public LookControl m_21563_() {
        return this.f_21365_;
    }

    public MoveControl m_21566_() {
        if (this.m_20159_() && this.m_20202_() instanceof Mob) {
            Mob mob = (Mob)this.m_20202_();
            return mob.m_21566_();
        }
        return this.f_21342_;
    }

    public JumpControl m_21569_() {
        return this.f_21343_;
    }

    public PathNavigation m_21573_() {
        if (this.m_20159_() && this.m_20202_() instanceof Mob) {
            Mob mob = (Mob)this.m_20202_();
            return mob.m_21573_();
        }
        return this.f_21344_;
    }

    public Sensing m_21574_() {
        return this.f_21349_;
    }

    @Nullable
    public LivingEntity m_5448_() {
        return this.f_21362_;
    }

    public void m_6710_(@Nullable LivingEntity entitylivingbaseIn) {
        this.f_21362_ = entitylivingbaseIn;
        Reflector.callVoid(Reflector.ForgeHooks_onLivingSetAttackTarget, new Object[]{this, entitylivingbaseIn});
    }

    public boolean m_6549_(EntityType<?> typeIn) {
        return typeIn != EntityType.f_20453_;
    }

    public boolean m_5886_(ProjectileWeaponItem p_5886_1_) {
        return false;
    }

    public void m_8035_() {
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(f_21340_, (byte)0);
    }

    public int m_8100_() {
        return 80;
    }

    public void m_8032_() {
        SoundEvent soundevent = this.m_7515_();
        if (soundevent != null) {
            this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
        }
    }

    public void m_6075_() {
        super.m_6075_();
        this.f_19853_.m_46473_().m_6180_("mobBaseTick");
        if (this.m_6084_() && this.f_19796_.nextInt(1000) < this.f_21363_++) {
            this.m_21551_();
            this.m_8032_();
        }
        this.f_19853_.m_46473_().m_7238_();
    }

    protected void m_6677_(DamageSource source) {
        this.m_21551_();
        super.m_6677_(source);
    }

    private void m_21551_() {
        this.f_21363_ = -this.m_8100_();
    }

    protected int m_6552_(Player player) {
        if (this.f_21364_ > 0) {
            int i = this.f_21364_;
            for (int j = 0; j < this.f_21351_.size(); ++j) {
                if (((ItemStack)this.f_21351_.get(j)).m_41619_() || !(this.f_21348_[j] <= 1.0f)) continue;
                i += 1 + this.f_19796_.nextInt(3);
            }
            for (int k = 0; k < this.f_21350_.size(); ++k) {
                if (((ItemStack)this.f_21350_.get(k)).m_41619_() || !(this.f_21347_[k] <= 1.0f)) continue;
                i += 1 + this.f_19796_.nextInt(3);
            }
            return i;
        }
        return this.f_21364_;
    }

    public void m_21373_() {
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.f_19796_.nextGaussian() * 0.02;
                double d1 = this.f_19796_.nextGaussian() * 0.02;
                double d2 = this.f_19796_.nextGaussian() * 0.02;
                double d3 = 10.0;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20165_(1.0) - d0 * 10.0, this.m_20187_() - d1 * 10.0, this.m_20262_(1.0) - d2 * 10.0, d0, d1, d2);
            }
        } else {
            this.f_19853_.m_7605_((Entity)this, (byte)20);
        }
    }

    public void m_7822_(byte id) {
        if (id == 20) {
            this.m_21373_();
        } else {
            super.m_7822_(id);
        }
    }

    public void m_8119_() {
        if (Config.isSmoothWorld() && this.canSkipUpdate()) {
            this.onUpdateMinimal();
            return;
        }
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.m_6119_();
            if (this.f_19797_ % 5 == 0) {
                this.m_8022_();
            }
        }
    }

    protected void m_8022_() {
        boolean flag = !(this.m_6688_() instanceof Mob);
        boolean flag1 = !(this.m_20202_() instanceof Boat);
        this.f_21345_.m_25360_(Goal.Flag.MOVE, flag);
        this.f_21345_.m_25360_(Goal.Flag.JUMP, flag && flag1);
        this.f_21345_.m_25360_(Goal.Flag.LOOK, flag);
    }

    protected float m_5632_(float p_5632_1_, float p_5632_2_) {
        this.f_21361_.m_8121_();
        return p_5632_2_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return null;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("CanPickUpLoot", this.m_21531_());
        compound.m_128379_("PersistenceRequired", this.f_21353_);
        ListTag listtag = new ListTag();
        for (Object itemstack : this.f_21351_) {
            CompoundTag compoundtag = new CompoundTag();
            if (!itemstack.m_41619_()) {
                itemstack.m_41739_(compoundtag);
            }
            listtag.add((Object)compoundtag);
        }
        compound.m_128365_("ArmorItems", (net.minecraft.nbt.Tag)listtag);
        ListTag listtag1 = new ListTag();
        for (Object itemstack1 : this.f_21350_) {
            CompoundTag compoundtag1 = new CompoundTag();
            if (!itemstack1.m_41619_()) {
                itemstack1.m_41739_(compoundtag1);
            }
            listtag1.add((Object)compoundtag1);
        }
        compound.m_128365_("HandItems", (net.minecraft.nbt.Tag)listtag1);
        ListTag listtag2 = new ListTag();
        for (ItemStack f : (Object)this.f_21348_) {
            listtag2.add((Object)FloatTag.m_128566_((float)f));
        }
        compound.m_128365_("ArmorDropChances", (net.minecraft.nbt.Tag)listtag2);
        ListTag listtag3 = new ListTag();
        for (float f1 : this.f_21347_) {
            listtag3.add((Object)FloatTag.m_128566_((float)f1));
        }
        compound.m_128365_("HandDropChances", (net.minecraft.nbt.Tag)listtag3);
        if (this.f_21357_ != null) {
            CompoundTag compoundtag2 = new CompoundTag();
            if (this.f_21357_ instanceof LivingEntity) {
                UUID uuid = this.f_21357_.m_141538_();
                compoundtag2.m_128362_("UUID", uuid);
            } else if (this.f_21357_ instanceof HangingEntity) {
                BlockPos blockpos = ((HangingEntity)this.f_21357_).m_31748_();
                compoundtag2.m_128405_("X", blockpos.m_123341_());
                compoundtag2.m_128405_("Y", blockpos.m_123342_());
                compoundtag2.m_128405_("Z", blockpos.m_123343_());
            }
            compound.m_128365_(f_303058_, (net.minecraft.nbt.Tag)compoundtag2);
        } else if (this.f_21359_ != null) {
            compound.m_128365_(f_303058_, (net.minecraft.nbt.Tag)this.f_21359_.m_6426_());
        }
        compound.m_128379_("LeftHanded", this.m_21526_());
        if (this.f_21355_ != null) {
            compound.m_128359_("DeathLootTable", this.f_21355_.toString());
            if (this.f_21356_ != 0L) {
                compound.m_128356_("DeathLootTableSeed", this.f_21356_);
            }
        }
        if (this.m_21525_()) {
            compound.m_128379_("NoAI", this.m_21525_());
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("CanPickUpLoot", 1)) {
            this.m_21553_(compound.m_128471_("CanPickUpLoot"));
        }
        this.f_21353_ = compound.m_128471_("PersistenceRequired");
        if (compound.m_128425_("ArmorItems", 9)) {
            ListTag listtag = compound.m_128437_("ArmorItems", 10);
            for (int i = 0; i < this.f_21351_.size(); ++i) {
                this.f_21351_.set(i, (Object)ItemStack.m_41712_((CompoundTag)listtag.m_128728_(i)));
            }
        }
        if (compound.m_128425_("HandItems", 9)) {
            ListTag listtag1 = compound.m_128437_("HandItems", 10);
            for (int j = 0; j < this.f_21350_.size(); ++j) {
                this.f_21350_.set(j, (Object)ItemStack.m_41712_((CompoundTag)listtag1.m_128728_(j)));
            }
        }
        if (compound.m_128425_("ArmorDropChances", 9)) {
            ListTag listtag2 = compound.m_128437_("ArmorDropChances", 5);
            for (int k = 0; k < listtag2.size(); ++k) {
                this.f_21348_[k] = listtag2.m_128775_(k);
            }
        }
        if (compound.m_128425_("HandDropChances", 9)) {
            ListTag listtag3 = compound.m_128437_("HandDropChances", 5);
            for (int l = 0; l < listtag3.size(); ++l) {
                this.f_21347_[l] = listtag3.m_128775_(l);
            }
        }
        if (compound.m_128425_(f_303058_, 10)) {
            this.f_21359_ = compound.m_128469_(f_303058_);
        }
        this.m_21559_(compound.m_128471_("LeftHanded"));
        if (compound.m_128425_("DeathLootTable", 8)) {
            this.f_21355_ = new ResourceLocation(compound.m_128461_("DeathLootTable"));
            this.f_21356_ = compound.m_128454_("DeathLootTableSeed");
        }
        this.m_21557_(compound.m_128471_("NoAI"));
    }

    protected void m_7625_(DamageSource damageSourceIn, boolean p_7625_2_) {
        super.m_7625_(damageSourceIn, p_7625_2_);
        this.f_21355_ = null;
    }

    protected LootContext.Builder m_7771_(boolean p_7771_1_, DamageSource damageSourceIn) {
        return super.m_7771_(p_7771_1_, damageSourceIn).m_78967_(this.f_21356_, this.f_19796_);
    }

    public final ResourceLocation m_5743_() {
        return this.f_21355_ == null ? this.m_7582_() : this.f_21355_;
    }

    protected ResourceLocation m_7582_() {
        return super.m_5743_();
    }

    public void m_21564_(float amount) {
        this.f_20902_ = amount;
    }

    public void m_21567_(float amount) {
        this.f_20901_ = amount;
    }

    public void m_21570_(float amount) {
        this.f_20900_ = amount;
    }

    public void m_7910_(float speedIn) {
        super.m_7910_(speedIn);
        this.m_21564_(speedIn);
    }

    public void m_8107_() {
        super.m_8107_();
        this.f_19853_.m_46473_().m_6180_("looting");
        boolean mobGriefing = this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_);
        if (Reflector.ForgeEventFactory_getMobGriefingEvent.exists()) {
            mobGriefing = Reflector.callBoolean(Reflector.ForgeEventFactory_getMobGriefingEvent, new Object[]{this.f_19853_, this});
        }
        if (!this.f_19853_.f_46443_ && this.m_21531_() && this.m_6084_() && !this.f_20890_ && mobGriefing) {
            for (ItemEntity itementity : this.f_19853_.m_45976_(ItemEntity.class, this.m_141786_().m_82377_(1.0, 0.0, 1.0))) {
                if (itementity.m_149649_() || itementity.m_32055_().m_41619_() || itementity.m_32063_() || !this.m_7243_(itementity.m_32055_())) continue;
                this.m_7581_(itementity);
            }
        }
        this.f_19853_.m_46473_().m_7238_();
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.m_32055_();
        if (this.m_21540_(itemstack)) {
            this.m_21053_(itemEntity);
            this.m_7938_((Entity)itemEntity, itemstack.m_41613_());
            itemEntity.m_149572_();
        }
    }

    public boolean m_21540_(ItemStack p_21540_1_) {
        EquipmentSlot equipmentslot = Mob.m_150278_((ItemStack)p_21540_1_);
        ItemStack itemstack = this.m_6844_(equipmentslot);
        boolean flag = this.m_7808_(p_21540_1_, itemstack);
        if (flag && this.m_7252_(p_21540_1_)) {
            double d0 = this.m_21519_(equipmentslot);
            if (!itemstack.m_41619_() && (double)Math.max(this.f_19796_.nextFloat() - 0.1f, 0.0f) < d0) {
                this.m_19983_(itemstack);
            }
            this.m_21468_(equipmentslot, p_21540_1_);
            this.m_150207_(p_21540_1_);
            return true;
        }
        return false;
    }

    protected void m_21468_(EquipmentSlot p_21468_1_, ItemStack p_21468_2_) {
        this.m_8061_(p_21468_1_, p_21468_2_);
        this.m_21508_(p_21468_1_);
        this.f_21353_ = true;
    }

    public void m_21508_(EquipmentSlot p_21508_1_) {
        switch (p_21508_1_.m_20743_()) {
            case HAND: {
                this.f_21347_[p_21508_1_.m_20749_()] = 2.0f;
                break;
            }
            case ARMOR: {
                this.f_21348_[p_21508_1_.m_20749_()] = 2.0f;
            }
        }
    }

    protected boolean m_7808_(ItemStack candidate, ItemStack existing) {
        if (existing.m_41619_()) {
            return true;
        }
        if (candidate.m_41720_() instanceof SwordItem) {
            if (!(existing.m_41720_() instanceof SwordItem)) {
                return true;
            }
            SwordItem sworditem = (SwordItem)candidate.m_41720_();
            SwordItem sworditem1 = (SwordItem)existing.m_41720_();
            if (sworditem.m_43299_() != sworditem1.m_43299_()) {
                return sworditem.m_43299_() > sworditem1.m_43299_();
            }
            return this.m_21477_(candidate, existing);
        }
        if (candidate.m_41720_() instanceof BowItem && existing.m_41720_() instanceof BowItem) {
            return this.m_21477_(candidate, existing);
        }
        if (candidate.m_41720_() instanceof CrossbowItem && existing.m_41720_() instanceof CrossbowItem) {
            return this.m_21477_(candidate, existing);
        }
        if (candidate.m_41720_() instanceof ArmorItem) {
            if (EnchantmentHelper.m_44920_((ItemStack)existing)) {
                return false;
            }
            if (!(existing.m_41720_() instanceof ArmorItem)) {
                return true;
            }
            ArmorItem armoritem = (ArmorItem)candidate.m_41720_();
            ArmorItem armoritem1 = (ArmorItem)existing.m_41720_();
            if (armoritem.m_40404_() != armoritem1.m_40404_()) {
                return armoritem.m_40404_() > armoritem1.m_40404_();
            }
            if (armoritem.m_40405_() != armoritem1.m_40405_()) {
                return armoritem.m_40405_() > armoritem1.m_40405_();
            }
            return this.m_21477_(candidate, existing);
        }
        if (candidate.m_41720_() instanceof DiggerItem) {
            if (existing.m_41720_() instanceof BlockItem) {
                return true;
            }
            if (existing.m_41720_() instanceof DiggerItem) {
                DiggerItem diggeritem = (DiggerItem)candidate.m_41720_();
                DiggerItem diggeritem1 = (DiggerItem)existing.m_41720_();
                if (diggeritem.m_41008_() != diggeritem1.m_41008_()) {
                    return diggeritem.m_41008_() > diggeritem1.m_41008_();
                }
                return this.m_21477_(candidate, existing);
            }
        }
        return false;
    }

    public boolean m_21477_(ItemStack p_21477_1_, ItemStack p_21477_2_) {
        if (p_21477_1_.m_41773_() >= p_21477_2_.m_41773_() && (!p_21477_1_.m_41782_() || p_21477_2_.m_41782_())) {
            if (p_21477_1_.m_41782_() && p_21477_2_.m_41782_()) {
                return p_21477_1_.m_41783_().m_128431_().stream().anyMatch(p_21512_0_ -> !p_21512_0_.equals("Damage")) && !p_21477_2_.m_41783_().m_128431_().stream().anyMatch(p_21502_0_ -> !p_21502_0_.equals("Damage"));
            }
            return false;
        }
        return true;
    }

    public boolean m_7252_(ItemStack stack) {
        return true;
    }

    public boolean m_7243_(ItemStack p_7243_1_) {
        return this.m_7252_(p_7243_1_);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return true;
    }

    public boolean m_8023_() {
        return this.m_20159_();
    }

    protected boolean m_8028_() {
        return false;
    }

    public void m_6043_() {
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_149572_();
        } else if (!this.m_21532_() && !this.m_8023_()) {
            Player entity = this.f_19853_.m_45930_((Entity)this, -1.0);
            if (Reflector.ForgeEventFactory_canEntityDespawn.exists()) {
                Object result = Reflector.ForgeEventFactory_canEntityDespawn.call((Object)this);
                if (result == ReflectorForge.EVENT_RESULT_DENY) {
                    this.f_20891_ = 0;
                    entity = null;
                } else if (result == ReflectorForge.EVENT_RESULT_ALLOW) {
                    this.m_149572_();
                    entity = null;
                }
            }
            if (entity != null) {
                int i;
                int j;
                double d0 = entity.m_20280_((Entity)this);
                if (d0 > (double)(j = (i = this.m_6095_().m_20674_().m_21611_()) * i) && this.m_6785_(d0)) {
                    this.m_149572_();
                }
                int k = this.m_6095_().m_20674_().m_21612_();
                int l = k * k;
                if (this.f_20891_ > 600 && this.f_19796_.nextInt(800) == 0 && d0 > (double)l && this.m_6785_(d0)) {
                    this.m_149572_();
                } else if (d0 < (double)l) {
                    this.f_20891_ = 0;
                }
            }
        } else {
            this.f_20891_ = 0;
        }
    }

    protected final void m_6140_() {
        ++this.f_20891_;
        this.f_19853_.m_46473_().m_6180_("sensing");
        this.f_21349_.m_26789_();
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("targetSelector");
        this.f_21346_.m_25373_();
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("goalSelector");
        this.f_21345_.m_25373_();
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("navigation");
        this.f_21344_.m_7638_();
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("mob tick");
        this.m_8024_();
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("controls");
        this.f_19853_.m_46473_().m_6180_("move");
        this.f_21342_.m_8126_();
        this.f_19853_.m_46473_().m_6182_("look");
        this.f_21365_.m_8128_();
        this.f_19853_.m_46473_().m_6182_("jump");
        this.f_21343_.m_8124_();
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_7238_();
        this.m_8025_();
    }

    protected void m_8025_() {
        DebugPackets.m_133699_((Level)this.f_19853_, (Mob)this, (GoalSelector)this.f_21345_);
    }

    protected void m_8024_() {
    }

    public int m_8132_() {
        return 40;
    }

    public int m_8085_() {
        return 75;
    }

    public int m_21529_() {
        return 10;
    }

    public void m_21391_(Entity entityIn, float maxYawIncrease, float maxPitchIncrease) {
        double d1;
        double d0 = entityIn.m_20185_() - this.m_20185_();
        double d2 = entityIn.m_20189_() - this.m_20189_();
        if (entityIn instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entityIn;
            d1 = livingentity.m_20188_() - this.m_20188_();
        } else {
            d1 = (entityIn.m_141786_().f_82289_ + entityIn.m_141786_().f_82292_) / 2.0 - this.m_20188_();
        }
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        float f = (float)(Mth.m_14136_(d2, d0) * 57.2957763671875) - 90.0f;
        float f1 = (float)(-(Mth.m_14136_(d1, d3) * 57.2957763671875));
        this.m_302846_(this.m_21376_(this.m_302839_(), f1, maxPitchIncrease));
        this.m_302844_(this.m_21376_(this.m_302838_(), f, maxYawIncrease));
    }

    private float m_21376_(float angle, float targetAngle, float maxIncrease) {
        float f = Mth.m_14177_(targetAngle - angle);
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    public static boolean m_21400_(EntityType<? extends Mob> typeIn, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        BlockPos blockpos = pos.m_7495_();
        return reason == MobSpawnType.SPAWNER || worldIn.m_8055_(blockpos).m_60643_((BlockGetter)worldIn, blockpos, typeIn);
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return true;
    }

    public boolean m_6914_(LevelReader worldIn) {
        return !worldIn.m_46855_(this.m_141786_()) && worldIn.m_45784_((Entity)this);
    }

    public int m_5792_() {
        return 4;
    }

    public boolean m_7296_(int sizeIn) {
        return false;
    }

    public int m_6056_() {
        if (this.m_5448_() == null) {
            return 3;
        }
        int i = (int)(this.m_21223_() - this.m_21233_() * 0.33f);
        if ((i -= (3 - this.f_19853_.m_46791_().m_19028_()) * 4) < 0) {
            i = 0;
        }
        return i + 3;
    }

    public Iterable<ItemStack> m_6167_() {
        return this.f_21350_;
    }

    public Iterable<ItemStack> m_6168_() {
        return this.f_21351_;
    }

    public ItemStack m_6844_(EquipmentSlot slotIn) {
        switch (slotIn.m_20743_()) {
            case HAND: {
                return (ItemStack)this.f_21350_.get(slotIn.m_20749_());
            }
            case ARMOR: {
                return (ItemStack)this.f_21351_.get(slotIn.m_20749_());
            }
        }
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
        this.m_320324_(stack);
        switch (slotIn.m_20743_()) {
            case HAND: {
                this.f_21350_.set(slotIn.m_20749_(), (Object)stack);
                break;
            }
            case ARMOR: {
                this.f_21351_.set(slotIn.m_20749_(), (Object)stack);
            }
        }
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
            boolean flag;
            ItemStack itemstack = this.m_6844_(equipmentslot);
            float f = this.m_21519_(equipmentslot);
            boolean bl = flag = f > 1.0f;
            if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack) || !recentlyHitIn && !flag || !(Math.max(this.f_19796_.nextFloat() - (float)looting * 0.01f, 0.0f) < f)) continue;
            if (!flag && itemstack.m_41763_()) {
                itemstack.m_41721_(itemstack.m_41776_() - this.f_19796_.nextInt(1 + this.f_19796_.nextInt(Math.max(itemstack.m_41776_() - 3, 1))));
            }
            this.m_19983_(itemstack);
            this.m_8061_(equipmentslot, ItemStack.f_41583_);
        }
    }

    protected float m_21519_(EquipmentSlot slotIn) {
        float f;
        switch (slotIn.m_20743_()) {
            case HAND: {
                f = this.f_21347_[slotIn.m_20749_()];
                break;
            }
            case ARMOR: {
                f = this.f_21348_[slotIn.m_20749_()];
                break;
            }
            default: {
                f = 0.0f;
            }
        }
        return f;
    }

    protected void m_6851_(DifficultyInstance difficulty) {
        if (this.f_19796_.nextFloat() < 0.15f * difficulty.m_19057_()) {
            float f;
            int i = this.f_19796_.nextInt(2);
            float f2 = f = this.f_19853_.m_46791_() == Difficulty.HARD ? 0.1f : 0.25f;
            if (this.f_19796_.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.f_19796_.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.f_19796_.nextFloat() < 0.095f) {
                ++i;
            }
            boolean flag = true;
            for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                Item item;
                if (equipmentslot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                ItemStack itemstack = this.m_6844_(equipmentslot);
                if (!flag && this.f_19796_.nextFloat() < f) break;
                flag = false;
                if (!itemstack.m_41619_() || (item = Mob.m_21412_(equipmentslot, i)) == null) continue;
                this.m_8061_(equipmentslot, new ItemStack((ItemLike)item));
            }
        }
    }

    @Nullable
    public static Item m_21412_(EquipmentSlot slotIn, int chance) {
        switch (slotIn) {
            case HEAD: {
                if (chance == 0) {
                    return Items.f_42407_;
                }
                if (chance == 1) {
                    return Items.f_42476_;
                }
                if (chance == 2) {
                    return Items.f_42464_;
                }
                if (chance == 3) {
                    return Items.f_42468_;
                }
                if (chance == 4) {
                    return Items.f_42472_;
                }
            }
            case CHEST: {
                if (chance == 0) {
                    return Items.f_42408_;
                }
                if (chance == 1) {
                    return Items.f_42477_;
                }
                if (chance == 2) {
                    return Items.f_42465_;
                }
                if (chance == 3) {
                    return Items.f_42469_;
                }
                if (chance == 4) {
                    return Items.f_42473_;
                }
            }
            case LEGS: {
                if (chance == 0) {
                    return Items.f_42462_;
                }
                if (chance == 1) {
                    return Items.f_42478_;
                }
                if (chance == 2) {
                    return Items.f_42466_;
                }
                if (chance == 3) {
                    return Items.f_42470_;
                }
                if (chance == 4) {
                    return Items.f_42474_;
                }
            }
            case FEET: {
                if (chance == 0) {
                    return Items.f_42463_;
                }
                if (chance == 1) {
                    return Items.f_42479_;
                }
                if (chance == 2) {
                    return Items.f_42467_;
                }
                if (chance == 3) {
                    return Items.f_42471_;
                }
                if (chance != 4) break;
                return Items.f_42475_;
            }
        }
        return null;
    }

    protected void m_6850_(DifficultyInstance difficulty) {
        float f = difficulty.m_19057_();
        this.m_7908_(f);
        for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
            if (equipmentslot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            this.m_21380_(f, equipmentslot);
        }
    }

    protected void m_7908_(float p_7908_1_) {
        if (!this.m_21205_().m_41619_() && this.f_19796_.nextFloat() < 0.25f * p_7908_1_) {
            this.m_8061_(EquipmentSlot.MAINHAND, EnchantmentHelper.m_44877_((Random)this.f_19796_, (ItemStack)this.m_21205_(), (int)((int)(5.0f + p_7908_1_ * (float)this.f_19796_.nextInt(18))), (boolean)false));
        }
    }

    protected void m_21380_(float p_21380_1_, EquipmentSlot p_21380_2_) {
        ItemStack itemstack = this.m_6844_(p_21380_2_);
        if (!itemstack.m_41619_() && this.f_19796_.nextFloat() < 0.5f * p_21380_1_) {
            this.m_8061_(p_21380_2_, EnchantmentHelper.m_44877_((Random)this.f_19796_, (ItemStack)itemstack, (int)((int)(5.0f + p_21380_1_ * (float)this.f_19796_.nextInt(18))), (boolean)false));
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.m_21051_(Attributes.f_22277_).m_22125_(new AttributeModifier("Random spawn bonus", this.f_19796_.nextGaussian() * 0.05, AttributeModifier.Operation.MULTIPLY_BASE));
        if (this.f_19796_.nextFloat() < 0.05f) {
            this.m_21559_(true);
        } else {
            this.m_21559_(false);
        }
        return spawnDataIn;
    }

    public boolean m_5807_() {
        return false;
    }

    public void m_21530_() {
        this.f_21353_ = true;
    }

    public void m_21409_(EquipmentSlot slotIn, float chance) {
        switch (slotIn.m_20743_()) {
            case HAND: {
                this.f_21347_[slotIn.m_20749_()] = chance;
                break;
            }
            case ARMOR: {
                this.f_21348_[slotIn.m_20749_()] = chance;
            }
        }
    }

    public boolean m_21531_() {
        return this.f_21352_;
    }

    public void m_21553_(boolean canPickup) {
        this.f_21352_ = canPickup;
    }

    public boolean m_7066_(ItemStack itemstackIn) {
        EquipmentSlot equipmentslot = Mob.m_150278_((ItemStack)itemstackIn);
        return this.m_6844_(equipmentslot).m_41619_() && this.m_21531_();
    }

    public boolean m_21532_() {
        return this.f_21353_;
    }

    public final InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!this.m_6084_()) {
            return InteractionResult.PASS;
        }
        if (this.m_21524_() == player) {
            this.m_21455_(true, !player.m_158008_().f_35937_);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        InteractionResult interactionresult = this.m_21499_(player, hand);
        if (interactionresult.m_19077_()) {
            return interactionresult;
        }
        interactionresult = this.m_6071_(player, hand);
        return interactionresult.m_19077_() ? interactionresult : super.m_6096_(player, hand);
    }

    private InteractionResult m_21499_(Player p_21499_1_, InteractionHand p_21499_2_) {
        InteractionResult interactionresult;
        ItemStack itemstack = p_21499_1_.m_21120_(p_21499_2_);
        if (itemstack.m_160754_(Items.f_42655_) && this.m_6573_(p_21499_1_)) {
            this.m_21463_((Entity)p_21499_1_, true);
            itemstack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (itemstack.m_160754_(Items.f_42656_) && (interactionresult = itemstack.m_41647_(p_21499_1_, (LivingEntity)this, p_21499_2_)).m_19077_()) {
            return interactionresult;
        }
        if (itemstack.m_41720_() instanceof SpawnEggItem) {
            if (this.f_19853_ instanceof ServerLevel) {
                SpawnEggItem spawneggitem = (SpawnEggItem)itemstack.m_41720_();
                Optional optional = spawneggitem.m_43215_(p_21499_1_, this, this.m_6095_(), (ServerLevel)this.f_19853_, this.m_20182_(), itemstack);
                optional.ifPresent(p_21474_2_ -> this.m_5502_(p_21499_1_, (Mob)((Object)p_21474_2_)));
                return optional.isPresent() ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    protected void m_5502_(Player playerIn, Mob child) {
    }

    protected InteractionResult m_6071_(Player p_6071_1_, InteractionHand p_6071_2_) {
        return InteractionResult.PASS;
    }

    public boolean m_21533_() {
        return this.m_21444_(this.m_141983_());
    }

    public boolean m_21444_(BlockPos pos) {
        if (this.f_21341_ == -1.0f) {
            return true;
        }
        return this.f_21360_.m_123331_((Vec3i)pos) < (double)(this.f_21341_ * this.f_21341_);
    }

    public void m_21446_(BlockPos pos, int distance) {
        this.f_21360_ = pos;
        this.f_21341_ = distance;
    }

    public BlockPos m_21534_() {
        return this.f_21360_;
    }

    public float m_21535_() {
        return this.f_21341_;
    }

    public void m_303064_() {
        this.f_21341_ = -1.0f;
    }

    public boolean m_21536_() {
        return this.f_21341_ != -1.0f;
    }

    @Nullable
    public <T extends Mob> T m_21406_(EntityType<T> p_21406_1_, boolean p_21406_2_) {
        if (this.m_149649_()) {
            return (T)((Object)((Mob)null));
        }
        Mob t = (Mob)p_21406_1_.m_20615_(this.f_19853_);
        t.m_20359_((Entity)this);
        t.m_6863_(this.m_6162_());
        t.m_21557_(this.m_21525_());
        if (this.m_8077_()) {
            t.m_6593_(this.m_7770_());
            t.m_20340_(this.m_20151_());
        }
        if (this.m_21532_()) {
            t.m_21530_();
        }
        t.m_20331_(this.m_20147_());
        if (p_21406_2_) {
            t.m_21553_(this.m_21531_());
            for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                ItemStack itemstack = this.m_6844_(equipmentslot);
                if (itemstack.m_41619_()) continue;
                t.m_8061_(equipmentslot, itemstack.m_41777_());
                t.m_21409_(equipmentslot, this.m_21519_(equipmentslot));
                itemstack.m_41764_(0);
            }
        }
        this.f_19853_.m_7967_((Entity)t);
        if (this.m_20159_()) {
            Entity entity = this.m_20202_();
            this.m_8127_();
            t.m_7998_(entity, true);
        }
        this.m_149572_();
        return (T)((Object)t);
    }

    protected void m_6119_() {
        if (this.f_21359_ != null) {
            this.m_21528_();
        }
        if (!(this.f_21357_ == null || this.m_6084_() && this.f_21357_.m_6084_())) {
            this.m_21455_(true, true);
        }
    }

    public void m_21455_(boolean sendPacket, boolean dropLead) {
        if (this.f_21357_ != null) {
            this.f_21357_ = null;
            this.f_21359_ = null;
            if (!this.f_19853_.f_46443_ && dropLead) {
                this.m_19998_((ItemLike)Items.f_42655_);
            }
            if (!this.f_19853_.f_46443_ && sendPacket && this.f_19853_ instanceof ServerLevel) {
                ((ServerLevel)this.f_19853_).m_7726_().m_8445_((Entity)this, (Packet)new ClientboundSetEntityLinkPacket((Entity)this, (Entity)null));
            }
        }
    }

    public boolean m_6573_(Player player) {
        return !this.m_21523_() && !(this instanceof Enemy);
    }

    public boolean m_21523_() {
        return this.f_21357_ != null;
    }

    @Nullable
    public Entity m_21524_() {
        if (this.f_21357_ == null && this.f_21358_ != 0 && this.f_19853_.f_46443_) {
            this.f_21357_ = this.f_19853_.m_6815_(this.f_21358_);
        }
        return this.f_21357_;
    }

    public void m_21463_(Entity entityIn, boolean sendAttachNotification) {
        this.f_21357_ = entityIn;
        this.f_21359_ = null;
        if (!this.f_19853_.f_46443_ && sendAttachNotification && this.f_19853_ instanceof ServerLevel) {
            ((ServerLevel)this.f_19853_).m_7726_().m_8445_((Entity)this, (Packet)new ClientboundSetEntityLinkPacket((Entity)this, this.f_21357_));
        }
        if (this.m_20159_()) {
            this.m_8127_();
        }
    }

    public void m_21506_(int leashHolderIDIn) {
        this.f_21358_ = leashHolderIDIn;
        this.m_21455_(false, false);
    }

    public boolean m_7998_(Entity entityIn, boolean force) {
        boolean flag = super.m_7998_(entityIn, force);
        if (flag && this.m_21523_()) {
            this.m_21455_(true, true);
        }
        return flag;
    }

    private void m_21528_() {
        if (this.f_21359_ != null && this.f_19853_ instanceof ServerLevel) {
            if (this.f_21359_.m_128403_("UUID")) {
                UUID uuid = this.f_21359_.m_128342_("UUID");
                Entity entity = ((ServerLevel)this.f_19853_).m_8791_(uuid);
                if (entity != null) {
                    this.m_21463_(entity, true);
                    return;
                }
            } else if (this.f_21359_.m_128425_("X", 99) && this.f_21359_.m_128425_("Y", 99) && this.f_21359_.m_128425_("Z", 99)) {
                BlockPos blockpos = new BlockPos(this.f_21359_.m_128451_("X"), this.f_21359_.m_128451_("Y"), this.f_21359_.m_128451_("Z"));
                this.m_21463_((Entity)LeashFenceKnotEntity.m_31844_((Level)this.f_19853_, (BlockPos)blockpos), true);
                return;
            }
            if (this.f_19797_ > 100) {
                this.m_19998_((ItemLike)Items.f_42655_);
                this.f_21359_ = null;
            }
        }
    }

    public boolean m_6109_() {
        return this.m_5807_() && super.m_6109_();
    }

    public boolean m_6142_() {
        return super.m_6142_() && !this.m_21525_();
    }

    public void m_21557_(boolean disable) {
        byte b0 = this.f_19804_.m_135370_(f_21340_);
        this.f_19804_.m_135381_(f_21340_, disable ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE));
    }

    public void m_21559_(boolean leftHanded) {
        byte b0 = this.f_19804_.m_135370_(f_21340_);
        this.f_19804_.m_135381_(f_21340_, leftHanded ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD));
    }

    public void m_21561_(boolean hasAggro) {
        byte b0 = this.f_19804_.m_135370_(f_21340_);
        this.f_19804_.m_135381_(f_21340_, hasAggro ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB));
    }

    public boolean m_21525_() {
        return (this.f_19804_.m_135370_(f_21340_) & 1) != 0;
    }

    public boolean m_21526_() {
        return (this.f_19804_.m_135370_(f_21340_) & 2) != 0;
    }

    public boolean m_5912_() {
        return (this.f_19804_.m_135370_(f_21340_) & 4) != 0;
    }

    public void m_6863_(boolean childZombie) {
    }

    public HumanoidArm m_5737_() {
        return this.m_21526_() ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
    }

    public double m_141628_(LivingEntity p_141628_1_) {
        return this.m_20205_() * 2.0f * this.m_20205_() * 2.0f + p_141628_1_.m_20205_();
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag;
        int i;
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entityIn).m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            entityIn.m_20254_(i * 4);
        }
        if (flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), f)) {
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).m_303034_((double)(f1 * 0.5f), (double)Mth.m_14031_(this.m_302838_() * ((float)Math.PI / 180)), (double)(-Mth.m_14089_(this.m_302838_() * ((float)Math.PI / 180))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if (entityIn instanceof Player) {
                Player player = (Player)entityIn;
                this.m_21424_(player, this.m_21205_(), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
            }
            this.m_19970_(this, entityIn);
            this.m_21335_(entityIn);
        }
        return flag;
    }

    private void m_21424_(Player p_21424_1_, ItemStack p_21424_2_, ItemStack p_21424_3_) {
        if (!p_21424_2_.m_41619_() && !p_21424_3_.m_41619_() && p_21424_2_.m_41720_() instanceof AxeItem && p_21424_3_.m_160754_(Items.f_42740_)) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
            if (this.f_19796_.nextFloat() < f) {
                p_21424_1_.m_36335_().m_41524_(Items.f_42740_, 100);
                this.f_19853_.m_7605_((Entity)p_21424_1_, (byte)30);
            }
        }
    }

    protected boolean m_21527_() {
        if (this.f_19853_.m_46461_() && !this.f_19853_.f_46443_) {
            boolean flag;
            float f = this.m_6073_();
            BlockPos blockpos = new BlockPos(this.m_20185_(), this.m_20188_(), this.m_20189_());
            boolean bl = flag = this.m_20071_() || this.f_149382_ || this.f_149383_;
            if (f > 0.5f && this.f_19796_.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && !flag && this.f_19853_.m_45527_(blockpos)) {
                return true;
            }
        }
        return false;
    }

    protected void m_6197_(Tag<Fluid> fluidTag) {
        if (this.m_21573_().m_26576_()) {
            super.m_6197_(fluidTag);
        } else {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.3, 0.0));
        }
    }

    public void m_303065_() {
        this.f_21345_.m_303699_();
        this.m_6274_().m_303085_();
    }

    protected void m_6089_() {
        super.m_6089_();
        this.m_21455_(true, false);
        this.m_20158_().forEach(p_303066_0_ -> p_303066_0_.m_41764_(0));
    }

    @Nullable
    public ItemStack m_141551_() {
        SpawnEggItem spawneggitem = SpawnEggItem.m_43213_((EntityType)this.m_6095_());
        return spawneggitem == null ? null : new ItemStack((ItemLike)spawneggitem);
    }

    private boolean canSkipUpdate() {
        double dz;
        if (this.m_6162_()) {
            return false;
        }
        if (this.f_20916_ > 0) {
            return false;
        }
        if (this.f_19797_ < 20) {
            return false;
        }
        List listPlayers = this.getListPlayers(this.m_20193_());
        if (listPlayers == null) {
            return false;
        }
        if (listPlayers.size() != 1) {
            return false;
        }
        Entity player = (Entity)listPlayers.get(0);
        double dx = Math.max(Math.abs(this.m_20185_() - player.m_20185_()) - 16.0, 0.0);
        double distSq = dx * dx + (dz = Math.max(Math.abs(this.m_20189_() - player.m_20189_()) - 16.0, 0.0)) * dz;
        return !this.m_6783_(distSq);
    }

    private List getListPlayers(Level entityWorld) {
        Level world = this.m_20193_();
        if (world instanceof ClientLevel) {
            ClientLevel worldClient = (ClientLevel)world;
            return worldClient.m_6907_();
        }
        if (world instanceof ServerLevel) {
            ServerLevel worldServer = (ServerLevel)world;
            return worldServer.m_6907_();
        }
        return null;
    }

    private void onUpdateMinimal() {
        ++this.f_20891_;
        if (this instanceof Monster) {
            float brightness = this.m_6073_();
            boolean raider = this instanceof Raider;
            if (brightness > 0.5f || raider) {
                this.f_20891_ += 2;
            }
        }
    }
}

