/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.util.profiling.ContinuousProfiler;
import net.minecraft.util.profiling.FilledProfileResults;
import net.minecraft.util.profiling.ProfileCollector;
import net.minecraft.util.profiling.ProfileResults;
import net.minecraft.util.profiling.ProfilerPathEntry;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.optifine.Config;
import net.optifine.Lagometer;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorClass;
import net.optifine.reflect.ReflectorField;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class ActiveProfiler
implements ProfileCollector {
    private static final long f_18368_ = Duration.ofMillis(100L).toNanos();
    private static final Logger f_18369_ = LogManager.getLogger();
    private final List<String> f_18370_ = Lists.newArrayList();
    private final LongList f_18371_ = new LongArrayList();
    private final Map<String, PathEntry> f_18372_ = Maps.newHashMap();
    private final IntSupplier f_18373_;
    private final LongSupplier f_18374_;
    private final long f_18375_;
    private final int f_18376_;
    private String f_18377_ = "";
    private boolean f_18378_;
    @Nullable
    private PathEntry f_18379_;
    private final boolean f_18380_;
    private final Set<Pair<String, MetricCategory>> f_301989_ = new ObjectArraySet();
    private boolean clientProfiler = false;
    private boolean lagometerActive = false;
    private static final String SCHEDULED_EXECUTABLES = "scheduledExecutables";
    private static final String TICK = "tick";
    private static final String SOUND = "sound";
    private static final int HASH_SCHEDULED_EXECUTABLES = "scheduledExecutables".hashCode();
    private static final int HASH_TICK = "tick".hashCode();
    private static final int HASH_SOUND = "sound".hashCode();
    private static final ReflectorClass MINECRAFT = new ReflectorClass(Minecraft.class);
    private static final ReflectorField Minecraft_timeTracker = new ReflectorField(MINECRAFT, ContinuousProfiler.class);

    public ActiveProfiler(LongSupplier p_i18382_1_, IntSupplier p_i18382_2_, boolean p_i18382_3_) {
        this.f_18375_ = p_i18382_1_.getAsLong();
        this.f_18374_ = p_i18382_1_;
        this.f_18376_ = p_i18382_2_.getAsInt();
        this.f_18373_ = p_i18382_2_;
        this.f_18380_ = p_i18382_3_;
    }

    public void m_7242_() {
        ContinuousProfiler timeTracker = (ContinuousProfiler)Reflector.getFieldValue(Minecraft.m_91087_(), Minecraft_timeTracker);
        this.clientProfiler = timeTracker != null && timeTracker.m_18439_() == this;
        boolean bl = this.lagometerActive = this.clientProfiler && Lagometer.isActive();
        if (this.f_18378_) {
            f_18369_.error("Profiler tick already started - missing endTick()?");
        } else {
            this.f_18378_ = true;
            this.f_18377_ = "";
            this.f_18370_.clear();
            this.m_6180_("root");
        }
    }

    public void m_7241_() {
        if (!this.f_18378_) {
            f_18369_.error("Profiler tick already ended - missing startTick()?");
        } else {
            this.m_7238_();
            this.f_18378_ = false;
            if (!this.f_18377_.isEmpty()) {
                f_18369_.error("Profiler tick ended before path was fully popped (remainder: '{}'). Mismatched push/pop?", new Supplier[]{() -> ProfileResults.m_18575_((String)this.f_18377_)});
            }
        }
    }

    public void m_6180_(String name) {
        if (this.lagometerActive) {
            int hashName = name.hashCode();
            if (hashName == HASH_SCHEDULED_EXECUTABLES && name.equals(SCHEDULED_EXECUTABLES)) {
                Lagometer.timerScheduledExecutables.start();
            } else if (hashName == HASH_TICK && name.equals(TICK) && Config.isMinecraftThread()) {
                Lagometer.timerScheduledExecutables.end();
                Lagometer.timerTick.start();
            }
        }
        if (!this.f_18378_) {
            f_18369_.error("Cannot push '{}' to profiler if profiler tick hasn't started - missing startTick()?", (Object)name);
        } else {
            if (!this.f_18377_.isEmpty()) {
                this.f_18377_ = this.f_18377_ + "\u001e";
            }
            this.f_18377_ = this.f_18377_ + name;
            this.f_18370_.add(this.f_18377_);
            this.f_18371_.add(Util.m_137569_());
            this.f_18379_ = null;
        }
    }

    public void m_6521_(java.util.function.Supplier<String> nameSupplier) {
        this.m_6180_(nameSupplier.get());
    }

    public void m_299607_(MetricCategory categoryIn) {
        this.f_301989_.add((Pair<String, MetricCategory>)Pair.of((Object)this.f_18377_, (Object)categoryIn));
    }

    public void m_7238_() {
        if (!this.f_18378_) {
            f_18369_.error("Cannot pop from profiler if profiler tick hasn't started - missing startTick()?");
        } else if (this.f_18371_.isEmpty()) {
            f_18369_.error("Tried to pop one too many times! Mismatched push() and pop()?");
        } else {
            long i = Util.m_137569_();
            long j = this.f_18371_.removeLong(this.f_18371_.size() - 1);
            this.f_18370_.remove(this.f_18370_.size() - 1);
            long k = i - j;
            PathEntry activeprofiler$pathentry = this.m_18406_();
            activeprofiler$pathentry.f_301997_ = (activeprofiler$pathentry.f_301997_ * 49L + k) / 50L;
            activeprofiler$pathentry.f_18410_ = 1L;
            activeprofiler$pathentry.f_301997_ += k;
            ++activeprofiler$pathentry.f_18410_;
            activeprofiler$pathentry.f_301995_ = Math.max(activeprofiler$pathentry.f_301995_, k);
            activeprofiler$pathentry.f_301996_ = Math.min(activeprofiler$pathentry.f_301996_, k);
            if (this.f_18380_ && k > f_18368_) {
                f_18369_.warn("Something's taking too long! '{}' took aprox {} ms", new Supplier[]{() -> ProfileResults.m_18575_((String)this.f_18377_), () -> (double)k / 1000000.0});
            }
            this.f_18377_ = this.f_18370_.isEmpty() ? "" : this.f_18370_.get(this.f_18370_.size() - 1);
            this.f_18379_ = null;
        }
    }

    public void m_6182_(String name) {
        int hashName;
        if (this.lagometerActive && (hashName = name.hashCode()) == HASH_SOUND && name.equals(SOUND)) {
            Lagometer.timerTick.end();
        }
        this.m_7238_();
        this.m_6180_(name);
    }

    public void m_6523_(java.util.function.Supplier<String> nameSupplier) {
        this.m_7238_();
        this.m_6521_(nameSupplier);
    }

    private PathEntry m_18406_() {
        if (this.f_18379_ == null) {
            this.f_18379_ = this.f_18372_.computeIfAbsent(this.f_18377_, p_18404_0_ -> new PathEntry());
        }
        return this.f_18379_;
    }

    public void m_6174_(String nameIn) {
        this.m_18406_().f_18411_.addTo((Object)nameIn, 1L);
    }

    public void m_6525_(java.util.function.Supplier<String> nameSupplierIn) {
        this.m_18406_().f_18411_.addTo((Object)nameSupplierIn.get(), 1L);
    }

    public ProfileResults m_5948_() {
        return new FilledProfileResults(this.f_18372_, this.f_18375_, this.f_18376_, this.f_18374_.getAsLong(), this.f_18373_.getAsInt());
    }

    @Nullable
    public PathEntry m_299725_(String nameIn) {
        return this.f_18372_.get(nameIn);
    }

    public Set<Pair<String, MetricCategory>> m_299829_() {
        return this.f_301989_;
    }

    public static class PathEntry
    implements ProfilerPathEntry {
        long f_301995_ = Long.MIN_VALUE;
        long f_301996_ = Long.MAX_VALUE;
        long f_301997_;
        long f_18410_;
        final Object2LongOpenHashMap<String> f_18411_ = new Object2LongOpenHashMap();

        public long m_7235_() {
            return this.f_301997_;
        }

        public long m_299937_() {
            return this.f_301995_;
        }

        public long m_7234_() {
            return this.f_18410_;
        }

        public Object2LongMap<String> m_7446_() {
            return Object2LongMaps.unmodifiable(this.f_18411_);
        }
    }
}

