/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkTaskPriorityQueue;
import net.minecraft.server.level.ChunkTaskPriorityQueueSorter;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.CsvOutput;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.phys.Vec3;
import net.optifine.reflect.Reflector;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkMap
extends ChunkStorage
implements ChunkHolder.PlayerProvider {
    private static final byte f_300169_ = -1;
    private static final byte f_300170_ = 0;
    private static final byte f_300171_ = 1;
    private static final Logger f_140128_ = LogManager.getLogger();
    private static final int f_300172_ = 200;
    private static final int f_300173_ = 3;
    public static final int f_300167_ = 33;
    public static final int f_140127_ = 65 + ChunkStatus.m_62421_();
    public static final int f_300168_ = 31;
    private final Long2ObjectLinkedOpenHashMap<ChunkHolder> f_140129_ = new Long2ObjectLinkedOpenHashMap();
    private volatile Long2ObjectLinkedOpenHashMap<ChunkHolder> f_140130_ = this.f_140129_.clone();
    private final Long2ObjectLinkedOpenHashMap<ChunkHolder> f_140131_ = new Long2ObjectLinkedOpenHashMap();
    private final LongSet f_140132_ = new LongOpenHashSet();
    final ServerLevel f_140133_;
    private final ThreadedLevelLightEngine f_140134_;
    private final BlockableEventLoop<Runnable> f_140135_;
    private final ChunkGenerator f_140136_;
    private final Supplier<DimensionDataStorage> f_140137_;
    private final PoiManager f_140138_;
    final LongSet f_140139_ = new LongOpenHashSet();
    private boolean f_140140_;
    private final ChunkTaskPriorityQueueSorter f_140141_;
    private final ProcessorHandle<ChunkTaskPriorityQueueSorter.Message<Runnable>> f_140142_;
    private final ProcessorHandle<ChunkTaskPriorityQueueSorter.Message<Runnable>> f_140143_;
    private final ChunkProgressListener f_140144_;
    private final ChunkStatusUpdateListener f_142513_;
    private final DistanceManager f_140145_;
    private final AtomicInteger f_140146_ = new AtomicInteger();
    private final StructureManager f_140147_;
    private final String f_320768_;
    private final PlayerMap f_140149_ = new PlayerMap();
    private final Int2ObjectMap<TrackedEntity> f_140150_ = new Int2ObjectOpenHashMap();
    private final Long2ByteMap f_140151_ = new Long2ByteOpenHashMap();
    private final Queue<Runnable> f_140125_ = Queues.newConcurrentLinkedQueue();
    int f_140126_;

    public ChunkMap(ServerLevel worldIn, LevelStorageSource.LevelStorageAccess levelSaveIn, DataFixer dataFixerIn, StructureManager templateManagerIn, Executor executorIn, BlockableEventLoop<Runnable> taskExecutorIn, LightChunkGetter lightProviderIn, ChunkGenerator chunkGeneratorIn, ChunkProgressListener statusListenerIn, ChunkStatusUpdateListener p_i142514_10_, Supplier<DimensionDataStorage> p_i142514_11_, int p_i142514_12_, boolean p_i142514_13_) {
        super(new File(levelSaveIn.m_78299_(worldIn.m_46472_()), "region"), dataFixerIn, p_i142514_13_);
        this.f_140147_ = templateManagerIn;
        File file1 = levelSaveIn.m_78299_(worldIn.m_46472_());
        this.f_320768_ = file1.getName();
        this.f_140133_ = worldIn;
        this.f_140136_ = chunkGeneratorIn;
        this.f_140135_ = taskExecutorIn;
        ProcessorMailbox processormailbox = ProcessorMailbox.m_18751_((Executor)executorIn, (String)"worldgen");
        ProcessorHandle processorhandle = ProcessorHandle.m_18714_((String)"main", taskExecutorIn::m_6937_);
        this.f_140144_ = statusListenerIn;
        this.f_142513_ = p_i142514_10_;
        ProcessorMailbox processormailbox1 = ProcessorMailbox.m_18751_((Executor)executorIn, (String)"light");
        this.f_140141_ = new ChunkTaskPriorityQueueSorter((List)ImmutableList.of((Object)processormailbox, (Object)processorhandle, (Object)processormailbox1), executorIn, Integer.MAX_VALUE);
        this.f_140142_ = this.f_140141_.m_140604_((ProcessorHandle)processormailbox, false);
        this.f_140143_ = this.f_140141_.m_140604_(processorhandle, false);
        this.f_140134_ = new ThreadedLevelLightEngine(lightProviderIn, this, this.f_140133_.m_6042_().m_63935_(), processormailbox1, this.f_140141_.m_140604_((ProcessorHandle)processormailbox1, false));
        this.f_140145_ = new DistanceManager(executorIn, taskExecutorIn);
        this.f_140137_ = p_i142514_11_;
        this.f_140138_ = new PoiManager(new File(file1, "poi"), dataFixerIn, p_i142514_13_, (LevelHeightAccessor)worldIn);
        this.m_140167_(p_i142514_12_);
    }

    private static double m_140226_(ChunkPos chunkPosIn, Entity entityIn) {
        double d0 = SectionPos.m_213997_((int)chunkPosIn.f_45578_, (int)8);
        double d1 = SectionPos.m_213997_((int)chunkPosIn.f_45579_, (int)8);
        double d2 = d0 - entityIn.m_20185_();
        double d3 = d1 - entityIn.m_20189_();
        return d2 * d2 + d3 * d3;
    }

    private static int m_140338_(ChunkPos pos, ServerPlayer player, boolean p_140338_2_) {
        int j;
        int i;
        if (p_140338_2_) {
            SectionPos sectionpos = player.m_8965_();
            i = sectionpos.m_123170_();
            j = sectionpos.m_123222_();
        } else {
            i = SectionPos.m_123171_((int)player.m_149633_());
            j = SectionPos.m_123171_((int)player.m_149635_());
        }
        return ChunkMap.m_140206_(pos, i, j);
    }

    private static int m_300239_(ChunkPos chunkPosIn, Entity entityIn) {
        return ChunkMap.m_140206_(chunkPosIn, SectionPos.m_123171_((int)entityIn.m_149633_()), SectionPos.m_123171_((int)entityIn.m_149635_()));
    }

    private static int m_140206_(ChunkPos chunkPosIn, int x, int y) {
        int i = chunkPosIn.f_45578_ - x;
        int j = chunkPosIn.f_45579_ - y;
        return Math.max(Math.abs(i), Math.abs(j));
    }

    protected ThreadedLevelLightEngine m_140166_() {
        return this.f_140134_;
    }

    @Nullable
    protected ChunkHolder m_140174_(long chunkPosIn) {
        return (ChunkHolder)this.f_140129_.get(chunkPosIn);
    }

    @Nullable
    protected ChunkHolder m_140327_(long chunkPosIn) {
        return (ChunkHolder)this.f_140130_.get(chunkPosIn);
    }

    protected IntSupplier m_140371_(long chunkPosIn) {
        return () -> {
            ChunkHolder chunkholder = this.m_140327_(chunkPosIn);
            return chunkholder == null ? ChunkTaskPriorityQueue.f_140508_ - 1 : Math.min(chunkholder.m_140094_(), ChunkTaskPriorityQueue.f_140508_ - 1);
        };
    }

    public String m_140204_(ChunkPos pos) {
        ChunkHolder chunkholder = this.m_140327_(pos.m_45588_());
        if (chunkholder == null) {
            return "null";
        }
        String s = chunkholder.m_140093_() + "\n";
        ChunkStatus chunkstatus = chunkholder.m_140088_();
        ChunkAccess chunkaccess = chunkholder.m_140089_();
        if (chunkstatus != null) {
            s = s + "St: \u00a7" + chunkstatus.m_62445_() + chunkstatus + "\u00a7r\n";
        }
        if (chunkaccess != null) {
            s = s + "Ch: \u00a7" + chunkaccess.m_6415_().m_62445_() + chunkaccess.m_6415_() + "\u00a7r\n";
        }
        ChunkHolder.FullChunkStatus chunkholder$fullchunkstatus = chunkholder.m_140091_();
        s = s + "\u00a7" + chunkholder$fullchunkstatus.ordinal() + chunkholder$fullchunkstatus;
        return s + "\u00a7r";
    }

    private CompletableFuture<Either<List<ChunkAccess>, ChunkHolder.ChunkLoadingFailure>> m_140210_(ChunkPos pos, final int p_140210_2_, IntFunction<ChunkStatus> p_140210_3_) {
        ArrayList list = Lists.newArrayList();
        final int i = pos.f_45578_;
        final int j = pos.f_45579_;
        for (int k = -p_140210_2_; k <= p_140210_2_; ++k) {
            for (int l = -p_140210_2_; l <= p_140210_2_; ++l) {
                int i1 = Math.max(Math.abs(l), Math.abs(k));
                final ChunkPos chunkpos = new ChunkPos(i + l, j + k);
                long j1 = chunkpos.m_45588_();
                ChunkHolder chunkholder = this.m_140174_(j1);
                if (chunkholder == null) {
                    return CompletableFuture.completedFuture(Either.right((Object)new ChunkHolder.ChunkLoadingFailure(){

                        public String toString() {
                            return "Unloaded " + chunkpos;
                        }
                    }));
                }
                ChunkStatus chunkstatus = p_140210_3_.apply(i1);
                CompletableFuture completablefuture = chunkholder.m_140049_(chunkstatus, this);
                list.add(completablefuture);
            }
        }
        CompletableFuture completablefuture1 = Util.m_137567_(list);
        return completablefuture1.thenApply(p_140169_4_ -> {
            ArrayList list1 = Lists.newArrayList();
            int k1 = 0;
            for (final Either either : p_140169_4_) {
                Optional optional = either.left();
                if (!optional.isPresent()) {
                    final int l1 = k1;
                    return Either.right((Object)new ChunkHolder.ChunkLoadingFailure(){

                        public String toString() {
                            int i2 = i + l1 % (p_140210_2_ * 2 + 1);
                            return "Unloaded " + new ChunkPos(i2, j + l1 / (p_140210_2_ * 2 + 1)) + " " + either.right().get();
                        }
                    });
                }
                list1.add(optional.get());
                ++k1;
            }
            return Either.left((Object)list1);
        });
    }

    public CompletableFuture<Either<LevelChunk, ChunkHolder.ChunkLoadingFailure>> m_142678_(ChunkPos p_142678_1_) {
        return this.m_140210_(p_142678_1_, 2, p_142690_0_ -> ChunkStatus.f_62326_).thenApplyAsync(p_142704_0_ -> p_142704_0_.mapLeft(p_300261_0_ -> (LevelChunk)p_300261_0_.get(p_300261_0_.size() / 2)), (Executor)this.f_140135_);
    }

    @Nullable
    ChunkHolder m_140176_(long chunkPosIn, int newLevel, @Nullable ChunkHolder holder, int oldLevel) {
        if (oldLevel > f_140127_ && newLevel > f_140127_) {
            return holder;
        }
        if (holder != null) {
            holder.m_140027_(newLevel);
        }
        if (holder != null) {
            if (newLevel > f_140127_) {
                this.f_140139_.add(chunkPosIn);
            } else {
                this.f_140139_.remove(chunkPosIn);
            }
        }
        if (newLevel <= f_140127_ && holder == null) {
            holder = (ChunkHolder)this.f_140131_.remove(chunkPosIn);
            if (holder != null) {
                holder.m_140027_(newLevel);
            } else {
                holder = new ChunkHolder(new ChunkPos(chunkPosIn), newLevel, (LevelHeightAccessor)this.f_140133_, (LevelLightEngine)this.f_140134_, (ChunkHolder.LevelChangeListener)this.f_140141_, (ChunkHolder.PlayerProvider)this);
            }
            this.f_140129_.put(chunkPosIn, (Object)holder);
            this.f_140140_ = true;
        }
        return holder;
    }

    public void close() throws IOException {
        try {
            this.f_140141_.close();
            this.f_140138_.close();
        }
        finally {
            super.close();
        }
    }

    protected void m_140318_(boolean flush) {
        if (flush) {
            List list = this.f_140130_.values().stream().filter(ChunkHolder::m_140095_).peek(ChunkHolder::m_140096_).collect(Collectors.toList());
            MutableBoolean mutableboolean = new MutableBoolean();
            do {
                mutableboolean.setFalse();
                list.stream().map(p_140419_1_ -> {
                    CompletableFuture completablefuture;
                    do {
                        completablefuture = p_140419_1_.m_140090_();
                        this.f_140135_.m_18701_(completablefuture::isDone);
                    } while (completablefuture != p_140419_1_.m_140090_());
                    return (ChunkAccess)completablefuture.join();
                }).filter(p_140399_0_ -> p_140399_0_ instanceof ImposterProtoChunk || p_140399_0_ instanceof LevelChunk).filter(this::m_140258_).forEach(p_140282_1_ -> mutableboolean.setTrue());
            } while (mutableboolean.isTrue());
            this.m_140353_(() -> true);
            this.m_63514_();
        } else {
            this.f_140130_.values().stream().filter(ChunkHolder::m_140095_).forEach(p_140411_1_ -> {
                ChunkAccess chunkaccess = p_140411_1_.m_140090_().getNow(null);
                if (chunkaccess instanceof ImposterProtoChunk || chunkaccess instanceof LevelChunk) {
                    this.m_140258_(chunkaccess);
                    p_140411_1_.m_140096_();
                }
            });
        }
    }

    protected void m_140280_(BooleanSupplier hasMoreTime) {
        ProfilerFiller profilerfiller = this.f_140133_.m_46473_();
        profilerfiller.m_6180_("poi");
        this.f_140138_.m_6202_(hasMoreTime);
        profilerfiller.m_6182_("chunk_unload");
        if (!this.f_140133_.m_7441_()) {
            this.m_140353_(hasMoreTime);
        }
        profilerfiller.m_7238_();
    }

    private void m_140353_(BooleanSupplier hasMoreTime) {
        Runnable runnable;
        LongIterator longiterator = this.f_140139_.iterator();
        int i = 0;
        while (longiterator.hasNext() && (hasMoreTime.getAsBoolean() || i < 200 || this.f_140139_.size() > 2000)) {
            long j = longiterator.nextLong();
            ChunkHolder chunkholder = (ChunkHolder)this.f_140129_.remove(j);
            if (chunkholder != null) {
                this.f_140131_.put(j, (Object)chunkholder);
                this.f_140140_ = true;
                ++i;
                this.m_140181_(j, chunkholder);
            }
            longiterator.remove();
        }
        for (int saveTasksSize = this.f_140125_.size(); (hasMoreTime.getAsBoolean() || saveTasksSize > 2000) && (runnable = this.f_140125_.poll()) != null; --saveTasksSize) {
            runnable.run();
        }
    }

    private void m_140181_(long chunkPosIn, ChunkHolder chunkHolderIn) {
        CompletableFuture completablefuture = chunkHolderIn.m_140090_();
        ((CompletableFuture)completablefuture.thenAcceptAsync(p_140305_5_ -> {
            CompletableFuture completablefuture1 = chunkHolderIn.m_140090_();
            if (completablefuture1 != completablefuture) {
                this.m_140181_(chunkPosIn, chunkHolderIn);
            } else if (this.f_140131_.remove(chunkPosIn, (Object)chunkHolderIn) && p_140305_5_ != null) {
                if (p_140305_5_ instanceof LevelChunk) {
                    ((LevelChunk)p_140305_5_).m_62913_(false);
                    if (Reflector.ChunkEvent_Unload_Constructor.exists()) {
                        Reflector.postForgeBusEvent(Reflector.ChunkEvent_Unload_Constructor, (LevelChunk)p_140305_5_);
                    }
                }
                this.m_140258_((ChunkAccess)p_140305_5_);
                if (this.f_140132_.remove(chunkPosIn) && p_140305_5_ instanceof LevelChunk) {
                    LevelChunk levelchunk = (LevelChunk)p_140305_5_;
                    this.f_140133_.m_8712_(levelchunk);
                }
                this.f_140134_.m_9330_(p_140305_5_.m_7697_());
                this.f_140134_.m_9409_();
                this.f_140144_.m_5511_(p_140305_5_.m_7697_(), (ChunkStatus)null);
            }
        }, this.f_140125_::add)).whenComplete((p_140301_1_, p_140301_2_) -> {
            if (p_140301_2_ != null) {
                f_140128_.error("Failed to save chunk {}", (Object)chunkHolderIn.m_140092_(), p_140301_2_);
            }
        });
    }

    protected boolean m_140324_() {
        if (!this.f_140140_) {
            return false;
        }
        this.f_140130_ = this.f_140129_.clone();
        this.f_140140_ = false;
        return true;
    }

    public CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_140292_(ChunkHolder chunkHolderIn, ChunkStatus chunkStatusIn) {
        Optional optional;
        ChunkPos chunkpos = chunkHolderIn.m_140092_();
        if (chunkStatusIn == ChunkStatus.f_62314_) {
            return this.m_140417_(chunkpos);
        }
        if (chunkStatusIn == ChunkStatus.f_62323_) {
            this.f_140145_.m_140792_(TicketType.f_9446_, chunkpos, 33 + ChunkStatus.m_62370_((ChunkStatus)ChunkStatus.f_62323_), chunkpos);
        }
        if ((optional = chunkHolderIn.m_140049_(chunkStatusIn.m_62482_(), this).getNow(ChunkHolder.f_139995_).left()).isPresent() && ((ChunkAccess)optional.get()).m_6415_().m_62427_(chunkStatusIn)) {
            CompletableFuture completablefuture = chunkStatusIn.m_62364_(this.f_140133_, this.f_140147_, this.f_140134_, p_300253_2_ -> this.m_140383_(chunkHolderIn), (ChunkAccess)optional.get());
            this.f_140144_.m_5511_(chunkpos, chunkStatusIn);
            return completablefuture;
        }
        return this.m_140360_(chunkHolderIn, chunkStatusIn);
    }

    private CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_140417_(ChunkPos chunkPosIn) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.f_140133_.m_46473_().m_6174_("chunkLoad");
                CompoundTag compoundtag = this.m_140427_(chunkPosIn);
                if (compoundtag != null) {
                    boolean flag;
                    boolean bl = flag = compoundtag.m_128425_("Level", 10) && compoundtag.m_128469_("Level").m_128425_("Status", 8);
                    if (flag) {
                        ProtoChunk chunkaccess = ChunkSerializer.m_63457_((ServerLevel)this.f_140133_, (StructureManager)this.f_140147_, (PoiManager)this.f_140138_, (ChunkPos)chunkPosIn, (CompoundTag)compoundtag);
                        this.m_140229_(chunkPosIn, chunkaccess.m_6415_().m_62494_());
                        return Either.left((Object)chunkaccess);
                    }
                    f_140128_.error("Chunk file at {} is missing level data, skipping", (Object)chunkPosIn);
                }
            }
            catch (ReportedException reportedexception) {
                Throwable throwable = reportedexception.getCause();
                if (!(throwable instanceof IOException)) {
                    this.m_140422_(chunkPosIn);
                    throw reportedexception;
                }
                f_140128_.error("Couldn't load chunk {}", (Object)chunkPosIn, (Object)throwable);
            }
            catch (Exception exception) {
                f_140128_.error("Couldn't load chunk {}", (Object)chunkPosIn, (Object)exception);
            }
            this.m_140422_(chunkPosIn);
            return Either.left((Object)new ProtoChunk(chunkPosIn, UpgradeData.f_63320_, (LevelHeightAccessor)this.f_140133_));
        }, this.f_140135_);
    }

    private void m_140422_(ChunkPos p_140422_1_) {
        this.f_140151_.put(p_140422_1_.m_45588_(), (byte)-1);
    }

    private byte m_140229_(ChunkPos p_140229_1_, ChunkStatus.ChunkType p_140229_2_) {
        return this.f_140151_.put(p_140229_1_.m_45588_(), (byte)(p_140229_2_ == ChunkStatus.ChunkType.PROTOCHUNK ? -1 : 1));
    }

    private CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_140360_(ChunkHolder chunkHolderIn, ChunkStatus chunkStatusIn) {
        ChunkPos chunkpos = chunkHolderIn.m_140092_();
        CompletableFuture<Either<List<ChunkAccess>, ChunkHolder.ChunkLoadingFailure>> completablefuture = this.m_140210_(chunkpos, chunkStatusIn.m_62488_(), p_300244_2_ -> this.m_140262_(chunkStatusIn, p_300244_2_));
        this.f_140133_.m_46473_().m_6525_(() -> "chunkGenerate " + chunkStatusIn.m_62467_());
        Executor executor = p_300270_2_ -> this.f_140142_.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140642_((ChunkHolder)chunkHolderIn, (Runnable)p_300270_2_));
        return completablefuture.thenComposeAsync(p_300193_5_ -> (CompletionStage)p_300193_5_.map(p_300199_5_ -> {
            try {
                CompletableFuture completablefuture1 = chunkStatusIn.m_174401_(executor, this.f_140133_, this.f_140136_, this.f_140147_, this.f_140134_, p_300233_2_ -> this.m_140383_(chunkHolderIn), p_300199_5_);
                this.f_140144_.m_5511_(chunkpos, chunkStatusIn);
                return completablefuture1;
            }
            catch (Exception exception) {
                exception.getStackTrace();
                CrashReport crashreport = CrashReport.m_127521_(exception, "Exception generating new chunk");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Chunk to be generated");
                crashreportcategory.m_128159_("Location", (Object)String.format("%d,%d", chunkpos.f_45578_, chunkpos.f_45579_));
                crashreportcategory.m_128159_("Position hash", (Object)ChunkPos.m_45589_(chunkpos.f_45578_, chunkpos.f_45579_));
                crashreportcategory.m_128159_("Generator", (Object)this.f_140136_);
                throw new ReportedException(crashreport);
            }
        }, p_300190_2_ -> {
            this.m_140375_(chunkpos);
            return CompletableFuture.completedFuture(Either.right((Object)p_300190_2_));
        }), executor);
    }

    protected void m_140375_(ChunkPos p_140375_1_) {
        this.f_140135_.m_6937_(Util.m_137474_(() -> this.f_140145_.m_140823_(TicketType.f_9446_, p_140375_1_, 33 + ChunkStatus.m_62370_((ChunkStatus)ChunkStatus.f_62323_), p_140375_1_), () -> "release light ticket " + p_140375_1_));
    }

    private ChunkStatus m_140262_(ChunkStatus p_140262_1_, int p_140262_2_) {
        ChunkStatus chunkstatus = p_140262_2_ == 0 ? p_140262_1_.m_62482_() : ChunkStatus.m_174344_((int)(ChunkStatus.m_62370_((ChunkStatus)p_140262_1_) + p_140262_2_));
        return chunkstatus;
    }

    private static void m_142567_(ServerLevel p_142567_0_, List<CompoundTag> p_142567_1_) {
        if (!p_142567_1_.isEmpty()) {
            p_142567_0_.m_143421_(EntityType.m_149892_(p_142567_1_, (Level)p_142567_0_));
        }
    }

    private CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_140383_(ChunkHolder p_140383_1_) {
        CompletableFuture completablefuture = p_140383_1_.m_140047_(ChunkStatus.f_62326_.m_62482_());
        return completablefuture.thenApplyAsync(p_300179_2_ -> {
            ChunkStatus chunkstatus = ChunkHolder.m_140074_((int)p_140383_1_.m_140093_());
            return !chunkstatus.m_62427_(ChunkStatus.f_62326_) ? ChunkHolder.f_139995_ : p_300179_2_.mapLeft(p_300176_2_ -> {
                LevelChunk levelchunk;
                ChunkPos chunkpos = p_140383_1_.m_140092_();
                ProtoChunk protochunk = (ProtoChunk)p_300176_2_;
                if (protochunk instanceof ImposterProtoChunk) {
                    levelchunk = ((ImposterProtoChunk)protochunk).m_62768_();
                } else {
                    levelchunk = new LevelChunk(this.f_140133_, protochunk, p_300220_2_ -> ChunkMap.m_142567_(this.f_140133_, protochunk.m_63293_()));
                    p_140383_1_.m_140052_(new ImposterProtoChunk(levelchunk));
                }
                levelchunk.m_62879_(() -> ChunkHolder.m_140083_((int)p_140383_1_.m_140093_()));
                levelchunk.m_62952_();
                if (this.f_140132_.add(chunkpos.m_45588_())) {
                    levelchunk.m_62913_(true);
                    try {
                        Reflector.setFieldValue(p_140383_1_, Reflector.ForgeChunkHolder_currentlyLoading, levelchunk);
                        levelchunk.m_174654_();
                        Reflector.postForgeBusEvent(Reflector.ChunkEvent_Load_Constructor, levelchunk);
                    }
                    finally {
                        Reflector.setFieldValue(p_140383_1_, Reflector.ForgeChunkHolder_currentlyLoading, null);
                    }
                }
                return levelchunk;
            });
        }, p_300265_2_ -> this.f_140143_.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140624_((Runnable)p_300265_2_, (long)p_140383_1_.m_140092_().m_45588_(), () -> ((ChunkHolder)p_140383_1_).m_140093_())));
    }

    public CompletableFuture<Either<LevelChunk, ChunkHolder.ChunkLoadingFailure>> m_142541_(ChunkHolder p_142541_1_) {
        ChunkPos chunkpos = p_142541_1_.m_140092_();
        CompletableFuture<Either<List<ChunkAccess>, ChunkHolder.ChunkLoadingFailure>> completablefuture = this.m_140210_(chunkpos, 1, p_300231_0_ -> ChunkStatus.f_62326_);
        CompletionStage completablefuture1 = completablefuture.thenApplyAsync(p_300249_0_ -> p_300249_0_.flatMap(p_300251_0_ -> {
            LevelChunk levelchunk = (LevelChunk)p_300251_0_.get(p_300251_0_.size() / 2);
            levelchunk.m_62812_();
            return Either.left((Object)levelchunk);
        }), p_300256_2_ -> this.f_140143_.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140642_((ChunkHolder)p_142541_1_, (Runnable)p_300256_2_)));
        ((CompletableFuture)completablefuture1).thenAcceptAsync(p_300211_2_ -> p_300211_2_.ifLeft(p_300208_2_ -> {
            this.f_140146_.getAndIncrement();
            Packet[] packet = new Packet[2];
            this.m_5960_(chunkpos, false).forEach(p_300227_3_ -> this.m_140195_((ServerPlayer)p_300227_3_, (Packet<?>[])packet, (LevelChunk)p_300208_2_));
        }), p_300236_2_ -> this.f_140143_.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140642_((ChunkHolder)p_142541_1_, (Runnable)p_300236_2_)));
        return completablefuture1;
    }

    public CompletableFuture<Either<LevelChunk, ChunkHolder.ChunkLoadingFailure>> m_142663_(ChunkHolder p_142663_1_) {
        return this.m_140210_(p_142663_1_.m_140092_(), 1, ChunkStatus::m_174344_).thenApplyAsync(p_300223_0_ -> p_300223_0_.mapLeft(p_300225_0_ -> {
            LevelChunk levelchunk = (LevelChunk)p_300225_0_.get(p_300225_0_.size() / 2);
            levelchunk.m_62813_();
            return levelchunk;
        }), p_300182_2_ -> this.f_140143_.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140642_((ChunkHolder)p_142663_1_, (Runnable)p_300182_2_)));
    }

    public int m_140368_() {
        return this.f_140146_.get();
    }

    private boolean m_140258_(ChunkAccess chunkIn) {
        this.f_140138_.m_63796_(chunkIn.m_7697_());
        if (!chunkIn.m_6344_()) {
            return false;
        }
        chunkIn.m_8092_(false);
        ChunkPos chunkpos = chunkIn.m_7697_();
        try {
            ChunkStatus chunkstatus = chunkIn.m_6415_();
            if (chunkstatus.m_62494_() != ChunkStatus.ChunkType.LEVELCHUNK) {
                if (this.m_140425_(chunkpos)) {
                    return false;
                }
                if (chunkstatus == ChunkStatus.f_62314_ && chunkIn.m_6633_().values().stream().noneMatch(StructureStart::m_73603_)) {
                    return false;
                }
            }
            this.f_140133_.m_46473_().m_6174_("chunkSave");
            CompoundTag compoundtag = ChunkSerializer.m_63454_((ServerLevel)this.f_140133_, (ChunkAccess)chunkIn);
            if (Reflector.ChunkDataEvent_Save_Constructor.exists()) {
                Level worldForge = (Level)Reflector.call(chunkIn, Reflector.ForgeIChunk_getWorldForge, new Object[0]);
                Reflector.postForgeBusEvent(Reflector.ChunkDataEvent_Save_Constructor, chunkIn, worldForge != null ? worldForge : this.f_140133_, compoundtag);
            }
            this.m_63502_(chunkpos, compoundtag);
            this.m_140229_(chunkpos, chunkstatus.m_62494_());
            return true;
        }
        catch (Exception exception) {
            f_140128_.error("Failed to save chunk {},{}", (Object)chunkpos.f_45578_, (Object)chunkpos.f_45579_, (Object)exception);
            return false;
        }
    }

    private boolean m_140425_(ChunkPos p_140425_1_) {
        CompoundTag compoundtag;
        byte b0 = this.f_140151_.get(p_140425_1_.m_45588_());
        if (b0 != 0) {
            return b0 == 1;
        }
        try {
            compoundtag = this.m_140427_(p_140425_1_);
            if (compoundtag == null) {
                this.m_140422_(p_140425_1_);
                return false;
            }
        }
        catch (Exception exception) {
            f_140128_.error("Failed to read chunk {}", (Object)p_140425_1_, (Object)exception);
            this.m_140422_(p_140425_1_);
            return false;
        }
        ChunkStatus.ChunkType chunkstatus$chunktype = ChunkSerializer.m_63485_((CompoundTag)compoundtag);
        return this.m_140229_(p_140425_1_, chunkstatus$chunktype) == 1;
    }

    protected void m_140167_(int viewDistance) {
        int i = Mth.m_14045_(viewDistance + 1, 3, 64);
        if (i != this.f_140126_) {
            int j = this.f_140126_;
            this.f_140126_ = i;
            this.f_140145_.m_140777_(this.f_140126_);
            for (ChunkHolder chunkholder : this.f_140129_.values()) {
                ChunkPos chunkpos = chunkholder.m_140092_();
                Packet[] packet = new Packet[2];
                this.m_5960_(chunkpos, false).forEach(p_300185_4_ -> {
                    int k = ChunkMap.m_140338_(chunkpos, p_300185_4_, true);
                    boolean flag = k <= j;
                    boolean flag1 = k <= this.f_140126_;
                    this.m_140186_((ServerPlayer)p_300185_4_, chunkpos, (Packet<?>[])packet, flag, flag1);
                });
            }
        }
    }

    protected void m_140186_(ServerPlayer player, ChunkPos chunkPosIn, Packet<?>[] packetCache, boolean wasLoaded, boolean load) {
        if (player.f_19853_ == this.f_140133_) {
            ChunkHolder chunkholder;
            if (Reflector.ForgeEventFactory_fireChunkWatch.exists()) {
                Reflector.ForgeEventFactory_fireChunkWatch.call(wasLoaded, load, player, chunkPosIn, this.f_140133_);
            }
            if (load && !wasLoaded && (chunkholder = this.m_140327_(chunkPosIn.m_45588_())) != null) {
                LevelChunk levelchunk = chunkholder.m_140085_();
                if (levelchunk != null) {
                    this.m_140195_(player, packetCache, levelchunk);
                }
                DebugPackets.m_133676_((ServerLevel)this.f_140133_, (ChunkPos)chunkPosIn);
            }
            if (!load && wasLoaded) {
                player.m_9088_(chunkPosIn);
            }
        }
    }

    public int m_140394_() {
        return this.f_140130_.size();
    }

    protected net.minecraft.server.level.DistanceManager m_142715_() {
        return this.f_140145_;
    }

    protected Iterable<ChunkHolder> m_140416_() {
        return Iterables.unmodifiableIterable((Iterable)this.f_140130_.values());
    }

    void m_140274_(Writer p_140274_1_) throws IOException {
        CsvOutput csvoutput = CsvOutput.m_13619_().m_13630_("x").m_13630_("z").m_13630_("level").m_13630_("in_memory").m_13630_("status").m_13630_("full_status").m_13630_("accessible_ready").m_13630_("ticking_ready").m_13630_("entity_ticking_ready").m_13630_("ticket").m_13630_("spawning").m_13630_("block_entity_count").m_13628_(p_140274_1_);
        for (Long2ObjectMap.Entry entry : this.f_140130_.long2ObjectEntrySet()) {
            ChunkPos chunkpos = new ChunkPos(entry.getLongKey());
            ChunkHolder chunkholder = (ChunkHolder)entry.getValue();
            Optional<ChunkAccess> optional = Optional.ofNullable(chunkholder.m_140089_());
            Optional<Object> optional1 = optional.flatMap(p_300242_0_ -> p_300242_0_ instanceof LevelChunk ? Optional.of((LevelChunk)p_300242_0_) : Optional.empty());
            csvoutput.m_13624_(new Object[]{chunkpos.f_45578_, chunkpos.f_45579_, chunkholder.m_140093_(), optional.isPresent(), optional.map(ChunkAccess::m_6415_).orElse(null), optional1.map(LevelChunk::m_6708_).orElse(null), ChunkMap.m_140278_(chunkholder.m_140082_()), ChunkMap.m_140278_(chunkholder.m_140026_()), ChunkMap.m_140278_(chunkholder.m_140073_()), this.f_140145_.m_140838_(entry.getLongKey()), !this.m_140397_(chunkpos), optional1.map(p_300268_0_ -> p_300268_0_.m_62954_().size()).orElse(0)});
        }
    }

    private static String m_140278_(CompletableFuture<Either<LevelChunk, ChunkHolder.ChunkLoadingFailure>> p_140278_0_) {
        try {
            Either<LevelChunk, ChunkHolder.ChunkLoadingFailure> either = p_140278_0_.getNow((Either<LevelChunk, ChunkHolder.ChunkLoadingFailure>)((Either)null));
            return either != null ? (String)either.map(p_300259_0_ -> "done", p_300174_0_ -> "unloaded") : "not completed";
        }
        catch (CompletionException completionexception) {
            return "failed " + completionexception.getCause().getMessage();
        }
        catch (CancellationException cancellationexception) {
            return "cancelled";
        }
    }

    @Nullable
    private CompoundTag m_140427_(ChunkPos pos) throws IOException {
        CompoundTag compoundtag = this.m_63512_(pos);
        return compoundtag == null ? null : this.m_63507_(this.f_140133_.m_46472_(), this.f_140137_, compoundtag);
    }

    boolean m_140397_(ChunkPos chunkPosIn) {
        long i = chunkPosIn.m_45588_();
        return !this.f_140145_.m_140847_(i) ? true : this.f_140149_.m_8243_(i).noneMatch(p_300205_1_ -> !p_300205_1_.m_5833_() && ChunkMap.m_140226_(chunkPosIn, (Entity)p_300205_1_) < 16384.0);
    }

    private boolean m_140329_(ServerPlayer player) {
        return player.m_5833_() && !this.f_140133_.m_46469_().m_46207_(GameRules.f_46146_);
    }

    void m_140192_(ServerPlayer player, boolean track) {
        boolean flag = this.m_140329_(player);
        boolean flag1 = this.f_140149_.m_8260_(player);
        int i = SectionPos.m_123171_((int)player.m_149633_());
        int j = SectionPos.m_123171_((int)player.m_149635_());
        if (track) {
            this.f_140149_.m_8252_(ChunkPos.m_45589_(i, j), player, flag);
            this.m_140373_(player);
            if (!flag) {
                this.f_140145_.m_140802_(SectionPos.m_123194_((Entity)player), player);
            }
        } else {
            SectionPos sectionpos = player.m_8965_();
            this.f_140149_.m_8249_(sectionpos.m_123251_().m_45588_(), player);
            if (!flag1) {
                this.f_140145_.m_140828_(sectionpos, player);
            }
        }
        for (int l = i - this.f_140126_; l <= i + this.f_140126_; ++l) {
            for (int k = j - this.f_140126_; k <= j + this.f_140126_; ++k) {
                ChunkPos chunkpos = new ChunkPos(l, k);
                this.m_140186_(player, chunkpos, new Packet[2], !track, track);
            }
        }
    }

    private SectionPos m_140373_(ServerPlayer serverPlayerEntityIn) {
        SectionPos sectionpos = SectionPos.m_123194_((Entity)serverPlayerEntityIn);
        serverPlayerEntityIn.m_9119_(sectionpos);
        serverPlayerEntityIn.f_8906_.m_141822_((Packet)new ClientboundSetChunkCacheCenterPacket(sectionpos.m_123170_(), sectionpos.m_123222_()));
        return sectionpos;
    }

    public void m_140184_(ServerPlayer player) {
        boolean flag2;
        for (TrackedEntity chunkmap$trackedentity : this.f_140150_.values()) {
            if (chunkmap$trackedentity.f_140472_ == player) {
                chunkmap$trackedentity.m_140487_(this.f_140133_.m_6907_());
                continue;
            }
            chunkmap$trackedentity.m_140497_(player);
        }
        int l1 = SectionPos.m_123171_((int)player.m_149633_());
        int i2 = SectionPos.m_123171_((int)player.m_149635_());
        SectionPos sectionpos = player.m_8965_();
        SectionPos sectionpos1 = SectionPos.m_123194_((Entity)player);
        long i = sectionpos.m_123251_().m_45588_();
        long j = sectionpos1.m_123251_().m_45588_();
        boolean flag = this.f_140149_.m_8262_(player);
        boolean flag1 = this.m_140329_(player);
        boolean bl = flag2 = sectionpos.m_123252_() != sectionpos1.m_123252_();
        if (flag2 || flag != flag1) {
            this.m_140373_(player);
            if (!flag) {
                this.f_140145_.m_140828_(sectionpos, player);
            }
            if (!flag1) {
                this.f_140145_.m_140802_(sectionpos1, player);
            }
            if (!flag && flag1) {
                this.f_140149_.m_8256_(player);
            }
            if (flag && !flag1) {
                this.f_140149_.m_8258_(player);
            }
            if (i != j) {
                this.f_140149_.m_8245_(i, j, player);
            }
        }
        int k = sectionpos.m_123170_();
        int l = sectionpos.m_123222_();
        if (Math.abs(k - l1) <= this.f_140126_ * 2 && Math.abs(l - i2) <= this.f_140126_ * 2) {
            int k2 = Math.min(l1, k) - this.f_140126_;
            int i3 = Math.min(i2, l) - this.f_140126_;
            int j3 = Math.max(l1, k) + this.f_140126_;
            int k3 = Math.max(i2, l) + this.f_140126_;
            for (int l3 = k2; l3 <= j3; ++l3) {
                for (int k1 = i3; k1 <= k3; ++k1) {
                    ChunkPos chunkpos1 = new ChunkPos(l3, k1);
                    boolean flag5 = ChunkMap.m_140206_(chunkpos1, k, l) <= this.f_140126_;
                    boolean flag6 = ChunkMap.m_140206_(chunkpos1, l1, i2) <= this.f_140126_;
                    this.m_140186_(player, chunkpos1, new Packet[2], flag5, flag6);
                }
            }
        } else {
            for (int i1 = k - this.f_140126_; i1 <= k + this.f_140126_; ++i1) {
                for (int j1 = l - this.f_140126_; j1 <= l + this.f_140126_; ++j1) {
                    ChunkPos chunkpos = new ChunkPos(i1, j1);
                    boolean flag3 = true;
                    boolean flag4 = false;
                    this.m_140186_(player, chunkpos, new Packet[2], true, false);
                }
            }
            for (int j2 = l1 - this.f_140126_; j2 <= l1 + this.f_140126_; ++j2) {
                for (int l2 = i2 - this.f_140126_; l2 <= i2 + this.f_140126_; ++l2) {
                    ChunkPos chunkpos2 = new ChunkPos(j2, l2);
                    boolean flag7 = false;
                    boolean flag8 = true;
                    this.m_140186_(player, chunkpos2, new Packet[2], false, true);
                }
            }
        }
    }

    public Stream<ServerPlayer> m_5960_(ChunkPos pos, boolean boundaryOnly) {
        return this.f_140149_.m_8243_(pos.m_45588_()).filter(p_300214_3_ -> {
            int i = ChunkMap.m_140338_(pos, p_300214_3_, true);
            if (i > this.f_140126_) {
                return false;
            }
            return !boundaryOnly || i == this.f_140126_;
        });
    }

    protected void m_140199_(Entity entityIn) {
        EntityType entitytype;
        int i;
        boolean multipart = entityIn instanceof EnderDragonPart;
        if (Reflector.PartEntity.exists()) {
            multipart = Reflector.PartEntity.isInstance(entityIn);
        }
        if (!multipart && (i = (entitytype = entityIn.m_6095_()).m_20681_() * 16) != 0) {
            int j = entitytype.m_20682_();
            if (this.f_140150_.containsKey(entityIn.m_141546_())) {
                throw Util.m_137570_(new IllegalStateException("Entity is already tracked!"));
            }
            TrackedEntity chunkmap$trackedentity = new TrackedEntity(entityIn, i, j, entitytype.m_20683_());
            this.f_140150_.put(entityIn.m_141546_(), (Object)chunkmap$trackedentity);
            chunkmap$trackedentity.m_140487_(this.f_140133_.m_6907_());
            if (entityIn instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)entityIn;
                this.m_140192_(serverplayer, true);
                for (TrackedEntity chunkmap$trackedentity1 : this.f_140150_.values()) {
                    if (chunkmap$trackedentity1.f_140472_ == serverplayer) continue;
                    chunkmap$trackedentity1.m_140497_(serverplayer);
                }
            }
        }
    }

    protected void m_140331_(Entity entityIn) {
        TrackedEntity chunkmap$trackedentity1;
        if (entityIn instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entityIn;
            this.m_140192_(serverplayer, false);
            for (TrackedEntity chunkmap$trackedentity : this.f_140150_.values()) {
                chunkmap$trackedentity.m_140485_(serverplayer);
            }
        }
        if ((chunkmap$trackedentity1 = (TrackedEntity)this.f_140150_.remove(entityIn.m_141546_())) != null) {
            chunkmap$trackedentity1.m_140482_();
        }
    }

    protected void m_140421_() {
        ArrayList list = Lists.newArrayList();
        List list1 = this.f_140133_.m_6907_();
        for (TrackedEntity chunkmap$trackedentity : this.f_140150_.values()) {
            SectionPos sectionpos = chunkmap$trackedentity.f_140474_;
            SectionPos sectionpos1 = SectionPos.m_123194_((Entity)chunkmap$trackedentity.f_140472_);
            if (!Objects.equals(sectionpos, sectionpos1)) {
                chunkmap$trackedentity.m_140487_(list1);
                Entity entity = chunkmap$trackedentity.f_140472_;
                if (entity instanceof ServerPlayer) {
                    list.add((ServerPlayer)entity);
                }
                chunkmap$trackedentity.f_140474_ = sectionpos1;
            }
            chunkmap$trackedentity.f_140471_.m_8533_();
        }
        if (!list.isEmpty()) {
            for (TrackedEntity chunkmap$trackedentity1 : this.f_140150_.values()) {
                chunkmap$trackedentity1.m_140487_(list);
            }
        }
    }

    public void m_140201_(Entity entityIn, Packet<?> p_140201_2_) {
        TrackedEntity chunkmap$trackedentity = (TrackedEntity)this.f_140150_.get(entityIn.m_141546_());
        if (chunkmap$trackedentity != null) {
            chunkmap$trackedentity.m_140489_(p_140201_2_);
        }
    }

    protected void m_140333_(Entity entityIn, Packet<?> p_140333_2_) {
        TrackedEntity chunkmap$trackedentity = (TrackedEntity)this.f_140150_.get(entityIn.m_141546_());
        if (chunkmap$trackedentity != null) {
            chunkmap$trackedentity.m_140499_(p_140333_2_);
        }
    }

    private void m_140195_(ServerPlayer player, Packet<?>[] packetCache, LevelChunk chunkIn) {
        if (packetCache[0] == null) {
            packetCache[0] = new ClientboundLevelChunkPacket(chunkIn);
            packetCache[1] = new ClientboundLightUpdatePacket(chunkIn.m_7697_(), (LevelLightEngine)this.f_140134_, (BitSet)null, (BitSet)null, true);
        }
        player.m_9090_(chunkIn.m_7697_(), packetCache[0], packetCache[1]);
        DebugPackets.m_133676_((ServerLevel)this.f_140133_, (ChunkPos)chunkIn.m_7697_());
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        for (TrackedEntity chunkmap$trackedentity : this.f_140150_.values()) {
            Entity entity = chunkmap$trackedentity.f_140472_;
            if (entity == player || !entity.m_149632_().equals(chunkIn.m_7697_())) continue;
            chunkmap$trackedentity.m_140497_(player);
            if (entity instanceof Mob && ((Mob)entity).m_21524_() != null) {
                list.add(entity);
            }
            if (entity.m_20197_().isEmpty()) continue;
            list1.add(entity);
        }
        if (!list.isEmpty()) {
            for (Entity entity1 : list) {
                player.f_8906_.m_141822_((Packet)new ClientboundSetEntityLinkPacket(entity1, ((Mob)entity1).m_21524_()));
            }
        }
        if (!list1.isEmpty()) {
            for (Entity entity2 : list1) {
                player.f_8906_.m_141822_((Packet)new ClientboundSetPassengersPacket(entity2));
            }
        }
    }

    protected PoiManager m_140424_() {
        return this.f_140138_;
    }

    public String m_320769_() {
        return this.f_320768_;
    }

    public CompletableFuture<Void> m_140270_(LevelChunk chunkIn) {
        return this.f_140135_.m_18707_(() -> chunkIn.m_62823_(this.f_140133_));
    }

    void m_142599_(ChunkPos p_142599_1_, ChunkHolder.FullChunkStatus p_142599_2_) {
        this.f_142513_.m_175510_(p_142599_1_, p_142599_2_);
    }

    class TrackedEntity {
        final ServerEntity f_140471_;
        final Entity f_140472_;
        private final int f_140473_;
        SectionPos f_140474_;
        private final Set<ServerPlayerConnection> f_140475_ = Sets.newIdentityHashSet();

        public TrackedEntity(Entity entityIn, int p_i140476_3_, int updateFrequency, boolean sendVelocityUpdatesIn) {
            this.f_140471_ = new ServerEntity(ChunkMap.this.f_140133_, entityIn, updateFrequency, sendVelocityUpdatesIn, this::m_140489_);
            this.f_140472_ = entityIn;
            this.f_140473_ = p_i140476_3_;
            this.f_140474_ = SectionPos.m_123194_((Entity)entityIn);
        }

        public boolean equals(Object p_equals_1_) {
            if (p_equals_1_ instanceof TrackedEntity) {
                return ((TrackedEntity)p_equals_1_).f_140472_.m_141546_() == this.f_140472_.m_141546_();
            }
            return false;
        }

        public int hashCode() {
            return this.f_140472_.m_141546_();
        }

        public void m_140489_(Packet<?> p_140489_1_) {
            for (ServerPlayerConnection serverplayerconnection : this.f_140475_) {
                serverplayerconnection.m_141822_(p_140489_1_);
            }
        }

        public void m_140499_(Packet<?> p_140499_1_) {
            this.m_140489_(p_140499_1_);
            if (this.f_140472_ instanceof ServerPlayer) {
                ((ServerPlayer)this.f_140472_).f_8906_.m_141822_(p_140499_1_);
            }
        }

        public void m_140482_() {
            for (ServerPlayerConnection serverplayerconnection : this.f_140475_) {
                this.f_140471_.m_8534_(serverplayerconnection.m_141664_());
            }
        }

        public void m_140485_(ServerPlayer player) {
            if (this.f_140475_.remove(player.f_8906_)) {
                this.f_140471_.m_8534_(player);
            }
        }

        public void m_140497_(ServerPlayer player) {
            if (player != this.f_140472_) {
                boolean flag;
                Vec3 vec3 = player.m_20182_().m_82546_(this.f_140471_.m_8540_());
                int i = Math.min(this.m_140496_(), (ChunkMap.this.f_140126_ - 1) * 16);
                boolean bl = flag = vec3.f_82479_ >= (double)(-i) && vec3.f_82479_ <= (double)i && vec3.f_82481_ >= (double)(-i) && vec3.f_82481_ <= (double)i && this.f_140472_.m_6459_(player);
                if (flag) {
                    if (this.f_140475_.add((ServerPlayerConnection)player.f_8906_)) {
                        this.f_140471_.m_8541_(player);
                    }
                } else if (this.f_140475_.remove(player.f_8906_)) {
                    this.f_140471_.m_8534_(player);
                }
            }
        }

        private int m_140483_(int p_140483_1_) {
            return ChunkMap.this.f_140133_.m_299823_().m_7186_(p_140483_1_);
        }

        private int m_140496_() {
            int i = this.f_140473_;
            for (Entity entity : this.f_140472_.m_149628_()) {
                int j = entity.m_6095_().m_20681_() * 16;
                if (j <= i) continue;
                i = j;
            }
            return this.m_140483_(i);
        }

        public void m_140487_(List<ServerPlayer> playersListIn) {
            for (ServerPlayer serverplayer : playersListIn) {
                this.m_140497_(serverplayer);
            }
        }
    }

    class DistanceManager
    extends net.minecraft.server.level.DistanceManager {
        protected DistanceManager(Executor p_i140457_2_, Executor p_i140457_3_) {
            super(p_i140457_2_, p_i140457_3_);
        }

        @Override
        protected boolean m_7009_(long p_7009_1_) {
            return ChunkMap.this.f_140139_.contains(p_7009_1_);
        }

        @Override
        @Nullable
        protected ChunkHolder m_7316_(long chunkPosIn) {
            return ChunkMap.this.m_140174_(chunkPosIn);
        }

        @Override
        @Nullable
        protected ChunkHolder m_7288_(long chunkPosIn, int newLevel, @Nullable ChunkHolder holder, int oldLevel) {
            return ChunkMap.this.m_140176_(chunkPosIn, newLevel, holder, oldLevel);
        }
    }
}

