/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.OutputStream;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.class_1257;
import net.minecraft.class_128;
import net.minecraft.class_140;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1940;
import net.minecraft.class_2170;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2966;
import net.minecraft.class_2981;
import net.minecraft.class_31;
import net.minecraft.class_3176;
import net.minecraft.class_32;
import net.minecraft.class_3264;
import net.minecraft.class_3279;
import net.minecraft.class_3283;
import net.minecraft.class_3286;
import net.minecraft.class_3312;
import net.minecraft.class_34;
import net.minecraft.class_3532;
import net.minecraft.class_3551;
import net.minecraft.class_3806;
import net.minecraft.class_3807;
import net.minecraft.class_3951;
import net.minecraft.class_5218;
import net.minecraft.class_5219;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5350;
import net.minecraft.class_5352;
import net.minecraft.class_5359;
import net.minecraft.class_5382;
import net.minecraft.class_5455;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Main {
    private static final Logger field_24625 = LogManager.getLogger();

    @DontObfuscate
    public static void main(String[] stringArray) {
        class_155.method_36208();
        OptionParser optionParser = new OptionParser();
        OptionSpecBuilder \u00e2\u02dc\u01922 = optionParser.accepts("nogui");
        OptionSpecBuilder \u00e2\u02dc\u01923 = optionParser.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder \u00e2\u02dc\u01924 = optionParser.accepts("demo");
        OptionSpecBuilder \u00e2\u02dc\u01925 = optionParser.accepts("bonusChest");
        OptionSpecBuilder \u00e2\u02dc\u01926 = optionParser.accepts("forceUpgrade");
        OptionSpecBuilder \u00e2\u02dc\u01927 = optionParser.accepts("eraseCache");
        OptionSpecBuilder \u00e2\u02dc\u01928 = optionParser.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec \u00e2\u02dc\u01929 = optionParser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec \u00e2\u02dc\u019210 = optionParser.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec \u00e2\u02dc\u019211 = optionParser.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec \u00e2\u02dc\u019212 = optionParser.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec \u00e2\u02dc\u019213 = optionParser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec \u00e2\u02dc\u019214 = optionParser.accepts("serverId").withRequiredArg();
        NonOptionArgumentSpec \u00e2\u02dc\u019215 = optionParser.nonOptions();
        try {
            Object object;
            OptionSet optionSet = optionParser.parse(stringArray);
            if (optionSet.has((OptionSpec)\u00e2\u02dc\u01929)) {
                optionParser.printHelpOn((OutputStream)System.err);
                return;
            }
            class_128.method_24305();
            class_2966.method_12851();
            class_2966.method_17598();
            class_156.method_29476();
            class_5455.class_5457 \u00e2\u02dc\u019216 = class_5455.method_30528();
            Path \u00e2\u02dc\u019217 = Paths.get("server.properties", new String[0]);
            class_3807 \u00e2\u02dc\u019218 = new class_3807(\u00e2\u02dc\u019217);
            \u00e2\u02dc\u019218.method_16719();
            Path \u00e2\u02dc\u019219 = Paths.get("eula.txt", new String[0]);
            class_2981 \u00e2\u02dc\u019220 = new class_2981(\u00e2\u02dc\u019219);
            if (optionSet.has((OptionSpec)\u00e2\u02dc\u01923)) {
                field_24625.info("Initialized '{}' and '{}'", (Object)\u00e2\u02dc\u019217.toAbsolutePath(), (Object)\u00e2\u02dc\u019219.toAbsolutePath());
                return;
            }
            if (!\u00e2\u02dc\u019220.method_12866()) {
                field_24625.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File \u00e2\u02dc\u019221 = new File((String)optionSet.valueOf((OptionSpec)\u00e2\u02dc\u019211));
            YggdrasilAuthenticationService \u00e2\u02dc\u019222 = new YggdrasilAuthenticationService(Proxy.NO_PROXY);
            MinecraftSessionService \u00e2\u02dc\u019223 = \u00e2\u02dc\u019222.createMinecraftSessionService();
            GameProfileRepository \u00e2\u02dc\u019224 = \u00e2\u02dc\u019222.createProfileRepository();
            class_3312 \u00e2\u02dc\u019225 = new class_3312(\u00e2\u02dc\u019224, new File(\u00e2\u02dc\u019221, MinecraftServer.field_4588.getName()));
            String \u00e2\u02dc\u019226 = Optional.ofNullable((String)optionSet.valueOf((OptionSpec)\u00e2\u02dc\u019212)).orElse(\u00e2\u02dc\u019218.method_16717().field_16820);
            class_32 \u00e2\u02dc\u019227 = class_32.method_26999(\u00e2\u02dc\u019221.toPath());
            class_32.class_5143 \u00e2\u02dc\u019228 = \u00e2\u02dc\u019227.method_27002(\u00e2\u02dc\u019226);
            MinecraftServer.method_27725(\u00e2\u02dc\u019228);
            class_34 \u00e2\u02dc\u019229 = \u00e2\u02dc\u019228.method_29584();
            if (\u00e2\u02dc\u019229 != null && \u00e2\u02dc\u019229.method_33783()) {
                field_24625.info("Loading of worlds with extended height is disabled.");
                return;
            }
            class_5359 \u00e2\u02dc\u019230 = \u00e2\u02dc\u019228.method_29585();
            boolean \u00e2\u02dc\u019231 = optionSet.has((OptionSpec)\u00e2\u02dc\u01928);
            if (\u00e2\u02dc\u019231) {
                field_24625.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            class_3283 \u00e2\u02dc\u019232 = new class_3283(class_3264.field_14190, new class_3286(), new class_3279(\u00e2\u02dc\u019228.method_27010(class_5218.field_24186).toFile(), class_5352.field_25349));
            class_5359 \u00e2\u02dc\u019233 = MinecraftServer.method_29736(\u00e2\u02dc\u019232, \u00e2\u02dc\u019230 == null ? class_5359.field_25393 : \u00e2\u02dc\u019230, \u00e2\u02dc\u019231);
            CompletableFuture<class_5350> \u00e2\u02dc\u019234 = class_5350.method_29466(\u00e2\u02dc\u019232.method_29211(), \u00e2\u02dc\u019216, class_2170.class_5364.field_25420, \u00e2\u02dc\u019218.method_16717().field_20324, class_156.method_18349(), Runnable::run);
            try {
                class_5350 class_53502 = \u00e2\u02dc\u019234.get();
            }
            catch (Exception exception) {
                field_24625.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)exception);
                \u00e2\u02dc\u019232.close();
                return;
            }
            class_53502.method_29475();
            class_5382<class_2520> class_53822 = class_5382.method_36574(class_2509.field_11560, class_53502.method_29474(), \u00e2\u02dc\u019216);
            \u00e2\u02dc\u019218.method_16717().method_37371(\u00e2\u02dc\u019216);
            class_5219 \u00e2\u02dc\u019235 = \u00e2\u02dc\u019228.method_27013(class_53822, \u00e2\u02dc\u019233);
            if (\u00e2\u02dc\u019235 == null) {
                if (optionSet.has((OptionSpec)\u00e2\u02dc\u01924)) {
                    object = MinecraftServer.field_17704;
                    \u00e2\u02dc\u0192 = class_5285.method_31112(\u00e2\u02dc\u019216);
                } else {
                    Object object2 = \u00e2\u02dc\u019218.method_16717();
                    object = new class_1940(((class_3806)object2).field_16820, ((class_3806)object2).field_16841, ((class_3806)object2).field_16838, ((class_3806)object2).field_16840, false, new class_1928(), \u00e2\u02dc\u019233);
                    \u00e2\u02dc\u0192 = optionSet.has((OptionSpec)\u00e2\u02dc\u01925) ? ((class_3806)object2).method_37371(\u00e2\u02dc\u019216).method_28036() : ((class_3806)object2).method_37371(\u00e2\u02dc\u019216);
                }
                \u00e2\u02dc\u019235 = new class_31((class_1940)object, (class_5285)\u00e2\u02dc\u0192, Lifecycle.stable());
            }
            if (optionSet.has((OptionSpec)\u00e2\u02dc\u01926)) {
                Main.method_29173(\u00e2\u02dc\u019228, class_3551.method_15450(), optionSet.has((OptionSpec)\u00e2\u02dc\u01927), () -> true, \u00e2\u02dc\u019235.method_28057().method_29575());
            }
            \u00e2\u02dc\u019228.method_27425(\u00e2\u02dc\u019216, \u00e2\u02dc\u019235);
            object = \u00e2\u02dc\u019235;
            \u00e2\u02dc\u0192 = MinecraftServer.method_29740(arg_0 -> Main.method_29734(\u00e2\u02dc\u019216, \u00e2\u02dc\u019228, \u00e2\u02dc\u019232, class_53502, (class_5219)object, \u00e2\u02dc\u019218, \u00e2\u02dc\u019223, \u00e2\u02dc\u019224, \u00e2\u02dc\u019225, optionSet, (OptionSpec)\u00e2\u02dc\u019210, (OptionSpec)\u00e2\u02dc\u019213, (OptionSpec)\u00e2\u02dc\u01924, (OptionSpec)\u00e2\u02dc\u019214, (OptionSpec)\u00e2\u02dc\u01922, (OptionSpec)\u00e2\u02dc\u019215, arg_0));
            object2 = new Thread("Server Shutdown Thread", (class_3176)\u00e2\u02dc\u0192){
                final /* synthetic */ class_3176 field_4611;
                {
                    this.field_4611 = class_31762;
                    super(string);
                }

                @Override
                public void run() {
                    this.field_4611.method_3747(true);
                }
            };
            ((Thread)object2).setUncaughtExceptionHandler(new class_140(field_24625));
            Runtime.getRuntime().addShutdownHook((Thread)object2);
        }
        catch (Exception exception) {
            field_24625.fatal("Failed to start the minecraft server", (Throwable)exception);
        }
    }

    private static void method_29173(class_32.class_5143 class_51432, DataFixer dataFixer, boolean bl, BooleanSupplier booleanSupplier2, ImmutableSet<class_5321<class_1937>> immutableSet) {
        field_24625.info("Forcing world upgrade!");
        class_1257 class_12572 = new class_1257(class_51432, dataFixer, immutableSet, bl);
        class_2561 \u00e2\u02dc\u01922 = null;
        while (!class_12572.method_5403()) {
            BooleanSupplier booleanSupplier2;
            class_2561 class_25612 = class_12572.method_5394();
            if (\u00e2\u02dc\u01922 != class_25612) {
                \u00e2\u02dc\u01922 = class_25612;
                field_24625.info(class_12572.method_5394().getString());
            }
            if ((\u00e2\u02dc\u0192 = class_12572.method_5397()) > 0) {
                int n = class_12572.method_5400() + class_12572.method_5399();
                field_24625.info("{}% completed ({} / {} chunks)...", (Object)class_3532.method_15375((float)n / (float)\u00e2\u02dc\u0192 * 100.0f), (Object)n, (Object)\u00e2\u02dc\u0192);
            }
            if (!booleanSupplier2.getAsBoolean()) {
                class_12572.method_5402();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ class_3176 method_29734(class_5455.class_5457 class_54572, class_32.class_5143 class_51432, class_3283 class_32832, class_5350 class_53502, class_5219 class_52192, class_3807 class_38072, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, class_3312 class_33122, OptionSet optionSet, OptionSpec optionSpec, OptionSpec optionSpec2, OptionSpec optionSpec3, OptionSpec optionSpec4, OptionSpec optionSpec5, OptionSpec optionSpec6, Thread thread) {
        class_3176 class_31762 = new class_3176(thread, class_54572, class_51432, class_32832, class_53502, class_52192, class_38072, class_3551.method_15450(), minecraftSessionService, gameProfileRepository, class_33122, class_3951::new);
        class_31762.method_3849((String)optionSet.valueOf(optionSpec));
        class_31762.method_3779((Integer)optionSet.valueOf(optionSpec2));
        class_31762.method_3730(optionSet.has(optionSpec3));
        class_31762.method_17819((String)optionSet.valueOf(optionSpec4));
        boolean bl = \u00e2\u02dc\u0192 = !optionSet.has(optionSpec5) && !optionSet.valuesOf(optionSpec6).contains("nogui");
        if (\u00e2\u02dc\u0192 && !GraphicsEnvironment.isHeadless()) {
            class_31762.method_13948();
        }
        return class_31762;
    }
}

