/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.StringUtils;

public class ResourceLocation
implements Comparable<ResourceLocation> {
    public static final Codec<ResourceLocation> f_135803_ = Codec.STRING.comapFlatMap(ResourceLocation::m_135837_, ResourceLocation::toString).stable();
    private static final SimpleCommandExceptionType f_135806_ = new SimpleCommandExceptionType((Message)new TranslatableComponent("argument.id.invalid"));
    public static final char f_319403_ = ':';
    public static final String f_319404_ = "minecraft";
    public static final String f_319405_ = "realms";
    protected final String f_135804_;
    protected final String f_135805_;

    protected ResourceLocation(String[] resourceParts) {
        this.f_135804_ = StringUtils.isEmpty((CharSequence)resourceParts[0]) ? f_319404_ : resourceParts[0];
        this.f_135805_ = resourceParts[1];
        if (!this.f_135805_.equals("DUMMY")) {
            return;
        }
        if (!ResourceLocation.m_135843_(this.f_135804_)) {
            throw new ResourceLocationException("Non [a-z0-9_.-] character in namespace of location: " + this.f_135804_ + ":" + this.f_135805_);
        }
        if (!ResourceLocation.m_135841_(this.f_135805_)) {
            throw new ResourceLocationException("Non [a-z0-9/._-] character in path of location: " + this.f_135804_ + ":" + this.f_135805_);
        }
    }

    public ResourceLocation(String resourceName) {
        this(ResourceLocation.m_135832_(resourceName, ':'));
    }

    public ResourceLocation(String namespaceIn, String pathIn) {
        this(new String[]{namespaceIn, pathIn});
    }

    public static ResourceLocation m_135822_(String resourceName, char splitOn) {
        return new ResourceLocation(ResourceLocation.m_135832_(resourceName, splitOn));
    }

    @Nullable
    public static ResourceLocation m_135820_(String string) {
        try {
            return new ResourceLocation(string);
        }
        catch (ResourceLocationException resourcelocationexception) {
            return null;
        }
    }

    protected static String[] m_135832_(String resourceName, char splitOn) {
        String[] astring = new String[]{f_319404_, resourceName};
        int i = resourceName.indexOf(splitOn);
        if (i >= 0) {
            astring[1] = resourceName.substring(i + 1, resourceName.length());
            if (i >= 1) {
                astring[0] = resourceName.substring(0, i);
            }
        }
        return astring;
    }

    private static DataResult<ResourceLocation> m_135837_(String stringIn) {
        try {
            return DataResult.success((Object)new ResourceLocation(stringIn));
        }
        catch (ResourceLocationException resourcelocationexception) {
            return DataResult.error((String)("Not a valid resource location: " + stringIn + " " + resourcelocationexception.getMessage()));
        }
    }

    public String m_135815_() {
        return this.f_135805_;
    }

    public String m_135827_() {
        return this.f_135804_;
    }

    public String toString() {
        return this.f_135804_ + ":" + this.f_135805_;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof ResourceLocation)) {
            return false;
        }
        ResourceLocation resourcelocation = (ResourceLocation)p_equals_1_;
        return this.f_135804_.equals(resourcelocation.f_135804_) && this.f_135805_.equals(resourcelocation.f_135805_);
    }

    public int hashCode() {
        return 31 * this.f_135804_.hashCode() + this.f_135805_.hashCode();
    }

    @Override
    public int compareTo(ResourceLocation p_compareTo_1_) {
        int i = this.f_135805_.compareTo(p_compareTo_1_.f_135805_);
        if (i == 0) {
            i = this.f_135804_.compareTo(p_compareTo_1_.f_135804_);
        }
        return i;
    }

    public String m_319406_() {
        return this.toString().replace('/', '_').replace(':', '_');
    }

    public static ResourceLocation m_135818_(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        while (reader.canRead() && ResourceLocation.m_135816_(reader.peek())) {
            reader.skip();
        }
        String s = reader.getString().substring(i, reader.getCursor());
        try {
            return new ResourceLocation(s);
        }
        catch (ResourceLocationException resourcelocationexception) {
            reader.setCursor(i);
            throw f_135806_.createWithContext((ImmutableStringReader)reader);
        }
    }

    public static boolean m_135816_(char charIn) {
        return charIn >= '0' && charIn <= '9' || charIn >= 'a' && charIn <= 'z' || charIn == '_' || charIn == ':' || charIn == '/' || charIn == '.' || charIn == '-';
    }

    private static boolean m_135841_(String pathIn) {
        for (int i = 0; i < pathIn.length(); ++i) {
            if (ResourceLocation.m_135828_(pathIn.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean m_135843_(String namespaceIn) {
        for (int i = 0; i < namespaceIn.length(); ++i) {
            if (ResourceLocation.m_135835_(namespaceIn.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean m_135828_(char charIn) {
        return charIn == '_' || charIn == '-' || charIn >= 'a' && charIn <= 'z' || charIn >= '0' && charIn <= '9' || charIn == '/' || charIn == '.';
    }

    private static boolean m_135835_(char charIn) {
        return charIn == '_' || charIn == '-' || charIn >= 'a' && charIn <= 'z' || charIn >= '0' && charIn <= '9' || charIn == '.';
    }

    public static boolean m_135830_(String resourceName) {
        String[] astring = ResourceLocation.m_135832_(resourceName, ':');
        return ResourceLocation.m_135843_(StringUtils.isEmpty((CharSequence)astring[0]) ? f_319404_ : astring[0]) && ResourceLocation.m_135841_(astring[1]);
    }

    public int compareNamespaced(ResourceLocation o) {
        int ret = this.f_135804_.compareTo(o.f_135804_);
        return ret != 0 ? ret : this.f_135805_.compareTo(o.f_135805_);
    }

    public static class Serializer
    implements JsonDeserializer<ResourceLocation>,
    JsonSerializer<ResourceLocation> {
        public ResourceLocation deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            return new ResourceLocation(GsonHelper.m_13805_((JsonElement)p_deserialize_1_, (String)"location"));
        }

        public JsonElement serialize(ResourceLocation p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            return new JsonPrimitive(p_serialize_1_.toString());
        }
    }
}

