/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.metadata.animation;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.client.resources.metadata.animation.AnimationFrame;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSectionSerializer;

public class AnimationMetadataSection {
    public static final AnimationMetadataSectionSerializer f_119011_ = new AnimationMetadataSectionSerializer();
    public static final String f_316752_ = "animation";
    public static final int f_316753_ = 1;
    public static final int f_316754_ = -1;
    public static final AnimationMetadataSection f_119012_ = new AnimationMetadataSection((List)Lists.newArrayList(), -1, -1, 1, false){

        @Override
        public Pair<Integer, Integer> m_7117_(int widthIn, int heightIn) {
            return Pair.of((Object)widthIn, (Object)heightIn);
        }
    };
    private final List<AnimationFrame> f_119013_;
    private final int f_119014_;
    private final int f_119015_;
    private final int f_119016_;
    private final boolean f_119017_;

    public AnimationMetadataSection(List<AnimationFrame> animationFramesIn, int frameWidthIn, int frameHeightIn, int frameTimeIn, boolean interpolateIn) {
        this.f_119013_ = animationFramesIn;
        this.f_119014_ = frameWidthIn;
        this.f_119015_ = frameHeightIn;
        this.f_119016_ = frameTimeIn;
        this.f_119017_ = interpolateIn;
    }

    private static boolean m_119033_(int valMul, int val) {
        return valMul / val * val == valMul;
    }

    public Pair<Integer, Integer> m_7117_(int widthIn, int heightIn) {
        Pair<Integer, Integer> pair = this.m_119039_(widthIn, heightIn);
        int i = (Integer)pair.getFirst();
        int j = (Integer)pair.getSecond();
        if (AnimationMetadataSection.m_119033_(widthIn, i) && AnimationMetadataSection.m_119033_(heightIn, j)) {
            return pair;
        }
        throw new IllegalArgumentException(String.format("Image size %s,%s is not multiply of frame size %s,%s", widthIn, heightIn, i, j));
    }

    private Pair<Integer, Integer> m_119039_(int defWidthIn, int defHeightIn) {
        if (this.f_119014_ != -1) {
            return this.f_119015_ != -1 ? Pair.of((Object)this.f_119014_, (Object)this.f_119015_) : Pair.of((Object)this.f_119014_, (Object)defHeightIn);
        }
        if (this.f_119015_ != -1) {
            return Pair.of((Object)defWidthIn, (Object)this.f_119015_);
        }
        int i = Math.min(defWidthIn, defHeightIn);
        return Pair.of((Object)i, (Object)i);
    }

    public int m_119026_(int defHeightIn) {
        return this.f_119015_ == -1 ? defHeightIn : this.f_119015_;
    }

    public int m_119031_(int defWidthIn) {
        return this.f_119014_ == -1 ? defWidthIn : this.f_119014_;
    }

    public int m_119030_() {
        return this.f_119016_;
    }

    public boolean m_119036_() {
        return this.f_119017_;
    }

    public void m_212078_(FrameOutput frameOutputIn) {
        for (AnimationFrame animationframe : this.f_119013_) {
            frameOutputIn.m_212092_(animationframe.m_119010_(), animationframe.m_212068_(this.f_119016_));
        }
    }

    public List<AnimationFrame> getAnimationFrames() {
        return this.f_119013_;
    }

    public int getFrameCount() {
        return this.f_119013_.size();
    }

    @FunctionalInterface
    public static interface FrameOutput {
        public void m_212092_(int var1, int var2);
    }
}

