/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationFrame;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.LazyLoadedValue;

public final class MissingTextureAtlasSprite
extends TextureAtlasSprite {
    private static final int f_316666_ = 16;
    private static final int f_316667_ = 16;
    private static final String f_316668_ = "missingno";
    private static final ResourceLocation f_118059_ = new ResourceLocation("missingno");
    @Nullable
    private static DynamicTexture f_118060_;
    private static final LazyLoadedValue<NativeImage> f_118061_;
    private static final TextureAtlasSprite.Info f_118062_;

    public MissingTextureAtlasSprite(TextureAtlas atlasTextureIn, TextureAtlasSprite.Info spriteInfoIn, int mipmapLevelIn, int atlasWidthIn, int atlasHeightIn, int xIn, int yIn) {
        super(atlasTextureIn, spriteInfoIn, mipmapLevelIn, atlasWidthIn, atlasHeightIn, xIn, yIn, MissingTextureAtlasSprite.makeMissingImage(spriteInfoIn.m_118434_(), spriteInfoIn.m_118437_()));
    }

    private MissingTextureAtlasSprite(TextureAtlas atlasTextureIn, int mipmapLevelIn, int atlasWidthIn, int atlasHeightIn, int xIn, int yIn) {
        super(atlasTextureIn, f_118062_, mipmapLevelIn, atlasWidthIn, atlasHeightIn, xIn, yIn, (NativeImage)f_118061_.m_13971_());
    }

    public static MissingTextureAtlasSprite m_118072_(TextureAtlas atlasTextureIn, int mipmapLevelIn, int atlasWidthIn, int atlasHeightIn, int xIn, int yIn) {
        return new MissingTextureAtlasSprite(atlasTextureIn, mipmapLevelIn, atlasWidthIn, atlasHeightIn, xIn, yIn);
    }

    public static ResourceLocation m_118071_() {
        return f_118059_;
    }

    public static TextureAtlasSprite.Info m_118079_() {
        return f_118062_;
    }

    @Override
    public void close() {
        super.close();
    }

    public static DynamicTexture m_118080_() {
        if (f_118060_ == null) {
            f_118060_ = new DynamicTexture((NativeImage)f_118061_.m_13971_());
            Minecraft.m_91087_().m_91097_().m_118495_(f_118059_, f_118060_);
        }
        return f_118060_;
    }

    private static NativeImage makeMissingImage(int width, int height) {
        int widthHalf = width / 2;
        int heightHalf = height / 2;
        NativeImage image = new NativeImage(width, height, false);
        int colBlack = -16777216;
        int colPurple = -524040;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (y < heightHalf ^ x < widthHalf) {
                    image.m_84988_(x, y, colPurple);
                    continue;
                }
                image.m_84988_(x, y, colBlack);
            }
        }
        return image;
    }

    static {
        f_118061_ = new LazyLoadedValue(() -> {
            NativeImage nativeimage = new NativeImage(16, 16, false);
            int i = -16777216;
            int j = -524040;
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (k < 8 ^ l < 8) {
                        nativeimage.m_84988_(l, k, -524040);
                        continue;
                    }
                    nativeimage.m_84988_(l, k, -16777216);
                }
            }
            nativeimage.m_85123_();
            return nativeimage;
        });
        f_118062_ = new TextureAtlasSprite.Info(f_118059_, 16, 16, new AnimationMetadataSection((List<AnimationFrame>)ImmutableList.of((Object)new AnimationFrame(0, -1)), 16, 16, 1, false));
    }
}

