/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.optifine.Config;
import net.optifine.shaders.Shaders;

public abstract class MobRenderer<T extends Mob, M extends EntityModel<T>>
extends LivingEntityRenderer<T, M> {
    public static final int f_316595_ = 24;

    public MobRenderer(EntityRendererProvider.Context contextIn, M entityModelIn, float shadowSizeIn) {
        super(contextIn, entityModelIn, shadowSizeIn);
    }

    @Override
    protected boolean m_6512_(T entity) {
        return super.m_6512_(entity) && (entity.m_6052_() || entity.m_8077_() && entity == this.f_114476_.f_114359_);
    }

    @Override
    public boolean m_5523_(T livingEntityIn, Frustum camera, double camX, double camY, double camZ) {
        if (super.m_5523_(livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        Entity entity = ((Mob)((Object)livingEntityIn)).m_21524_();
        return entity != null ? camera.m_113029_(entity.m_6921_()) : false;
    }

    @Override
    public void m_7392_(T entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        Entity entity = ((Mob)((Object)entityIn)).m_21524_();
        if (entity != null) {
            this.m_115461_(entityIn, partialTicks, matrixStackIn, bufferIn, entity);
        }
    }

    private <E extends Entity> void m_115461_(T entityLivingIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, E leashHolder) {
        if (Config.isShaders() && Shaders.isShadowPass) {
            return;
        }
        matrixStackIn.m_85836_();
        Vec3 vec3 = leashHolder.m_7398_(partialTicks);
        double d0 = (double)(Mth.m_14179_(partialTicks, ((Mob)((Object)entityLivingIn)).f_20883_, ((Mob)((Object)entityLivingIn)).f_20884_) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 vec31 = entityLivingIn.m_7939_();
        double d1 = Math.cos(d0) * vec31.f_82481_ + Math.sin(d0) * vec31.f_82479_;
        double d2 = Math.sin(d0) * vec31.f_82481_ - Math.cos(d0) * vec31.f_82479_;
        double d3 = Mth.m_14139_(partialTicks, ((Mob)((Object)entityLivingIn)).f_19854_, entityLivingIn.m_20185_()) + d1;
        double d4 = Mth.m_14139_(partialTicks, ((Mob)((Object)entityLivingIn)).f_19855_, entityLivingIn.m_20186_()) + vec31.f_82480_;
        double d5 = Mth.m_14139_(partialTicks, ((Mob)((Object)entityLivingIn)).f_19856_, entityLivingIn.m_20189_()) + d2;
        matrixStackIn.m_85837_(d1, vec31.f_82480_, d2);
        float f = (float)(vec3.f_82479_ - d3);
        float f1 = (float)(vec3.f_82480_ - d4);
        float f2 = (float)(vec3.f_82481_ - d5);
        float f3 = 0.025f;
        VertexConsumer vertexconsumer = bufferIn.m_6299_(RenderType.m_110475_());
        Matrix4f matrix4f = matrixStackIn.m_85850_().m_85861_();
        float f4 = Mth.m_14195_(f * f + f2 * f2) * 0.025f / 2.0f;
        float f5 = f2 * f4;
        float f6 = f * f4;
        BlockPos blockpos = new BlockPos(entityLivingIn.m_20299_(partialTicks));
        BlockPos blockpos1 = new BlockPos(leashHolder.m_20299_(partialTicks));
        int i = this.m_6086_(entityLivingIn, blockpos);
        int j = this.f_114476_.m_114382_(leashHolder).m_6086_(leashHolder, blockpos1);
        int k = ((Mob)((Object)entityLivingIn)).f_19853_.m_45517_(LightLayer.SKY, blockpos);
        int l = ((Mob)((Object)entityLivingIn)).f_19853_.m_45517_(LightLayer.SKY, blockpos1);
        if (Config.isShaders()) {
            Shaders.beginLeash();
        }
        for (int i1 = 0; i1 <= 24; ++i1) {
            MobRenderer.m_209630_(vertexconsumer, matrix4f, f, f1, f2, i, j, k, l, 0.025f, 0.025f, f5, f6, i1, false);
        }
        for (int j1 = 24; j1 >= 0; --j1) {
            MobRenderer.m_209630_(vertexconsumer, matrix4f, f, f1, f2, i, j, k, l, 0.025f, 0.0f, f5, f6, j1, true);
        }
        if (Config.isShaders()) {
            Shaders.endLeash();
        }
        matrixStackIn.m_85849_();
    }

    private static void m_209630_(VertexConsumer bufferIn, Matrix4f matrixIn, float p_209630_2_, float p_209630_3_, float p_209630_4_, int p_209630_5_, int p_209630_6_, int p_209630_7_, int p_209630_8_, float p_209630_9_, float p_209630_10_, float p_209630_11_, float p_209630_12_, int p_209630_13_, boolean p_209630_14_) {
        float f = (float)p_209630_13_ / 24.0f;
        int i = (int)Mth.m_14179_(f, p_209630_5_, p_209630_6_);
        int j = (int)Mth.m_14179_(f, p_209630_7_, p_209630_8_);
        int k = LightTexture.m_109885_(i, j);
        float f1 = p_209630_13_ % 2 == (p_209630_14_ ? 1 : 0) ? 0.7f : 1.0f;
        float f2 = 0.5f * f1;
        float f3 = 0.4f * f1;
        float f4 = 0.3f * f1;
        float f5 = p_209630_2_ * f;
        float f6 = p_209630_3_ > 0.0f ? p_209630_3_ * f * f : p_209630_3_ - p_209630_3_ * (1.0f - f) * (1.0f - f);
        float f7 = p_209630_4_ * f;
        bufferIn.m_85982_(matrixIn, f5 - p_209630_11_, f6 + p_209630_10_, f7 + p_209630_12_).m_85950_(f2, f3, f4, 1.0f).m_85969_(k).m_5752_();
        bufferIn.m_85982_(matrixIn, f5 + p_209630_11_, f6 + p_209630_9_ - p_209630_10_, f7 - p_209630_12_).m_85950_(f2, f3, f4, 1.0f).m_85969_(k).m_5752_();
    }
}

