/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EndCrystalRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.optifine.Config;
import net.optifine.shaders.Shaders;

public class EnderDragonRenderer
extends EntityRenderer<EnderDragon> {
    public static final ResourceLocation f_114174_ = new ResourceLocation("textures/entity/end_crystal/end_crystal_beam.png");
    private static final ResourceLocation f_114175_ = new ResourceLocation("textures/entity/enderdragon/dragon_exploding.png");
    private static final ResourceLocation f_114176_ = new ResourceLocation("textures/entity/enderdragon/dragon.png");
    private static final ResourceLocation f_114177_ = new ResourceLocation("textures/entity/enderdragon/dragon_eyes.png");
    private static final RenderType f_114178_ = RenderType.m_110458_(f_114176_);
    private static final RenderType f_114179_ = RenderType.m_110479_(f_114176_);
    private static final RenderType f_114180_ = RenderType.m_110488_(f_114177_);
    private static final RenderType f_114181_ = RenderType.m_110476_(f_114174_);
    private static final float f_114182_ = (float)(Math.sqrt(3.0) / 2.0);
    private final DragonModel f_114183_;

    public EnderDragonRenderer(EntityRendererProvider.Context contextIn) {
        super(contextIn);
        this.f_114477_ = 0.5f;
        this.f_114183_ = new DragonModel(contextIn.m_208800_(ModelLayers.f_201437_));
    }

    @Override
    public void m_7392_(EnderDragon entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.m_85836_();
        float f = (float)entityIn.m_31101_(7, partialTicks)[0];
        float f1 = (float)(entityIn.m_31101_(5, partialTicks)[1] - entityIn.m_31101_(10, partialTicks)[1]);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(-f));
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(f1 * 10.0f));
        matrixStackIn.m_85837_(0.0, 0.0, 1.0);
        matrixStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStackIn.m_85837_(0.0, -1.501f, 0.0);
        boolean flag = entityIn.f_20916_ > 0;
        this.f_114183_.m_6839_(entityIn, 0.0f, 0.0f, partialTicks);
        if (entityIn.f_31084_ > 0) {
            float f2 = (float)entityIn.f_31084_ / 200.0f;
            VertexConsumer vertexconsumer = bufferIn.m_6299_(RenderType.m_282959_(f_114175_));
            this.f_114183_.m_7695_(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, f2);
            VertexConsumer vertexconsumer1 = bufferIn.m_6299_(f_114179_);
            this.f_114183_.m_7695_(matrixStackIn, vertexconsumer1, packedLightIn, OverlayTexture.m_118090_((float)0.0f, (boolean)flag), 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            VertexConsumer vertexconsumer3 = bufferIn.m_6299_(f_114178_);
            this.f_114183_.m_7695_(matrixStackIn, vertexconsumer3, packedLightIn, OverlayTexture.m_118090_((float)0.0f, (boolean)flag), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        VertexConsumer vertexconsumer4 = bufferIn.m_6299_(f_114180_);
        if (Config.isShaders()) {
            Shaders.beginSpiderEyes();
        }
        Config.getRenderGlobal().renderOverlayEyes = true;
        this.f_114183_.m_7695_(matrixStackIn, vertexconsumer4, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        Config.getRenderGlobal().renderOverlayEyes = false;
        if (Config.isShaders()) {
            Shaders.endSpiderEyes();
        }
        if (entityIn.f_31084_ > 0) {
            float f5 = ((float)entityIn.f_31084_ + partialTicks) / 200.0f;
            float f7 = Math.min(f5 > 0.8f ? (f5 - 0.8f) / 0.2f : 0.0f, 1.0f);
            Random random = new Random(432L);
            VertexConsumer vertexconsumer2 = bufferIn.m_6299_(RenderType.m_110502_());
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.0, -1.0, -2.0);
            int i = 0;
            while ((float)i < (f5 + f5 * f5) / 2.0f * 60.0f) {
                matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(random.nextFloat() * 360.0f));
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(random.nextFloat() * 360.0f));
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(random.nextFloat() * 360.0f));
                matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(random.nextFloat() * 360.0f));
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(random.nextFloat() * 360.0f));
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(random.nextFloat() * 360.0f + f5 * 90.0f));
                float f3 = random.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
                float f4 = random.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
                Matrix4f matrix4f = matrixStackIn.m_85850_().m_85861_();
                int j = (int)(255.0f * (1.0f - f7));
                EnderDragonRenderer.m_114219_(vertexconsumer2, matrix4f, j);
                EnderDragonRenderer.m_114214_(vertexconsumer2, matrix4f, f3, f4);
                EnderDragonRenderer.m_114223_(vertexconsumer2, matrix4f, f3, f4);
                EnderDragonRenderer.m_114219_(vertexconsumer2, matrix4f, j);
                EnderDragonRenderer.m_114223_(vertexconsumer2, matrix4f, f3, f4);
                EnderDragonRenderer.m_114228_(vertexconsumer2, matrix4f, f3, f4);
                EnderDragonRenderer.m_114219_(vertexconsumer2, matrix4f, j);
                EnderDragonRenderer.m_114228_(vertexconsumer2, matrix4f, f3, f4);
                EnderDragonRenderer.m_114214_(vertexconsumer2, matrix4f, f3, f4);
                ++i;
            }
            matrixStackIn.m_85849_();
        }
        matrixStackIn.m_85849_();
        if (entityIn.f_31086_ != null) {
            matrixStackIn.m_85836_();
            float f6 = (float)(entityIn.f_31086_.m_20185_() - Mth.m_14139_(partialTicks, entityIn.f_19854_, entityIn.m_20185_()));
            float f8 = (float)(entityIn.f_31086_.m_20186_() - Mth.m_14139_(partialTicks, entityIn.f_19855_, entityIn.m_20186_()));
            float f9 = (float)(entityIn.f_31086_.m_20189_() - Mth.m_14139_(partialTicks, entityIn.f_19856_, entityIn.m_20189_()));
            EnderDragonRenderer.m_114187_(f6, f8 + EndCrystalRenderer.m_114158_((EndCrystal)entityIn.f_31086_, (float)partialTicks), f9, partialTicks, entityIn.f_19797_, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.m_85849_();
        }
        super.m_7392_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private static void m_114219_(VertexConsumer p_114219_0_, Matrix4f p_114219_1_, int p_114219_2_) {
        p_114219_0_.m_85982_(p_114219_1_, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, p_114219_2_).m_5752_();
    }

    private static void m_114214_(VertexConsumer p_114214_0_, Matrix4f p_114214_1_, float p_114214_2_, float p_114214_3_) {
        p_114214_0_.m_85982_(p_114214_1_, -f_114182_ * p_114214_3_, p_114214_2_, -0.5f * p_114214_3_).m_6122_(255, 0, 255, 0).m_5752_();
    }

    private static void m_114223_(VertexConsumer p_114223_0_, Matrix4f p_114223_1_, float p_114223_2_, float p_114223_3_) {
        p_114223_0_.m_85982_(p_114223_1_, f_114182_ * p_114223_3_, p_114223_2_, -0.5f * p_114223_3_).m_6122_(255, 0, 255, 0).m_5752_();
    }

    private static void m_114228_(VertexConsumer p_114228_0_, Matrix4f p_114228_1_, float p_114228_2_, float p_114228_3_) {
        p_114228_0_.m_85982_(p_114228_1_, 0.0f, p_114228_2_, 1.0f * p_114228_3_).m_6122_(255, 0, 255, 0).m_5752_();
    }

    public static void m_114187_(float p_114187_0_, float p_114187_1_, float p_114187_2_, float p_114187_3_, int p_114187_4_, PoseStack p_114187_5_, MultiBufferSource p_114187_6_, int p_114187_7_) {
        float f = Mth.m_14116_(p_114187_0_ * p_114187_0_ + p_114187_2_ * p_114187_2_);
        float f1 = Mth.m_14116_(p_114187_0_ * p_114187_0_ + p_114187_1_ * p_114187_1_ + p_114187_2_ * p_114187_2_);
        p_114187_5_.m_85836_();
        p_114187_5_.m_85837_(0.0, 2.0, 0.0);
        p_114187_5_.m_85845_(Vector3f.f_122225_.m_122270_((float)(-Math.atan2(p_114187_2_, p_114187_0_)) - 1.5707964f));
        p_114187_5_.m_85845_(Vector3f.f_122223_.m_122270_((float)(-Math.atan2(f, p_114187_1_)) - 1.5707964f));
        VertexConsumer vertexconsumer = p_114187_6_.m_6299_(f_114181_);
        float f2 = 0.0f - ((float)p_114187_4_ + p_114187_3_) * 0.01f;
        float f3 = Mth.m_14116_(p_114187_0_ * p_114187_0_ + p_114187_1_ * p_114187_1_ + p_114187_2_ * p_114187_2_) / 32.0f - ((float)p_114187_4_ + p_114187_3_) * 0.01f;
        int i = 8;
        float f4 = 0.0f;
        float f5 = 0.75f;
        float f6 = 0.0f;
        PoseStack.Pose posestack$pose = p_114187_5_.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_85861_();
        Matrix3f matrix3f = posestack$pose.m_85864_();
        for (int j = 1; j <= 8; ++j) {
            float f7 = Mth.m_14031_((float)j * ((float)Math.PI * 2) / 8.0f) * 0.75f;
            float f8 = Mth.m_14089_((float)j * ((float)Math.PI * 2) / 8.0f) * 0.75f;
            float f9 = (float)j / 8.0f;
            vertexconsumer.m_85982_(matrix4f, f4 * 0.2f, f5 * 0.2f, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(f6, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(p_114187_7_).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_85982_(matrix4f, f4, f5, f1).m_6122_(255, 255, 255, 255).m_7421_(f6, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(p_114187_7_).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_85982_(matrix4f, f7, f8, f1).m_6122_(255, 255, 255, 255).m_7421_(f9, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(p_114187_7_).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_85982_(matrix4f, f7 * 0.2f, f8 * 0.2f, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(f9, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(p_114187_7_).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            f4 = f7;
            f5 = f8;
            f6 = f9;
        }
        p_114187_5_.m_85849_();
    }

    @Override
    public ResourceLocation m_5478_(EnderDragon entity) {
        return f_114176_;
    }

    public static LayerDefinition m_208563_() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_201849_();
        float f = -16.0f;
        PartDefinition partdefinition1 = partdefinition.m_201872_("head", CubeListBuilder.m_201831_().m_201807_("upperlip", -6.0f, -1.0f, -24.0f, 12, 5, 16, 176, 44).m_201807_("upperhead", -8.0f, -8.0f, -10.0f, 16, 16, 16, 112, 30).m_201753_().m_201807_("scale", -5.0f, -12.0f, -4.0f, 2, 4, 6, 0, 0).m_201807_("nostril", -5.0f, -3.0f, -22.0f, 2, 2, 4, 112, 0).m_201753_().m_201807_("scale", 3.0f, -12.0f, -4.0f, 2, 4, 6, 0, 0).m_201807_("nostril", 3.0f, -3.0f, -22.0f, 2, 2, 4, 112, 0), PartPose.f_201677_);
        partdefinition1.m_201872_("jaw", CubeListBuilder.m_201831_().m_201807_("jaw", -6.0f, 0.0f, -16.0f, 12, 4, 16, 176, 65), PartPose.m_201692_((float)0.0f, (float)4.0f, (float)-8.0f));
        partdefinition.m_201872_("neck", CubeListBuilder.m_201831_().m_201807_("box", -5.0f, -5.0f, -5.0f, 10, 10, 10, 192, 104).m_201807_("scale", -1.0f, -9.0f, -3.0f, 2, 4, 6, 48, 0), PartPose.f_201677_);
        partdefinition.m_201872_("body", CubeListBuilder.m_201831_().m_201807_("body", -12.0f, 0.0f, -16.0f, 24, 24, 64, 0, 0).m_201807_("scale", -1.0f, -6.0f, -10.0f, 2, 6, 12, 220, 53).m_201807_("scale", -1.0f, -6.0f, 10.0f, 2, 6, 12, 220, 53).m_201807_("scale", -1.0f, -6.0f, 30.0f, 2, 6, 12, 220, 53), PartPose.m_201692_((float)0.0f, (float)4.0f, (float)8.0f));
        PartDefinition partdefinition2 = partdefinition.m_201872_("left_wing", CubeListBuilder.m_201831_().m_201753_().m_201807_("bone", 0.0f, -4.0f, -4.0f, 56, 8, 8, 112, 88).m_201807_("skin", 0.0f, 0.0f, 2.0f, 56, 0, 56, -56, 88), PartPose.m_201692_((float)12.0f, (float)5.0f, (float)2.0f));
        partdefinition2.m_201872_("left_wing_tip", CubeListBuilder.m_201831_().m_201753_().m_201807_("bone", 0.0f, -2.0f, -2.0f, 56, 4, 4, 112, 136).m_201807_("skin", 0.0f, 0.0f, 2.0f, 56, 0, 56, -56, 144), PartPose.m_201692_((float)56.0f, (float)0.0f, (float)0.0f));
        PartDefinition partdefinition3 = partdefinition.m_201872_("left_front_leg", CubeListBuilder.m_201831_().m_201807_("main", -4.0f, -4.0f, -4.0f, 8, 24, 8, 112, 104), PartPose.m_201692_((float)12.0f, (float)20.0f, (float)2.0f));
        PartDefinition partdefinition4 = partdefinition3.m_201872_("left_front_leg_tip", CubeListBuilder.m_201831_().m_201807_("main", -3.0f, -1.0f, -3.0f, 6, 24, 6, 226, 138), PartPose.m_201692_((float)0.0f, (float)20.0f, (float)-1.0f));
        partdefinition4.m_201872_("left_front_foot", CubeListBuilder.m_201831_().m_201807_("main", -4.0f, 0.0f, -12.0f, 8, 4, 16, 144, 104), PartPose.m_201692_((float)0.0f, (float)23.0f, (float)0.0f));
        PartDefinition partdefinition5 = partdefinition.m_201872_("left_hind_leg", CubeListBuilder.m_201831_().m_201807_("main", -8.0f, -4.0f, -8.0f, 16, 32, 16, 0, 0), PartPose.m_201692_((float)16.0f, (float)16.0f, (float)42.0f));
        PartDefinition partdefinition6 = partdefinition5.m_201872_("left_hind_leg_tip", CubeListBuilder.m_201831_().m_201807_("main", -6.0f, -2.0f, 0.0f, 12, 32, 12, 196, 0), PartPose.m_201692_((float)0.0f, (float)32.0f, (float)-4.0f));
        partdefinition6.m_201872_("left_hind_foot", CubeListBuilder.m_201831_().m_201807_("main", -9.0f, 0.0f, -20.0f, 18, 6, 24, 112, 0), PartPose.m_201692_((float)0.0f, (float)31.0f, (float)4.0f));
        PartDefinition partdefinition7 = partdefinition.m_201872_("right_wing", CubeListBuilder.m_201831_().m_201807_("bone", -56.0f, -4.0f, -4.0f, 56, 8, 8, 112, 88).m_201807_("skin", -56.0f, 0.0f, 2.0f, 56, 0, 56, -56, 88), PartPose.m_201692_((float)-12.0f, (float)5.0f, (float)2.0f));
        partdefinition7.m_201872_("right_wing_tip", CubeListBuilder.m_201831_().m_201807_("bone", -56.0f, -2.0f, -2.0f, 56, 4, 4, 112, 136).m_201807_("skin", -56.0f, 0.0f, 2.0f, 56, 0, 56, -56, 144), PartPose.m_201692_((float)-56.0f, (float)0.0f, (float)0.0f));
        PartDefinition partdefinition8 = partdefinition.m_201872_("right_front_leg", CubeListBuilder.m_201831_().m_201807_("main", -4.0f, -4.0f, -4.0f, 8, 24, 8, 112, 104), PartPose.m_201692_((float)-12.0f, (float)20.0f, (float)2.0f));
        PartDefinition partdefinition9 = partdefinition8.m_201872_("right_front_leg_tip", CubeListBuilder.m_201831_().m_201807_("main", -3.0f, -1.0f, -3.0f, 6, 24, 6, 226, 138), PartPose.m_201692_((float)0.0f, (float)20.0f, (float)-1.0f));
        partdefinition9.m_201872_("right_front_foot", CubeListBuilder.m_201831_().m_201807_("main", -4.0f, 0.0f, -12.0f, 8, 4, 16, 144, 104), PartPose.m_201692_((float)0.0f, (float)23.0f, (float)0.0f));
        PartDefinition partdefinition10 = partdefinition.m_201872_("right_hind_leg", CubeListBuilder.m_201831_().m_201807_("main", -8.0f, -4.0f, -8.0f, 16, 32, 16, 0, 0), PartPose.m_201692_((float)-16.0f, (float)16.0f, (float)42.0f));
        PartDefinition partdefinition11 = partdefinition10.m_201872_("right_hind_leg_tip", CubeListBuilder.m_201831_().m_201807_("main", -6.0f, -2.0f, 0.0f, 12, 32, 12, 196, 0), PartPose.m_201692_((float)0.0f, (float)32.0f, (float)-4.0f));
        partdefinition11.m_201872_("right_hind_foot", CubeListBuilder.m_201831_().m_201807_("main", -9.0f, 0.0f, -20.0f, 18, 6, 24, 112, 0), PartPose.m_201692_((float)0.0f, (float)31.0f, (float)4.0f));
        return LayerDefinition.m_201838_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public static class DragonModel
    extends EntityModel<EnderDragon> {
        private final ModelPart f_114235_;
        private final ModelPart f_114236_;
        private final ModelPart f_114237_;
        private final ModelPart f_114238_;
        private final ModelPart f_114239_;
        private final ModelPart f_114240_;
        private final ModelPart f_114241_;
        private final ModelPart f_114242_;
        private final ModelPart f_114243_;
        private final ModelPart f_114244_;
        private final ModelPart f_114245_;
        private final ModelPart f_114246_;
        private final ModelPart f_114247_;
        private final ModelPart f_114248_;
        private final ModelPart f_114249_;
        private final ModelPart f_114250_;
        private final ModelPart f_114251_;
        private final ModelPart f_114252_;
        private final ModelPart f_114253_;
        private final ModelPart f_114254_;
        @Nullable
        private EnderDragon f_114233_;
        private float f_114234_;

        public DragonModel(ModelPart partIn) {
            this.f_114235_ = partIn.m_201626_("head");
            this.f_114237_ = this.f_114235_.m_201626_("jaw");
            this.f_114236_ = partIn.m_201626_("neck");
            this.f_114238_ = partIn.m_201626_("body");
            this.f_114239_ = partIn.m_201626_("left_wing");
            this.f_114240_ = this.f_114239_.m_201626_("left_wing_tip");
            this.f_114241_ = partIn.m_201626_("left_front_leg");
            this.f_114242_ = this.f_114241_.m_201626_("left_front_leg_tip");
            this.f_114243_ = this.f_114242_.m_201626_("left_front_foot");
            this.f_114244_ = partIn.m_201626_("left_hind_leg");
            this.f_114245_ = this.f_114244_.m_201626_("left_hind_leg_tip");
            this.f_114246_ = this.f_114245_.m_201626_("left_hind_foot");
            this.f_114247_ = partIn.m_201626_("right_wing");
            this.f_114248_ = this.f_114247_.m_201626_("right_wing_tip");
            this.f_114249_ = partIn.m_201626_("right_front_leg");
            this.f_114250_ = this.f_114249_.m_201626_("right_front_leg_tip");
            this.f_114251_ = this.f_114250_.m_201626_("right_front_foot");
            this.f_114252_ = partIn.m_201626_("right_hind_leg");
            this.f_114253_ = this.f_114252_.m_201626_("right_hind_leg_tip");
            this.f_114254_ = this.f_114253_.m_201626_("right_hind_foot");
        }

        public void m_6839_(EnderDragon entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
            this.f_114233_ = entityIn;
            this.f_114234_ = partialTick;
        }

        public void m_6973_(EnderDragon entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        }

        public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            matrixStackIn.m_85836_();
            float f = Mth.m_14179_(this.f_114234_, this.f_114233_.f_31081_, this.f_114233_.f_31082_);
            this.f_114237_.f_104203_ = (float)(Math.sin(f * ((float)Math.PI * 2)) + 1.0) * 0.2f;
            float f1 = (float)(Math.sin(f * ((float)Math.PI * 2) - 1.0f) + 1.0);
            f1 = (f1 * f1 + f1 * 2.0f) * 0.05f;
            matrixStackIn.m_85837_(0.0, f1 - 2.0f, -3.0);
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(f1 * 2.0f));
            float f2 = 0.0f;
            float f3 = 20.0f;
            float f4 = -12.0f;
            float f5 = 1.5f;
            double[] adouble = this.f_114233_.m_31101_(6, this.f_114234_);
            float f6 = Mth.m_14209_(this.f_114233_.m_31101_(5, this.f_114234_)[0] - this.f_114233_.m_31101_(10, this.f_114234_)[0]);
            float f7 = Mth.m_14209_(this.f_114233_.m_31101_(5, this.f_114234_)[0] + (double)(f6 / 2.0f));
            float f8 = f * ((float)Math.PI * 2);
            for (int i = 0; i < 5; ++i) {
                double[] adouble1 = this.f_114233_.m_31101_(5 - i, this.f_114234_);
                float f9 = (float)Math.cos((float)i * 0.45f + f8) * 0.15f;
                this.f_114236_.f_104204_ = Mth.m_14209_(adouble1[0] - adouble[0]) * ((float)Math.PI / 180) * 1.5f;
                this.f_114236_.f_104203_ = f9 + this.f_114233_.m_31108_(i, adouble, adouble1) * ((float)Math.PI / 180) * 1.5f * 5.0f;
                this.f_114236_.f_104205_ = -Mth.m_14209_(adouble1[0] - (double)f7) * ((float)Math.PI / 180) * 1.5f;
                this.f_114236_.f_104201_ = f3;
                this.f_114236_.f_104202_ = f4;
                this.f_114236_.f_104200_ = f2;
                f3 = (float)((double)f3 + Math.sin(this.f_114236_.f_104203_) * 10.0);
                f4 = (float)((double)f4 - Math.cos(this.f_114236_.f_104204_) * Math.cos(this.f_114236_.f_104203_) * 10.0);
                f2 = (float)((double)f2 - Math.sin(this.f_114236_.f_104204_) * Math.cos(this.f_114236_.f_104203_) * 10.0);
                this.f_114236_.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, alpha);
            }
            this.f_114235_.f_104201_ = f3;
            this.f_114235_.f_104202_ = f4;
            this.f_114235_.f_104200_ = f2;
            double[] adouble2 = this.f_114233_.m_31101_(0, this.f_114234_);
            this.f_114235_.f_104204_ = Mth.m_14209_(adouble2[0] - adouble[0]) * ((float)Math.PI / 180);
            this.f_114235_.f_104203_ = Mth.m_14209_(this.f_114233_.m_31108_(6, adouble, adouble2)) * ((float)Math.PI / 180) * 1.5f * 5.0f;
            this.f_114235_.f_104205_ = -Mth.m_14209_(adouble2[0] - (double)f7) * ((float)Math.PI / 180);
            this.f_114235_.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, alpha);
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.0, 1.0, 0.0);
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(-f6 * 1.5f));
            matrixStackIn.m_85837_(0.0, -1.0, 0.0);
            this.f_114238_.f_104205_ = 0.0f;
            this.f_114238_.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, alpha);
            float f10 = f * ((float)Math.PI * 2);
            this.f_114239_.f_104203_ = 0.125f - (float)Math.cos(f10) * 0.2f;
            this.f_114239_.f_104204_ = -0.25f;
            this.f_114239_.f_104205_ = -((float)(Math.sin(f10) + 0.125)) * 0.8f;
            this.f_114240_.f_104205_ = (float)(Math.sin(f10 + 2.0f) + 0.5) * 0.75f;
            this.f_114247_.f_104203_ = this.f_114239_.f_104203_;
            this.f_114247_.f_104204_ = -this.f_114239_.f_104204_;
            this.f_114247_.f_104205_ = -this.f_114239_.f_104205_;
            this.f_114248_.f_104205_ = -this.f_114240_.f_104205_;
            this.m_285325_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, f1, this.f_114239_, this.f_114241_, this.f_114242_, this.f_114243_, this.f_114244_, this.f_114245_, this.f_114246_, alpha);
            this.m_285325_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, f1, this.f_114247_, this.f_114249_, this.f_114250_, this.f_114251_, this.f_114252_, this.f_114253_, this.f_114254_, alpha);
            matrixStackIn.m_85849_();
            float f11 = -((float)Math.sin(f * ((float)Math.PI * 2))) * 0.0f;
            f8 = f * ((float)Math.PI * 2);
            f3 = 10.0f;
            f4 = 60.0f;
            f2 = 0.0f;
            adouble = this.f_114233_.m_31101_(11, this.f_114234_);
            for (int j = 0; j < 12; ++j) {
                adouble2 = this.f_114233_.m_31101_(12 + j, this.f_114234_);
                f11 = (float)((double)f11 + Math.sin((float)j * 0.45f + f8) * (double)0.05f);
                this.f_114236_.f_104204_ = (Mth.m_14209_(adouble2[0] - adouble[0]) * 1.5f + 180.0f) * ((float)Math.PI / 180);
                this.f_114236_.f_104203_ = f11 + (float)(adouble2[1] - adouble[1]) * ((float)Math.PI / 180) * 1.5f * 5.0f;
                this.f_114236_.f_104205_ = Mth.m_14209_(adouble2[0] - (double)f7) * ((float)Math.PI / 180) * 1.5f;
                this.f_114236_.f_104201_ = f3;
                this.f_114236_.f_104202_ = f4;
                this.f_114236_.f_104200_ = f2;
                f3 = (float)((double)f3 + Math.sin(this.f_114236_.f_104203_) * 10.0);
                f4 = (float)((double)f4 - Math.cos(this.f_114236_.f_104204_) * Math.cos(this.f_114236_.f_104203_) * 10.0);
                f2 = (float)((double)f2 - Math.sin(this.f_114236_.f_104204_) * Math.cos(this.f_114236_.f_104203_) * 10.0);
                this.f_114236_.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, alpha);
            }
            matrixStackIn.m_85849_();
        }

        private void m_285325_(PoseStack p_285325_1_, VertexConsumer p_285325_2_, int p_285325_3_, int p_285325_4_, float p_285325_5_, ModelPart p_285325_6_, ModelPart p_285325_7_, ModelPart p_285325_8_, ModelPart p_285325_9_, ModelPart p_285325_10_, ModelPart p_285325_11_, ModelPart p_285325_12_, float p_285325_13_) {
            p_285325_10_.f_104203_ = 1.0f + p_285325_5_ * 0.1f;
            p_285325_11_.f_104203_ = 0.5f + p_285325_5_ * 0.1f;
            p_285325_12_.f_104203_ = 0.75f + p_285325_5_ * 0.1f;
            p_285325_7_.f_104203_ = 1.3f + p_285325_5_ * 0.1f;
            p_285325_8_.f_104203_ = -0.5f - p_285325_5_ * 0.1f;
            p_285325_9_.f_104203_ = 0.75f + p_285325_5_ * 0.1f;
            p_285325_6_.m_104306_(p_285325_1_, p_285325_2_, p_285325_3_, p_285325_4_, 1.0f, 1.0f, 1.0f, p_285325_13_);
            p_285325_7_.m_104306_(p_285325_1_, p_285325_2_, p_285325_3_, p_285325_4_, 1.0f, 1.0f, 1.0f, p_285325_13_);
            p_285325_10_.m_104306_(p_285325_1_, p_285325_2_, p_285325_3_, p_285325_4_, 1.0f, 1.0f, 1.0f, p_285325_13_);
        }
    }
}

