/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.optifine.Config;
import net.optifine.render.VboRegion;

public class ViewArea {
    protected final LevelRenderer f_110838_;
    protected final Level f_110839_;
    protected int f_110840_;
    protected int f_110841_;
    protected int f_110842_;
    public ChunkRenderDispatcher.RenderChunk[] f_110843_;
    private Map<ChunkPos, VboRegion[]> mapVboRegions = new HashMap<ChunkPos, VboRegion[]>();

    public ViewArea(ChunkRenderDispatcher renderDispatcherIn, Level worldIn, int countChunksIn, LevelRenderer renderGlobalIn) {
        this.f_110838_ = renderGlobalIn;
        this.f_110839_ = worldIn;
        this.m_110853_(countChunksIn);
        this.m_110864_(renderDispatcherIn);
    }

    protected void m_110864_(ChunkRenderDispatcher renderChunkFactory) {
        int l;
        int i = this.f_110841_ * this.f_110840_ * this.f_110842_;
        this.f_110843_ = new ChunkRenderDispatcher.RenderChunk[i];
        int minBuildHeight = this.f_110839_.m_141493_();
        for (int j = 0; j < this.f_110841_; ++j) {
            for (int k = 0; k < this.f_110840_; ++k) {
                for (l = 0; l < this.f_110842_; ++l) {
                    int i1 = this.m_110855_(j, k, l);
                    ChunkRenderDispatcher chunkRenderDispatcher = renderChunkFactory;
                    chunkRenderDispatcher.getClass();
                    this.f_110843_[i1] = chunkRenderDispatcher.new ChunkRenderDispatcher.RenderChunk(i1);
                    this.f_110843_[i1].m_112801_(j * 16, k * 16 + minBuildHeight, l * 16);
                    if (!Config.isVbo() || !Config.isRenderRegions()) continue;
                    this.updateVboRegion(this.f_110843_[i1]);
                }
            }
        }
        for (int k = 0; k < this.f_110843_.length; ++k) {
            ChunkRenderDispatcher.RenderChunk renderChunk = this.f_110843_[k];
            for (l = 0; l < Direction.f_122346_.length; ++l) {
                Direction facing = Direction.f_122346_[l];
                BlockPos posOffset16 = renderChunk.m_112824_(facing);
                ChunkRenderDispatcher.RenderChunk neighbour = this.m_110866_(posOffset16);
                renderChunk.setRenderChunkNeighbour(facing, neighbour);
            }
        }
    }

    public void m_110849_() {
        for (ChunkRenderDispatcher.RenderChunk chunkrenderdispatcher$renderchunk : this.f_110843_) {
            chunkrenderdispatcher$renderchunk.m_112838_();
        }
        this.deleteVboRegions();
    }

    private int m_110855_(int x, int y, int z) {
        return (z * this.f_110840_ + y) * this.f_110841_ + x;
    }

    protected void m_110853_(int renderDistanceChunks) {
        int i;
        this.f_110841_ = i = renderDistanceChunks * 2 + 1;
        this.f_110840_ = this.f_110839_.m_163335_();
        this.f_110842_ = i;
    }

    public void m_110850_(double viewEntityX, double viewEntityZ) {
        int i = Mth.m_14107_(viewEntityX);
        int j = Mth.m_14107_(viewEntityZ);
        for (int k = 0; k < this.f_110841_; ++k) {
            int l = this.f_110841_ * 16;
            int i1 = i - 8 - l / 2;
            int j1 = i1 + Math.floorMod(k * 16 - i1, l);
            for (int k1 = 0; k1 < this.f_110842_; ++k1) {
                int l1 = this.f_110842_ * 16;
                int i2 = j - 8 - l1 / 2;
                int j2 = i2 + Math.floorMod(k1 * 16 - i2, l1);
                for (int k2 = 0; k2 < this.f_110840_; ++k2) {
                    int l2 = this.f_110839_.m_141493_() + k2 * 16;
                    ChunkRenderDispatcher.RenderChunk chunkrenderdispatcher$renderchunk = this.f_110843_[this.m_110855_(k, k2, k1)];
                    chunkrenderdispatcher$renderchunk.m_112801_(j1, l2, j2);
                }
            }
        }
    }

    public void m_110859_(int sectionX, int sectionY, int sectionZ, boolean rerenderOnMainThread) {
        int i = Math.floorMod(sectionX, this.f_110841_);
        int j = Math.floorMod(sectionY - this.f_110839_.m_163336_(), this.f_110840_);
        int k = Math.floorMod(sectionZ, this.f_110842_);
        ChunkRenderDispatcher.RenderChunk chunkrenderdispatcher$renderchunk = this.f_110843_[this.m_110855_(i, j, k)];
        chunkrenderdispatcher$renderchunk.m_112828_(rerenderOnMainThread);
    }

    @Nullable
    public ChunkRenderDispatcher.RenderChunk m_110866_(BlockPos pos) {
        int i = pos.m_123341_() >> 4;
        int j = pos.m_123342_() - this.f_110839_.m_141493_() >> 4;
        int k = pos.m_123343_() >> 4;
        if (j >= 0 && j < this.f_110840_) {
            i = Mth.m_14100_(i, this.f_110841_);
            k = Mth.m_14100_(k, this.f_110842_);
            return this.f_110843_[this.m_110855_(i, j, k)];
        }
        return null;
    }

    private void updateVboRegion(ChunkRenderDispatcher.RenderChunk renderChunk) {
        int ix;
        BlockPos pos = renderChunk.m_112839_();
        int rx = pos.m_123341_() >> 8 << 8;
        int rz = pos.m_123343_() >> 8 << 8;
        ChunkPos cp = new ChunkPos(rx, rz);
        RenderType[] layers = RenderType.CHUNK_RENDER_TYPES;
        VboRegion[] regions = this.mapVboRegions.get(cp);
        if (regions == null) {
            regions = new VboRegion[layers.length];
            for (ix = 0; ix < layers.length; ++ix) {
                if (layers[ix].isNeedsSorting()) continue;
                regions[ix] = new VboRegion(layers[ix]);
            }
            this.mapVboRegions.put(cp, regions);
        }
        for (ix = 0; ix < layers.length; ++ix) {
            RenderType layer = layers[ix];
            VboRegion vr = regions[ix];
            renderChunk.m_112807_(layer).setVboRegion(vr);
        }
    }

    public void deleteVboRegions() {
        Set<ChunkPos> keys = this.mapVboRegions.keySet();
        for (ChunkPos cp : keys) {
            VboRegion[] vboRegions = this.mapVboRegions.get(cp);
            for (int i = 0; i < vboRegions.length; ++i) {
                VboRegion vboRegion = vboRegions[i];
                if (vboRegion != null) {
                    vboRegion.deleteGlBuffers();
                }
                vboRegions[i] = null;
            }
        }
        this.mapVboRegions.clear();
    }
}

