/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.blockentity.TheEndPortalRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.optifine.Config;
import net.optifine.EmissiveTextures;
import net.optifine.RandomEntities;
import net.optifine.SmartAnimations;
import net.optifine.render.RenderStateManager;
import net.optifine.render.RenderUtils;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersRender;
import net.optifine.util.CompoundKey;

public abstract class RenderType
extends RenderStateShard {
    private static final int f_316216_ = 4;
    private static final int f_316217_ = 0x100000;
    public static final int f_316212_ = 0x200000;
    public static final int f_316213_ = 262144;
    public static final int f_316214_ = 131072;
    public static final int f_316215_ = 256;
    private static final RenderType f_110372_ = RenderType.m_206136_("solid", DefaultVertexFormat.f_85811_, VertexFormat.Mode.QUADS, 0x200000, true, false, CompositeState.m_110628_().m_110671_(f_110152_).m_283066_(f_282791_).m_283059_(f_110145_).m_110691_(true));
    private static final RenderType f_110373_ = RenderType.m_206136_("cutout_mipped", DefaultVertexFormat.f_85811_, VertexFormat.Mode.QUADS, 131072, true, false, CompositeState.m_110628_().m_110671_(f_110152_).m_283066_(f_282792_).m_283059_(f_110145_).m_110691_(true));
    private static final RenderType f_110374_ = RenderType.m_206136_("cutout", DefaultVertexFormat.f_85811_, VertexFormat.Mode.QUADS, 131072, true, false, CompositeState.m_110628_().m_110671_(f_110152_).m_283066_(f_282793_).m_283059_(f_110146_).m_110691_(true));
    private static final RenderType f_110375_ = RenderType.m_206136_("translucent", DefaultVertexFormat.f_85811_, VertexFormat.Mode.QUADS, 0x200000, true, true, RenderType.m_282918_(f_282794_));
    private static final RenderType f_110376_ = RenderType.m_206136_("translucent_moving_block", DefaultVertexFormat.f_85811_, VertexFormat.Mode.QUADS, 262144, false, true, RenderType.m_110408_());
    private static final RenderType f_110377_ = RenderType.m_206136_("translucent_no_crumbling", DefaultVertexFormat.f_85811_, VertexFormat.Mode.QUADS, 262144, false, true, RenderType.m_282918_(f_282796_));
    private static final Function<ResourceLocation, RenderType> f_316218_ = Util.m_300606_(p_316266_0_ -> {
        CompositeState rendertype$compositestate = CompositeState.m_110628_().m_283066_(f_282797_).m_283059_(new RenderStateShard.TextureStateShard((ResourceLocation)p_316266_0_, false, false)).m_110685_(f_110134_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110669_(f_110119_).m_110691_(true);
        return RenderType.m_206136_("armor_cutout_no_cull", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, true, false, rendertype$compositestate);
    });
    private static final Function<ResourceLocation, RenderType> f_316219_ = Util.m_300606_(p_316264_0_ -> {
        CompositeState rendertype$compositestate = CompositeState.m_110628_().m_283066_(f_282798_).m_283059_(new RenderStateShard.TextureStateShard((ResourceLocation)p_316264_0_, false, false)).m_110685_(f_110134_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(true);
        return RenderType.m_206136_("entity_solid", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, true, false, rendertype$compositestate);
    });
    private static final Function<ResourceLocation, RenderType> f_316220_ = Util.m_300606_(p_316262_0_ -> {
        CompositeState rendertype$compositestate = CompositeState.m_110628_().m_283066_(f_282799_).m_283059_(new RenderStateShard.TextureStateShard((ResourceLocation)p_316262_0_, false, false)).m_110685_(f_110134_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(true);
        return RenderType.m_206136_("entity_cutout", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, true, false, rendertype$compositestate);
    });
    private static final BiFunction<ResourceLocation, Boolean, RenderType> f_316223_ = Util.m_300600_((p_316277_0_, p_316277_1_) -> {
        CompositeState rendertype$compositestate = CompositeState.m_110628_().m_283066_(f_282800_).m_283059_(new RenderStateShard.TextureStateShard((ResourceLocation)p_316277_0_, false, false)).m_110685_(f_110134_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_((boolean)p_316277_1_);
        return RenderType.m_206136_("entity_cutout_no_cull", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, true, false, rendertype$compositestate);
    });
    private static final BiFunction<ResourceLocation, Boolean, RenderType> f_316224_ = Util.m_300600_((p_316274_0_, p_316274_1_) -> {
        CompositeState rendertype$compositestate = CompositeState.m_110628_().m_283066_(f_282752_).m_283059_(new RenderStateShard.TextureStateShard((ResourceLocation)p_316274_0_, false, false)).m_110685_(f_110134_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110669_(f_110119_).m_110691_((boolean)p_316274_1_);
        return RenderType.m_206136_("entity_cutout_no_cull_z_offset", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, true, false, rendertype$compositestate);
    });
    private static final Function<ResourceLocation, RenderType> f_316225_ = Util.m_300606_(p_316260_0_ -> {
        CompositeState rendertype$compositestate = CompositeState.m_110628_().m_283066_(f_282753_).m_283059_(new RenderStateShard.TextureStateShard((ResourceLocation)p_316260_0_, false, false)).m_110685_(f_110139_).m_110675_(f_110129_).m_110671_(f_110152_).m_110677_(f_110154_).m_110687_(RenderStateShard.f_110114_).m_110691_(true);
        return RenderType.m_206136_("item_entity_translucent_cull", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, true, true, rendertype$compositestate);
    });
    private static final Function<ResourceLocation, RenderType> f_316226_ = Util.m_300606_(p_316258_0_ -> {
        CompositeState rendertype$compositestate = CompositeState.m_110628_().m_283066_(f_282754_).m_283059_(new RenderStateShard.TextureStateShard((ResourceLocation)p_316258_0_, false, false)).m_110685_(f_110139_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(true);
        return RenderType.m_206136_("entity_translucent_cull", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, true, true, rendertype$compositestate);
    });
    private static final BiFunction<ResourceLocation, Boolean, RenderType> f_316227_ = Util.m_300600_((p_316271_0_, p_316271_1_) -> {
        CompositeState rendertype$compositestate = CompositeState.m_110628_().m_283066_(f_282755_).m_283059_(new RenderStateShard.TextureStateShard((ResourceLocation)p_316271_0_, false, false)).m_110685_(f_110139_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_((boolean)p_316271_1_);
        return RenderType.m_206136_("entity_translucent", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, true, true, rendertype$compositestate);
    });
    private static final Function<ResourceLocation, RenderType> f_316228_ = Util.m_300606_(p_316256_0_ -> {
        CompositeState rendertype$compositestate = CompositeState.m_110628_().m_283066_(f_282756_).m_283059_(new RenderStateShard.TextureStateShard((ResourceLocation)p_316256_0_, false, false)).m_110661_(f_110110_).m_110671_(f_110152_).m_110691_(true);
        return RenderType.m_206130_("entity_smooth_cutout", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, rendertype$compositestate);
    });
    private static final BiFunction<ResourceLocation, Boolean, RenderType> f_316229_ = Util.m_300600_((p_316268_0_, p_316268_1_) -> {
        CompositeState rendertype$compositestate = CompositeState.m_110628_().m_283066_(f_282757_).m_283059_(new RenderStateShard.TextureStateShard((ResourceLocation)p_316268_0_, false, false)).m_110685_(p_316268_1_ != false ? f_110139_ : f_110134_).m_110687_(p_316268_1_ != false ? f_110115_ : f_110114_).m_110691_(false);
        return RenderType.m_206136_("beacon_beam", DefaultVertexFormat.f_85811_, VertexFormat.Mode.QUADS, 256, false, true, rendertype$compositestate);
    });
    private static final Function<ResourceLocation, RenderType> f_316230_ = Util.m_300606_(p_316254_0_ -> {
        CompositeState rendertype$compositestate = CompositeState.m_110628_().m_283066_(f_282758_).m_283059_(new RenderStateShard.TextureStateShard((ResourceLocation)p_316254_0_, false, false)).m_110663_(f_110112_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(false);
        return RenderType.m_206130_("entity_decal", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, rendertype$compositestate);
    });
    private static final Function<ResourceLocation, RenderType> f_316231_ = Util.m_300606_(p_316252_0_ -> {
        CompositeState rendertype$compositestate = CompositeState.m_110628_().m_283066_(f_282759_).m_283059_(new RenderStateShard.TextureStateShard((ResourceLocation)p_316252_0_, false, false)).m_110685_(f_110139_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110687_(f_110115_).m_110691_(false);
        return RenderType.m_206136_("entity_no_outline", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, false, true, rendertype$compositestate);
    });
    private static final Function<ResourceLocation, RenderType> f_316232_ = Util.m_300606_(p_316250_0_ -> {
        CompositeState rendertype$compositestate = CompositeState.m_110628_().m_283066_(f_282760_).m_283059_(new RenderStateShard.TextureStateShard((ResourceLocation)p_316250_0_, false, false)).m_110685_(f_110139_).m_110661_(f_110158_).m_110671_(f_110152_).m_110677_(f_110154_).m_110687_(f_110115_).m_110663_(f_110113_).m_110669_(f_110119_).m_110691_(false);
        return RenderType.m_206136_("entity_shadow", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, false, false, rendertype$compositestate);
    });
    private static final Function<ResourceLocation, RenderType> f_316233_ = Util.m_300606_(p_316248_0_ -> {
        CompositeState rendertype$compositestate = CompositeState.m_110628_().m_283066_(f_282761_).m_283059_(new RenderStateShard.TextureStateShard((ResourceLocation)p_316248_0_, false, false)).m_110661_(f_110110_).m_110691_(true);
        return RenderType.m_206130_("entity_alpha", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, rendertype$compositestate);
    });
    private static final Function<ResourceLocation, RenderType> f_316234_ = Util.m_300606_(p_316246_0_ -> {
        RenderStateShard.TextureStateShard renderstateshard$texturestateshard = new RenderStateShard.TextureStateShard((ResourceLocation)p_316246_0_, false, false);
        return RenderType.m_206136_("eyes", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, false, true, CompositeState.m_110628_().m_283066_(f_282762_).m_283059_(renderstateshard$texturestateshard).m_110685_(f_110135_).m_110687_(f_110115_).m_110691_(false));
    });
    private static final RenderType f_110378_ = RenderType.m_206130_("leash", DefaultVertexFormat.f_85816_, VertexFormat.Mode.TRIANGLE_STRIP, 256, CompositeState.m_110628_().m_283066_(f_282764_).m_283059_(f_110147_).m_110661_(f_110110_).m_110671_(f_110152_).m_110691_(false));
    private static final RenderType f_110379_ = RenderType.m_206130_("water_mask", DefaultVertexFormat.f_85814_, VertexFormat.Mode.QUADS, 256, CompositeState.m_110628_().m_283066_(f_282765_).m_283059_(f_110147_).m_110687_(f_110116_).m_110691_(false));
    private static final RenderType f_110380_ = RenderType.m_206130_("armor_glint", DefaultVertexFormat.f_85817_, VertexFormat.Mode.QUADS, 256, CompositeState.m_110628_().m_283066_(f_282767_).m_283059_(new RenderStateShard.TextureStateShard(ItemRenderer.f_115092_, true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(f_110150_).m_110669_(f_110119_).m_110691_(false));
    private static final RenderType f_110381_ = RenderType.m_206130_("armor_entity_glint", DefaultVertexFormat.f_85817_, VertexFormat.Mode.QUADS, 256, CompositeState.m_110628_().m_283066_(f_282768_).m_283059_(new RenderStateShard.TextureStateShard(ItemRenderer.f_115092_, true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(f_110151_).m_110669_(f_110119_).m_110691_(false));
    private static final RenderType f_110382_ = RenderType.m_206130_("glint_translucent", DefaultVertexFormat.f_85817_, VertexFormat.Mode.QUADS, 256, CompositeState.m_110628_().m_283066_(f_282769_).m_283059_(new RenderStateShard.TextureStateShard(ItemRenderer.f_115092_, true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(f_110150_).m_110675_(f_110129_).m_110691_(false));
    private static final RenderType f_110383_ = RenderType.m_206130_("glint", DefaultVertexFormat.f_85817_, VertexFormat.Mode.QUADS, 256, CompositeState.m_110628_().m_283066_(f_282770_).m_283059_(new RenderStateShard.TextureStateShard(ItemRenderer.f_115092_, true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(f_110150_).m_110691_(false));
    private static final RenderType f_110384_ = RenderType.m_206130_("glint_direct", DefaultVertexFormat.f_85817_, VertexFormat.Mode.QUADS, 256, CompositeState.m_110628_().m_283066_(f_282771_).m_283059_(new RenderStateShard.TextureStateShard(ItemRenderer.f_115092_, true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(f_110150_).m_110691_(false));
    private static final RenderType f_110385_ = RenderType.m_206130_("entity_glint", DefaultVertexFormat.f_85817_, VertexFormat.Mode.QUADS, 256, CompositeState.m_110628_().m_283066_(f_282772_).m_283059_(new RenderStateShard.TextureStateShard(ItemRenderer.f_115092_, true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110675_(f_110129_).m_110683_(f_110151_).m_110691_(false));
    private static final RenderType f_110386_ = RenderType.m_206130_("entity_glint_direct", DefaultVertexFormat.f_85817_, VertexFormat.Mode.QUADS, 256, CompositeState.m_110628_().m_283066_(f_282773_).m_283059_(new RenderStateShard.TextureStateShard(ItemRenderer.f_115092_, true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(f_110151_).m_110691_(false));
    private static final Function<ResourceLocation, RenderType> f_316235_ = Util.m_300606_(p_316244_0_ -> {
        RenderStateShard.TextureStateShard renderstateshard$texturestateshard = new RenderStateShard.TextureStateShard((ResourceLocation)p_316244_0_, false, false);
        return RenderType.m_206136_("crumbling", DefaultVertexFormat.f_85811_, VertexFormat.Mode.QUADS, 256, false, true, CompositeState.m_110628_().m_283066_(f_282774_).m_283059_(renderstateshard$texturestateshard).m_110685_(f_110138_).m_110687_(f_110115_).m_110669_(f_110118_).m_110691_(false));
    });
    private static final Function<ResourceLocation, RenderType> f_316236_ = Util.m_300606_(p_316242_0_ -> RenderType.m_206136_("text", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, 256, false, false, CompositeState.m_110628_().m_283066_(f_282775_).m_283059_(new RenderStateShard.TextureStateShard((ResourceLocation)p_316242_0_, false, false)).m_110685_(f_110139_).m_110671_(f_110152_).m_110691_(false)));
    private static final Function<ResourceLocation, RenderType> f_316237_ = Util.m_300606_(p_316240_0_ -> RenderType.m_206136_("text_intensity", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, 256, false, false, CompositeState.m_110628_().m_283066_(f_316208_).m_283059_(new RenderStateShard.TextureStateShard((ResourceLocation)p_316240_0_, false, false)).m_110685_(f_110139_).m_110671_(f_110152_).m_110691_(false)));
    private static final Function<ResourceLocation, RenderType> f_316238_ = Util.m_300606_(p_316294_0_ -> RenderType.m_206136_("text_polygon_offset", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, 256, false, false, CompositeState.m_110628_().m_283066_(f_282775_).m_283059_(new RenderStateShard.TextureStateShard((ResourceLocation)p_316294_0_, false, false)).m_110685_(f_110139_).m_110671_(f_110152_).m_110669_(f_110118_).m_110691_(false)));
    private static final Function<ResourceLocation, RenderType> f_316239_ = Util.m_300606_(p_316292_0_ -> RenderType.m_206136_("text_intensity_polygon_offset", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, 256, false, false, CompositeState.m_110628_().m_283066_(f_316208_).m_283059_(new RenderStateShard.TextureStateShard((ResourceLocation)p_316292_0_, false, false)).m_110685_(f_110139_).m_110671_(f_110152_).m_110669_(f_110118_).m_110691_(false)));
    private static final Function<ResourceLocation, RenderType> f_316221_ = Util.m_300606_(p_316290_0_ -> RenderType.m_206136_("text_see_through", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, 256, false, false, CompositeState.m_110628_().m_283066_(f_282776_).m_283059_(new RenderStateShard.TextureStateShard((ResourceLocation)p_316290_0_, false, false)).m_110685_(f_110139_).m_110671_(f_110152_).m_110663_(f_110111_).m_110687_(f_110115_).m_110691_(false)));
    private static final Function<ResourceLocation, RenderType> f_316222_ = Util.m_300606_(p_316288_0_ -> RenderType.m_206136_("text_intensity_see_through", DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, 256, false, false, CompositeState.m_110628_().m_283066_(f_316210_).m_283059_(new RenderStateShard.TextureStateShard((ResourceLocation)p_316288_0_, false, false)).m_110685_(f_110139_).m_110671_(f_110152_).m_110663_(f_110111_).m_110687_(f_110115_).m_110691_(false)));
    private static final RenderType f_110387_ = RenderType.m_206136_("lightning", DefaultVertexFormat.f_85815_, VertexFormat.Mode.QUADS, 256, false, true, CompositeState.m_110628_().m_283066_(f_282777_).m_110687_(f_110114_).m_110685_(f_110136_).m_110675_(f_110127_).m_110691_(false));
    private static final RenderType f_110388_ = RenderType.m_206136_("tripwire", DefaultVertexFormat.f_85811_, VertexFormat.Mode.QUADS, 262144, true, true, RenderType.m_110409_());
    private static final RenderType f_282904_ = RenderType.m_206136_("end_portal", DefaultVertexFormat.f_85814_, VertexFormat.Mode.QUADS, 256, false, false, CompositeState.m_110628_().m_283066_(f_282779_).m_283059_(RenderStateShard.MultiTextureStateShard.m_282848_().m_282853_(TheEndPortalRenderer.f_112626_, false, false).m_282853_(TheEndPortalRenderer.f_112627_, false, false).m_282852_()).m_110691_(false));
    private static final RenderType f_282905_ = RenderType.m_206136_("end_gateway", DefaultVertexFormat.f_85814_, VertexFormat.Mode.QUADS, 256, false, false, CompositeState.m_110628_().m_283066_(f_282780_).m_283059_(RenderStateShard.MultiTextureStateShard.m_282848_().m_282853_(TheEndPortalRenderer.f_112626_, false, false).m_282853_(TheEndPortalRenderer.f_112627_, false, false).m_282852_()).m_110691_(false));
    public static final CompositeRenderType f_110371_ = RenderType.m_206130_("lines", DefaultVertexFormat.f_268509_, VertexFormat.Mode.LINES, 256, CompositeState.m_110628_().m_283066_(f_282781_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.empty())).m_110669_(f_110119_).m_110685_(f_110139_).m_110675_(f_110129_).m_110687_(f_110114_).m_110661_(f_110110_).m_110691_(false));
    public static final CompositeRenderType f_282903_ = RenderType.m_206130_("line_strip", DefaultVertexFormat.f_268509_, VertexFormat.Mode.LINE_STRIP, 256, CompositeState.m_110628_().m_283066_(f_282781_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.empty())).m_110669_(f_110119_).m_110685_(f_110139_).m_110675_(f_110129_).m_110687_(f_110114_).m_110661_(f_110110_).m_110691_(false));
    private final VertexFormat f_110389_;
    private final VertexFormat.Mode f_110390_;
    private final int f_110391_;
    private final boolean f_110392_;
    private final boolean f_110393_;
    private final Optional<RenderType> f_110394_;
    private int id = -1;
    public static final RenderType[] CHUNK_RENDER_TYPES = RenderType.getChunkRenderTypesArray();
    private static Map<CompoundKey, RenderType> RENDER_TYPES;

    public int ordinal() {
        return this.id;
    }

    public boolean isNeedsSorting() {
        return this.f_110393_;
    }

    private static RenderType[] getChunkRenderTypesArray() {
        RenderType[] renderTypes = RenderType.m_110506_().toArray(new RenderType[0]);
        int i = 0;
        while (i < renderTypes.length) {
            RenderType renderType = renderTypes[i];
            renderType.id = i++;
        }
        return renderTypes;
    }

    public static RenderType m_110451_() {
        return f_110372_;
    }

    public static RenderType m_110457_() {
        return f_110373_;
    }

    public static RenderType m_110463_() {
        return f_110374_;
    }

    private static CompositeState m_282918_(RenderStateShard.ShaderStateShard shardIn) {
        return CompositeState.m_110628_().m_110671_(f_110152_).m_283066_(shardIn).m_283059_(f_110145_).m_110685_(f_110139_).m_110675_(f_110125_).m_110691_(true);
    }

    public static RenderType m_110466_() {
        return f_110375_;
    }

    private static CompositeState m_110408_() {
        return CompositeState.m_110628_().m_110671_(f_110152_).m_283066_(f_282795_).m_283059_(f_110145_).m_110685_(f_110139_).m_110675_(f_110129_).m_110691_(true);
    }

    public static RenderType m_110469_() {
        return f_110376_;
    }

    public static RenderType m_110472_() {
        return f_110377_;
    }

    public static RenderType m_110431_(ResourceLocation locationIn) {
        locationIn = RenderType.getCustomTexture(locationIn);
        return f_316218_.apply(locationIn);
    }

    public static RenderType m_110446_(ResourceLocation locationIn) {
        locationIn = RenderType.getCustomTexture(locationIn);
        return f_316219_.apply(locationIn);
    }

    public static RenderType m_110452_(ResourceLocation locationIn) {
        locationIn = RenderType.getCustomTexture(locationIn);
        return f_316220_.apply(locationIn);
    }

    public static RenderType m_110443_(ResourceLocation locationIn, boolean outlineIn) {
        locationIn = RenderType.getCustomTexture(locationIn);
        return f_316223_.apply(locationIn, outlineIn);
    }

    public static RenderType m_110458_(ResourceLocation locationIn) {
        return RenderType.m_110443_(locationIn, true);
    }

    public static RenderType m_110448_(ResourceLocation locationIn, boolean outlineIn) {
        locationIn = RenderType.getCustomTexture(locationIn);
        return f_316224_.apply(locationIn, outlineIn);
    }

    public static RenderType m_110464_(ResourceLocation locationIn) {
        return RenderType.m_110448_(locationIn, true);
    }

    public static RenderType m_110467_(ResourceLocation locationIn) {
        locationIn = RenderType.getCustomTexture(locationIn);
        return f_316225_.apply(locationIn);
    }

    public static RenderType m_110470_(ResourceLocation locationIn) {
        locationIn = RenderType.getCustomTexture(locationIn);
        return f_316226_.apply(locationIn);
    }

    public static RenderType m_110454_(ResourceLocation locationIn, boolean outlineIn) {
        locationIn = RenderType.getCustomTexture(locationIn);
        return f_316227_.apply(locationIn, outlineIn);
    }

    public static RenderType m_110473_(ResourceLocation locationIn) {
        return RenderType.m_110454_(locationIn, true);
    }

    public static RenderType m_110476_(ResourceLocation locationIn) {
        locationIn = RenderType.getCustomTexture(locationIn);
        return f_316228_.apply(locationIn);
    }

    public static RenderType m_110460_(ResourceLocation locationIn, boolean colorFlagIn) {
        locationIn = RenderType.getCustomTexture(locationIn);
        return f_316229_.apply(locationIn, colorFlagIn);
    }

    public static RenderType m_110479_(ResourceLocation locationIn) {
        locationIn = RenderType.getCustomTexture(locationIn);
        return f_316230_.apply(locationIn);
    }

    public static RenderType m_110482_(ResourceLocation locationIn) {
        locationIn = RenderType.getCustomTexture(locationIn);
        return f_316231_.apply(locationIn);
    }

    public static RenderType m_110485_(ResourceLocation locationIn) {
        locationIn = RenderType.getCustomTexture(locationIn);
        return f_316232_.apply(locationIn);
    }

    public static RenderType m_282959_(ResourceLocation locationIn) {
        locationIn = RenderType.getCustomTexture(locationIn);
        return f_316233_.apply(locationIn);
    }

    public static RenderType m_110488_(ResourceLocation locationIn) {
        locationIn = RenderType.getCustomTexture(locationIn);
        return f_316234_.apply(locationIn);
    }

    public static RenderType m_110436_(ResourceLocation locationIn, float uIn, float vIn) {
        locationIn = RenderType.getCustomTexture(locationIn);
        return RenderType.m_206136_("energy_swirl", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, false, true, CompositeState.m_110628_().m_283066_(f_282763_).m_283059_(new RenderStateShard.TextureStateShard(locationIn, false, false)).m_110683_(new RenderStateShard.OffsetTexturingStateShard(uIn, vIn)).m_110685_(f_110135_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(false));
    }

    public static RenderType m_110475_() {
        return f_110378_;
    }

    public static RenderType m_110478_() {
        return f_110379_;
    }

    public static RenderType m_110491_(ResourceLocation locationIn) {
        locationIn = RenderType.getCustomTexture(locationIn);
        return CompositeRenderType.f_316296_.apply(locationIn, f_110110_);
    }

    public static RenderType m_110481_() {
        return f_110380_;
    }

    public static RenderType m_110484_() {
        return f_110381_;
    }

    public static RenderType m_110487_() {
        return f_110382_;
    }

    public static RenderType m_110490_() {
        return f_110383_;
    }

    public static RenderType m_110493_() {
        return f_110384_;
    }

    public static RenderType m_110496_() {
        return f_110385_;
    }

    public static RenderType m_110499_() {
        return f_110386_;
    }

    public static RenderType m_110494_(ResourceLocation locationIn) {
        locationIn = RenderType.getCustomTexture(locationIn);
        return f_316235_.apply(locationIn);
    }

    public static RenderType m_110497_(ResourceLocation locationIn) {
        return f_316236_.apply(locationIn);
    }

    public static RenderType m_316280_(ResourceLocation locationIn) {
        return f_316237_.apply(locationIn);
    }

    public static RenderType m_316282_(ResourceLocation locationIn) {
        return f_316238_.apply(locationIn);
    }

    public static RenderType m_316284_(ResourceLocation locationIn) {
        return f_316239_.apply(locationIn);
    }

    public static RenderType m_110500_(ResourceLocation locationIn) {
        return f_316221_.apply(locationIn);
    }

    public static RenderType m_316286_(ResourceLocation locationIn) {
        return f_316222_.apply(locationIn);
    }

    public static RenderType m_110502_() {
        return f_110387_;
    }

    private static CompositeState m_110409_() {
        return CompositeState.m_110628_().m_110671_(f_110152_).m_283066_(f_282778_).m_283059_(f_110145_).m_110685_(f_110139_).m_110675_(f_110127_).m_110691_(true);
    }

    public static RenderType m_110503_() {
        return f_110388_;
    }

    public static RenderType m_282966_() {
        return f_282904_;
    }

    public static RenderType m_282967_() {
        return f_282905_;
    }

    public static RenderType m_110504_() {
        return f_110371_;
    }

    public static RenderType m_282968_() {
        return f_282903_;
    }

    public RenderType(String nameIn, VertexFormat formatIn, VertexFormat.Mode drawModeIn, int bufferSizeIn, boolean useDelegateIn, boolean needsSortingIn, Runnable setupTaskIn, Runnable clearTaskIn) {
        super(nameIn, setupTaskIn, clearTaskIn);
        this.f_110389_ = formatIn;
        this.f_110390_ = drawModeIn;
        this.f_110391_ = bufferSizeIn;
        this.f_110392_ = useDelegateIn;
        this.f_110393_ = needsSortingIn;
        this.f_110394_ = Optional.of(this);
    }

    static CompositeRenderType m_206130_(String nameIn, VertexFormat vertexFormatIn, VertexFormat.Mode drawModeIn, int bufferSizeIn, CompositeState renderStateIn) {
        return RenderType.m_206136_(nameIn, vertexFormatIn, drawModeIn, bufferSizeIn, false, false, renderStateIn);
    }

    static CompositeRenderType m_206136_(String name, VertexFormat vertexFormatIn, VertexFormat.Mode glMode, int bufferSizeIn, boolean useDelegateIn, boolean needsSortingIn, CompositeState renderStateIn) {
        return new CompositeRenderType(name, vertexFormatIn, glMode, bufferSizeIn, useDelegateIn, needsSortingIn, renderStateIn);
    }

    public void m_110412_(BufferBuilder bufferIn, int cameraX, int cameraY, int cameraZ) {
        if (bufferIn.m_85732_()) {
            if (this.f_110393_) {
                bufferIn.m_190426_(cameraX, cameraY, cameraZ);
            }
            if (bufferIn.animatedSprites != null) {
                SmartAnimations.spritesRendered(bufferIn.animatedSprites);
            }
            bufferIn.m_85721_();
            this.m_110185_();
            if (Config.isShaders()) {
                RenderUtils.setFlushRenderBuffers(false);
                Shaders.pushProgram();
                ShadersRender.preRender((RenderType)this, (BufferBuilder)bufferIn);
            }
            BufferUploader.m_85761_(bufferIn);
            if (Config.isShaders()) {
                ShadersRender.postRender((RenderType)this, (BufferBuilder)bufferIn);
                Shaders.popProgram();
                RenderUtils.setFlushRenderBuffers(true);
            }
            this.m_110188_();
        }
    }

    @Override
    public String toString() {
        return this.f_110133_;
    }

    public static List<RenderType> m_110506_() {
        return ImmutableList.of((Object)RenderType.m_110451_(), (Object)RenderType.m_110457_(), (Object)RenderType.m_110463_(), (Object)RenderType.m_110466_(), (Object)RenderType.m_110503_());
    }

    public int m_110507_() {
        return this.f_110391_;
    }

    public VertexFormat m_110508_() {
        return this.f_110389_;
    }

    public VertexFormat.Mode m_206176_() {
        return this.f_110390_;
    }

    public Optional<RenderType> m_7280_() {
        return Optional.empty();
    }

    public boolean m_5492_() {
        return false;
    }

    public boolean m_110405_() {
        return this.f_110392_;
    }

    public Optional<RenderType> m_110406_() {
        return this.f_110394_;
    }

    public static ResourceLocation getCustomTexture(ResourceLocation locationIn) {
        if (Config.isRandomEntities()) {
            locationIn = RandomEntities.getTextureLocation((ResourceLocation)locationIn);
        }
        if (EmissiveTextures.isActive()) {
            locationIn = EmissiveTextures.getEmissiveTexture((ResourceLocation)locationIn);
        }
        return locationIn;
    }

    public boolean isEntitySolid() {
        return this.getName().equals("entity_solid");
    }

    public static int getCountRenderStates() {
        return ((CompositeRenderType)RenderType.f_110371_).f_110511_.f_110592_.size();
    }

    public ResourceLocation getTextureLocation() {
        return null;
    }

    public boolean isGlint() {
        return this.getTextureLocation() == ItemRenderer.f_115092_;
    }

    static enum OutlineProperty {
        NONE("none"),
        IS_OUTLINE("is_outline"),
        AFFECTS_OUTLINE("affects_outline");

        private final String f_110696_;

        private OutlineProperty(String nameIn) {
            this.f_110696_ = nameIn;
        }

        public String toString() {
            return this.f_110696_;
        }
    }

    protected static final class CompositeState {
        final RenderStateShard.EmptyTextureStateShard f_110576_;
        private final RenderStateShard.ShaderStateShard f_283017_;
        private final RenderStateShard.TransparencyStateShard f_110577_;
        private final RenderStateShard.DepthTestStateShard f_110581_;
        final RenderStateShard.CullStateShard f_110582_;
        private final RenderStateShard.LightmapStateShard f_110583_;
        private final RenderStateShard.OverlayStateShard f_110584_;
        private final RenderStateShard.LayeringStateShard f_110586_;
        private final RenderStateShard.OutputStateShard f_110587_;
        private final RenderStateShard.TexturingStateShard f_110588_;
        private final RenderStateShard.WriteMaskStateShard f_110589_;
        private final RenderStateShard.LineStateShard f_110590_;
        final OutlineProperty f_110591_;
        final ImmutableList<RenderStateShard> f_110592_;

        CompositeState(RenderStateShard.EmptyTextureStateShard textureIn, RenderStateShard.ShaderStateShard shaderStateIn, RenderStateShard.TransparencyStateShard transparencyIn, RenderStateShard.DepthTestStateShard depthTestIn, RenderStateShard.CullStateShard cullIn, RenderStateShard.LightmapStateShard lightmapIn, RenderStateShard.OverlayStateShard overlayIn, RenderStateShard.LayeringStateShard layerIn, RenderStateShard.OutputStateShard targetIn, RenderStateShard.TexturingStateShard texturingIn, RenderStateShard.WriteMaskStateShard writeMaskIn, RenderStateShard.LineStateShard lineIn, OutlineProperty outlineIn) {
            this.f_110576_ = textureIn;
            this.f_283017_ = shaderStateIn;
            this.f_110577_ = transparencyIn;
            this.f_110581_ = depthTestIn;
            this.f_110582_ = cullIn;
            this.f_110583_ = lightmapIn;
            this.f_110584_ = overlayIn;
            this.f_110586_ = layerIn;
            this.f_110587_ = targetIn;
            this.f_110588_ = texturingIn;
            this.f_110589_ = writeMaskIn;
            this.f_110590_ = lineIn;
            this.f_110591_ = outlineIn;
            this.f_110592_ = ImmutableList.of((Object)this.f_110576_, (Object)this.f_283017_, (Object)this.f_110577_, (Object)this.f_110581_, (Object)this.f_110582_, (Object)this.f_110583_, (Object)this.f_110584_, (Object)this.f_110586_, (Object)this.f_110587_, (Object)this.f_110588_, (Object)this.f_110589_, (Object)this.f_110590_, (Object[])new RenderStateShard[0]);
        }

        public String toString() {
            return "CompositeState[" + this.f_110592_ + ", outlineProperty=" + (Object)((Object)this.f_110591_) + "]";
        }

        public static CompositeStateBuilder m_110628_() {
            return new CompositeStateBuilder();
        }

        public CompositeStateBuilder getCopyBuilder() {
            CompositeStateBuilder builder = new CompositeStateBuilder();
            builder.m_283059_(this.f_110576_);
            builder.m_283066_(this.f_283017_);
            builder.m_110685_(this.f_110577_);
            builder.m_110663_(this.f_110581_);
            builder.m_110661_(this.f_110582_);
            builder.m_110671_(this.f_110583_);
            builder.m_110677_(this.f_110584_);
            builder.m_110669_(this.f_110586_);
            builder.m_110675_(this.f_110587_);
            builder.m_110683_(this.f_110588_);
            builder.m_110687_(this.f_110589_);
            builder.m_110673_(this.f_110590_);
            return builder;
        }

        public static class CompositeStateBuilder {
            private RenderStateShard.EmptyTextureStateShard f_110641_ = RenderStateShard.f_110147_;
            private RenderStateShard.ShaderStateShard f_283055_ = RenderStateShard.f_282782_;
            private RenderStateShard.TransparencyStateShard f_110642_ = RenderStateShard.f_110134_;
            private RenderStateShard.DepthTestStateShard f_110646_ = RenderStateShard.f_110113_;
            private RenderStateShard.CullStateShard f_110647_ = RenderStateShard.f_110158_;
            private RenderStateShard.LightmapStateShard f_110648_ = RenderStateShard.f_110153_;
            private RenderStateShard.OverlayStateShard f_110649_ = RenderStateShard.f_110155_;
            private RenderStateShard.LayeringStateShard f_110651_ = RenderStateShard.f_110117_;
            private RenderStateShard.OutputStateShard f_110652_ = RenderStateShard.f_110123_;
            private RenderStateShard.TexturingStateShard f_110653_ = RenderStateShard.f_110148_;
            private RenderStateShard.WriteMaskStateShard f_110654_ = RenderStateShard.f_110114_;
            private RenderStateShard.LineStateShard f_110655_ = RenderStateShard.f_110130_;

            CompositeStateBuilder() {
            }

            public CompositeStateBuilder m_283059_(RenderStateShard.EmptyTextureStateShard textureIn) {
                this.f_110641_ = textureIn;
                return this;
            }

            public CompositeStateBuilder m_283066_(RenderStateShard.ShaderStateShard shaderStateIn) {
                this.f_283055_ = shaderStateIn;
                return this;
            }

            public CompositeStateBuilder m_110685_(RenderStateShard.TransparencyStateShard transparencyIn) {
                this.f_110642_ = transparencyIn;
                return this;
            }

            public CompositeStateBuilder m_110663_(RenderStateShard.DepthTestStateShard depthTestIn) {
                this.f_110646_ = depthTestIn;
                return this;
            }

            public CompositeStateBuilder m_110661_(RenderStateShard.CullStateShard cullIn) {
                this.f_110647_ = cullIn;
                return this;
            }

            public CompositeStateBuilder m_110671_(RenderStateShard.LightmapStateShard lightmapIn) {
                this.f_110648_ = lightmapIn;
                return this;
            }

            public CompositeStateBuilder m_110677_(RenderStateShard.OverlayStateShard overlayIn) {
                this.f_110649_ = overlayIn;
                return this;
            }

            public CompositeStateBuilder m_110669_(RenderStateShard.LayeringStateShard layerIn) {
                this.f_110651_ = layerIn;
                return this;
            }

            public CompositeStateBuilder m_110675_(RenderStateShard.OutputStateShard targetIn) {
                this.f_110652_ = targetIn;
                return this;
            }

            public CompositeStateBuilder m_110683_(RenderStateShard.TexturingStateShard texturingIn) {
                this.f_110653_ = texturingIn;
                return this;
            }

            public CompositeStateBuilder m_110687_(RenderStateShard.WriteMaskStateShard writeMaskIn) {
                this.f_110654_ = writeMaskIn;
                return this;
            }

            public CompositeStateBuilder m_110673_(RenderStateShard.LineStateShard lineIn) {
                this.f_110655_ = lineIn;
                return this;
            }

            public CompositeState m_110691_(boolean outlineIn) {
                return this.m_110689_(outlineIn ? OutlineProperty.AFFECTS_OUTLINE : OutlineProperty.NONE);
            }

            public CompositeState m_110689_(OutlineProperty outlineStateIn) {
                return new CompositeState(this.f_110641_, this.f_283055_, this.f_110642_, this.f_110646_, this.f_110647_, this.f_110648_, this.f_110649_, this.f_110651_, this.f_110652_, this.f_110653_, this.f_110654_, this.f_110655_, outlineStateIn);
            }
        }
    }

    static final class CompositeRenderType
    extends RenderType {
        static final BiFunction<ResourceLocation, RenderStateShard.CullStateShard, RenderType> f_316296_ = Util.m_300600_((p_316303_0_, p_316303_1_) -> RenderType.m_206130_("outline", DefaultVertexFormat.f_85818_, VertexFormat.Mode.QUADS, 256, CompositeState.m_110628_().m_283066_(f_282766_).m_283059_(new RenderStateShard.TextureStateShard((ResourceLocation)p_316303_0_, false, false)).m_110661_((RenderStateShard.CullStateShard)p_316303_1_).m_110663_(f_110111_).m_110675_(f_110124_).m_110689_(OutlineProperty.IS_OUTLINE)));
        private final CompositeState f_110511_;
        private final Optional<RenderType> f_110513_;
        private final boolean f_110514_;
        private Map<ResourceLocation, CompositeRenderType> mapTextured = new HashMap<ResourceLocation, CompositeRenderType>();

        CompositeRenderType(String name, VertexFormat vertexFormatIn, VertexFormat.Mode glMode, int bufferSizeIn, boolean useDelegateIn, boolean needsSortingIn, CompositeState renderStateIn) {
            super(name, vertexFormatIn, glMode, bufferSizeIn, useDelegateIn, needsSortingIn, () -> RenderStateManager.setupRenderStates(renderStateIn.f_110592_), () -> RenderStateManager.clearRenderStates(renderStateIn.f_110592_));
            this.f_110511_ = renderStateIn;
            this.f_110513_ = renderStateIn.f_110591_ == OutlineProperty.AFFECTS_OUTLINE ? renderStateIn.f_110576_.m_223863_().map(locationIn -> f_316296_.apply((ResourceLocation)locationIn, renderStateIn.f_110582_)) : Optional.empty();
            this.f_110514_ = renderStateIn.f_110591_ == OutlineProperty.IS_OUTLINE;
        }

        @Override
        public Optional<RenderType> m_7280_() {
            return this.f_110513_;
        }

        @Override
        public boolean m_5492_() {
            return this.f_110514_;
        }

        protected final CompositeState m_316297_() {
            return this.f_110511_;
        }

        @Override
        public String toString() {
            return "" + this.f_110133_ + ":RenderType[" + this.f_110133_ + ":" + this.f_110511_ + "]";
        }

        public CompositeRenderType getTextured(ResourceLocation textureLocation) {
            if (textureLocation == null) {
                return this;
            }
            Optional<ResourceLocation> optLoc = this.f_110511_.f_110576_.m_223863_();
            if (!optLoc.isPresent()) {
                return this;
            }
            ResourceLocation loc = optLoc.get();
            if (loc == null) {
                return this;
            }
            if (textureLocation.equals(loc)) {
                return this;
            }
            CompositeRenderType typeTex = this.mapTextured.get(textureLocation);
            if (typeTex == null) {
                CompositeState.CompositeStateBuilder builderTex = this.f_110511_.getCopyBuilder();
                builderTex.m_283059_(new RenderStateShard.TextureStateShard(textureLocation, this.f_110511_.f_110576_.isBlur(), this.f_110511_.f_110576_.isMipmap()));
                CompositeState stateTex = builderTex.m_110691_(this.f_110514_);
                typeTex = CompositeRenderType.m_206136_(this.f_110133_, this.m_110508_(), this.m_206176_(), this.m_110507_(), this.m_110405_(), this.isNeedsSorting(), stateTex);
                this.mapTextured.put(textureLocation, typeTex);
            }
            return typeTex;
        }

        @Override
        public ResourceLocation getTextureLocation() {
            Optional<ResourceLocation> optLoc = this.f_110511_.f_110576_.m_223863_();
            if (!optLoc.isPresent()) {
                return null;
            }
            return optLoc.get();
        }
    }
}

