/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.optifine.render.VertexBuilderDummy;
import net.optifine.util.TextureUtils;

public interface MultiBufferSource {
    public static BufferSource m_109898_(BufferBuilder builderIn) {
        return MultiBufferSource.m_109900_((Map<RenderType, BufferBuilder>)ImmutableMap.of(), builderIn);
    }

    public static BufferSource m_109900_(Map<RenderType, BufferBuilder> mapBuildersIn, BufferBuilder builderIn) {
        return new BufferSource(builderIn, mapBuildersIn);
    }

    public VertexConsumer m_6299_(RenderType var1);

    default public void flushRenderBuffers() {
    }

    public static class BufferSource
    implements MultiBufferSource {
        protected final BufferBuilder f_109904_;
        protected final Map<RenderType, BufferBuilder> f_109905_;
        protected RenderType f_109906_ = null;
        protected final Set<BufferBuilder> f_109907_ = Sets.newIdentityHashSet();
        private final VertexConsumer DUMMY_BUFFER = new VertexBuilderDummy(this);

        protected BufferSource(BufferBuilder bufferIn, Map<RenderType, BufferBuilder> fixedBuffersIn) {
            this.f_109904_ = bufferIn;
            this.f_109905_ = fixedBuffersIn;
            this.f_109904_.setRenderTypeBuffer(this);
            for (BufferBuilder bb : fixedBuffersIn.values()) {
                bb.setRenderTypeBuffer(this);
            }
        }

        @Override
        public VertexConsumer m_6299_(RenderType renderTypeIn) {
            BufferBuilder bufferbuilder = this.m_109914_(renderTypeIn);
            if (!Objects.equals(this.f_109906_, renderTypeIn)) {
                RenderType rendertype;
                if (this.f_109906_ != null && !this.f_109905_.containsKey(rendertype = this.f_109906_)) {
                    this.m_109912_(rendertype);
                }
                if (this.f_109907_.add(bufferbuilder)) {
                    bufferbuilder.setRenderType(renderTypeIn);
                    bufferbuilder.m_190458_(renderTypeIn.m_206176_(), renderTypeIn.m_110508_());
                }
                this.f_109906_ = renderTypeIn;
            }
            if (renderTypeIn.getTextureLocation() == TextureUtils.LOCATION_TEXTURE_EMPTY) {
                return this.DUMMY_BUFFER;
            }
            return bufferbuilder;
        }

        private BufferBuilder m_109914_(RenderType renderTypeIn) {
            return this.f_109905_.getOrDefault(renderTypeIn, this.f_109904_);
        }

        public void m_316188_() {
            if (this.f_109906_ != null) {
                RenderType rendertype = this.f_109906_;
                if (!this.f_109905_.containsKey(rendertype)) {
                    this.m_109912_(rendertype);
                }
                this.f_109906_ = null;
            }
        }

        public void m_109911_() {
            VertexConsumer vertexconsumer;
            if (this.f_109907_.isEmpty()) {
                return;
            }
            if (this.f_109906_ != null && (vertexconsumer = this.m_6299_(this.f_109906_)) == this.f_109904_) {
                this.m_109912_(this.f_109906_);
            }
            if (this.f_109907_.isEmpty()) {
                return;
            }
            for (RenderType rendertype : this.f_109905_.keySet()) {
                this.m_109912_(rendertype);
                if (!this.f_109907_.isEmpty()) continue;
                break;
            }
        }

        public void m_109912_(RenderType renderTypeIn) {
            BufferBuilder bufferbuilder = this.m_109914_(renderTypeIn);
            boolean flag = Objects.equals(this.f_109906_, renderTypeIn);
            if ((flag || bufferbuilder != this.f_109904_) && this.f_109907_.remove((Object)bufferbuilder)) {
                renderTypeIn.m_110412_(bufferbuilder, 0, 0, 0);
                if (flag) {
                    this.f_109906_ = null;
                }
            }
        }

        public VertexConsumer getBuffer(ResourceLocation textureLocation, VertexConsumer def) {
            if (!(this.f_109906_ instanceof RenderType.CompositeRenderType)) {
                return def;
            }
            textureLocation = RenderType.getCustomTexture(textureLocation);
            RenderType.CompositeRenderType type = (RenderType.CompositeRenderType)this.f_109906_;
            RenderType.CompositeRenderType typeTex = type.getTextured(textureLocation);
            VertexConsumer buffer = this.m_6299_(typeTex);
            return buffer;
        }

        public RenderType getLastRenderType() {
            return this.f_109906_;
        }

        @Override
        public void flushRenderBuffers() {
            RenderType oldRenderType = this.f_109906_;
            this.m_109911_();
            if (oldRenderType != null) {
                this.m_6299_(oldRenderType);
            }
        }

        public VertexConsumer getDummyBuffer() {
            return this.DUMMY_BUFFER;
        }
    }
}

