/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Option;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RunningTrimmedMean;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.ViewArea;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemFrameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.ICloudRenderHandler;
import net.minecraftforge.client.ISkyRenderHandler;
import net.minecraftforge.client.IWeatherParticleRenderHandler;
import net.minecraftforge.client.IWeatherRenderHandler;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.CustomSky;
import net.optifine.DynamicLights;
import net.optifine.Lagometer;
import net.optifine.SmartAnimations;
import net.optifine.entity.model.CustomEntityModels;
import net.optifine.reflect.Reflector;
import net.optifine.render.ChunkVisibility;
import net.optifine.render.RenderEnv;
import net.optifine.render.RenderStateManager;
import net.optifine.render.VboRegion;
import net.optifine.shaders.RenderStage;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersRender;
import net.optifine.shaders.ShadowUtils;
import net.optifine.util.BiomeUtils;
import net.optifine.util.MathUtils;
import net.optifine.util.PairInt;
import net.optifine.util.RenderChunkUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class LevelRenderer
implements ResourceManagerReloadListener,
AutoCloseable {
    private static final Logger f_109453_ = LogManager.getLogger();
    public static final int f_316090_ = 16;
    public static final int f_316091_ = 66;
    public static final int f_316092_ = 4356;
    private static final float f_316093_ = 512.0f;
    private static final int f_316094_ = 32;
    private static final int f_316095_ = 10;
    private static final int f_316096_ = 21;
    private static final int f_316097_ = 15;
    private static final ResourceLocation f_109454_ = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation f_109455_ = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation f_109456_ = new ResourceLocation("textures/environment/clouds.png");
    private static final ResourceLocation f_109457_ = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation f_109458_ = new ResourceLocation("textures/misc/forcefield.png");
    private static final ResourceLocation f_109459_ = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation f_109460_ = new ResourceLocation("textures/environment/snow.png");
    public static final Direction[] f_109434_ = Direction.values();
    private final Minecraft f_109461_;
    private final TextureManager f_109462_;
    private final EntityRenderDispatcher f_109463_;
    private final BlockEntityRenderDispatcher f_205636_;
    private final RenderBuffers f_109464_;
    private ClientLevel f_109465_;
    private Set<ChunkRenderDispatcher.RenderChunk> f_109466_ = new ObjectLinkedOpenHashSet();
    private ObjectArrayList<RenderChunkInfo> f_109467_ = new ObjectArrayList();
    private final Set<BlockEntity> f_109468_ = Sets.newHashSet();
    private ViewArea f_109469_;
    private RenderInfoMap f_316089_;
    @Nullable
    private VertexBuffer f_109471_;
    @Nullable
    private VertexBuffer f_109472_;
    @Nullable
    private VertexBuffer f_109473_;
    private boolean f_109474_ = true;
    @Nullable
    private VertexBuffer f_109475_;
    private final RunningTrimmedMean f_109476_ = new RunningTrimmedMean(100);
    private int f_109477_;
    private final Int2ObjectMap<BlockDestructionProgress> f_109408_ = new Int2ObjectOpenHashMap();
    private final Long2ObjectMap<SortedSet<BlockDestructionProgress>> f_109409_ = new Long2ObjectOpenHashMap();
    private final Map<BlockPos, SoundInstance> f_109410_ = Maps.newHashMap();
    @Nullable
    private RenderTarget f_109411_;
    @Nullable
    private PostChain f_109412_;
    @Nullable
    private RenderTarget f_109413_;
    @Nullable
    private RenderTarget f_109414_;
    @Nullable
    private RenderTarget f_109415_;
    @Nullable
    private RenderTarget f_109416_;
    @Nullable
    private RenderTarget f_109417_;
    @Nullable
    private PostChain f_109418_;
    private double f_109419_ = Double.MIN_VALUE;
    private double f_109420_ = Double.MIN_VALUE;
    private double f_109421_ = Double.MIN_VALUE;
    private int f_109422_ = Integer.MIN_VALUE;
    private int f_109423_ = Integer.MIN_VALUE;
    private int f_109424_ = Integer.MIN_VALUE;
    private double f_109425_ = Double.MIN_VALUE;
    private double f_109426_ = Double.MIN_VALUE;
    private double f_109427_ = Double.MIN_VALUE;
    private double f_109428_ = Double.MIN_VALUE;
    private double f_109429_ = Double.MIN_VALUE;
    private int f_109430_ = Integer.MIN_VALUE;
    private int f_109431_ = Integer.MIN_VALUE;
    private int f_109432_ = Integer.MIN_VALUE;
    private Vec3 f_109433_ = Vec3.f_82478_;
    private CloudStatus f_109435_;
    private ChunkRenderDispatcher f_109436_;
    private int f_109438_ = -1;
    private int f_109439_;
    private int f_109440_;
    private Frustum f_205635_;
    private boolean f_109441_;
    @Nullable
    private Frustum f_109442_;
    private final Vector4f[] f_109443_ = new Vector4f[8];
    private final Vector3d f_109444_ = new Vector3d(0.0, 0.0, 0.0);
    private double f_109445_;
    private double f_109446_;
    private double f_109447_;
    private boolean f_109448_ = true;
    private int f_109449_;
    private int f_109450_;
    private final float[] f_109451_ = new float[1024];
    private final float[] f_109452_ = new float[1024];
    public Entity renderedEntity;
    public Set chunksToResortTransparency = new LinkedHashSet();
    public Set chunksToUpdateForced = new LinkedHashSet();
    private Set<ChunkRenderDispatcher.RenderChunk> chunksToUpdatePrev = new ObjectLinkedOpenHashSet();
    private Deque visibilityDeque = new ArrayDeque();
    private LongOpenHashSet renderInfosEntities = new LongOpenHashSet(1024);
    private List<RenderChunkInfo> renderInfosTileEntities = new ArrayList<RenderChunkInfo>(1024);
    private ObjectArrayList renderInfosNormal = new ObjectArrayList(1024);
    private LongOpenHashSet renderInfosEntitiesNormal = new LongOpenHashSet(1024);
    private List renderInfosTileEntitiesNormal = new ArrayList(1024);
    private ObjectArrayList renderInfosShadow = new ObjectArrayList(1024);
    private LongOpenHashSet renderInfosEntitiesShadow = new LongOpenHashSet(1024);
    private List renderInfosTileEntitiesShadow = new ArrayList(1024);
    private int renderDistance = 0;
    private int renderDistanceSq = 0;
    private static final Set SET_ALL_FACINGS = Collections.unmodifiableSet(new HashSet<Direction>(Arrays.asList(Direction.f_122346_)));
    private int countTileEntitiesRendered;
    private int countLoadedChunksPrev = 0;
    private RenderEnv renderEnv = new RenderEnv(Blocks.f_50016_.m_49966_(), new BlockPos(0, 0, 0));
    public boolean renderOverlayDamaged = false;
    public boolean renderOverlayEyes = false;
    private boolean firstWorldLoad = false;
    private static int renderEntitiesCounter = 0;
    public int loadVisibleChunksCounter = -1;
    public static final int loadVisibleChunksMessageId = 201435902;
    private static boolean ambientOcclusion = false;
    private Map<String, List<Entity>> mapEntityLists = new HashMap<String, List<Entity>>();
    private Map<RenderType, Map> mapRegionLayers = new LinkedHashMap<RenderType, Map>();

    public LevelRenderer(Minecraft mcIn, RenderBuffers rainTimeBuffersIn) {
        this.f_109461_ = mcIn;
        this.f_109463_ = mcIn.m_91290_();
        this.f_205636_ = mcIn.m_193404_();
        this.f_109464_ = rainTimeBuffersIn;
        this.f_109462_ = mcIn.m_91097_();
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = Mth.m_14116_(f * f + f1 * f1);
                this.f_109451_[i << 5 | j] = -f1 / f2;
                this.f_109452_[i << 5 | j] = f / f2;
            }
        }
        this.m_109837_();
        this.m_109836_();
        this.m_109835_();
    }

    private void m_109703_(LightTexture lightmapIn, float partialTicks, double xIn, double yIn, double zIn) {
        IWeatherRenderHandler renderHandler;
        if (Reflector.ForgeDimensionRenderInfo_getWeatherRenderHandler.exists() && (renderHandler = (IWeatherRenderHandler)Reflector.call(this.f_109465_.m_104583_(), Reflector.ForgeDimensionRenderInfo_getWeatherRenderHandler, new Object[0])) != null) {
            renderHandler.render(this.f_109477_, partialTicks, this.f_109465_, this.f_109461_, lightmapIn, xIn, yIn, zIn);
            return;
        }
        float f = this.f_109461_.f_91073_.m_46722_(partialTicks);
        if (!(f <= 0.0f)) {
            if (Config.isRainOff()) {
                return;
            }
            lightmapIn.m_109896_();
            ClientLevel level = this.f_109461_.f_91073_;
            int i = Mth.m_14107_(xIn);
            int j = Mth.m_14107_(yIn);
            int k = Mth.m_14107_(zIn);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            RenderSystem.m_69464_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            int l = 5;
            if (Config.isRainFancy()) {
                l = 10;
            }
            RenderSystem.m_69458_((boolean)Minecraft.m_91085_());
            int i1 = -1;
            float f1 = (float)this.f_109477_ + partialTicks;
            RenderSystem.m_256236_(GameRenderer::m_282220_);
            RenderSystem.m_256242_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int j1 = k - l; j1 <= k + l; ++j1) {
                for (int k1 = i - l; k1 <= i + l; ++k1) {
                    int l1 = (j1 - k + 16) * 32 + k1 - i + 16;
                    double d0 = (double)this.f_109451_[l1] * 0.5;
                    double d1 = (double)this.f_109452_[l1] * 0.5;
                    blockpos$mutableblockpos.m_122178_(k1, 0, j1);
                    Biome biome = level.m_46857_((BlockPos)blockpos$mutableblockpos);
                    if (biome.m_47530_() == Biome.Precipitation.NONE) continue;
                    int i2 = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, (BlockPos)blockpos$mutableblockpos).m_123342_();
                    int j2 = j - l;
                    int k2 = j + l;
                    if (j2 < i2) {
                        j2 = i2;
                    }
                    if (k2 < i2) {
                        k2 = i2;
                    }
                    int l2 = i2;
                    if (i2 < j) {
                        l2 = j;
                    }
                    if (j2 == k2) continue;
                    Random random = new Random(k1 * k1 * 3121 + k1 * 45238971 ^ j1 * j1 * 418711 + j1 * 13761);
                    blockpos$mutableblockpos.m_122178_(k1, j2, j1);
                    float f2 = biome.m_47505_((BlockPos)blockpos$mutableblockpos);
                    if (f2 >= 0.15f) {
                        if (i1 != 0) {
                            if (i1 >= 0) {
                                tesselator.m_85914_();
                            }
                            i1 = 0;
                            RenderSystem.m_256269_((int)0, (ResourceLocation)f_109459_);
                            bufferbuilder.m_190458_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                        }
                        int i3 = this.f_109477_ + k1 * k1 * 3121 + k1 * 45238971 + j1 * j1 * 418711 + j1 * 13761 & 0x1F;
                        float f3 = -((float)i3 + partialTicks) / 32.0f * (3.0f + random.nextFloat());
                        double d2 = (double)k1 + 0.5 - xIn;
                        double d4 = (double)j1 + 0.5 - zIn;
                        float f4 = (float)Math.sqrt(d2 * d2 + d4 * d4) / (float)l;
                        float f5 = ((1.0f - f4 * f4) * 0.5f + 0.5f) * f;
                        blockpos$mutableblockpos.m_122178_(k1, l2, j1);
                        int j3 = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                        bufferbuilder.m_5483_((double)k1 - xIn - d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn - d1 + 0.5).m_7421_(0.0f, (float)j2 * 0.25f + f3).m_85950_(1.0f, 1.0f, 1.0f, f5).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - xIn + d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn + d1 + 0.5).m_7421_(1.0f, (float)j2 * 0.25f + f3).m_85950_(1.0f, 1.0f, 1.0f, f5).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - xIn + d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn + d1 + 0.5).m_7421_(1.0f, (float)k2 * 0.25f + f3).m_85950_(1.0f, 1.0f, 1.0f, f5).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - xIn - d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn - d1 + 0.5).m_7421_(0.0f, (float)k2 * 0.25f + f3).m_85950_(1.0f, 1.0f, 1.0f, f5).m_85969_(j3).m_5752_();
                        continue;
                    }
                    if (i1 != 1) {
                        if (i1 >= 0) {
                            tesselator.m_85914_();
                        }
                        i1 = 1;
                        RenderSystem.m_256269_((int)0, (ResourceLocation)f_109460_);
                        bufferbuilder.m_190458_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                    }
                    float f6 = -((float)(this.f_109477_ & 0x1FF) + partialTicks) / 512.0f;
                    float f7 = (float)(random.nextDouble() + (double)f1 * 0.01 * (double)((float)random.nextGaussian()));
                    float f8 = (float)(random.nextDouble() + (double)(f1 * (float)random.nextGaussian()) * 0.001);
                    double d3 = (double)k1 + 0.5 - xIn;
                    double d5 = (double)j1 + 0.5 - zIn;
                    float f9 = (float)Math.sqrt(d3 * d3 + d5 * d5) / (float)l;
                    float f10 = ((1.0f - f9 * f9) * 0.3f + 0.5f) * f;
                    blockpos$mutableblockpos.m_122178_(k1, l2, j1);
                    int k3 = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                    int l3 = k3 >> 16 & 0xFFFF;
                    int i4 = k3 & 0xFFFF;
                    int j4 = (l3 * 3 + 240) / 4;
                    int k4 = (i4 * 3 + 240) / 4;
                    bufferbuilder.m_5483_((double)k1 - xIn - d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn - d1 + 0.5).m_7421_(0.0f + f7, (float)j2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                    bufferbuilder.m_5483_((double)k1 - xIn + d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn + d1 + 0.5).m_7421_(1.0f + f7, (float)j2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                    bufferbuilder.m_5483_((double)k1 - xIn + d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn + d1 + 0.5).m_7421_(1.0f + f7, (float)k2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                    bufferbuilder.m_5483_((double)k1 - xIn - d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn - d1 + 0.5).m_7421_(0.0f + f7, (float)k2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                }
            }
            if (i1 >= 0) {
                tesselator.m_85914_();
            }
            RenderSystem.m_69481_();
            RenderSystem.m_69461_();
            lightmapIn.m_109891_();
        }
    }

    public void m_109693_(Camera activeRenderInfoIn) {
        IWeatherParticleRenderHandler renderHandler;
        if (Reflector.ForgeDimensionRenderInfo_getWeatherParticleRenderHandler.exists() && (renderHandler = (IWeatherParticleRenderHandler)Reflector.call(this.f_109465_.m_104583_(), Reflector.ForgeDimensionRenderInfo_getWeatherParticleRenderHandler, new Object[0])) != null) {
            renderHandler.render(this.f_109477_, this.f_109465_, this.f_109461_, activeRenderInfoIn);
            return;
        }
        float f = this.f_109461_.f_91073_.m_46722_(1.0f) / (Minecraft.m_91405_() ? 1.0f : 2.0f);
        if (!Config.isRainFancy()) {
            f /= 2.0f;
        }
        if (!(f <= 0.0f) && Config.isRainSplash()) {
            Random random = new Random((long)this.f_109477_ * 312987231L);
            ClientLevel levelreader = this.f_109461_.f_91073_;
            BlockPos blockpos = new BlockPos(activeRenderInfoIn.m_90583_());
            BlockPos blockpos1 = null;
            int i = (int)(100.0f * f * f) / (this.f_109461_.f_91066_.f_92073_ == ParticleStatus.DECREASED ? 2 : 1);
            for (int j = 0; j < i; ++j) {
                int k = random.nextInt(21) - 10;
                int l = random.nextInt(21) - 10;
                BlockPos blockpos2 = levelreader.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockpos.m_224058_(k, 0, l)).m_7495_();
                Biome biome = levelreader.m_46857_(blockpos2);
                if (blockpos2.m_123342_() <= levelreader.m_141493_() || blockpos2.m_123342_() > blockpos.m_123342_() + 10 || blockpos2.m_123342_() < blockpos.m_123342_() - 10 || biome.m_47530_() != Biome.Precipitation.RAIN || !(biome.m_47505_(blockpos2) >= 0.15f)) continue;
                blockpos1 = blockpos2;
                if (this.f_109461_.f_91066_.f_92073_ == ParticleStatus.MINIMAL) break;
                double d0 = random.nextDouble();
                double d1 = random.nextDouble();
                BlockState blockstate = levelreader.m_8055_(blockpos2);
                FluidState fluidstate = levelreader.m_6425_(blockpos2);
                VoxelShape voxelshape = blockstate.m_60812_((BlockGetter)levelreader, blockpos2);
                double d2 = voxelshape.m_83290_(Direction.Axis.Y, d0, d1);
                double d3 = fluidstate.m_76155_((BlockGetter)levelreader, blockpos2);
                double d4 = Math.max(d2, d3);
                SimpleParticleType particleoptions = !fluidstate.m_76153_((Tag)FluidTags.f_13132_) && !blockstate.m_60713_(Blocks.f_50450_) && !CampfireBlock.m_51319_((BlockState)blockstate) ? ParticleTypes.f_123761_ : ParticleTypes.f_123762_;
                this.f_109461_.f_91073_.m_7106_((ParticleOptions)particleoptions, (double)blockpos2.m_123341_() + d0, (double)blockpos2.m_123342_() + d4, (double)blockpos2.m_123343_() + d1, 0.0, 0.0, 0.0);
            }
            if (blockpos1 != null && random.nextInt(3) < this.f_109450_++) {
                this.f_109450_ = 0;
                if (blockpos1.m_123342_() > blockpos.m_123342_() + 1 && levelreader.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockpos).m_123342_() > Mth.m_14143_(blockpos.m_123342_())) {
                    this.f_109461_.f_91073_.m_104677_(blockpos1, SoundEvents.f_12542_, SoundSource.WEATHER, 0.1f, 0.5f, false);
                } else {
                    this.f_109461_.f_91073_.m_104677_(blockpos1, SoundEvents.f_12541_, SoundSource.WEATHER, 0.2f, 1.0f, false);
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.f_109412_ != null) {
            this.f_109412_.close();
        }
        if (this.f_109418_ != null) {
            this.f_109418_.close();
        }
    }

    public void m_6213_(ResourceManager resourceManager) {
        this.m_109482_();
        if (Minecraft.m_91085_()) {
            this.m_109833_();
        }
    }

    public void m_109482_() {
        if (this.f_109412_ != null) {
            this.f_109412_.close();
        }
        ResourceLocation resourcelocation = new ResourceLocation("shaders/post/entity_outline.json");
        try {
            this.f_109412_ = new PostChain(this.f_109461_.m_91097_(), this.f_109461_.m_91098_(), this.f_109461_.m_91385_(), resourcelocation);
            this.f_109412_.m_110025_(this.f_109461_.m_91268_().m_85441_(), this.f_109461_.m_91268_().m_85442_());
            this.f_109411_ = this.f_109412_.m_110036_("final");
        }
        catch (IOException ioexception) {
            f_109453_.warn("Failed to load shader: {}", (Object)resourcelocation, (Object)ioexception);
            this.f_109412_ = null;
            this.f_109411_ = null;
        }
        catch (JsonSyntaxException jsonsyntaxexception) {
            f_109453_.warn("Failed to parse shader: {}", (Object)resourcelocation, (Object)jsonsyntaxexception);
            this.f_109412_ = null;
            this.f_109411_ = null;
        }
    }

    private void m_109833_() {
        this.m_109834_();
        ResourceLocation resourcelocation = new ResourceLocation("shaders/post/transparency.json");
        try {
            PostChain postchain = new PostChain(this.f_109461_.m_91097_(), this.f_109461_.m_91098_(), this.f_109461_.m_91385_(), resourcelocation);
            postchain.m_110025_(this.f_109461_.m_91268_().m_85441_(), this.f_109461_.m_91268_().m_85442_());
            RenderTarget rendertarget1 = postchain.m_110036_("translucent");
            RenderTarget rendertarget2 = postchain.m_110036_("itemEntity");
            RenderTarget rendertarget3 = postchain.m_110036_("particles");
            RenderTarget rendertarget4 = postchain.m_110036_("weather");
            RenderTarget rendertarget = postchain.m_110036_("clouds");
            this.f_109418_ = postchain;
            this.f_109413_ = rendertarget1;
            this.f_109414_ = rendertarget2;
            this.f_109415_ = rendertarget3;
            this.f_109416_ = rendertarget4;
            this.f_109417_ = rendertarget;
        }
        catch (Exception exception) {
            String s = exception instanceof JsonSyntaxException ? "parse" : "load";
            String s1 = "Failed to " + s + " shader: " + resourcelocation;
            TransparencyShaderException levelrenderer$transparencyshaderexception = new TransparencyShaderException(s1, exception);
            if (this.f_109461_.m_91099_().m_10523_().size() > 1) {
                TextComponent component;
                try {
                    component = new TextComponent(this.f_109461_.m_91098_().m_223800_(resourcelocation).m_7816_());
                }
                catch (IOException ioexception) {
                    component = null;
                }
                this.f_109461_.f_91066_.f_92115_ = GraphicsStatus.FANCY;
                this.f_109461_.m_91241_((Throwable)levelrenderer$transparencyshaderexception, (Component)component);
            }
            CrashReport crashreport = this.f_109461_.m_91354_(new CrashReport(s1, levelrenderer$transparencyshaderexception));
            this.f_109461_.f_91066_.f_92115_ = GraphicsStatus.FANCY;
            this.f_109461_.f_91066_.m_92169_();
            f_109453_.fatal(s1, (Throwable)levelrenderer$transparencyshaderexception);
            this.f_109461_.m_91394_();
            Minecraft.m_91332_((CrashReport)crashreport);
        }
    }

    private void m_109834_() {
        if (this.f_109418_ != null) {
            this.f_109418_.close();
            this.f_109413_.m_83930_();
            this.f_109414_.m_83930_();
            this.f_109415_.m_83930_();
            this.f_109416_.m_83930_();
            this.f_109417_.m_83930_();
            this.f_109418_ = null;
            this.f_109413_ = null;
            this.f_109414_ = null;
            this.f_109415_ = null;
            this.f_109416_ = null;
            this.f_109417_ = null;
        }
    }

    public void m_109769_() {
        if (this.m_109817_()) {
            RenderSystem.m_69478_();
            RenderSystem.m_69416_((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ZERO, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
            this.f_109411_.m_83957_(this.f_109461_.m_91268_().m_85441_(), this.f_109461_.m_91268_().m_85442_(), false);
            RenderSystem.m_69461_();
        }
    }

    public boolean m_109817_() {
        if (Config.isShaders() || Config.isAntialiasing()) {
            return false;
        }
        return !this.f_109461_.f_91063_.m_315925_() && this.f_109411_ != null && this.f_109412_ != null && this.f_109461_.f_91074_ != null;
    }

    private void m_109835_() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        if (this.f_109473_ != null) {
            this.f_109473_.close();
        }
        this.f_109473_ = new VertexBuffer();
        LevelRenderer.m_282417_(bufferbuilder, -16.0f);
        this.f_109473_.m_85925_(bufferbuilder);
    }

    private void m_109836_() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        if (this.f_109472_ != null) {
            this.f_109472_.close();
        }
        this.f_109472_ = new VertexBuffer();
        LevelRenderer.m_282417_(bufferbuilder, 16.0f);
        this.f_109472_.m_85925_(bufferbuilder);
    }

    private static void m_282417_(BufferBuilder bufferBuilderIn, float posY) {
        float f = Math.signum(posY) * 512.0f;
        float f1 = 512.0f;
        RenderSystem.m_256236_(GameRenderer::m_282213_);
        bufferBuilderIn.m_190458_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85814_);
        bufferBuilderIn.m_5483_(0.0, posY, 0.0).m_5752_();
        for (int i = -180; i <= 180; i += 45) {
            bufferBuilderIn.m_5483_(f * Mth.m_14089_((float)i * ((float)Math.PI / 180)), posY, 512.0f * Mth.m_14031_((float)i * ((float)Math.PI / 180))).m_5752_();
        }
        bufferBuilderIn.m_85721_();
    }

    private void m_109837_() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_256236_(GameRenderer::m_282213_);
        if (this.f_109471_ != null) {
            this.f_109471_.close();
        }
        this.f_109471_ = new VertexBuffer();
        this.m_109554_(bufferbuilder);
        bufferbuilder.m_85721_();
        this.f_109471_.m_85925_(bufferbuilder);
    }

    private void m_109554_(BufferBuilder bufferBuilderIn) {
        Random random = new Random(10842L);
        bufferBuilderIn.m_190458_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (int i = 0; i < 1500; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = 0.0;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                bufferBuilderIn.m_5483_(d5 + d25, d6 + d23, d7 + d26).m_5752_();
            }
        }
    }

    public void m_109701_(@Nullable ClientLevel worldClientIn) {
        this.f_109419_ = Double.MIN_VALUE;
        this.f_109420_ = Double.MIN_VALUE;
        this.f_109421_ = Double.MIN_VALUE;
        this.f_109422_ = Integer.MIN_VALUE;
        this.f_109423_ = Integer.MIN_VALUE;
        this.f_109424_ = Integer.MIN_VALUE;
        this.f_109463_.m_114406_(worldClientIn);
        this.f_109465_ = worldClientIn;
        if (Config.isDynamicLights()) {
            DynamicLights.clear();
        }
        ChunkVisibility.reset();
        this.renderEnv.reset(null, null);
        BiomeUtils.onWorldChanged((Level)this.f_109465_);
        Shaders.checkWorldChanged((ClientLevel)this.f_109465_);
        if (worldClientIn != null) {
            this.f_109467_.ensureCapacity(4356 * worldClientIn.m_163335_());
            this.m_109818_();
        } else {
            this.f_109466_.clear();
            this.chunksToUpdatePrev.clear();
            this.clearRenderInfos();
            if (this.f_109469_ != null) {
                this.f_109469_.m_110849_();
                this.f_109469_ = null;
            }
            if (this.f_109436_ != null) {
                this.f_109436_.m_112733_();
            }
            this.f_109436_ = null;
            this.f_109468_.clear();
        }
    }

    public void m_316159_() {
        if (Minecraft.m_91085_()) {
            this.m_109833_();
        } else {
            this.m_109834_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_109818_() {
        if (this.f_109465_ != null) {
            Entity entity;
            this.m_316159_();
            this.f_109465_.m_104810_();
            if (this.f_109436_ == null) {
                this.f_109436_ = new ChunkRenderDispatcher(this.f_109465_, this, Util.m_137578_(), this.f_109461_.m_91103_(), this.f_109464_.m_110098_());
            } else {
                this.f_109436_.m_112691_(this.f_109465_);
            }
            this.f_109448_ = true;
            this.f_109474_ = true;
            ItemBlockRenderTypes.m_109291_((boolean)Config.isTreesFancy());
            ModelBlockRenderer.updateAoLightValue();
            if (Config.isDynamicLights()) {
                DynamicLights.clear();
            }
            SmartAnimations.update();
            ambientOcclusion = Minecraft.m_91086_();
            this.f_109438_ = this.f_109461_.f_91066_.f_92106_;
            this.renderDistance = this.f_109438_ * 16;
            this.renderDistanceSq = this.renderDistance * this.renderDistance;
            if (this.f_109469_ != null) {
                this.f_109469_.m_110849_();
            }
            this.m_109819_();
            Set<BlockEntity> set = this.f_109468_;
            synchronized (set) {
                this.f_109468_.clear();
            }
            this.f_109469_ = new ViewArea(this.f_109436_, this.f_109465_, this.f_109461_.f_91066_.f_92106_, this);
            this.f_316089_ = new RenderInfoMap(this.f_109469_.f_110843_.length);
            if (this.f_109465_ != null && (entity = this.f_109461_.m_91288_()) != null) {
                this.f_109469_.m_110850_(entity.m_20185_(), entity.m_20189_());
            }
        }
        if (this.f_109461_.f_91074_ == null) {
            this.firstWorldLoad = true;
        }
    }

    protected void m_109819_() {
        this.f_109466_.clear();
        this.f_109436_.m_112731_();
    }

    public void m_109487_(int width, int height) {
        this.m_109826_();
        if (this.f_109412_ != null) {
            this.f_109412_.m_110025_(width, height);
        }
        if (this.f_109418_ != null) {
            this.f_109418_.m_110025_(width, height);
        }
    }

    public String m_109820_() {
        int i = this.f_109469_.f_110843_.length;
        int j = this.m_109821_();
        return String.format("C: %d/%d %sD: %d, %s", j, i, this.f_109461_.f_90980_ ? "(s) " : "", this.f_109438_, this.f_109436_ == null ? "null" : this.f_109436_.m_112719_());
    }

    public ChunkRenderDispatcher m_316160_() {
        return this.f_109436_;
    }

    public double m_316161_() {
        return this.f_109469_.f_110843_.length;
    }

    public double m_316162_() {
        return this.f_109438_;
    }

    public int m_109821_() {
        int i = 0;
        for (RenderChunkInfo levelrenderer$renderchunkinfo : this.f_109467_) {
            if (levelrenderer$renderchunkinfo.f_109839_.m_112835_().m_112757_()) continue;
            ++i;
        }
        return i;
    }

    public String m_109822_() {
        return "E: " + this.f_109439_ + "/" + this.f_109465_.m_104813_() + ", B: " + this.f_109440_ + ", " + Config.getVersionDebug();
    }

    public void m_109695_(Camera activeRenderInfoIn, Frustum camera, boolean debugCamera, int frameCount, boolean playerSpectator) {
        EntitySectionStorage entitySectionStorage;
        int maxWorldY;
        Vec3 vec3 = activeRenderInfoIn.m_90583_();
        if (this.f_109461_.f_91066_.f_92106_ != this.f_109438_) {
            this.m_109818_();
        }
        this.f_109465_.m_46473_().m_6180_("camera");
        double d0 = this.f_109461_.f_91074_.m_20185_();
        double d1 = this.f_109461_.f_91074_.m_20186_();
        double d2 = this.f_109461_.f_91074_.m_20189_();
        double d3 = d0 - this.f_109419_;
        double d4 = d1 - this.f_109420_;
        double d5 = d2 - this.f_109421_;
        int i = SectionPos.m_213994_((double)d0);
        int j = SectionPos.m_213994_((double)d1);
        int k = SectionPos.m_213994_((double)d2);
        if (this.f_109422_ != i || this.f_109423_ != j || this.f_109424_ != k || d3 * d3 + d4 * d4 + d5 * d5 > 16.0) {
            this.f_109419_ = d0;
            this.f_109420_ = d1;
            this.f_109421_ = d2;
            this.f_109422_ = i;
            this.f_109423_ = j;
            this.f_109424_ = k;
            this.f_109469_.m_110850_(d0, d2);
        }
        if (Config.isDynamicLights()) {
            DynamicLights.update((LevelRenderer)this);
        }
        this.f_109436_.m_112693_(vec3);
        this.f_109465_.m_46473_().m_6182_("cull");
        this.f_109461_.m_91307_().m_6182_("culling");
        BlockPos blockpos = activeRenderInfoIn.m_90588_();
        ChunkRenderDispatcher.RenderChunk chunkrenderdispatcher$renderchunk = this.f_109469_.m_110866_(blockpos);
        int l = 16;
        BlockPos blockpos1 = new BlockPos(Mth.m_14107_(vec3.f_82479_ / 16.0) * 16, Mth.m_14107_(vec3.f_82480_ / 16.0) * 16, Mth.m_14107_(vec3.f_82481_ / 16.0) * 16);
        float f = activeRenderInfoIn.m_90589_();
        float f1 = activeRenderInfoIn.m_90590_();
        this.f_109448_ = this.f_109448_ || !this.f_109466_.isEmpty() || vec3.f_82479_ != this.f_109425_ || vec3.f_82480_ != this.f_109426_ || vec3.f_82481_ != this.f_109427_ || (double)f != this.f_109428_ || (double)f1 != this.f_109429_;
        this.f_109425_ = vec3.f_82479_;
        this.f_109426_ = vec3.f_82480_;
        this.f_109427_ = vec3.f_82481_;
        this.f_109428_ = f;
        this.f_109429_ = f1;
        this.f_109461_.m_91307_().m_6182_("update");
        Lagometer.timerVisibility.start();
        int countLoadedChunks = this.getCountLoadedChunks();
        if (countLoadedChunks != this.countLoadedChunksPrev) {
            this.countLoadedChunksPrev = countLoadedChunks;
            this.f_109448_ = true;
        }
        Entity entityIn = activeRenderInfoIn.m_90592_();
        int maxChunkY = maxWorldY = this.f_109465_.m_163334_();
        if (!ChunkVisibility.isFinished()) {
            this.f_109448_ = true;
        }
        if ((entitySectionStorage = this.f_109465_.getEntityStorage().getSectionStorage()).resetUpdated()) {
            this.f_109448_ = true;
        }
        if (!debugCamera && this.f_109448_ && Config.isIntegratedServerRunning() && !Shaders.isShadowPass) {
            maxChunkY = ChunkVisibility.getMaxChunkY((ClientLevel)this.f_109465_, (Entity)entityIn, (int)this.f_109438_);
        }
        ChunkRenderDispatcher.RenderChunk renderChunkPlayer = this.f_109469_.m_110866_(new BlockPos(entityIn.m_20185_(), entityIn.m_20186_(), entityIn.m_20189_()));
        if (Shaders.isShadowPass) {
            this.f_109467_ = this.renderInfosShadow;
            this.renderInfosEntities = this.renderInfosEntitiesShadow;
            this.renderInfosTileEntities = this.renderInfosTileEntitiesShadow;
            if (!debugCamera && this.f_109448_) {
                this.clearRenderInfos();
                if (renderChunkPlayer != null && renderChunkPlayer.m_112839_().m_123342_() > maxChunkY) {
                    this.addEntitySection(this.renderInfosEntities, entitySectionStorage, renderChunkPlayer.m_112839_());
                }
                Iterator it = ShadowUtils.makeShadowChunkIterator((ClientLevel)this.f_109465_, (double)0.0, (Entity)entityIn, (int)this.f_109438_, (ViewArea)this.f_109469_);
                while (it.hasNext()) {
                    ChunkRenderDispatcher.RenderChunk chunk = (ChunkRenderDispatcher.RenderChunk)it.next();
                    if (chunk == null || chunk.m_112839_().m_123342_() > maxChunkY) continue;
                    RenderChunkInfo renderInfo = chunk.getRenderInfo();
                    if (!chunk.f_112784_.get().m_112757_()) {
                        this.f_109467_.add((Object)renderInfo);
                    }
                    this.addEntitySection(this.renderInfosEntities, entitySectionStorage, chunk.m_112839_());
                    if (chunk.m_112835_().m_112773_().size() <= 0) continue;
                    this.renderInfosTileEntities.add(renderInfo);
                }
            }
        } else {
            this.f_109467_ = this.renderInfosNormal;
            this.renderInfosEntities = this.renderInfosEntitiesNormal;
            this.renderInfosTileEntities = this.renderInfosTileEntitiesNormal;
        }
        if (!debugCamera && this.f_109448_ && !Shaders.isShadowPass) {
            this.f_109448_ = false;
            Vector3f viewVector = activeRenderInfoIn.m_90596_();
            this.updateRenderChunks(camera, frameCount, playerSpectator, vec3, blockpos, chunkrenderdispatcher$renderchunk, 16, blockpos1, maxChunkY, maxWorldY, renderChunkPlayer, viewVector);
        }
        Lagometer.timerVisibility.end();
        if (Shaders.isShadowPass) {
            Shaders.mcProfilerEndSection();
            return;
        }
        this.f_109461_.m_91307_().m_6182_("rebuildNear");
        Set<ChunkRenderDispatcher.RenderChunk> set = this.f_109466_;
        this.f_109466_ = this.chunksToUpdatePrev;
        this.chunksToUpdatePrev = set;
        this.f_109466_.clear();
        Lagometer.timerChunkUpdate.start();
        for (RenderChunkInfo levelrenderer$renderchunkinfo : this.f_109467_) {
            boolean flag2;
            ChunkRenderDispatcher.RenderChunk chunkrenderdispatcher$renderchunk1 = levelrenderer$renderchunkinfo.f_109839_;
            if (!chunkrenderdispatcher$renderchunk1.m_112841_() && !set.contains(chunkrenderdispatcher$renderchunk1)) continue;
            this.f_109448_ = true;
            BlockPos posChunk = chunkrenderdispatcher$renderchunk1.m_112839_();
            boolean bl = flag2 = (double)MathUtils.distanceSq((BlockPos)blockpos1, (float)(posChunk.m_123341_() + 8), (float)(posChunk.m_123342_() + 8), (float)(posChunk.m_123343_() + 8)) < 768.0;
            if (!chunkrenderdispatcher$renderchunk1.m_112842_() && !flag2) {
                this.f_109466_.add(chunkrenderdispatcher$renderchunk1);
                continue;
            }
            if (!chunkrenderdispatcher$renderchunk1.isPlayerUpdate()) {
                this.chunksToUpdateForced.add(chunkrenderdispatcher$renderchunk1);
                continue;
            }
            this.f_109461_.m_91307_().m_6180_("build near");
            this.f_109436_.m_112715_(chunkrenderdispatcher$renderchunk1);
            chunkrenderdispatcher$renderchunk1.m_112840_();
            this.f_109461_.m_91307_().m_7238_();
        }
        Lagometer.timerChunkUpdate.end();
        this.f_109466_.addAll(set);
        this.f_109461_.m_91307_().m_7238_();
    }

    private void updateRenderChunks(Frustum camera, int frameCount, boolean playerSpectator, Vec3 viewPos, BlockPos viewBlockPos, ChunkRenderDispatcher.RenderChunk viewRenderChunk, int chunkSizeIn, BlockPos playerPosIn, int maxChunkY, int maxWorldY, ChunkRenderDispatcher.RenderChunk renderChunkPlayer, Vector3f viewVector) {
        this.clearRenderInfos();
        this.visibilityDeque.clear();
        Deque queue = this.visibilityDeque;
        Entity.m_20103_((double)(Mth.m_14008_((double)this.f_109461_.f_91066_.f_92106_ / 8.0, 1.0, 2.5) * (double)this.f_109461_.f_91066_.f_92112_));
        boolean flag = this.f_109461_.f_90980_;
        EntitySectionStorage entitySectionStorage = this.f_109465_.getEntityStorage().getSectionStorage();
        BlockPos posPlayer = viewBlockPos;
        int playerY = posPlayer.m_123342_();
        int playerChunkY = playerY >> 4 << 4;
        if (playerChunkY > maxChunkY && playerChunkY > (maxChunkY += 16) && maxChunkY < maxWorldY) {
            ChunkRenderDispatcher.RenderChunk renderChunk;
            if (renderChunkPlayer != null) {
                this.addEntitySection(this.renderInfosEntities, entitySectionStorage, renderChunkPlayer.m_112839_());
            }
            Vec3 posStart = new Vec3((double)posPlayer.m_123341_(), (double)maxChunkY, (double)posPlayer.m_123343_());
            Vec3 pos = new Vec3(posStart.m_7096_(), posStart.m_7098_(), posStart.m_7094_());
            Vector3f view = viewVector;
            Vector3f viewFlat = new Vector3f(view.m_122239_(), 0.0f, view.m_122269_());
            if (!viewFlat.m_122278_()) {
                viewFlat = new Vector3f(1.0f, 0.0f, 0.0f);
            }
            double dx = viewFlat.m_122239_() * 16.0f;
            double dz = viewFlat.m_122269_() * 16.0f;
            double renderDistance = this.f_109438_ * 16;
            double maxDistSq = renderDistance * renderDistance;
            while (pos.m_82557_(posStart) < maxDistSq && (renderChunk = this.f_109469_.m_110866_(new BlockPos(pos))) != null) {
                if (camera.m_113029_(renderChunk.f_112785_)) {
                    renderChunk.m_112799_(frameCount);
                    queue.add(new RenderChunkInfo(renderChunk, null, 0));
                    break;
                }
                pos = pos.m_82520_(dx, 0.0, dz);
            }
        }
        if (queue.isEmpty()) {
            if (viewRenderChunk == null || viewRenderChunk.m_112839_().m_123342_() > maxChunkY) {
                int i;
                int n = i = playerPosIn.m_123342_() > this.f_109465_.m_141493_() ? Math.min(maxChunkY, this.f_109465_.m_163334_() - 8) : this.f_109465_.m_141493_() + 8;
                if (renderChunkPlayer != null) {
                    this.addEntitySection(this.renderInfosEntities, entitySectionStorage, renderChunkPlayer.m_112839_());
                }
                int j = Mth.m_14107_(viewPos.f_82479_ / (double)chunkSizeIn) * chunkSizeIn;
                int k = Mth.m_14107_(viewPos.f_82481_ / (double)chunkSizeIn) * chunkSizeIn;
                ArrayList list = Lists.newArrayList();
                for (int l = -this.f_109438_; l <= this.f_109438_; ++l) {
                    for (int i1 = -this.f_109438_; i1 <= this.f_109438_; ++i1) {
                        ChunkRenderDispatcher.RenderChunk chunkrenderdispatcher$renderchunk = this.f_109469_.m_110866_(new BlockPos(j + SectionPos.m_213997_((int)l, (int)8), i, k + SectionPos.m_213997_((int)i1, (int)8)));
                        if (chunkrenderdispatcher$renderchunk == null || !camera.m_113029_(chunkrenderdispatcher$renderchunk.f_112785_)) continue;
                        chunkrenderdispatcher$renderchunk.m_112799_(frameCount);
                        RenderChunkInfo info = chunkrenderdispatcher$renderchunk.getRenderInfo();
                        info.initialize(null, 0, 0);
                        list.add(info);
                    }
                }
                list.sort(Comparator.comparingDouble(p_316154_1_ -> viewBlockPos.m_123331_((Vec3i)p_316154_1_.f_109839_.m_112839_().m_224058_(8, 8, 8))));
                queue.addAll(list);
            } else {
                if (playerSpectator && this.f_109465_.m_8055_(viewBlockPos).m_60804_((BlockGetter)this.f_109465_, viewBlockPos)) {
                    flag = false;
                }
                viewRenderChunk.m_112799_(frameCount);
                queue.add(new RenderChunkInfo(viewRenderChunk, null, 0));
            }
        }
        this.f_109461_.m_91307_().m_6180_("iteration");
        int k1 = this.f_109461_.f_91066_.f_92106_;
        this.f_316089_.m_316179_();
        boolean fog = Config.isFogOn();
        while (!queue.isEmpty()) {
            Direction[] facings;
            RenderChunkInfo levelrenderer$renderchunkinfo = (RenderChunkInfo)queue.poll();
            ChunkRenderDispatcher.RenderChunk chunkrenderdispatcher$renderchunk2 = levelrenderer$renderchunkinfo.f_109839_;
            ChunkRenderDispatcher.CompiledChunk compiledChunk3 = chunkrenderdispatcher$renderchunk2.f_112784_.get();
            if (!compiledChunk3.m_112757_() || chunkrenderdispatcher$renderchunk2.m_112841_()) {
                this.f_109467_.add((Object)levelrenderer$renderchunkinfo);
            }
            this.addEntitySection(this.renderInfosEntities, entitySectionStorage, chunkrenderdispatcher$renderchunk2.m_112839_());
            if (compiledChunk3.m_112773_().size() > 0) {
                this.renderInfosTileEntities.add(levelrenderer$renderchunkinfo);
            }
            for (Direction direction : facings = flag ? ChunkVisibility.getFacingsNotOpposite((int)levelrenderer$renderchunkinfo.f_109841_) : Direction.f_122346_) {
                ChunkRenderDispatcher.RenderChunk chunkrenderdispatcher$renderchunk1;
                if (flag && levelrenderer$renderchunkinfo.m_109859_(direction.m_122424_())) continue;
                if (flag && levelrenderer$renderchunkinfo.m_316170_()) {
                    ChunkRenderDispatcher.CompiledChunk chunkrenderdispatcher$compiledchunk = chunkrenderdispatcher$renderchunk2.m_112835_();
                    boolean flag1 = false;
                    for (int j1 = 0; j1 < f_109434_.length; ++j1) {
                        if (!levelrenderer$renderchunkinfo.m_316171_(j1) || !chunkrenderdispatcher$compiledchunk.m_7259_(f_109434_[j1].m_122424_(), direction)) continue;
                        flag1 = true;
                        break;
                    }
                    if (!flag1) continue;
                }
                if ((chunkrenderdispatcher$renderchunk1 = this.getRenderChunkOffset(playerPosIn, chunkrenderdispatcher$renderchunk2, direction, fog, maxChunkY)) == null || !chunkrenderdispatcher$renderchunk1.m_112798_()) continue;
                if (!chunkrenderdispatcher$renderchunk1.m_112799_(frameCount)) {
                    RenderChunkInfo levelrenderer$renderchunkinfo1 = this.f_316089_.m_316180_(chunkrenderdispatcher$renderchunk1);
                    if (levelrenderer$renderchunkinfo1 == null) continue;
                    levelrenderer$renderchunkinfo1.m_316173_(direction);
                    continue;
                }
                if (!camera.m_113029_(chunkrenderdispatcher$renderchunk1.f_112785_)) continue;
                RenderChunkInfo levelrenderer$renderchunkinfo2 = chunkrenderdispatcher$renderchunk1.getRenderInfo();
                int setFacing = levelrenderer$renderchunkinfo.f_109841_ | 1 << direction.ordinal();
                levelrenderer$renderchunkinfo2.initialize(direction, setFacing, levelrenderer$renderchunkinfo.f_109842_ + 1);
                queue.add(levelrenderer$renderchunkinfo2);
                this.f_316089_.m_316182_(chunkrenderdispatcher$renderchunk1, levelrenderer$renderchunkinfo2);
            }
        }
        this.f_109461_.m_91307_().m_7238_();
    }

    @Nullable
    private ChunkRenderDispatcher.RenderChunk getRenderChunkOffset(BlockPos playerPos, ChunkRenderDispatcher.RenderChunk renderChunkBase, Direction facing, boolean fog, int yMax) {
        ChunkRenderDispatcher.RenderChunk neighbour = renderChunkBase.getRenderChunkNeighbour(facing);
        if (neighbour == null) {
            return null;
        }
        if (neighbour.m_112839_().m_123342_() > yMax) {
            return null;
        }
        if (fog) {
            int dzs;
            BlockPos var4 = neighbour.m_112839_();
            int dxs = playerPos.m_123341_() - var4.m_123341_();
            int distSq = dxs * dxs + (dzs = playerPos.m_123343_() - var4.m_123343_()) * dzs;
            if (distSq > this.renderDistanceSq) {
                return null;
            }
        }
        return neighbour;
    }

    private void m_109525_(Matrix4f matrixIn, Matrix4f projectionIn, double camX, double camY, double camZ, Frustum frustumIn) {
        this.f_109442_ = frustumIn;
        Matrix4f matrix4f = projectionIn.m_27658_();
        matrix4f.m_27644_(matrixIn);
        matrix4f.m_27657_();
        this.f_109444_.f_86214_ = camX;
        this.f_109444_.f_86215_ = camY;
        this.f_109444_.f_86216_ = camZ;
        this.f_109443_[0] = new Vector4f(-1.0f, -1.0f, -1.0f, 1.0f);
        this.f_109443_[1] = new Vector4f(1.0f, -1.0f, -1.0f, 1.0f);
        this.f_109443_[2] = new Vector4f(1.0f, 1.0f, -1.0f, 1.0f);
        this.f_109443_[3] = new Vector4f(-1.0f, 1.0f, -1.0f, 1.0f);
        this.f_109443_[4] = new Vector4f(-1.0f, -1.0f, 1.0f, 1.0f);
        this.f_109443_[5] = new Vector4f(1.0f, -1.0f, 1.0f, 1.0f);
        this.f_109443_[6] = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.f_109443_[7] = new Vector4f(-1.0f, 1.0f, 1.0f, 1.0f);
        for (int i = 0; i < 8; ++i) {
            this.f_109443_[i].m_123607_(matrix4f);
            this.f_109443_[i].m_123621_();
        }
    }

    public void m_205731_(PoseStack matrixStackIn, Vec3 posIn, Matrix4f matrixIn) {
        Matrix4f matrix4f = matrixStackIn.m_85850_().m_85861_();
        double d0 = posIn.m_7096_();
        double d1 = posIn.m_7098_();
        double d2 = posIn.m_7094_();
        this.f_205635_ = new Frustum(matrix4f, matrixIn);
        this.f_205635_.m_113002_(d0, d1, d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_109599_(PoseStack matrixStackIn, float partialTicks, long finishTimeNano, boolean drawBlockOutline, Camera activeRenderInfoIn, GameRenderer gameRendererIn, LightTexture lightmapIn, Matrix4f projectionIn) {
        boolean flag1;
        Frustum frustum;
        boolean flag;
        RenderSystem.m_256260_((long)this.f_109465_.m_46467_(), (float)partialTicks);
        this.f_205636_.m_207240_(this.f_109465_, activeRenderInfoIn, this.f_109461_.f_91077_);
        this.f_109463_.m_114408_(this.f_109465_, activeRenderInfoIn, this.f_109461_.f_91076_);
        ProfilerFiller profilerfiller = this.f_109465_.m_46473_();
        profilerfiller.m_6182_("light_updates");
        this.f_109461_.f_91073_.m_7726_().m_7827_().m_299789_(Integer.MAX_VALUE, true, true);
        Vec3 vec3 = activeRenderInfoIn.m_90583_();
        double d0 = vec3.m_7096_();
        double d1 = vec3.m_7098_();
        double d2 = vec3.m_7094_();
        Matrix4f matrix4f = matrixStackIn.m_85850_().m_85861_();
        profilerfiller.m_6182_("culling");
        boolean bl = flag = this.f_109442_ != null;
        if (flag) {
            frustum = this.f_109442_;
            frustum.m_113002_(this.f_109444_.f_86214_, this.f_109444_.f_86215_, this.f_109444_.f_86216_);
        } else {
            frustum = this.f_205635_;
        }
        this.f_109461_.m_91307_().m_6182_("captureFrustum");
        if (this.f_109441_) {
            this.m_109525_(matrix4f, projectionIn, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, flag ? new Frustum(matrix4f, projectionIn) : frustum);
            this.f_109441_ = false;
        }
        profilerfiller.m_6182_("clear");
        if (Config.isShaders()) {
            Shaders.setViewport(0, 0, this.f_109461_.m_91268_().m_85441_(), this.f_109461_.m_91268_().m_85442_());
        } else {
            RenderSystem.m_69949_((int)0, (int)0, (int)this.f_109461_.m_91268_().m_85441_(), (int)this.f_109461_.m_91268_().m_85442_());
        }
        FogRenderer.m_109018_(activeRenderInfoIn, partialTicks, this.f_109461_.f_91073_, this.f_109461_.f_91066_.f_92106_, gameRendererIn.m_109131_(partialTicks));
        FogRenderer.m_109036_();
        RenderSystem.m_69421_((int)16640, (boolean)Minecraft.f_91002_);
        boolean isShaders = Config.isShaders();
        if (isShaders) {
            Shaders.clearRenderBuffer();
            Shaders.setCamera((PoseStack)matrixStackIn, (Camera)activeRenderInfoIn, (float)partialTicks);
            Shaders.renderPrepare();
        }
        frustum.disabled = Config.isShaders() && !Shaders.isFrustumCulling();
        float f = gameRendererIn.m_109152_();
        boolean bl2 = flag1 = this.f_109461_.f_91073_.m_104583_().m_5781_(Mth.m_14107_(d0), Mth.m_14107_(d1)) || this.f_109461_.f_91065_.m_93090_().m_93715_();
        if ((Config.isSkyEnabled() || Config.isSunMoonEnabled() || Config.isStarsEnabled()) && !Shaders.isShadowPass) {
            profilerfiller.m_6182_("sky");
            if (isShaders) {
                Shaders.beginSky();
            }
            RenderSystem.m_256236_(GameRenderer::m_282213_);
            this.m_316102_(matrixStackIn, projectionIn, partialTicks, () -> FogRenderer.setupFog(activeRenderInfoIn, FogRenderer.FogMode.FOG_SKY, f, flag1, partialTicks));
            if (isShaders) {
                Shaders.endSky();
            }
        } else {
            GlStateManager.m_84519_();
        }
        profilerfiller.m_6182_("fog");
        FogRenderer.setupFog(activeRenderInfoIn, FogRenderer.FogMode.FOG_TERRAIN, Math.max(f - 16.0f, 32.0f), flag1, partialTicks);
        profilerfiller.m_6182_("terrain_setup");
        this.checkLoadVisibleChunks(activeRenderInfoIn, frustum, this.f_109461_.f_91074_.m_5833_());
        this.m_109695_(activeRenderInfoIn, frustum, flag, this.f_109449_++, this.f_109461_.f_91074_.m_5833_());
        profilerfiller.m_6182_("updatechunks");
        int i = 30;
        int j = this.f_109461_.f_91066_.f_92113_;
        long k = 33333333L;
        long l = (double)j == Option.f_91670_.m_92235_() ? 0L : (long)(1000000000 / j);
        long i1 = Util.m_137569_() - finishTimeNano;
        long j1 = this.f_109476_.m_110712_(i1);
        long k1 = j1 * 3L / 2L;
        long l1 = Mth.m_14053_(k1, l, 33333333L);
        Lagometer.timerChunkUpload.start();
        this.m_109510_(finishTimeNano + l1);
        Lagometer.timerChunkUpload.end();
        profilerfiller.m_6182_("terrain");
        Lagometer.timerTerrain.start();
        if (this.f_109461_.f_91066_.ofSmoothFps) {
            this.f_109461_.m_91307_().m_6182_("finish");
            GL11.glFinish();
            this.f_109461_.m_91307_().m_6182_("terrain");
        }
        if (Config.isFogOff() && FogRenderer.fogStandard) {
            RenderSystem.setFogAllowed(false);
        }
        this.m_282537_(RenderType.m_110451_(), matrixStackIn, d0, d1, d2, projectionIn);
        this.f_109461_.m_91304_().m_119428_(TextureAtlas.f_118259_).setBlurMipmap(false, this.f_109461_.f_91066_.f_92027_ > 0);
        this.m_282537_(RenderType.m_110457_(), matrixStackIn, d0, d1, d2, projectionIn);
        this.f_109461_.m_91304_().m_119428_(TextureAtlas.f_118259_).restoreLastBlurMipmap();
        this.m_282537_(RenderType.m_110463_(), matrixStackIn, d0, d1, d2, projectionIn);
        if (isShaders) {
            ShadersRender.endTerrain();
        }
        Lagometer.timerTerrain.end();
        if (this.f_109465_.m_104583_().m_108885_()) {
            Lighting.m_84925_((Matrix4f)matrixStackIn.m_85850_().m_85861_());
        } else {
            Lighting.m_84928_((Matrix4f)matrixStackIn.m_85850_().m_85861_());
        }
        if (isShaders) {
            Shaders.beginEntities();
        }
        ItemFrameRenderer.updateItemRenderDistance();
        profilerfiller.m_6182_("entities");
        ++renderEntitiesCounter;
        this.f_109439_ = 0;
        this.f_109440_ = 0;
        this.countTileEntitiesRendered = 0;
        if (this.f_109414_ != null) {
            this.f_109414_.m_83954_(Minecraft.f_91002_);
            this.f_109414_.m_83945_(this.f_109461_.m_91385_());
            this.f_109461_.m_91385_().m_83947_(false);
        }
        if (this.f_109416_ != null) {
            this.f_109416_.m_83954_(Minecraft.f_91002_);
        }
        if (this.m_109817_()) {
            this.f_109411_.m_83954_(Minecraft.f_91002_);
            this.f_109461_.m_91385_().m_83947_(false);
        }
        boolean flag2 = false;
        MultiBufferSource.BufferSource multibuffersource$buffersource = this.f_109464_.m_110104_();
        if (Config.isFastRender()) {
            RenderStateManager.enableCache();
        }
        int minWorldY = this.f_109465_.m_141493_();
        int maxWorldY = this.f_109465_.m_163334_();
        for (Entity entity : this.f_109465_.m_104735_()) {
            boolean entityPlayerNotSpectator;
            BlockPos blockPos = entity.m_141983_();
            if (!this.renderInfosEntities.contains(SectionPos.m_214039_((BlockPos)blockPos)) && blockPos.m_123342_() > minWorldY && blockPos.m_123342_() < maxWorldY) continue;
            boolean bl3 = entityPlayerNotSpectator = entity == this.f_109461_.f_91074_ && !this.f_109461_.f_91074_.m_5833_();
            if (!this.f_109463_.m_114397_(entity, frustum, d0, d1, d2) && !entity.m_20367_((Entity)this.f_109461_.f_91074_) || entity == activeRenderInfoIn.m_90592_() && !activeRenderInfoIn.m_90594_() && (!(activeRenderInfoIn.m_90592_() instanceof LivingEntity) || !((LivingEntity)activeRenderInfoIn.m_90592_()).m_5803_()) || entity instanceof LocalPlayer && activeRenderInfoIn.m_90592_() != entity && !entityPlayerNotSpectator) continue;
            String string = entity.getClass().getName();
            List<Entity> listEntities = this.mapEntityLists.get(string);
            if (listEntities == null) {
                listEntities = new ArrayList<Entity>();
                this.mapEntityLists.put(string, listEntities);
            }
            listEntities.add(entity);
        }
        Collection<List<Entity>> entityLists = this.mapEntityLists.values();
        for (List<Entity> list : entityLists) {
            for (Entity entity : list) {
                MultiBufferSource.BufferSource multibuffersource;
                ++this.f_109439_;
                if (entity.f_19797_ == 0) {
                    entity.f_19790_ = entity.m_20185_();
                    entity.f_19791_ = entity.m_20186_();
                    entity.f_19792_ = entity.m_20189_();
                }
                if (this.m_109817_() && this.f_109461_.m_91314_(entity)) {
                    flag2 = true;
                    OutlineBufferSource outlinebuffersource = this.f_109464_.m_110109_();
                    multibuffersource = outlinebuffersource;
                    int i2 = entity.m_19876_();
                    int j2 = 255;
                    int k2 = i2 >> 16 & 0xFF;
                    int l2 = i2 >> 8 & 0xFF;
                    int i3 = i2 & 0xFF;
                    outlinebuffersource.m_109929_(k2, l2, i3, 255);
                } else {
                    multibuffersource = multibuffersource$buffersource;
                }
                this.renderedEntity = entity;
                if (isShaders) {
                    Shaders.nextEntity((Entity)entity);
                }
                this.m_109517_(entity, d0, d1, d2, partialTicks, matrixStackIn, multibuffersource);
                this.renderedEntity = null;
            }
            list.clear();
        }
        multibuffersource$buffersource.m_316188_();
        this.m_109588_(matrixStackIn);
        multibuffersource$buffersource.m_109912_(RenderType.m_110446_(TextureAtlas.f_118259_));
        multibuffersource$buffersource.m_109912_(RenderType.m_110452_(TextureAtlas.f_118259_));
        multibuffersource$buffersource.m_109912_(RenderType.m_110458_(TextureAtlas.f_118259_));
        multibuffersource$buffersource.m_109912_(RenderType.m_110476_(TextureAtlas.f_118259_));
        if (isShaders) {
            Shaders.endEntities();
            Shaders.beginBlockEntities();
        }
        profilerfiller.m_6182_("blockentities");
        SignRenderer.updateTextRenderDistance();
        boolean bl4 = Reflector.IForgeTileEntity_getRenderBoundingBox.exists();
        Frustum frustum2 = frustum;
        for (RenderChunkInfo renderChunkInfo : this.renderInfosTileEntities) {
            List<BlockEntity> list = renderChunkInfo.f_109839_.m_112835_().m_112773_();
            if (list.isEmpty()) continue;
            for (BlockEntity blockentity1 : list) {
                int j3;
                AABB aabb;
                if (bl4 && (aabb = (AABB)Reflector.call(blockentity1, Reflector.IForgeTileEntity_getRenderBoundingBox, new Object[0])) != null && !frustum2.m_113029_(aabb)) continue;
                if (isShaders) {
                    Shaders.nextBlockEntity((BlockEntity)blockentity1);
                }
                BlockPos blockpos3 = blockentity1.m_58899_();
                MultiBufferSource multibuffersource1 = multibuffersource$buffersource;
                matrixStackIn.m_85836_();
                matrixStackIn.m_85837_((double)blockpos3.m_123341_() - d0, (double)blockpos3.m_123342_() - d1, (double)blockpos3.m_123343_() - d2);
                SortedSet sortedset = (SortedSet)this.f_109409_.get(blockpos3.m_121878_());
                if (sortedset != null && !sortedset.isEmpty() && (j3 = ((BlockDestructionProgress)sortedset.last()).m_139988_()) >= 0) {
                    PoseStack.Pose posestack$pose = matrixStackIn.m_85850_();
                    SheetedDecalTextureGenerator vertexconsumer = new SheetedDecalTextureGenerator(this.f_109464_.m_110108_().m_6299_(ModelBakery.f_119229_.get(j3)), posestack$pose.m_85861_(), posestack$pose.m_85864_());
                    multibuffersource1 = arg_0 -> LevelRenderer.lambda$updateCameraAndRender$2(multibuffersource$buffersource, (VertexConsumer)vertexconsumer, arg_0);
                }
                this.f_205636_.m_112267_(blockentity1, partialTicks, matrixStackIn, multibuffersource1);
                matrixStackIn.m_85849_();
                ++this.countTileEntitiesRendered;
            }
        }
        Set<BlockEntity> entityPlayerNotSpectator = this.f_109468_;
        synchronized (entityPlayerNotSpectator) {
            for (BlockEntity blockentity : this.f_109468_) {
                AABB aabb;
                if (bl4 && (aabb = (AABB)Reflector.call(blockentity, Reflector.IForgeTileEntity_getRenderBoundingBox, new Object[0])) != null && !frustum2.m_113029_(aabb)) continue;
                if (isShaders) {
                    Shaders.nextBlockEntity((BlockEntity)blockentity);
                }
                BlockPos blockpos2 = blockentity.m_58899_();
                matrixStackIn.m_85836_();
                matrixStackIn.m_85837_((double)blockpos2.m_123341_() - d0, (double)blockpos2.m_123342_() - d1, (double)blockpos2.m_123343_() - d2);
                this.f_205636_.m_112267_(blockentity, partialTicks, matrixStackIn, multibuffersource$buffersource);
                matrixStackIn.m_85849_();
                ++this.countTileEntitiesRendered;
            }
        }
        this.m_109588_(matrixStackIn);
        multibuffersource$buffersource.m_109912_(RenderType.m_110451_());
        multibuffersource$buffersource.m_109912_(RenderType.m_282966_());
        multibuffersource$buffersource.m_109912_(RenderType.m_282967_());
        multibuffersource$buffersource.m_109912_(Sheets.m_110789_());
        multibuffersource$buffersource.m_109912_(Sheets.m_110790_());
        multibuffersource$buffersource.m_109912_(Sheets.m_110785_());
        multibuffersource$buffersource.m_109912_(Sheets.m_110786_());
        multibuffersource$buffersource.m_109912_(Sheets.m_110787_());
        multibuffersource$buffersource.m_109912_(Sheets.m_110788_());
        multibuffersource$buffersource.m_109912_(Sheets.m_110762_());
        this.f_109464_.m_110109_().m_109928_();
        if (Config.isFastRender()) {
            RenderStateManager.disableCache();
        }
        if (flag2) {
            this.f_109412_.m_110023_(partialTicks);
            this.f_109461_.m_91385_().m_83947_(false);
        }
        if (isShaders) {
            Shaders.endBlockEntities();
        }
        this.renderOverlayDamaged = true;
        profilerfiller.m_6182_("destroyProgress");
        for (Long2ObjectMap.Entry entry : this.f_109409_.long2ObjectEntrySet()) {
            SortedSet sortedset1;
            double d5;
            double d4;
            BlockPos blockpos1 = BlockPos.m_122022_((long)entry.getLongKey());
            double d3 = (double)blockpos1.m_123341_() - d0;
            if (d3 * d3 + (d4 = (double)blockpos1.m_123342_() - d1) * d4 + (d5 = (double)blockpos1.m_123343_() - d2) * d5 > 1024.0 || (sortedset1 = (SortedSet)entry.getValue()) == null || sortedset1.isEmpty()) continue;
            int k3 = ((BlockDestructionProgress)sortedset1.last()).m_139988_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_((double)blockpos1.m_123341_() - d0, (double)blockpos1.m_123342_() - d1, (double)blockpos1.m_123343_() - d2);
            PoseStack.Pose posestack$pose1 = matrixStackIn.m_85850_();
            SheetedDecalTextureGenerator vertexconsumer1 = new SheetedDecalTextureGenerator(this.f_109464_.m_110108_().m_6299_(ModelBakery.f_119229_.get(k3)), posestack$pose1.m_85861_(), posestack$pose1.m_85864_());
            this.f_109461_.m_91289_().m_110918_(this.f_109465_.m_8055_(blockpos1), blockpos1, (BlockAndTintGetter)this.f_109465_, matrixStackIn, (VertexConsumer)vertexconsumer1);
            matrixStackIn.m_85849_();
        }
        this.renderOverlayDamaged = false;
        --renderEntitiesCounter;
        this.m_109588_(matrixStackIn);
        HitResult hitresult = this.f_109461_.f_91077_;
        if (drawBlockOutline && hitresult != null && hitresult.m_6662_() == HitResult.Type.BLOCK) {
            profilerfiller.m_6182_("outline");
            BlockPos blockPos = ((BlockHitResult)hitresult).m_82425_();
            BlockState blockstate = this.f_109465_.m_8055_(blockPos);
            if (isShaders) {
                ShadersRender.beginOutline();
            }
            if (!Reflector.callBoolean(Reflector.ForgeHooksClient_onDrawBlockHighlight, this, activeRenderInfoIn, hitresult, Float.valueOf(partialTicks), matrixStackIn, multibuffersource$buffersource) && !blockstate.m_60795_() && this.f_109465_.m_6857_().m_61937_(blockPos)) {
                VertexConsumer vertexconsumer2 = multibuffersource$buffersource.m_6299_(RenderType.m_110504_());
                this.m_109637_(matrixStackIn, vertexconsumer2, activeRenderInfoIn.m_90592_(), d0, d1, d2, blockPos, blockstate);
            }
            if (isShaders) {
                multibuffersource$buffersource.m_109912_(RenderType.m_110504_());
                ShadersRender.endOutline();
            }
        } else if (hitresult != null && hitresult.m_6662_() == HitResult.Type.ENTITY) {
            Reflector.ForgeHooksClient_onDrawBlockHighlight.call(this, activeRenderInfoIn, hitresult, Float.valueOf(partialTicks), matrixStackIn, multibuffersource$buffersource);
        }
        PoseStack poseStack = RenderSystem.m_255945_();
        poseStack.m_85836_();
        poseStack.m_268520_(matrixStackIn.m_85850_().m_85861_());
        RenderSystem.m_255902_();
        if (isShaders) {
            ShadersRender.beginDebug();
        }
        this.f_109461_.f_91064_.m_113457_(matrixStackIn, multibuffersource$buffersource, d0, d1, d2);
        poseStack.m_85849_();
        RenderSystem.m_255902_();
        multibuffersource$buffersource.m_109912_(Sheets.m_110792_());
        multibuffersource$buffersource.m_109912_(Sheets.m_110762_());
        multibuffersource$buffersource.m_109912_(Sheets.m_110782_());
        multibuffersource$buffersource.m_109912_(RenderType.m_110481_());
        multibuffersource$buffersource.m_109912_(RenderType.m_110484_());
        multibuffersource$buffersource.m_109912_(RenderType.m_110490_());
        multibuffersource$buffersource.m_109912_(RenderType.m_110493_());
        multibuffersource$buffersource.m_109912_(RenderType.m_110487_());
        multibuffersource$buffersource.m_109912_(RenderType.m_110496_());
        multibuffersource$buffersource.m_109912_(RenderType.m_110499_());
        multibuffersource$buffersource.m_109912_(RenderType.m_110478_());
        this.f_109464_.m_110108_().m_109911_();
        if (isShaders) {
            multibuffersource$buffersource.m_109911_();
            ShadersRender.endDebug();
            Shaders.preRenderHand();
            Matrix4f projectionPrev = RenderSystem.m_255946_().m_27658_();
            ShadersRender.renderHand0((GameRenderer)gameRendererIn, (PoseStack)matrixStackIn, (Camera)activeRenderInfoIn, (float)partialTicks);
            RenderSystem.m_256234_((Matrix4f)projectionPrev);
            Shaders.preWater();
        }
        if (this.f_109418_ != null) {
            multibuffersource$buffersource.m_109912_(RenderType.m_110504_());
            multibuffersource$buffersource.m_109911_();
            this.f_109413_.m_83954_(Minecraft.f_91002_);
            this.f_109413_.m_83945_(this.f_109461_.m_91385_());
            profilerfiller.m_6182_("translucent");
            this.m_282537_(RenderType.m_110466_(), matrixStackIn, d0, d1, d2, projectionIn);
            profilerfiller.m_6182_("string");
            this.m_282537_(RenderType.m_110503_(), matrixStackIn, d0, d1, d2, projectionIn);
            this.f_109415_.m_83954_(Minecraft.f_91002_);
            this.f_109415_.m_83945_(this.f_109461_.m_91385_());
            RenderStateShard.f_110126_.m_110185_();
            profilerfiller.m_6182_("particles");
            if (Reflector.ForgeHooksClient.exists()) {
                this.f_109461_.f_91061_.render(matrixStackIn, multibuffersource$buffersource, lightmapIn, activeRenderInfoIn, partialTicks, frustum);
            } else {
                this.f_109461_.f_91061_.m_107336_(matrixStackIn, multibuffersource$buffersource, lightmapIn, activeRenderInfoIn, partialTicks);
            }
            RenderStateShard.f_110126_.m_110188_();
        } else {
            profilerfiller.m_6182_("translucent");
            if (isShaders) {
                Shaders.beginWater();
            }
            if (this.f_109413_ != null) {
                this.f_109413_.m_83954_(Minecraft.f_91002_);
            }
            this.m_282537_(RenderType.m_110466_(), matrixStackIn, d0, d1, d2, projectionIn);
            if (isShaders) {
                Shaders.endWater();
            }
            multibuffersource$buffersource.m_109912_(RenderType.m_110504_());
            multibuffersource$buffersource.m_109911_();
            profilerfiller.m_6182_("string");
            this.m_282537_(RenderType.m_110503_(), matrixStackIn, d0, d1, d2, projectionIn);
            profilerfiller.m_6182_("particles");
            if (isShaders) {
                Shaders.beginParticles();
            }
            if (Reflector.ForgeHooksClient.exists()) {
                this.f_109461_.f_91061_.render(matrixStackIn, multibuffersource$buffersource, lightmapIn, activeRenderInfoIn, partialTicks, frustum);
            } else {
                this.f_109461_.f_91061_.m_107336_(matrixStackIn, multibuffersource$buffersource, lightmapIn, activeRenderInfoIn, partialTicks);
            }
            if (isShaders) {
                Shaders.endParticles();
            }
        }
        RenderSystem.setFogAllowed(true);
        poseStack.m_85836_();
        poseStack.m_268520_(matrixStackIn.m_85850_().m_85861_());
        RenderSystem.m_255902_();
        if (this.f_109461_.f_91066_.m_92174_() != CloudStatus.OFF) {
            if (this.f_109418_ != null) {
                this.f_109417_.m_83954_(Minecraft.f_91002_);
                RenderStateShard.f_110128_.m_110185_();
                profilerfiller.m_6182_("clouds");
                this.m_282433_(matrixStackIn, projectionIn, partialTicks, d0, d1, d2);
                RenderStateShard.f_110128_.m_110188_();
            } else {
                profilerfiller.m_6182_("clouds");
                RenderSystem.m_256236_(GameRenderer::m_282223_);
                this.m_282433_(matrixStackIn, projectionIn, partialTicks, d0, d1, d2);
            }
        }
        if (this.f_109418_ != null) {
            RenderStateShard.f_110127_.m_110185_();
            profilerfiller.m_6182_("weather");
            this.m_109703_(lightmapIn, partialTicks, d0, d1, d2);
            this.m_205906_(activeRenderInfoIn);
            RenderStateShard.f_110127_.m_110188_();
            this.f_109418_.m_110023_(partialTicks);
            this.f_109461_.m_91385_().m_83947_(false);
        } else {
            RenderSystem.m_69458_((boolean)false);
            if (Config.isShaders()) {
                GlStateManager.m_84298_((boolean)Shaders.isRainDepth());
            }
            profilerfiller.m_6182_("weather");
            if (isShaders) {
                Shaders.beginWeather();
            }
            this.m_109703_(lightmapIn, partialTicks, d0, d1, d2);
            if (isShaders) {
                Shaders.endWeather();
            }
            this.m_205906_(activeRenderInfoIn);
            RenderSystem.m_69458_((boolean)true);
        }
        this.m_109793_(activeRenderInfoIn);
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69461_();
        poseStack.m_85849_();
        RenderSystem.m_255902_();
        FogRenderer.m_109017_();
    }

    public void m_109588_(PoseStack matrixStackIn) {
        if (!matrixStackIn.m_85851_()) {
            throw new IllegalStateException("Pose stack not empty");
        }
    }

    public void m_109517_(Entity entityIn, double camX, double camY, double camZ, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn) {
        double d0 = Mth.m_14139_(partialTicks, entityIn.f_19790_, entityIn.m_20185_());
        double d1 = Mth.m_14139_(partialTicks, entityIn.f_19791_, entityIn.m_20186_());
        double d2 = Mth.m_14139_(partialTicks, entityIn.f_19792_, entityIn.m_20189_());
        float f = Mth.m_14179_(partialTicks, entityIn.f_19859_, entityIn.m_302838_());
        this.f_109463_.m_114384_(entityIn, d0 - camX, d1 - camY, d2 - camZ, f, partialTicks, matrixStackIn, bufferIn, this.f_109463_.m_114394_(entityIn, partialTicks));
    }

    public void m_282537_(RenderType blockLayerIn, PoseStack matrixStackIn, double xIn, double yIn, double zIn, Matrix4f projectionIn) {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
        blockLayerIn.m_110185_();
        boolean isShaders = Config.isShaders();
        if (blockLayerIn == RenderType.m_110466_() && !Shaders.isShadowPass) {
            this.f_109461_.m_91307_().m_6180_("translucent_sort");
            double d0 = xIn - this.f_109445_;
            double d1 = yIn - this.f_109446_;
            double d2 = zIn - this.f_109447_;
            if (d0 * d0 + d1 * d1 + d2 * d2 > 1.0) {
                this.f_109445_ = xIn;
                this.f_109446_ = yIn;
                this.f_109447_ = zIn;
                int j = 0;
                this.chunksToResortTransparency.clear();
                for (RenderChunkInfo levelrenderer$renderchunkinfo : this.f_109467_) {
                    if (j >= 15 || !levelrenderer$renderchunkinfo.f_109839_.m_112835_().isLayerStarted(blockLayerIn)) continue;
                    this.chunksToResortTransparency.add(levelrenderer$renderchunkinfo.f_109839_);
                    ++j;
                }
            }
            this.f_109461_.m_91307_().m_7238_();
        }
        this.f_109461_.m_91307_().m_6180_("filterempty");
        this.f_109461_.m_91307_().m_6523_(() -> "render_" + blockLayerIn);
        boolean flag = blockLayerIn != RenderType.m_110466_();
        ObjectListIterator objectlistiterator = this.f_109467_.listIterator(flag ? 0 : this.f_109467_.size());
        VertexFormat vertexformat = blockLayerIn.m_110508_();
        ShaderInstance shaderinstance = RenderSystem.m_255949_();
        BufferUploader.m_268466_();
        for (int k2 = 0; k2 < 12; ++k2) {
            int i = RenderSystem.m_255956_((int)k2);
            shaderinstance.setSampler(k2, i);
        }
        if (shaderinstance.f_283095_ != null) {
            shaderinstance.f_283095_.m_5679_(matrixStackIn.m_85850_().m_85861_());
        }
        if (shaderinstance.f_283096_ != null) {
            shaderinstance.f_283096_.m_5679_(projectionIn);
        }
        if (shaderinstance.f_283099_ != null) {
            shaderinstance.f_283099_.m_5941_(RenderSystem.m_255950_());
        }
        if (shaderinstance.f_283102_ != null) {
            shaderinstance.f_283102_.m_5985_(RenderSystem.m_255953_());
        }
        if (shaderinstance.f_283103_ != null) {
            shaderinstance.f_283103_.m_5985_(RenderSystem.m_255952_());
        }
        if (shaderinstance.f_283104_ != null) {
            shaderinstance.f_283104_.m_5941_(RenderSystem.m_255951_());
        }
        if (shaderinstance.f_283097_ != null) {
            shaderinstance.f_283097_.m_5679_(RenderSystem.m_255962_());
        }
        if (shaderinstance.f_283106_ != null) {
            shaderinstance.f_283106_.m_5985_(RenderSystem.m_255954_());
        }
        RenderSystem.m_256287_((ShaderInstance)shaderinstance);
        shaderinstance.m_283148_();
        Uniform uniform = shaderinstance.f_283107_;
        if (isShaders) {
            ShadersRender.preRenderChunkLayer((RenderType)blockLayerIn);
            Shaders.setModelViewMatrix((Matrix4f)matrixStackIn.m_85850_().m_85861_());
            Shaders.setProjectionMatrix((Matrix4f)projectionIn);
            Shaders.setTextureMatrix((Matrix4f)RenderSystem.m_255962_());
            Shaders.setColorModulator(RenderSystem.m_255950_());
        }
        boolean smartAnimations = SmartAnimations.isActive();
        if (isShaders && Shaders.activeProgramID > 0) {
            uniform = null;
        }
        boolean flag1 = false;
        if (Config.isRenderRegions() && !blockLayerIn.isNeedsSorting()) {
            int lastRegionX = Integer.MIN_VALUE;
            int lastRegionZ = Integer.MIN_VALUE;
            VboRegion lastVboRegion = null;
            Map mapRegionPositions = this.mapRegionLayers.computeIfAbsent(blockLayerIn, k -> new LinkedHashMap(16));
            Map lastMapVboRegions = null;
            List lastBuffers = null;
            while (!(!flag ? !objectlistiterator.hasPrevious() : !objectlistiterator.hasNext())) {
                BitSet animatedSprites;
                RenderChunkInfo worldrenderer$localrenderinformationcontainer1;
                RenderChunkInfo renderChunkInfo = worldrenderer$localrenderinformationcontainer1 = flag ? (RenderChunkInfo)objectlistiterator.next() : (RenderChunkInfo)objectlistiterator.previous();
                ChunkRenderDispatcher.RenderChunk chunkrenderdispatcher$chunkrender = worldrenderer$localrenderinformationcontainer1.f_109839_;
                if (chunkrenderdispatcher$chunkrender.m_112835_().m_112758_(blockLayerIn)) continue;
                VertexBuffer vertexbuffer = chunkrenderdispatcher$chunkrender.m_112807_(blockLayerIn);
                VboRegion vboRegion = vertexbuffer.getVboRegion();
                ChunkRenderDispatcher.RenderChunk renderchunk = chunkrenderdispatcher$chunkrender;
                if (renderchunk.regionX != lastRegionX || renderchunk.regionZ != lastRegionZ) {
                    PairInt pos = PairInt.of(renderchunk.regionX, renderchunk.regionZ);
                    lastMapVboRegions = mapRegionPositions.computeIfAbsent(pos, k -> new LinkedHashMap(8));
                    lastRegionX = renderchunk.regionX;
                    lastRegionZ = renderchunk.regionZ;
                    lastVboRegion = null;
                }
                if (vboRegion != lastVboRegion) {
                    lastBuffers = lastMapVboRegions.computeIfAbsent(vboRegion, k -> new ArrayList());
                    lastVboRegion = vboRegion;
                }
                lastBuffers.add(vertexbuffer);
                if (!smartAnimations || (animatedSprites = chunkrenderdispatcher$chunkrender.m_112835_().getAnimatedSprites(blockLayerIn)) == null) continue;
                SmartAnimations.spritesRendered(animatedSprites);
            }
            for (Map.Entry entryPos : mapRegionPositions.entrySet()) {
                PairInt pos = (PairInt)entryPos.getKey();
                Map mapRegions = (Map)entryPos.getValue();
                for (Map.Entry entryReg : mapRegions.entrySet()) {
                    VboRegion reg = (VboRegion)entryReg.getKey();
                    List listBuffers = (List)entryReg.getValue();
                    if (listBuffers.isEmpty()) continue;
                    for (VertexBuffer vertexBuffer : listBuffers) {
                        vertexBuffer.m_313172_();
                    }
                    this.drawRegion(pos.getLeft(), 0, pos.getRight(), xIn, yIn, zIn, reg, uniform, isShaders);
                    listBuffers.clear();
                    flag1 = true;
                }
            }
        } else {
            while (!(!flag ? !objectlistiterator.hasPrevious() : !objectlistiterator.hasNext())) {
                BitSet animatedSprites;
                RenderChunkInfo levelrenderer$renderchunkinfo1;
                RenderChunkInfo renderChunkInfo = levelrenderer$renderchunkinfo1 = flag ? (RenderChunkInfo)objectlistiterator.next() : (RenderChunkInfo)objectlistiterator.previous();
                ChunkRenderDispatcher.RenderChunk chunkrenderdispatcher$renderchunk = levelrenderer$renderchunkinfo1.f_109839_;
                if (chunkrenderdispatcher$renderchunk.m_112835_().m_112758_(blockLayerIn)) continue;
                VertexBuffer vertexbuffer = chunkrenderdispatcher$renderchunk.m_112807_(blockLayerIn);
                BlockPos blockpos = chunkrenderdispatcher$renderchunk.m_112839_();
                if (uniform != null) {
                    uniform.m_5889_((float)((double)blockpos.m_123341_() - xIn - (double)chunkrenderdispatcher$renderchunk.regionDX), (float)((double)blockpos.m_123342_() - yIn - (double)chunkrenderdispatcher$renderchunk.regionDY), (float)((double)blockpos.m_123343_() - zIn - (double)chunkrenderdispatcher$renderchunk.regionDZ));
                    uniform.m_85633_();
                }
                if (isShaders) {
                    Shaders.uniform_chunkOffset.setValue((float)((double)blockpos.m_123341_() - xIn - (double)chunkrenderdispatcher$renderchunk.regionDX), (float)((double)blockpos.m_123342_() - yIn - (double)chunkrenderdispatcher$renderchunk.regionDY), (float)((double)blockpos.m_123343_() - zIn - (double)chunkrenderdispatcher$renderchunk.regionDZ));
                }
                if (smartAnimations && (animatedSprites = chunkrenderdispatcher$renderchunk.m_112835_().getAnimatedSprites(blockLayerIn)) != null) {
                    SmartAnimations.spritesRendered(animatedSprites);
                }
                vertexbuffer.m_268571_();
                flag1 = true;
            }
        }
        if (Config.isMultiTexture()) {
            this.f_109461_.m_91097_().m_288247_(TextureAtlas.f_118259_);
        }
        if (uniform != null) {
            uniform.m_223874_(Vector3f.f_289941_);
        }
        if (isShaders) {
            Shaders.uniform_chunkOffset.setValue(0.0f, 0.0f, 0.0f);
        }
        shaderinstance.m_283147_();
        if (flag1) {
            vertexformat.m_86024_();
        }
        VertexBuffer.m_85931_();
        VertexBuffer.m_268564_();
        this.f_109461_.m_91307_().m_7238_();
        if (isShaders) {
            ShadersRender.postRenderChunkLayer((RenderType)blockLayerIn);
        }
        blockLayerIn.m_110188_();
    }

    private void drawRegion(int regionX, int regionY, int regionZ, double xIn, double yIn, double zIn, VboRegion vboRegion, Uniform uniform, boolean isShaders) {
        if (uniform != null) {
            uniform.m_5889_((float)((double)regionX - xIn), (float)((double)regionY - yIn), (float)((double)regionZ - zIn));
            uniform.m_85633_();
        }
        if (isShaders) {
            Shaders.uniform_chunkOffset.setValue((float)((double)regionX - xIn), (float)((double)regionY - yIn), (float)((double)regionZ - zIn));
        }
        vboRegion.finishDraw();
    }

    private void m_109793_(Camera activeRenderInfoIn) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_256236_(GameRenderer::m_282214_);
        if (this.f_109461_.f_90978_ || this.f_109461_.f_90979_) {
            double d0 = activeRenderInfoIn.m_90583_().m_7096_();
            double d1 = activeRenderInfoIn.m_90583_().m_7098_();
            double d2 = activeRenderInfoIn.m_90583_().m_7094_();
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69464_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69472_();
            for (RenderChunkInfo levelrenderer$renderchunkinfo : this.f_109467_) {
                ChunkRenderDispatcher.RenderChunk chunkrenderdispatcher$renderchunk = levelrenderer$renderchunkinfo.f_109839_;
                BlockPos blockpos = chunkrenderdispatcher$renderchunk.m_112839_();
                PoseStack posestack = RenderSystem.m_255945_();
                posestack.m_85836_();
                posestack.m_85837_((double)blockpos.m_123341_() - d0, (double)blockpos.m_123342_() - d1, (double)blockpos.m_123343_() - d2);
                RenderSystem.m_255902_();
                if (this.f_109461_.f_90978_) {
                    bufferbuilder.m_190458_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_85815_);
                    RenderSystem.m_69832_((float)10.0f);
                    int i = levelrenderer$renderchunkinfo.f_109842_ == 0 ? 0 : Mth.m_14169_((float)levelrenderer$renderchunkinfo.f_109842_ / 50.0f, 0.9f, 0.9f);
                    int j = i >> 16 & 0xFF;
                    int k = i >> 8 & 0xFF;
                    int l = i & 0xFF;
                    for (int i1 = 0; i1 < f_109434_.length; ++i1) {
                        if (!levelrenderer$renderchunkinfo.m_316171_(i1)) continue;
                        Direction direction = f_109434_[i1];
                        bufferbuilder.m_5483_(8.0, 8.0, 8.0).m_6122_(j, k, l, 255).m_5752_();
                        bufferbuilder.m_5483_(8 - 16 * direction.m_122429_(), 8 - 16 * direction.m_122430_(), 8 - 16 * direction.m_122431_()).m_6122_(j, k, l, 255).m_5752_();
                    }
                    tesselator.m_85914_();
                    RenderSystem.m_69832_((float)1.0f);
                }
                if (this.f_109461_.f_90979_ && !chunkrenderdispatcher$renderchunk.m_112835_().m_112757_()) {
                    bufferbuilder.m_190458_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_85815_);
                    RenderSystem.m_69832_((float)10.0f);
                    int j1 = 0;
                    for (Direction direction2 : f_109434_) {
                        for (Direction direction1 : f_109434_) {
                            boolean flag = chunkrenderdispatcher$renderchunk.m_112835_().m_7259_(direction2, direction1);
                            if (flag) continue;
                            ++j1;
                            bufferbuilder.m_5483_(8 + 8 * direction2.m_122429_(), 8 + 8 * direction2.m_122430_(), 8 + 8 * direction2.m_122431_()).m_6122_(1, 0, 0, 1).m_5752_();
                            bufferbuilder.m_5483_(8 + 8 * direction1.m_122429_(), 8 + 8 * direction1.m_122430_(), 8 + 8 * direction1.m_122431_()).m_6122_(1, 0, 0, 1).m_5752_();
                        }
                    }
                    tesselator.m_85914_();
                    RenderSystem.m_69832_((float)1.0f);
                    if (j1 > 0) {
                        bufferbuilder.m_190458_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                        float f = 0.5f;
                        float f1 = 0.2f;
                        bufferbuilder.m_5483_(0.5, 15.5, 0.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(15.5, 15.5, 0.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(15.5, 15.5, 15.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(0.5, 15.5, 15.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(0.5, 0.5, 15.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(15.5, 0.5, 15.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(15.5, 0.5, 0.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(0.5, 0.5, 0.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(0.5, 15.5, 0.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(0.5, 15.5, 15.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(0.5, 0.5, 15.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(0.5, 0.5, 0.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(15.5, 0.5, 0.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(15.5, 0.5, 15.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(15.5, 15.5, 15.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(15.5, 15.5, 0.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(0.5, 0.5, 0.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(15.5, 0.5, 0.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(15.5, 15.5, 0.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(0.5, 15.5, 0.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(0.5, 15.5, 15.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(15.5, 15.5, 15.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(15.5, 0.5, 15.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        bufferbuilder.m_5483_(0.5, 0.5, 15.5).m_85950_(0.9f, 0.9f, 0.0f, 0.2f).m_5752_();
                        tesselator.m_85914_();
                    }
                }
                posestack.m_85849_();
                RenderSystem.m_255902_();
            }
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69461_();
            RenderSystem.m_69481_();
            RenderSystem.m_69493_();
        }
        if (this.f_109442_ != null) {
            RenderSystem.m_69464_();
            RenderSystem.m_69472_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69832_((float)10.0f);
            PoseStack posestack1 = RenderSystem.m_255945_();
            posestack1.m_85836_();
            posestack1.m_85837_((float)(this.f_109444_.f_86214_ - activeRenderInfoIn.m_90583_().f_82479_), (float)(this.f_109444_.f_86215_ - activeRenderInfoIn.m_90583_().f_82480_), (float)(this.f_109444_.f_86216_ - activeRenderInfoIn.m_90583_().f_82481_));
            RenderSystem.m_255902_();
            RenderSystem.m_69458_((boolean)true);
            bufferbuilder.m_190458_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            this.m_109668_((VertexConsumer)((Object)bufferbuilder), 0, 1, 2, 3, 0, 1, 1);
            this.m_109668_((VertexConsumer)((Object)bufferbuilder), 4, 5, 6, 7, 1, 0, 0);
            this.m_109668_((VertexConsumer)((Object)bufferbuilder), 0, 1, 5, 4, 1, 1, 0);
            this.m_109668_((VertexConsumer)((Object)bufferbuilder), 2, 3, 7, 6, 0, 0, 1);
            this.m_109668_((VertexConsumer)((Object)bufferbuilder), 0, 4, 7, 3, 0, 1, 0);
            this.m_109668_((VertexConsumer)((Object)bufferbuilder), 1, 5, 6, 2, 1, 0, 1);
            tesselator.m_85914_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_256236_(GameRenderer::m_282213_);
            bufferbuilder.m_190458_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_85814_);
            RenderSystem.m_256242_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 0);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 1);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 1);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 2);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 2);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 3);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 3);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 0);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 4);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 5);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 5);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 6);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 6);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 7);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 7);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 4);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 0);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 4);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 1);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 5);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 2);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 6);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 3);
            this.m_109665_((VertexConsumer)((Object)bufferbuilder), 7);
            tesselator.m_85914_();
            posestack1.m_85849_();
            RenderSystem.m_255902_();
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69461_();
            RenderSystem.m_69481_();
            RenderSystem.m_69493_();
            RenderSystem.m_69832_((float)1.0f);
        }
    }

    private void m_109665_(VertexConsumer bufferIn, int vertex) {
        bufferIn.m_5483_(this.f_109443_[vertex].m_123601_(), this.f_109443_[vertex].m_123615_(), this.f_109443_[vertex].m_123616_()).m_5752_();
    }

    private void m_109668_(VertexConsumer bufferIn, int vertex1, int vertex2, int vertex3, int vertex4, int red, int green, int blue) {
        float f = 0.25f;
        bufferIn.m_5483_(this.f_109443_[vertex1].m_123601_(), this.f_109443_[vertex1].m_123615_(), this.f_109443_[vertex1].m_123616_()).m_85950_(red, green, blue, 0.25f).m_5752_();
        bufferIn.m_5483_(this.f_109443_[vertex2].m_123601_(), this.f_109443_[vertex2].m_123615_(), this.f_109443_[vertex2].m_123616_()).m_85950_(red, green, blue, 0.25f).m_5752_();
        bufferIn.m_5483_(this.f_109443_[vertex3].m_123601_(), this.f_109443_[vertex3].m_123615_(), this.f_109443_[vertex3].m_123616_()).m_85950_(red, green, blue, 0.25f).m_5752_();
        bufferIn.m_5483_(this.f_109443_[vertex4].m_123601_(), this.f_109443_[vertex4].m_123615_(), this.f_109443_[vertex4].m_123616_()).m_85950_(red, green, blue, 0.25f).m_5752_();
    }

    public void m_316163_() {
        this.f_109441_ = true;
    }

    public void m_316164_() {
        this.f_109442_ = null;
    }

    public void m_109823_() {
        ++this.f_109477_;
        if (this.f_109477_ % 20 == 0) {
            ObjectIterator iterator = this.f_109408_.values().iterator();
            while (iterator.hasNext()) {
                BlockDestructionProgress blockdestructionprogress = (BlockDestructionProgress)iterator.next();
                int i = blockdestructionprogress.m_139991_();
                if (this.f_109477_ - i <= 400) continue;
                iterator.remove();
                this.m_109765_(blockdestructionprogress);
            }
        }
        if (Config.isRenderRegions() && this.f_109477_ % 20 == 0) {
            this.mapRegionLayers.clear();
        }
    }

    private void m_109765_(BlockDestructionProgress progressIn) {
        long i = progressIn.m_139985_().m_121878_();
        Set set = (Set)this.f_109409_.get(i);
        set.remove(progressIn);
        if (set.isEmpty()) {
            this.f_109409_.remove(i);
        }
    }

    private void m_109780_(PoseStack matrixStackIn) {
        if (!Config.isSkyEnabled()) {
            return;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_256236_(GameRenderer::m_282217_);
        RenderSystem.m_256269_((int)0, (ResourceLocation)f_109457_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        for (int i = 0; i < 6; ++i) {
            matrixStackIn.m_85836_();
            if (i == 1) {
                matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            }
            if (i == 2) {
                matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            }
            if (i == 3) {
                matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            }
            if (i == 4) {
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            }
            if (i == 5) {
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(-90.0f));
            }
            Matrix4f matrix4f = matrixStackIn.m_85850_().m_85861_();
            bufferbuilder.m_190458_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            int r = 40;
            int g = 40;
            int b = 40;
            if (Config.isCustomColors()) {
                Vec3 vector3d = new Vec3((double)r / 255.0, (double)g / 255.0, (double)b / 255.0);
                vector3d = CustomColors.getWorldSkyColor((Vec3)vector3d, (Level)this.f_109465_, (Entity)this.f_109461_.m_91288_(), (float)0.0f);
                r = (int)(vector3d.f_82479_ * 255.0);
                g = (int)(vector3d.f_82480_ * 255.0);
                b = (int)(vector3d.f_82481_ * 255.0);
            }
            bufferbuilder.m_85982_(matrix4f, -100.0f, -100.0f, -100.0f).m_7421_(0.0f, 0.0f).m_6122_(r, g, b, 255).m_5752_();
            bufferbuilder.m_85982_(matrix4f, -100.0f, -100.0f, 100.0f).m_7421_(0.0f, 16.0f).m_6122_(r, g, b, 255).m_5752_();
            bufferbuilder.m_85982_(matrix4f, 100.0f, -100.0f, 100.0f).m_7421_(16.0f, 16.0f).m_6122_(r, g, b, 255).m_5752_();
            bufferbuilder.m_85982_(matrix4f, 100.0f, -100.0f, -100.0f).m_7421_(16.0f, 0.0f).m_6122_(r, g, b, 255).m_5752_();
            tesselator.m_85914_();
            matrixStackIn.m_85849_();
        }
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
        CustomSky.renderSky((Level)this.f_109465_, (TextureManager)this.f_109462_, (PoseStack)matrixStackIn, (float)0.0f);
    }

    public void m_316102_(PoseStack matrixStackIn, Matrix4f projectionIn, float partialTicks, Runnable setupFog) {
        ISkyRenderHandler renderHandler;
        setupFog.run();
        if (Reflector.ForgeDimensionRenderInfo_getSkyRenderHandler.exists() && (renderHandler = (ISkyRenderHandler)Reflector.call(this.f_109465_.m_104583_(), Reflector.ForgeDimensionRenderInfo_getSkyRenderHandler, new Object[0])) != null) {
            renderHandler.render(this.f_109477_, partialTicks, matrixStackIn, this.f_109465_, this.f_109461_);
            return;
        }
        if (this.f_109461_.f_91073_.m_104583_().m_108883_() == DimensionSpecialEffects.SkyType.END) {
            this.m_109780_(matrixStackIn);
        } else if (this.f_109461_.f_91073_.m_104583_().m_108883_() == DimensionSpecialEffects.SkyType.NORMAL) {
            float f10;
            RenderSystem.m_69472_();
            boolean isShaders = Config.isShaders();
            if (isShaders) {
                Shaders.disableTexture2D();
            }
            Vec3 vec3 = this.f_109465_.m_202072_(this.f_109461_.f_91063_.m_109153_().m_90583_(), partialTicks);
            vec3 = CustomColors.getSkyColor((Vec3)vec3, (BlockAndTintGetter)this.f_109461_.f_91073_, (double)this.f_109461_.m_91288_().m_20185_(), (double)(this.f_109461_.m_91288_().m_20186_() + 1.0), (double)this.f_109461_.m_91288_().m_20189_());
            if (isShaders) {
                Shaders.setSkyColor((Vec3)vec3);
                RenderSystem.setColorToAttribute(true);
            }
            float f = (float)vec3.f_82479_;
            float f1 = (float)vec3.f_82480_;
            float f2 = (float)vec3.f_82481_;
            FogRenderer.m_109036_();
            BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
            RenderSystem.m_69458_((boolean)false);
            if (isShaders) {
                Shaders.enableFog();
            }
            RenderSystem.m_256242_((float)f, (float)f1, (float)f2, (float)1.0f);
            if (isShaders) {
                Shaders.preSkyList((PoseStack)matrixStackIn);
            }
            ShaderInstance shaderinstance = RenderSystem.m_255949_();
            if (Config.isSkyEnabled()) {
                this.f_109472_.m_268555_(matrixStackIn.m_85850_().m_85861_(), projectionIn, shaderinstance);
            }
            if (isShaders) {
                Shaders.disableFog();
            }
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            float[] afloat = this.f_109465_.m_104583_().m_7518_(this.f_109465_.m_46942_(partialTicks), partialTicks);
            if (afloat != null && Config.isSunMoonEnabled()) {
                RenderSystem.m_256236_(GameRenderer::m_282214_);
                RenderSystem.m_69472_();
                if (isShaders) {
                    Shaders.disableTexture2D();
                }
                if (isShaders) {
                    Shaders.setRenderStage(RenderStage.SUNSET);
                }
                RenderSystem.m_256242_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                matrixStackIn.m_85836_();
                matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                float f3 = Mth.m_14031_(this.f_109465_.m_46490_(partialTicks)) < 0.0f ? 180.0f : 0.0f;
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(f3));
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
                float f4 = afloat[0];
                float f5 = afloat[1];
                float f6 = afloat[2];
                Matrix4f matrix4f = matrixStackIn.m_85850_().m_85861_();
                bufferbuilder.m_190458_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
                bufferbuilder.m_85982_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(f4, f5, f6, afloat[3]).m_5752_();
                int i = 16;
                for (int j = 0; j <= 16; ++j) {
                    float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                    float f8 = Mth.m_14031_(f7);
                    float f9 = Mth.m_14089_(f7);
                    bufferbuilder.m_85982_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).m_85950_(afloat[0], afloat[1], afloat[2], 0.0f).m_5752_();
                }
                bufferbuilder.m_85721_();
                BufferUploader.m_85761_(bufferbuilder);
                matrixStackIn.m_85849_();
            }
            RenderSystem.m_69493_();
            if (isShaders) {
                Shaders.enableTexture2D();
            }
            RenderSystem.m_69416_((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            matrixStackIn.m_85836_();
            float f11 = 1.0f - this.f_109465_.m_46722_(partialTicks);
            RenderSystem.m_256242_((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
            CustomSky.renderSky((Level)this.f_109465_, (TextureManager)this.f_109462_, (PoseStack)matrixStackIn, (float)partialTicks);
            if (isShaders) {
                Shaders.preCelestialRotate((PoseStack)matrixStackIn);
            }
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(this.f_109465_.m_46942_(partialTicks) * 360.0f));
            if (isShaders) {
                Shaders.postCelestialRotate((PoseStack)matrixStackIn);
            }
            Matrix4f matrix4f1 = matrixStackIn.m_85850_().m_85861_();
            float f12 = 30.0f;
            RenderSystem.m_256236_(GameRenderer::m_282216_);
            if (Config.isSunTexture()) {
                if (isShaders) {
                    Shaders.setRenderStage(RenderStage.SUN);
                }
                RenderSystem.m_256269_((int)0, (ResourceLocation)f_109455_);
                bufferbuilder.m_190458_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_85982_(matrix4f1, -f12, 100.0f, -f12).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder.m_85982_(matrix4f1, f12, 100.0f, -f12).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder.m_85982_(matrix4f1, f12, 100.0f, f12).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder.m_85982_(matrix4f1, -f12, 100.0f, f12).m_7421_(0.0f, 1.0f).m_5752_();
                bufferbuilder.m_85721_();
                BufferUploader.m_85761_(bufferbuilder);
            }
            f12 = 20.0f;
            if (Config.isMoonTexture()) {
                if (isShaders) {
                    Shaders.setRenderStage(RenderStage.MOON);
                }
                RenderSystem.m_256269_((int)0, (ResourceLocation)f_109454_);
                int k = this.f_109465_.m_46941_();
                int l = k % 4;
                int i1 = k / 4 % 2;
                float f13 = (float)(l + 0) / 4.0f;
                float f14 = (float)(i1 + 0) / 2.0f;
                float f15 = (float)(l + 1) / 4.0f;
                float f16 = (float)(i1 + 1) / 2.0f;
                bufferbuilder.m_190458_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_85982_(matrix4f1, -f12, -100.0f, f12).m_7421_(f15, f16).m_5752_();
                bufferbuilder.m_85982_(matrix4f1, f12, -100.0f, f12).m_7421_(f13, f16).m_5752_();
                bufferbuilder.m_85982_(matrix4f1, f12, -100.0f, -f12).m_7421_(f13, f14).m_5752_();
                bufferbuilder.m_85982_(matrix4f1, -f12, -100.0f, -f12).m_7421_(f15, f14).m_5752_();
                bufferbuilder.m_85721_();
                BufferUploader.m_85761_(bufferbuilder);
            }
            RenderSystem.m_69472_();
            if (isShaders) {
                Shaders.disableTexture2D();
            }
            if ((f10 = this.f_109465_.m_104811_(partialTicks) * f11) > 0.0f && Config.isStarsEnabled() && !CustomSky.hasSkyLayers((Level)this.f_109465_)) {
                if (isShaders) {
                    Shaders.setRenderStage(RenderStage.STARS);
                }
                RenderSystem.m_256242_((float)f10, (float)f10, (float)f10, (float)f10);
                FogRenderer.m_109017_();
                this.f_109471_.m_268555_(matrixStackIn.m_85850_().m_85861_(), projectionIn, GameRenderer.m_282213_());
                setupFog.run();
            }
            RenderSystem.m_256242_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69461_();
            if (isShaders) {
                Shaders.enableFog();
            }
            matrixStackIn.m_85849_();
            RenderSystem.m_69472_();
            if (isShaders) {
                Shaders.disableTexture2D();
            }
            RenderSystem.m_256242_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            double d0 = this.f_109461_.f_91074_.m_20299_((float)partialTicks).f_82480_ - this.f_109465_.m_6106_().m_315488_((LevelHeightAccessor)this.f_109465_);
            boolean voidRendered = false;
            if (d0 < 0.0) {
                if (isShaders) {
                    Shaders.setRenderStage(RenderStage.VOID);
                }
                matrixStackIn.m_85836_();
                matrixStackIn.m_85837_(0.0, 12.0, 0.0);
                this.f_109473_.m_268555_(matrixStackIn.m_85850_().m_85861_(), projectionIn, shaderinstance);
                matrixStackIn.m_85849_();
                voidRendered = true;
            }
            if (this.f_109465_.m_104583_().m_108882_()) {
                RenderSystem.m_256242_((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f), (float)1.0f);
            } else {
                RenderSystem.m_256242_((float)f, (float)f1, (float)f2, (float)1.0f);
            }
            if (isShaders) {
                RenderSystem.setColorToAttribute(false);
            }
            RenderSystem.m_69493_();
            RenderSystem.m_69458_((boolean)true);
        }
    }

    public void m_282433_(PoseStack matrixStackIn, Matrix4f projectionIn, float partialTicks, double viewEntityX, double viewEntityY, double viewEntityZ) {
        ICloudRenderHandler renderHandler;
        if (Config.isCloudsOff()) {
            return;
        }
        if (Reflector.ForgeDimensionRenderInfo_getCloudRenderHandler.exists() && (renderHandler = (ICloudRenderHandler)Reflector.call(this.f_109465_.m_104583_(), Reflector.ForgeDimensionRenderInfo_getCloudRenderHandler, new Object[0])) != null) {
            renderHandler.render(this.f_109477_, partialTicks, matrixStackIn, this.f_109465_, this.f_109461_, viewEntityX, viewEntityY, viewEntityZ);
            return;
        }
        float f = this.f_109465_.m_104583_().m_108871_();
        if (!Float.isNaN(f)) {
            if (Config.isShaders()) {
                Shaders.beginClouds();
            }
            RenderSystem.m_69464_();
            RenderSystem.m_69478_();
            RenderSystem.m_69482_();
            RenderSystem.m_69416_((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.m_69458_((boolean)true);
            float f1 = 12.0f;
            float f2 = 4.0f;
            double d0 = 2.0E-4;
            double d1 = ((float)this.f_109477_ + partialTicks) * 0.03f;
            double d2 = (viewEntityX + d1) / 12.0;
            double d3 = f - (float)viewEntityY + 0.33f;
            double d4 = viewEntityZ / 12.0 + (double)0.33f;
            d2 -= (double)(Mth.m_14107_(d2 / 2048.0) * 2048);
            d4 -= (double)(Mth.m_14107_(d4 / 2048.0) * 2048);
            float f3 = (float)(d2 - (double)Mth.m_14107_(d2));
            float f4 = (float)((d3 += this.f_109461_.f_91066_.ofCloudsHeight * 128.0) / 4.0 - (double)Mth.m_14107_(d3 / 4.0)) * 4.0f;
            float f5 = (float)(d4 - (double)Mth.m_14107_(d4));
            Vec3 vec3 = this.f_109465_.m_104808_(partialTicks);
            int i = (int)Math.floor(d2);
            int j = (int)Math.floor(d3 / 4.0);
            int k = (int)Math.floor(d4);
            if (i != this.f_109430_ || j != this.f_109431_ || k != this.f_109432_ || this.f_109461_.f_91066_.m_92174_() != this.f_109435_ || this.f_109433_.m_82557_(vec3) > 2.0E-4) {
                this.f_109430_ = i;
                this.f_109431_ = j;
                this.f_109432_ = k;
                this.f_109433_ = vec3;
                this.f_109435_ = this.f_109461_.f_91066_.m_92174_();
                this.f_109474_ = true;
            }
            if (this.f_109474_) {
                this.f_109474_ = false;
                BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
                if (this.f_109475_ != null) {
                    this.f_109475_.close();
                }
                this.f_109475_ = new VertexBuffer();
                this.m_109578_(bufferbuilder, d2, d3, d4, vec3);
                bufferbuilder.m_85721_();
                this.f_109475_.m_85925_(bufferbuilder);
            }
            RenderSystem.m_256236_(GameRenderer::m_282223_);
            RenderSystem.m_256269_((int)0, (ResourceLocation)f_109456_);
            FogRenderer.m_109036_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_85841_(12.0f, 1.0f, 12.0f);
            matrixStackIn.m_85837_(-f3, f4, -f5);
            if (this.f_109475_ != null) {
                int i1;
                for (int l = i1 = this.f_109435_ == CloudStatus.FANCY ? 0 : 1; l < 2; ++l) {
                    if (l == 0) {
                        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    } else {
                        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    }
                    ShaderInstance shaderinstance = RenderSystem.m_255949_();
                    this.f_109475_.m_268555_(matrixStackIn.m_85850_().m_85861_(), projectionIn, shaderinstance);
                }
            }
            matrixStackIn.m_85849_();
            RenderSystem.m_256242_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69481_();
            RenderSystem.m_69461_();
            if (Config.isShaders()) {
                Shaders.endClouds();
            }
        }
    }

    private void m_109578_(BufferBuilder bufferIn, double cloudsX, double cloudsY, double cloudsZ, Vec3 cloudsColor) {
        float f = 4.0f;
        float f1 = 0.00390625f;
        int i = 8;
        int j = 4;
        float f2 = 9.765625E-4f;
        float f3 = (float)Mth.m_14107_(cloudsX) * 0.00390625f;
        float f4 = (float)Mth.m_14107_(cloudsZ) * 0.00390625f;
        float f5 = (float)cloudsColor.f_82479_;
        float f6 = (float)cloudsColor.f_82480_;
        float f7 = (float)cloudsColor.f_82481_;
        float f8 = f5 * 0.9f;
        float f9 = f6 * 0.9f;
        float f10 = f7 * 0.9f;
        float f11 = f5 * 0.7f;
        float f12 = f6 * 0.7f;
        float f13 = f7 * 0.7f;
        float f14 = f5 * 0.8f;
        float f15 = f6 * 0.8f;
        float f16 = f7 * 0.8f;
        RenderSystem.m_256236_(GameRenderer::m_282223_);
        bufferIn.m_190458_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85822_);
        float f17 = (float)Math.floor(cloudsY / 4.0) * 4.0f;
        if (Config.isCloudsFancy()) {
            for (int k = -3; k <= 4; ++k) {
                for (int l = -3; l <= 4; ++l) {
                    float f18 = k * 8;
                    float f19 = l * 8;
                    if (f17 > -5.0f) {
                        bufferIn.m_5483_(f18 + 0.0f, f17 + 0.0f, f19 + 8.0f).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f11, f12, f13, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        bufferIn.m_5483_(f18 + 8.0f, f17 + 0.0f, f19 + 8.0f).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f11, f12, f13, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        bufferIn.m_5483_(f18 + 8.0f, f17 + 0.0f, f19 + 0.0f).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f11, f12, f13, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        bufferIn.m_5483_(f18 + 0.0f, f17 + 0.0f, f19 + 0.0f).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f11, f12, f13, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    }
                    if (f17 <= 5.0f) {
                        bufferIn.m_5483_(f18 + 0.0f, f17 + 4.0f - 9.765625E-4f, f19 + 8.0f).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                        bufferIn.m_5483_(f18 + 8.0f, f17 + 4.0f - 9.765625E-4f, f19 + 8.0f).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                        bufferIn.m_5483_(f18 + 8.0f, f17 + 4.0f - 9.765625E-4f, f19 + 0.0f).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                        bufferIn.m_5483_(f18 + 0.0f, f17 + 4.0f - 9.765625E-4f, f19 + 0.0f).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    }
                    if (k > -1) {
                        for (int i1 = 0; i1 < 8; ++i1) {
                            bufferIn.m_5483_(f18 + (float)i1 + 0.0f, f17 + 0.0f, f19 + 8.0f).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            bufferIn.m_5483_(f18 + (float)i1 + 0.0f, f17 + 4.0f, f19 + 8.0f).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            bufferIn.m_5483_(f18 + (float)i1 + 0.0f, f17 + 4.0f, f19 + 0.0f).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            bufferIn.m_5483_(f18 + (float)i1 + 0.0f, f17 + 0.0f, f19 + 0.0f).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                        }
                    }
                    if (k <= 1) {
                        for (int j2 = 0; j2 < 8; ++j2) {
                            bufferIn.m_5483_(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 0.0f, f19 + 8.0f).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            bufferIn.m_5483_(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 4.0f, f19 + 8.0f).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            bufferIn.m_5483_(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 4.0f, f19 + 0.0f).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            bufferIn.m_5483_(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 0.0f, f19 + 0.0f).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                        }
                    }
                    if (l > -1) {
                        for (int k2 = 0; k2 < 8; ++k2) {
                            bufferIn.m_5483_(f18 + 0.0f, f17 + 4.0f, f19 + (float)k2 + 0.0f).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            bufferIn.m_5483_(f18 + 8.0f, f17 + 4.0f, f19 + (float)k2 + 0.0f).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            bufferIn.m_5483_(f18 + 8.0f, f17 + 0.0f, f19 + (float)k2 + 0.0f).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            bufferIn.m_5483_(f18 + 0.0f, f17 + 0.0f, f19 + (float)k2 + 0.0f).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                        }
                    }
                    if (l > 1) continue;
                    for (int l2 = 0; l2 < 8; ++l2) {
                        bufferIn.m_5483_(f18 + 0.0f, f17 + 4.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                        bufferIn.m_5483_(f18 + 8.0f, f17 + 4.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                        bufferIn.m_5483_(f18 + 8.0f, f17 + 0.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                        bufferIn.m_5483_(f18 + 0.0f, f17 + 0.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                    }
                }
            }
        } else {
            boolean j1 = true;
            int k1 = 32;
            for (int l1 = -32; l1 < 32; l1 += 32) {
                for (int i2 = -32; i2 < 32; i2 += 32) {
                    bufferIn.m_5483_(l1 + 0, f17, i2 + 32).m_7421_((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    bufferIn.m_5483_(l1 + 32, f17, i2 + 32).m_7421_((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    bufferIn.m_5483_(l1 + 32, f17, i2 + 0).m_7421_((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    bufferIn.m_5483_(l1 + 0, f17, i2 + 0).m_7421_((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                }
            }
        }
    }

    public void m_109510_(long finishTimeNano) {
        ChunkRenderDispatcher.RenderChunk renderChunk;
        Iterator itTransparency;
        finishTimeNano = (long)((double)finishTimeNano + 1.0E8);
        this.f_109448_ |= this.f_109436_.m_112730_();
        long i = Util.m_137569_();
        boolean j = false;
        if (this.chunksToUpdateForced.size() > 0) {
            ChunkRenderDispatcher.RenderChunk rc;
            Iterator itForced = this.chunksToUpdateForced.iterator();
            while (itForced.hasNext() && this.f_109436_.updateChunkLater(rc = (ChunkRenderDispatcher.RenderChunk)itForced.next())) {
                rc.m_112840_();
                itForced.remove();
                this.f_109466_.remove(rc);
                this.chunksToResortTransparency.remove(rc);
            }
        }
        if (this.chunksToResortTransparency.size() > 0 && (itTransparency = this.chunksToResortTransparency.iterator()).hasNext() && this.f_109436_.updateTransparencyLater(renderChunk = (ChunkRenderDispatcher.RenderChunk)itTransparency.next())) {
            itTransparency.remove();
        }
        double weightTotal = 0.0;
        int updatesPerFrame = Config.getUpdatesPerFrame();
        if (!this.f_109466_.isEmpty()) {
            Iterator<ChunkRenderDispatcher.RenderChunk> iterator = this.f_109466_.iterator();
            while (iterator.hasNext()) {
                double weight;
                ChunkRenderDispatcher.RenderChunk chunkrenderdispatcher$renderchunk = iterator.next();
                boolean empty = chunkrenderdispatcher$renderchunk.isChunkRegionEmpty();
                boolean flag = chunkrenderdispatcher$renderchunk.m_112842_() || empty ? this.f_109436_.updateChunkNow(chunkrenderdispatcher$renderchunk) : this.f_109436_.updateChunkLater(chunkrenderdispatcher$renderchunk);
                if (!flag) break;
                chunkrenderdispatcher$renderchunk.m_112840_();
                iterator.remove();
                if (empty || !((weightTotal += (weight = 2.0 * RenderChunkUtils.getRelativeBufferSize((ChunkRenderDispatcher.RenderChunk)chunkrenderdispatcher$renderchunk))) > (double)updatesPerFrame)) continue;
                break;
            }
        }
    }

    private void m_205906_(Camera activeRenderInfoIn) {
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        WorldBorder worldborder = this.f_109465_.m_6857_();
        double d0 = this.f_109461_.f_91066_.f_92106_ * 16;
        if (!(activeRenderInfoIn.m_90583_().f_82479_ < worldborder.m_61957_() - d0 && activeRenderInfoIn.m_90583_().f_82479_ > worldborder.m_61955_() + d0 && activeRenderInfoIn.m_90583_().f_82481_ < worldborder.m_61958_() - d0 && activeRenderInfoIn.m_90583_().f_82481_ > worldborder.m_61956_() + d0)) {
            if (Config.isShaders()) {
                Shaders.pushProgram();
                Shaders.useProgram(Shaders.ProgramTexturedLit);
                Shaders.setRenderStage(RenderStage.WORLD_BORDER);
            }
            double d1 = 1.0 - worldborder.m_61941_(activeRenderInfoIn.m_90583_().f_82479_, activeRenderInfoIn.m_90583_().f_82481_) / d0;
            d1 = Math.pow(d1, 4.0);
            d1 = Mth.m_14008_(d1, 0.0, 1.0);
            double d2 = activeRenderInfoIn.m_90583_().f_82479_;
            double d3 = activeRenderInfoIn.m_90583_().f_82481_;
            double d4 = this.f_109461_.f_91063_.m_205502_();
            RenderSystem.m_69478_();
            RenderSystem.m_69482_();
            RenderSystem.m_69416_((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            RenderSystem.m_256269_((int)0, (ResourceLocation)f_109458_);
            RenderSystem.m_69458_((boolean)Minecraft.m_91085_());
            PoseStack posestack = RenderSystem.m_255945_();
            posestack.m_85836_();
            RenderSystem.m_255902_();
            int i = worldborder.m_61954_().m_61901_();
            float f = (float)(i >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(i & 0xFF) / 255.0f;
            RenderSystem.m_256242_((float)f, (float)f1, (float)f2, (float)((float)d1));
            RenderSystem.m_256236_(GameRenderer::m_282216_);
            RenderSystem.m_69863_((float)-3.0f, (float)-3.0f);
            RenderSystem.m_69486_();
            RenderSystem.m_69464_();
            float f3 = (float)(Util.m_137550_() % 3000L) / 3000.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = (float)(d4 - Mth.m_14185_(activeRenderInfoIn.m_90583_().f_82480_));
            bufferbuilder.m_190458_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            double d5 = Math.max((double)Mth.m_14107_(d3 - d0), worldborder.m_61956_());
            double d6 = Math.min((double)Mth.m_14165_(d3 + d0), worldborder.m_61958_());
            if (d2 > worldborder.m_61957_() - d0) {
                float f7 = 0.0f;
                double d7 = d5;
                while (d7 < d6) {
                    double d8 = Math.min(1.0, d6 - d7);
                    float f8 = (float)d8 * 0.5f;
                    bufferbuilder.m_5483_(worldborder.m_61957_() - d2, -d4, d7 - d3).m_7421_(f3 - f7, f3 + f6).m_5752_();
                    bufferbuilder.m_5483_(worldborder.m_61957_() - d2, -d4, d7 + d8 - d3).m_7421_(f3 - (f8 + f7), f3 + f6).m_5752_();
                    bufferbuilder.m_5483_(worldborder.m_61957_() - d2, d4, d7 + d8 - d3).m_7421_(f3 - (f8 + f7), f3 + 0.0f).m_5752_();
                    bufferbuilder.m_5483_(worldborder.m_61957_() - d2, d4, d7 - d3).m_7421_(f3 - f7, f3 + 0.0f).m_5752_();
                    d7 += 1.0;
                    f7 += 0.5f;
                }
            }
            if (d2 < worldborder.m_61955_() + d0) {
                float f9 = 0.0f;
                double d9 = d5;
                while (d9 < d6) {
                    double d12 = Math.min(1.0, d6 - d9);
                    float f12 = (float)d12 * 0.5f;
                    bufferbuilder.m_5483_(worldborder.m_61955_() - d2, -d4, d9 - d3).m_7421_(f3 + f9, f3 + f6).m_5752_();
                    bufferbuilder.m_5483_(worldborder.m_61955_() - d2, -d4, d9 + d12 - d3).m_7421_(f3 + f12 + f9, f3 + f6).m_5752_();
                    bufferbuilder.m_5483_(worldborder.m_61955_() - d2, d4, d9 + d12 - d3).m_7421_(f3 + f12 + f9, f3 + 0.0f).m_5752_();
                    bufferbuilder.m_5483_(worldborder.m_61955_() - d2, d4, d9 - d3).m_7421_(f3 + f9, f3 + 0.0f).m_5752_();
                    d9 += 1.0;
                    f9 += 0.5f;
                }
            }
            d5 = Math.max((double)Mth.m_14107_(d2 - d0), worldborder.m_61955_());
            d6 = Math.min((double)Mth.m_14165_(d2 + d0), worldborder.m_61957_());
            if (d3 > worldborder.m_61958_() - d0) {
                float f10 = 0.0f;
                double d10 = d5;
                while (d10 < d6) {
                    double d13 = Math.min(1.0, d6 - d10);
                    float f13 = (float)d13 * 0.5f;
                    bufferbuilder.m_5483_(d10 - d2, -d4, worldborder.m_61958_() - d3).m_7421_(f3 + f10, f3 + f6).m_5752_();
                    bufferbuilder.m_5483_(d10 + d13 - d2, -d4, worldborder.m_61958_() - d3).m_7421_(f3 + f13 + f10, f3 + f6).m_5752_();
                    bufferbuilder.m_5483_(d10 + d13 - d2, d4, worldborder.m_61958_() - d3).m_7421_(f3 + f13 + f10, f3 + 0.0f).m_5752_();
                    bufferbuilder.m_5483_(d10 - d2, d4, worldborder.m_61958_() - d3).m_7421_(f3 + f10, f3 + 0.0f).m_5752_();
                    d10 += 1.0;
                    f10 += 0.5f;
                }
            }
            if (d3 < worldborder.m_61956_() + d0) {
                float f11 = 0.0f;
                double d11 = d5;
                while (d11 < d6) {
                    double d14 = Math.min(1.0, d6 - d11);
                    float f14 = (float)d14 * 0.5f;
                    bufferbuilder.m_5483_(d11 - d2, -d4, worldborder.m_61956_() - d3).m_7421_(f3 - f11, f3 + f6).m_5752_();
                    bufferbuilder.m_5483_(d11 + d14 - d2, -d4, worldborder.m_61956_() - d3).m_7421_(f3 - (f14 + f11), f3 + f6).m_5752_();
                    bufferbuilder.m_5483_(d11 + d14 - d2, d4, worldborder.m_61956_() - d3).m_7421_(f3 - (f14 + f11), f3 + 0.0f).m_5752_();
                    bufferbuilder.m_5483_(d11 - d2, d4, worldborder.m_61956_() - d3).m_7421_(f3 - f11, f3 + 0.0f).m_5752_();
                    d11 += 1.0;
                    f11 += 0.5f;
                }
            }
            bufferbuilder.m_85721_();
            BufferUploader.m_85761_(bufferbuilder);
            RenderSystem.m_69481_();
            RenderSystem.m_69863_((float)0.0f, (float)0.0f);
            RenderSystem.m_69469_();
            RenderSystem.m_69416_((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            RenderSystem.m_69461_();
            posestack.m_85849_();
            RenderSystem.m_255902_();
            RenderSystem.m_69458_((boolean)true);
            if (Config.isShaders()) {
                Shaders.popProgram();
                Shaders.setRenderStage(RenderStage.NONE);
            }
        }
    }

    private void m_109637_(PoseStack matrixStackIn, VertexConsumer bufferIn, Entity entityIn, double xIn, double yIn, double zIn, BlockPos blockPosIn, BlockState blockStateIn) {
        if (Config.isCustomEntityModels() && CustomEntityModels.isCustomModel((BlockState)blockStateIn)) {
            return;
        }
        LevelRenderer.m_109782_(matrixStackIn, bufferIn, blockStateIn.m_60651_((BlockGetter)this.f_109465_, blockPosIn, CollisionContext.m_82750_((Entity)entityIn)), (double)blockPosIn.m_123341_() - xIn, (double)blockPosIn.m_123342_() - yIn, (double)blockPosIn.m_123343_() - zIn, 0.0f, 0.0f, 0.0f, 0.4f);
    }

    public static void m_109654_(PoseStack matrixStackIn, VertexConsumer bufferIn, VoxelShape shapeIn, double xIn, double yIn, double zIn, float red, float green, float blue, float alpha) {
        List list = shapeIn.m_83299_();
        int i = Mth.m_14165_((double)list.size() / 3.0);
        for (int j = 0; j < list.size(); ++j) {
            AABB aabb = (AABB)list.get(j);
            float f = ((float)j % (float)i + 1.0f) / (float)i;
            float f1 = j / i;
            float f2 = f * (float)(f1 == 0.0f ? 1 : 0);
            float f3 = f * (float)(f1 == 1.0f ? 1 : 0);
            float f4 = f * (float)(f1 == 2.0f ? 1 : 0);
            LevelRenderer.m_109782_(matrixStackIn, bufferIn, Shapes.m_83064_((AABB)aabb.m_82386_(0.0, 0.0, 0.0)), xIn, yIn, zIn, f2, f3, f4, 1.0f);
        }
    }

    private static void m_109782_(PoseStack matrixStackIn, VertexConsumer bufferIn, VoxelShape shapeIn, double xIn, double yIn, double zIn, float red, float green, float blue, float alpha) {
        PoseStack.Pose posestack$pose = matrixStackIn.m_85850_();
        shapeIn.m_83224_((x1, y1, z1, x2, y2, z2) -> {
            float f = (float)(x2 - x1);
            float f1 = (float)(y2 - y1);
            float f2 = (float)(z2 - z1);
            float f3 = Mth.m_14116_(f * f + f1 * f1 + f2 * f2);
            bufferIn.m_85982_(posestack$pose.m_85861_(), (float)(x1 + xIn), (float)(y1 + yIn), (float)(z1 + zIn)).m_85950_(red, green, blue, alpha).m_85977_(posestack$pose.m_85864_(), f /= f3, f1 /= f3, f2 /= f3).m_5752_();
            bufferIn.m_85982_(posestack$pose.m_85861_(), (float)(x2 + xIn), (float)(y2 + yIn), (float)(z2 + zIn)).m_85950_(red, green, blue, alpha).m_85977_(posestack$pose.m_85864_(), f, f1, f2).m_5752_();
        });
    }

    public static void m_316107_(VertexConsumer bufferIn, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float red, float green, float blue, float alpha) {
        LevelRenderer.m_109621_(new PoseStack(), bufferIn, minX, minY, minZ, maxX, maxY, maxZ, red, green, blue, alpha, red, green, blue);
    }

    public static void m_109646_(PoseStack matrixStackIn, VertexConsumer bufferIn, AABB aabbIn, float red, float green, float blue, float alpha) {
        LevelRenderer.m_109621_(matrixStackIn, bufferIn, aabbIn.f_82288_, aabbIn.f_82289_, aabbIn.f_82290_, aabbIn.f_82291_, aabbIn.f_82292_, aabbIn.f_82293_, red, green, blue, alpha, red, green, blue);
    }

    public static void m_109608_(PoseStack matrixStackIn, VertexConsumer bufferIn, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float red, float green, float blue, float alpha) {
        LevelRenderer.m_109621_(matrixStackIn, bufferIn, minX, minY, minZ, maxX, maxY, maxZ, red, green, blue, alpha, red, green, blue);
    }

    public static void m_109621_(PoseStack matrixStackIn, VertexConsumer bufferIn, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float red, float green, float blue, float alpha, float red2, float green2, float blue2) {
        Matrix4f matrix4f = matrixStackIn.m_85850_().m_85861_();
        Matrix3f matrix3f = matrixStackIn.m_85850_().m_85864_();
        float f = (float)minX;
        float f1 = (float)minY;
        float f2 = (float)minZ;
        float f3 = (float)maxX;
        float f4 = (float)maxY;
        float f5 = (float)maxZ;
        bufferIn.m_85982_(matrix4f, f, f1, f2).m_85950_(red, green2, blue2, alpha).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f3, f1, f2).m_85950_(red, green2, blue2, alpha).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f, f1, f2).m_85950_(red2, green, blue2, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f, f4, f2).m_85950_(red2, green, blue2, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f, f1, f2).m_85950_(red2, green2, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f, f1, f5).m_85950_(red2, green2, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f3, f1, f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f3, f4, f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f3, f4, f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f, f4, f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f, f4, f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f, f4, f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f, f4, f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f, f1, f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f, f1, f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f3, f1, f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f3, f1, f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f3, f1, f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f, f4, f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f3, f4, f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f3, f1, f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f3, f4, f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f3, f4, f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        bufferIn.m_85982_(matrix4f, f3, f4, f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    public static void m_109556_(BufferBuilder builder, double x1, double y1, double z1, double x2, double y2, double z2, float red, float green, float blue, float alpha) {
        builder.m_5483_(x1, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x1, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x1, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x1, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x1, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x1, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x1, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x1, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x2, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x2, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x2, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x2, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x2, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x2, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x2, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x2, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x1, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x1, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x1, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x2, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x1, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x2, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x2, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x1, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x1, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x1, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x2, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x2, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x2, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_5483_(x2, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
    }

    public void m_109544_(BlockGetter worldIn, BlockPos pos, BlockState oldState, BlockState newState, int flags) {
        this.m_109732_(pos, (flags & 8) != 0);
    }

    private void m_109732_(BlockPos posIn, boolean rerenderOnMainThread) {
        for (int i = posIn.m_123343_() - 1; i <= posIn.m_123343_() + 1; ++i) {
            for (int j = posIn.m_123341_() - 1; j <= posIn.m_123341_() + 1; ++j) {
                for (int k = posIn.m_123342_() - 1; k <= posIn.m_123342_() + 1; ++k) {
                    this.m_109501_(SectionPos.m_123171_((int)j), SectionPos.m_123171_((int)k), SectionPos.m_123171_((int)i), rerenderOnMainThread);
                }
            }
        }
    }

    public void m_109494_(int x1, int y1, int z1, int x2, int y2, int z2) {
        for (int i = z1 - 1; i <= z2 + 1; ++i) {
            for (int j = x1 - 1; j <= x2 + 1; ++j) {
                for (int k = y1 - 1; k <= y2 + 1; ++k) {
                    this.m_109770_(SectionPos.m_123171_((int)j), SectionPos.m_123171_((int)k), SectionPos.m_123171_((int)i));
                }
            }
        }
    }

    public void m_109721_(BlockPos blockPosIn, BlockState oldState, BlockState newState) {
        if (this.f_109461_.m_91304_().m_119415_(oldState, newState)) {
            this.m_109494_(blockPosIn.m_123341_(), blockPosIn.m_123342_(), blockPosIn.m_123343_(), blockPosIn.m_123341_(), blockPosIn.m_123342_(), blockPosIn.m_123343_());
        }
    }

    public void m_109490_(int sectionX, int sectionY, int sectionZ) {
        for (int i = sectionZ - 1; i <= sectionZ + 1; ++i) {
            for (int j = sectionX - 1; j <= sectionX + 1; ++j) {
                for (int k = sectionY - 1; k <= sectionY + 1; ++k) {
                    this.m_109770_(j, k, i);
                }
            }
        }
    }

    public void m_109770_(int sectionX, int sectionY, int sectionZ) {
        this.m_109501_(sectionX, sectionY, sectionZ, false);
    }

    private void m_109501_(int sectionX, int sectionY, int sectionZ, boolean rerenderOnMainThread) {
        this.f_109469_.m_110859_(sectionX, sectionY, sectionZ, rerenderOnMainThread);
    }

    public void m_109514_(@Nullable SoundEvent soundIn, BlockPos pos) {
        this.playStreamingMusic(soundIn, pos, soundIn == null ? null : RecordItem.m_43040_((SoundEvent)soundIn));
    }

    public void playStreamingMusic(@Nullable SoundEvent soundIn, BlockPos pos, @Nullable RecordItem musicDiscItem) {
        SoundInstance soundinstance = this.f_109410_.get(pos);
        if (soundinstance != null) {
            this.f_109461_.m_91106_().m_120399_(soundinstance);
            this.f_109410_.remove(pos);
        }
        if (soundIn != null) {
            RecordItem recorditem = RecordItem.m_43040_((SoundEvent)soundIn);
            if (Reflector.MinecraftForgeClient.exists()) {
                recorditem = musicDiscItem;
            }
            if (recorditem != null) {
                this.f_109461_.f_91065_.m_93055_((Component)recorditem.m_43050_());
            }
            SimpleSoundInstance simplesoundinstance = SimpleSoundInstance.m_119747_((SoundEvent)soundIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            this.f_109410_.put(pos, (SoundInstance)simplesoundinstance);
            this.f_109461_.m_91106_().m_120367_((SoundInstance)simplesoundinstance);
        }
        this.m_109550_(this.f_109465_, pos, soundIn != null);
    }

    private void m_109550_(Level worldIn, BlockPos pos, boolean isPartying) {
        for (LivingEntity livingentity : worldIn.m_45976_(LivingEntity.class, new AABB(pos).m_82400_(3.0))) {
            livingentity.m_6818_(pos, isPartying);
        }
    }

    public void m_109743_(ParticleOptions particleData, boolean alwaysRender, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.m_109752_(particleData, alwaysRender, false, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void m_109752_(ParticleOptions particleData, boolean ignoreRange, boolean minimizeLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        try {
            this.m_109804_(particleData, ignoreRange, minimizeLevel, x, y, z, xSpeed, ySpeed, zSpeed);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_(throwable, "Exception while adding particle");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Particle being added");
            crashreportcategory.m_128159_("ID", (Object)Registry.f_122829_.m_7981_((Object)particleData.m_6012_()));
            crashreportcategory.m_128159_("Parameters", (Object)particleData.m_5942_());
            crashreportcategory.m_128165_("Position", () -> CrashReportCategory.m_216858_((LevelHeightAccessor)this.f_109465_, (double)x, (double)y, (double)z));
            throw new ReportedException(crashreport);
        }
    }

    private <T extends ParticleOptions> void m_109735_(T particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.m_109743_(particleData, particleData.m_6012_().m_123742_(), x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Nullable
    private Particle m_109795_(ParticleOptions particleData, boolean alwaysRender, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        return this.m_109804_(particleData, alwaysRender, false, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Nullable
    private Particle m_109804_(ParticleOptions particleData, boolean alwaysRender, boolean minimizeLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        Camera camera = this.f_109461_.f_91063_.m_109153_();
        if (this.f_109461_ != null && camera.m_90593_() && this.f_109461_.f_91061_ != null) {
            ParticleStatus particlestatus = this.m_109767_(minimizeLevel);
            if (particleData == ParticleTypes.f_123812_ && !Config.isAnimatedExplosion()) {
                return null;
            }
            if (particleData == ParticleTypes.f_123813_ && !Config.isAnimatedExplosion()) {
                return null;
            }
            if (particleData == ParticleTypes.f_123759_ && !Config.isAnimatedExplosion()) {
                return null;
            }
            if (particleData == ParticleTypes.f_123768_ && !Config.isWaterParticles()) {
                return null;
            }
            if (particleData == ParticleTypes.f_123762_ && !Config.isAnimatedSmoke()) {
                return null;
            }
            if (particleData == ParticleTypes.f_123755_ && !Config.isAnimatedSmoke()) {
                return null;
            }
            if (particleData == ParticleTypes.f_123811_ && !Config.isPotionParticles()) {
                return null;
            }
            if (particleData == ParticleTypes.f_123770_ && !Config.isPotionParticles()) {
                return null;
            }
            if (particleData == ParticleTypes.f_123806_ && !Config.isPotionParticles()) {
                return null;
            }
            if (particleData == ParticleTypes.f_123751_ && !Config.isPotionParticles()) {
                return null;
            }
            if (particleData == ParticleTypes.f_123771_ && !Config.isPotionParticles()) {
                return null;
            }
            if (particleData == ParticleTypes.f_123760_ && !Config.isPortalParticles()) {
                return null;
            }
            if (particleData == ParticleTypes.f_123744_ && !Config.isAnimatedFlame()) {
                return null;
            }
            if (particleData == ParticleTypes.f_123745_ && !Config.isAnimatedFlame()) {
                return null;
            }
            if (particleData == ParticleTypes.f_123805_ && !Config.isAnimatedRedstone()) {
                return null;
            }
            if (particleData == ParticleTypes.f_123803_ && !Config.isDrippingWaterLava()) {
                return null;
            }
            if (particleData == ParticleTypes.f_123800_ && !Config.isDrippingWaterLava()) {
                return null;
            }
            if (particleData == ParticleTypes.f_123815_ && !Config.isFireworkParticles()) {
                return null;
            }
            if (!alwaysRender) {
                double maxDistSq = 1024.0;
                if (particleData == ParticleTypes.f_123797_) {
                    maxDistSq = 38416.0;
                }
                if (camera.m_90583_().m_82531_(x, y, z) > maxDistSq) {
                    return null;
                }
                if (particlestatus == ParticleStatus.MINIMAL) {
                    return null;
                }
            }
            Particle entityFx = this.f_109461_.f_91061_.m_107370_(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
            if (particleData == ParticleTypes.f_123795_) {
                CustomColors.updateWaterFX((Particle)entityFx, (BlockAndTintGetter)this.f_109465_, (double)x, (double)y, (double)z, (RenderEnv)this.renderEnv);
            }
            if (particleData == ParticleTypes.f_123769_) {
                CustomColors.updateWaterFX((Particle)entityFx, (BlockAndTintGetter)this.f_109465_, (double)x, (double)y, (double)z, (RenderEnv)this.renderEnv);
            }
            if (particleData == ParticleTypes.f_123761_) {
                CustomColors.updateWaterFX((Particle)entityFx, (BlockAndTintGetter)this.f_109465_, (double)x, (double)y, (double)z, (RenderEnv)this.renderEnv);
            }
            if (particleData == ParticleTypes.f_123757_) {
                CustomColors.updateMyceliumFX((Particle)entityFx);
            }
            if (particleData == ParticleTypes.f_123760_) {
                CustomColors.updatePortalFX((Particle)entityFx);
            }
            if (particleData == ParticleTypes.f_123805_) {
                CustomColors.updateReddustFX((Particle)entityFx, (BlockAndTintGetter)this.f_109465_, (double)x, (double)y, (double)z);
            }
            return entityFx;
        }
        return null;
    }

    private ParticleStatus m_109767_(boolean minimiseLevel) {
        ParticleStatus particlestatus = this.f_109461_.f_91066_.f_92073_;
        if (minimiseLevel && particlestatus == ParticleStatus.MINIMAL && this.f_109465_.f_46441_.nextInt(10) == 0) {
            particlestatus = ParticleStatus.DECREASED;
        }
        if (particlestatus == ParticleStatus.DECREASED && this.f_109465_.f_46441_.nextInt(3) == 0) {
            particlestatus = ParticleStatus.MINIMAL;
        }
        return particlestatus;
    }

    public void m_109824_() {
    }

    public void m_109506_(int soundID, BlockPos pos, int data) {
        switch (soundID) {
            case 1023: 
            case 1028: 
            case 1038: {
                Camera camera = this.f_109461_.f_91063_.m_109153_();
                if (!camera.m_90593_()) break;
                double d0 = (double)pos.m_123341_() - camera.m_90583_().f_82479_;
                double d1 = (double)pos.m_123342_() - camera.m_90583_().f_82480_;
                double d2 = (double)pos.m_123343_() - camera.m_90583_().f_82481_;
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                double d4 = camera.m_90583_().f_82479_;
                double d5 = camera.m_90583_().f_82480_;
                double d6 = camera.m_90583_().f_82481_;
                if (d3 > 0.0) {
                    d4 += d0 / d3 * 2.0;
                    d5 += d1 / d3 * 2.0;
                    d6 += d2 / d3 * 2.0;
                }
                if (soundID == 1023) {
                    this.f_109465_.m_7785_(d4, d5, d6, SoundEvents.f_12563_, SoundSource.HOSTILE, 1.0f, 1.0f, false);
                    break;
                }
                if (soundID == 1038) {
                    this.f_109465_.m_7785_(d4, d5, d6, SoundEvents.f_11860_, SoundSource.HOSTILE, 1.0f, 1.0f, false);
                    break;
                }
                this.f_109465_.m_7785_(d4, d5, d6, SoundEvents.f_11891_, SoundSource.HOSTILE, 5.0f, 1.0f, false);
            }
        }
    }

    public void m_109532_(Player player, int type, BlockPos blockPosIn, int data) {
        Random random = this.f_109465_.f_46441_;
        switch (type) {
            case 1000: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11796_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1001: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11797_, SoundSource.BLOCKS, 1.0f, 1.2f, false);
                break;
            }
            case 1002: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11798_, SoundSource.BLOCKS, 1.0f, 1.2f, false);
                break;
            }
            case 1003: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11898_, SoundSource.NEUTRAL, 1.0f, 1.2f, false);
                break;
            }
            case 1004: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11933_, SoundSource.NEUTRAL, 1.0f, 1.2f, false);
                break;
            }
            case 1005: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12056_, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1006: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12627_, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1007: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12629_, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1008: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11873_, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1009: {
                if (data == 0) {
                    this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f, false);
                    break;
                }
                if (data != 1) break;
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11914_, SoundSource.BLOCKS, 0.7f, 1.6f + (random.nextFloat() - random.nextFloat()) * 0.4f, false);
                break;
            }
            case 1010: {
                if (Item.m_41445_((int)data) instanceof RecordItem) {
                    if (Reflector.MinecraftForgeClient.exists()) {
                        this.playStreamingMusic(((RecordItem)Item.m_41445_((int)data)).m_43051_(), blockPosIn, (RecordItem)Item.m_41445_((int)data));
                        break;
                    }
                    this.m_109514_(((RecordItem)Item.m_41445_((int)data)).m_43051_(), blockPosIn);
                    break;
                }
                this.m_109514_(null, blockPosIn);
                break;
            }
            case 1011: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12055_, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1012: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12626_, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1013: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12628_, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1014: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11872_, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1015: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11924_, SoundSource.HOSTILE, 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1016: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11923_, SoundSource.HOSTILE, 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1017: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11896_, SoundSource.HOSTILE, 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1018: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11705_, SoundSource.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1019: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12599_, SoundSource.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1020: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12600_, SoundSource.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1021: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12601_, SoundSource.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1022: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12555_, SoundSource.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1024: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12558_, SoundSource.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1025: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11735_, SoundSource.NEUTRAL, 0.05f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1026: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12609_, SoundSource.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1027: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12616_, SoundSource.NEUTRAL, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1029: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11665_, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1030: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11671_, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1031: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11668_, SoundSource.BLOCKS, 0.3f, this.f_109465_.f_46441_.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1032: {
                this.f_109461_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119766_((SoundEvent)SoundEvents.f_12287_, (float)(random.nextFloat() * 0.4f + 0.8f), (float)0.25f));
                break;
            }
            case 1033: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11756_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1034: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11755_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1035: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1036: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12011_, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1037: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12012_, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1039: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12228_, SoundSource.HOSTILE, 0.3f, this.f_109465_.f_46441_.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1040: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12602_, SoundSource.NEUTRAL, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1041: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12044_, SoundSource.NEUTRAL, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1042: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11998_, SoundSource.BLOCKS, 1.0f, this.f_109465_.f_46441_.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1043: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11713_, SoundSource.BLOCKS, 1.0f, this.f_109465_.f_46441_.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1044: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12471_, SoundSource.BLOCKS, 1.0f, this.f_109465_.f_46441_.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1045: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_145024_, SoundSource.BLOCKS, 2.0f, this.f_109465_.f_46441_.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1046: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_145027_, SoundSource.BLOCKS, 2.0f, this.f_109465_.f_46441_.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1047: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_145028_, SoundSource.BLOCKS, 2.0f, this.f_109465_.f_46441_.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1048: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_145102_, SoundSource.NEUTRAL, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1500: {
                ComposterBlock.m_51923_((Level)this.f_109465_, (BlockPos)blockPosIn, (data > 0 ? 1 : 0) != 0);
                break;
            }
            case 1501: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f, false);
                for (int i2 = 0; i2 < 8; ++i2) {
                    this.f_109465_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)blockPosIn.m_123341_() + random.nextDouble(), (double)blockPosIn.m_123342_() + 1.2, (double)blockPosIn.m_123343_() + random.nextDouble(), 0.0, 0.0, 0.0);
                }
                break;
            }
            case 1502: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12374_, SoundSource.BLOCKS, 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f, false);
                for (int l1 = 0; l1 < 5; ++l1) {
                    double d15 = (double)blockPosIn.m_123341_() + random.nextDouble() * 0.6 + 0.2;
                    double d20 = (double)blockPosIn.m_123342_() + random.nextDouble() * 0.6 + 0.2;
                    double d26 = (double)blockPosIn.m_123343_() + random.nextDouble() * 0.6 + 0.2;
                    this.f_109465_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d15, d20, d26, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 1503: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11859_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                for (int k1 = 0; k1 < 16; ++k1) {
                    double d14 = (double)blockPosIn.m_123341_() + (5.0 + random.nextDouble() * 6.0) / 16.0;
                    double d19 = (double)blockPosIn.m_123342_() + 0.8125;
                    double d25 = (double)blockPosIn.m_123343_() + (5.0 + random.nextDouble() * 6.0) / 16.0;
                    this.f_109465_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d14, d19, d25, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 1504: {
                PointedDripstoneBlock.m_169353_((Level)this.f_109465_, (BlockPos)blockPosIn, (BlockState)this.f_109465_.m_8055_(blockPosIn));
                break;
            }
            case 1505: {
                BoneMealItem.m_40638_((LevelAccessor)this.f_109465_, (BlockPos)blockPosIn, (int)data);
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_300744_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 2000: {
                Direction direction = Direction.m_122376_(data);
                int j1 = direction.m_122429_();
                int j2 = direction.m_122430_();
                int k2 = direction.m_122431_();
                double d18 = (double)blockPosIn.m_123341_() + (double)j1 * 0.6 + 0.5;
                double d24 = (double)blockPosIn.m_123342_() + (double)j2 * 0.6 + 0.5;
                double d28 = (double)blockPosIn.m_123343_() + (double)k2 * 0.6 + 0.5;
                for (int i3 = 0; i3 < 10; ++i3) {
                    double d4 = random.nextDouble() * 0.2 + 0.01;
                    double d6 = d18 + (double)j1 * 0.01 + (random.nextDouble() - 0.5) * (double)k2 * 0.5;
                    double d8 = d24 + (double)j2 * 0.01 + (random.nextDouble() - 0.5) * (double)j2 * 0.5;
                    double d30 = d28 + (double)k2 * 0.01 + (random.nextDouble() - 0.5) * (double)j1 * 0.5;
                    double d9 = (double)j1 * d4 + random.nextGaussian() * 0.01;
                    double d10 = (double)j2 * d4 + random.nextGaussian() * 0.01;
                    double d11 = (double)k2 * d4 + random.nextGaussian() * 0.01;
                    this.m_109735_(ParticleTypes.f_123762_, d6, d8, d30, d9, d10, d11);
                }
                break;
            }
            case 2001: {
                BlockState blockstate = Block.m_49803_((int)data);
                if (!blockstate.m_60795_()) {
                    SoundType soundtype = blockstate.m_60827_();
                    if (Reflector.IForgeBlockState_getSoundType3.exists()) {
                        soundtype = (SoundType)Reflector.call(blockstate, Reflector.IForgeBlockState_getSoundType3, new Object[]{this.f_109465_, blockPosIn, null});
                    }
                    this.f_109465_.m_104677_(blockPosIn, soundtype.m_56775_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f, false);
                }
                this.f_109465_.m_141878_(blockPosIn, blockstate);
                break;
            }
            case 2002: 
            case 2007: {
                Vec3 vec3 = Vec3.m_82539_((Vec3i)blockPosIn);
                for (int i1 = 0; i1 < 8; ++i1) {
                    this.m_109735_(new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42736_)), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, random.nextGaussian() * 0.15, random.nextDouble() * 0.2, random.nextGaussian() * 0.15);
                }
                float f3 = (float)(data >> 16 & 0xFF) / 255.0f;
                float f4 = (float)(data >> 8 & 0xFF) / 255.0f;
                float f5 = (float)(data >> 0 & 0xFF) / 255.0f;
                SimpleParticleType particleoptions = type == 2007 ? ParticleTypes.f_123751_ : ParticleTypes.f_123806_;
                for (int j = 0; j < 100; ++j) {
                    double d23 = random.nextDouble() * 4.0;
                    double d27 = random.nextDouble() * Math.PI * 2.0;
                    double d29 = Math.cos(d27) * d23;
                    double d5 = 0.01 + random.nextDouble() * 0.5;
                    double d7 = Math.sin(d27) * d23;
                    Particle particle1 = this.m_109795_((ParticleOptions)particleoptions, particleoptions.m_6012_().m_123742_(), vec3.f_82479_ + d29 * 0.1, vec3.f_82480_ + 0.3, vec3.f_82481_ + d7 * 0.1, d29, d5, d7);
                    if (particle1 == null) continue;
                    float f2 = 0.75f + random.nextFloat() * 0.25f;
                    particle1.m_107253_(f3 * f2, f4 * f2, f5 * f2);
                    particle1.m_107268_((float)d23);
                }
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_12436_, SoundSource.NEUTRAL, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 2003: {
                double d0 = (double)blockPosIn.m_123341_() + 0.5;
                double d13 = blockPosIn.m_123342_();
                double d17 = (double)blockPosIn.m_123343_() + 0.5;
                for (int l2 = 0; l2 < 8; ++l2) {
                    this.m_109735_(new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42545_)), d0, d13, d17, random.nextGaussian() * 0.15, random.nextDouble() * 0.2, random.nextGaussian() * 0.15);
                }
                for (double d22 = 0.0; d22 < Math.PI * 2; d22 += 0.15707963267948966) {
                    this.m_109735_(ParticleTypes.f_123760_, d0 + Math.cos(d22) * 5.0, d13 - 0.4, d17 + Math.sin(d22) * 5.0, Math.cos(d22) * -5.0, 0.0, Math.sin(d22) * -5.0);
                    this.m_109735_(ParticleTypes.f_123760_, d0 + Math.cos(d22) * 5.0, d13 - 0.4, d17 + Math.sin(d22) * 5.0, Math.cos(d22) * -7.0, 0.0, Math.sin(d22) * -7.0);
                }
                break;
            }
            case 2004: {
                for (int l = 0; l < 20; ++l) {
                    double d12 = (double)blockPosIn.m_123341_() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
                    double d16 = (double)blockPosIn.m_123342_() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
                    double d21 = (double)blockPosIn.m_123343_() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
                    this.f_109465_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d12, d16, d21, 0.0, 0.0, 0.0);
                    this.f_109465_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d12, d16, d21, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 2005: {
                BoneMealItem.m_40638_((LevelAccessor)this.f_109465_, (BlockPos)blockPosIn, (int)data);
                break;
            }
            case 2006: {
                for (int k = 0; k < 200; ++k) {
                    float f = random.nextFloat() * 4.0f;
                    float f1 = random.nextFloat() * ((float)Math.PI * 2);
                    double d1 = Mth.m_14089_(f1) * f;
                    double d2 = 0.01 + random.nextDouble() * 0.5;
                    double d3 = Mth.m_14031_(f1) * f;
                    Particle particle = this.m_109795_((ParticleOptions)ParticleTypes.f_123799_, false, (double)blockPosIn.m_123341_() + d1 * 0.1, (double)blockPosIn.m_123342_() + 0.3, (double)blockPosIn.m_123343_() + d3 * 0.1, d1, d2, d3);
                    if (particle == null) continue;
                    particle.m_107268_(f);
                }
                if (data != 1) break;
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11892_, SoundSource.HOSTILE, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 2008: {
                this.f_109465_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, (double)blockPosIn.m_123341_() + 0.5, (double)blockPosIn.m_123342_() + 0.5, (double)blockPosIn.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                break;
            }
            case 2009: {
                for (int i = 0; i < 8; ++i) {
                    this.f_109465_.m_7106_((ParticleOptions)ParticleTypes.f_123796_, (double)blockPosIn.m_123341_() + random.nextDouble(), (double)blockPosIn.m_123342_() + 1.2, (double)blockPosIn.m_123343_() + random.nextDouble(), 0.0, 0.0, 0.0);
                }
                break;
            }
            case 3000: {
                this.f_109465_.m_6493_((ParticleOptions)ParticleTypes.f_123812_, true, (double)blockPosIn.m_123341_() + 0.5, (double)blockPosIn.m_123342_() + 0.5, (double)blockPosIn.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11858_, SoundSource.BLOCKS, 10.0f, (1.0f + (this.f_109465_.f_46441_.nextFloat() - this.f_109465_.f_46441_.nextFloat()) * 0.2f) * 0.7f, false);
                break;
            }
            case 3001: {
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_11894_, SoundSource.HOSTILE, 64.0f, 0.8f + this.f_109465_.f_46441_.nextFloat() * 0.3f, false);
                break;
            }
            case 3002: {
                if (data >= 0 && data < Direction.Axis.f_122448_.length) {
                    ParticleUtils.m_301143_((Direction.Axis)Direction.Axis.f_122448_[data], (Level)this.f_109465_, (BlockPos)blockPosIn, (double)0.125, (ParticleOptions)ParticleTypes.f_317361_, (UniformInt)UniformInt.m_302687_((int)10, (int)19));
                    break;
                }
                ParticleUtils.m_301138_((Level)this.f_109465_, (BlockPos)blockPosIn, (ParticleOptions)ParticleTypes.f_317361_, (UniformInt)UniformInt.m_302687_((int)3, (int)5));
                break;
            }
            case 3003: {
                ParticleUtils.m_301138_((Level)this.f_109465_, (BlockPos)blockPosIn, (ParticleOptions)ParticleTypes.f_317359_, (UniformInt)UniformInt.m_302687_((int)3, (int)5));
                this.f_109465_.m_104677_(blockPosIn, SoundEvents.f_300762_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 3004: {
                ParticleUtils.m_301138_((Level)this.f_109465_, (BlockPos)blockPosIn, (ParticleOptions)ParticleTypes.f_317360_, (UniformInt)UniformInt.m_302687_((int)3, (int)5));
                break;
            }
            case 3005: {
                ParticleUtils.m_301138_((Level)this.f_109465_, (BlockPos)blockPosIn, (ParticleOptions)ParticleTypes.f_317362_, (UniformInt)UniformInt.m_302687_((int)3, (int)5));
            }
        }
    }

    public void m_109774_(int breakerId, BlockPos pos, int progress) {
        if (progress >= 0 && progress < 10) {
            BlockDestructionProgress blockdestructionprogress1 = (BlockDestructionProgress)this.f_109408_.get(breakerId);
            if (blockdestructionprogress1 != null) {
                this.m_109765_(blockdestructionprogress1);
            }
            if (blockdestructionprogress1 == null || blockdestructionprogress1.m_139985_().m_123341_() != pos.m_123341_() || blockdestructionprogress1.m_139985_().m_123342_() != pos.m_123342_() || blockdestructionprogress1.m_139985_().m_123343_() != pos.m_123343_()) {
                blockdestructionprogress1 = new BlockDestructionProgress(breakerId, pos);
                this.f_109408_.put(breakerId, (Object)blockdestructionprogress1);
            }
            blockdestructionprogress1.m_139981_(progress);
            blockdestructionprogress1.m_139986_(this.f_109477_);
            ((SortedSet)this.f_109409_.computeIfAbsent(blockdestructionprogress1.m_139985_().m_121878_(), longIn -> Sets.newTreeSet())).add(blockdestructionprogress1);
        } else {
            BlockDestructionProgress blockdestructionprogress = (BlockDestructionProgress)this.f_109408_.remove(breakerId);
            if (blockdestructionprogress != null) {
                this.m_109765_(blockdestructionprogress);
            }
        }
    }

    public boolean m_109825_() {
        return this.f_109466_.isEmpty() && this.f_109436_.m_112732_();
    }

    public void m_109826_() {
        this.f_109448_ = true;
        this.f_109474_ = true;
    }

    public int getCountRenderers() {
        return this.f_109469_.f_110843_.length;
    }

    public int getCountActiveRenderers() {
        return this.f_109467_.size();
    }

    public int getCountEntitiesRendered() {
        return this.f_109439_;
    }

    public int getCountTileEntitiesRendered() {
        return this.countTileEntitiesRendered;
    }

    public int getCountLoadedChunks() {
        if (this.f_109465_ == null) {
            return 0;
        }
        ClientChunkCache chunkProvider = this.f_109465_.m_7726_();
        if (chunkProvider == null) {
            return 0;
        }
        return chunkProvider.m_299476_();
    }

    public int getCountChunksToUpdate() {
        return this.f_109466_.size();
    }

    public ChunkRenderDispatcher.RenderChunk getRenderChunk(BlockPos pos) {
        return this.f_109469_.m_110866_(pos);
    }

    public ClientLevel getWorld() {
        return this.f_109465_;
    }

    private void clearRenderInfos() {
        if (renderEntitiesCounter > 0) {
            this.f_109467_ = new ObjectArrayList(this.f_109467_.size() + 16);
            this.renderInfosEntities = new LongOpenHashSet(this.renderInfosEntities.size() + 16);
            this.renderInfosTileEntities = new ArrayList<RenderChunkInfo>(this.renderInfosTileEntities.size() + 16);
        } else {
            this.f_109467_.clear();
            this.renderInfosEntities.clear();
            this.renderInfosTileEntities.clear();
        }
    }

    public void onPlayerPositionSet() {
        if (this.firstWorldLoad) {
            this.m_109818_();
            this.firstWorldLoad = false;
        }
    }

    public void pauseChunkUpdates() {
        if (this.f_109436_ != null) {
            this.f_109436_.pauseChunkUpdates();
        }
    }

    public void resumeChunkUpdates() {
        if (this.f_109436_ != null) {
            this.f_109436_.resumeChunkUpdates();
        }
    }

    public int getFrameCount() {
        return this.f_109449_;
    }

    public int getNextFrameCount() {
        return ++this.f_109449_;
    }

    public RenderBuffers getRenderTypeTextures() {
        return this.f_109464_;
    }

    public LongOpenHashSet getRenderChunksEntities() {
        return this.renderInfosEntities;
    }

    private void addEntitySection(LongOpenHashSet set, EntitySectionStorage storage, BlockPos pos) {
        long sectionPos = SectionPos.m_214039_((BlockPos)pos);
        EntitySection es = storage.m_175654_(sectionPos);
        if (es == null) {
            return;
        }
        set.add(sectionPos);
    }

    public List<RenderChunkInfo> getRenderInfosTileEntities() {
        return this.renderInfosTileEntities;
    }

    private void checkLoadVisibleChunks(Camera activeRenderInfo, Frustum icamera, boolean spectator) {
        if (this.loadVisibleChunksCounter == 0) {
            this.loadAllVisibleChunks(activeRenderInfo, icamera, spectator);
            this.f_109461_.f_91065_.m_93076_().m_93803_(201435902);
        }
        if (this.loadVisibleChunksCounter > -1) {
            --this.loadVisibleChunksCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllVisibleChunks(Camera activeRenderInfo, Frustum icamera, boolean spectator) {
        int chunkUpdatesConfig = this.f_109461_.f_91066_.ofChunkUpdates;
        boolean lazyChunkLoadingConfig = this.f_109461_.f_91066_.ofLazyChunkLoading;
        try {
            this.f_109461_.f_91066_.ofChunkUpdates = 1000;
            this.f_109461_.f_91066_.ofLazyChunkLoading = false;
            LevelRenderer renderGlobal = Config.getRenderGlobal();
            int countLoadedChunks = renderGlobal.getCountLoadedChunks();
            long timeStart = System.currentTimeMillis();
            Config.dbg("Loading visible chunks");
            long timeLog = System.currentTimeMillis() + 5000L;
            int chunksUpdated = 0;
            boolean hasUpdates = false;
            do {
                hasUpdates = false;
                for (int i = 0; i < 100; ++i) {
                    renderGlobal.m_109826_();
                    renderGlobal.m_109695_(activeRenderInfo, icamera, false, this.f_109449_++, spectator);
                    if (!renderGlobal.m_109825_()) {
                        hasUpdates = true;
                    }
                    chunksUpdated += renderGlobal.getCountChunksToUpdate();
                    while (!renderGlobal.m_109825_()) {
                        renderGlobal.m_109510_(System.nanoTime() + 1000000000L);
                    }
                    chunksUpdated -= renderGlobal.getCountChunksToUpdate();
                    if (!hasUpdates) break;
                }
                if (renderGlobal.getCountLoadedChunks() != countLoadedChunks) {
                    hasUpdates = true;
                    countLoadedChunks = renderGlobal.getCountLoadedChunks();
                }
                if (System.currentTimeMillis() <= timeLog) continue;
                Config.log("Chunks loaded: " + chunksUpdated);
                timeLog = System.currentTimeMillis() + 5000L;
            } while (hasUpdates);
            Config.log("Chunks loaded: " + chunksUpdated);
            Config.log("Finished loading visible chunks");
            ChunkRenderDispatcher.renderChunksUpdated = 0;
        }
        finally {
            this.f_109461_.f_91066_.ofChunkUpdates = chunkUpdatesConfig;
            this.f_109461_.f_91066_.ofLazyChunkLoading = lazyChunkLoadingConfig;
        }
    }

    public IResourceType getResourceType() {
        return VanillaResourceType.MODELS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_109762_(Collection<BlockEntity> tileEntitiesToRemove, Collection<BlockEntity> tileEntitiesToAdd) {
        Set<BlockEntity> set = this.f_109468_;
        synchronized (set) {
            this.f_109468_.removeAll(tileEntitiesToRemove);
            this.f_109468_.addAll(tileEntitiesToAdd);
        }
    }

    public static int m_109541_(BlockAndTintGetter lightReaderIn, BlockPos blockPosIn) {
        return LevelRenderer.m_109537_(lightReaderIn, lightReaderIn.m_8055_(blockPosIn), blockPosIn);
    }

    public static int m_109537_(BlockAndTintGetter lightReaderIn, BlockState blockStateIn, BlockPos blockPosIn) {
        int k;
        if (blockStateIn.m_60788_((BlockGetter)lightReaderIn, blockPosIn)) {
            return 0xF000F0;
        }
        int i = lightReaderIn.m_45517_(LightLayer.SKY, blockPosIn);
        int j = lightReaderIn.m_45517_(LightLayer.BLOCK, blockPosIn);
        if (j < (k = blockStateIn.getLightValue((BlockGetter)lightReaderIn, blockPosIn))) {
            j = k;
        }
        int light = i << 20 | j << 4;
        if (Config.isDynamicLights() && lightReaderIn instanceof BlockGetter) {
            BlockAndTintGetter ibr = lightReaderIn;
            if (!ambientOcclusion || !blockStateIn.m_60804_((BlockGetter)ibr, blockPosIn)) {
                light = DynamicLights.getCombinedLight((BlockPos)blockPosIn, (int)light);
            }
        }
        return light;
    }

    @Nullable
    public RenderTarget m_109827_() {
        return this.f_109411_;
    }

    @Nullable
    public RenderTarget m_109828_() {
        return this.f_109413_;
    }

    @Nullable
    public RenderTarget m_109829_() {
        return this.f_109414_;
    }

    @Nullable
    public RenderTarget m_109830_() {
        return this.f_109415_;
    }

    @Nullable
    public RenderTarget m_109831_() {
        return this.f_109416_;
    }

    @Nullable
    public RenderTarget m_109832_() {
        return this.f_109417_;
    }

    private static /* synthetic */ VertexConsumer lambda$updateCameraAndRender$2(MultiBufferSource.BufferSource multibuffersource$buffersource, VertexConsumer vertexconsumer, RenderType renderTypeIn) {
        VertexConsumer vertexconsumer3 = multibuffersource$buffersource.m_6299_(renderTypeIn);
        return renderTypeIn.m_110405_() ? VertexMultiConsumer.m_86168_(vertexconsumer, vertexconsumer3) : vertexconsumer3;
    }

    public static class TransparencyShaderException
    extends RuntimeException {
        public TransparencyShaderException(String nameIn, Throwable causeIn) {
            super(nameIn, causeIn);
        }
    }

    static class RenderInfoMap {
        private final RenderChunkInfo[] f_316175_;
        private final RenderChunkInfo[] f_316176_;

        RenderInfoMap(int sizeIn) {
            this.f_316175_ = new RenderChunkInfo[sizeIn];
            this.f_316176_ = new RenderChunkInfo[sizeIn];
        }

        void m_316179_() {
            System.arraycopy(this.f_316176_, 0, this.f_316175_, 0, this.f_316175_.length);
        }

        public void m_316182_(ChunkRenderDispatcher.RenderChunk renderChunkIn, RenderChunkInfo infoIn) {
            this.f_316175_[renderChunkIn.f_316432_] = infoIn;
        }

        public RenderChunkInfo m_316180_(ChunkRenderDispatcher.RenderChunk renderChunkIn) {
            return this.f_316175_[renderChunkIn.f_316432_];
        }
    }

    public static class RenderChunkInfo {
        public final ChunkRenderDispatcher.RenderChunk f_109839_;
        private int f_316165_;
        int f_109841_;
        int f_109842_;

        public RenderChunkInfo(ChunkRenderDispatcher.RenderChunk renderChunkIn, @Nullable Direction facingIn, int counterIn) {
            this.f_109839_ = renderChunkIn;
            if (facingIn != null) {
                this.m_316173_(facingIn);
            }
            this.f_109842_ = counterIn;
        }

        public void setDirection(int dir, Direction facingIn) {
            this.f_109841_ = this.f_109841_ | dir | 1 << facingIn.ordinal();
        }

        public boolean m_109859_(Direction facingIn) {
            return (this.f_109841_ & 1 << facingIn.ordinal()) > 0;
        }

        private void initialize(Direction facingIn, int setFacingIn, int counter) {
            this.f_316165_ = facingIn != null ? 1 << facingIn.ordinal() : 0;
            this.f_109841_ = setFacingIn;
            this.f_109842_ = counter;
        }

        public void m_316173_(Direction directionIn) {
            this.f_316165_ = (byte)(this.f_316165_ | this.f_316165_ | 1 << directionIn.ordinal());
        }

        public boolean m_316171_(int dirIn) {
            return (this.f_316165_ & 1 << dirIn) > 0;
        }

        public boolean m_316170_() {
            return this.f_316165_ != 0;
        }
    }
}

