/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.ScreenEffectRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import net.optifine.Config;
import net.optifine.GlErrors;
import net.optifine.Lagometer;
import net.optifine.RandomEntities;
import net.optifine.entity.model.CustomEntityModels;
import net.optifine.gui.GuiChatOF;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.reflect.ReflectorResolver;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersRender;
import net.optifine.util.MemoryMonitor;
import net.optifine.util.TimedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GameRenderer
implements ResourceManagerReloadListener,
AutoCloseable {
    private static final ResourceLocation f_109057_ = new ResourceLocation("textures/misc/nausea.png");
    private static final Logger f_109058_ = LogManager.getLogger();
    private static final boolean f_315871_ = false;
    public static final float f_315867_ = 0.05f;
    private final Minecraft f_109059_;
    private final ResourceManager f_109060_;
    private final Random f_109061_ = new Random();
    private float f_109062_;
    public final ItemInHandRenderer f_109055_;
    private final MapRenderer f_109063_;
    private final RenderBuffers f_109064_;
    private int f_109065_;
    private float f_109066_;
    private float f_109067_;
    private float f_109068_;
    private float f_109069_;
    private boolean f_109070_ = true;
    private boolean f_109071_ = true;
    private long f_109072_;
    private boolean f_321122_;
    private long f_109073_ = Util.m_137550_();
    private final LightTexture f_109074_;
    private final OverlayTexture f_109075_ = new OverlayTexture();
    private boolean f_109076_;
    private float f_109077_ = 1.0f;
    private float f_109078_;
    private float f_109079_;
    public static final int f_315870_ = 40;
    @Nullable
    private ItemStack f_109080_;
    private int f_109047_;
    private float f_109048_;
    private float f_109049_;
    @Nullable
    private PostChain f_109050_;
    private static final ResourceLocation[] f_109051_ = new ResourceLocation[]{new ResourceLocation("shaders/post/notch.json"), new ResourceLocation("shaders/post/fxaa.json"), new ResourceLocation("shaders/post/art.json"), new ResourceLocation("shaders/post/bumpy.json"), new ResourceLocation("shaders/post/blobs2.json"), new ResourceLocation("shaders/post/pencil.json"), new ResourceLocation("shaders/post/color_convolve.json"), new ResourceLocation("shaders/post/deconverge.json"), new ResourceLocation("shaders/post/flip.json"), new ResourceLocation("shaders/post/invert.json"), new ResourceLocation("shaders/post/ntsc.json"), new ResourceLocation("shaders/post/outline.json"), new ResourceLocation("shaders/post/phosphor.json"), new ResourceLocation("shaders/post/scan_pincushion.json"), new ResourceLocation("shaders/post/sobel.json"), new ResourceLocation("shaders/post/bits.json"), new ResourceLocation("shaders/post/desaturate.json"), new ResourceLocation("shaders/post/green.json"), new ResourceLocation("shaders/post/blur.json"), new ResourceLocation("shaders/post/wobble.json"), new ResourceLocation("shaders/post/blobs.json"), new ResourceLocation("shaders/post/antialias.json"), new ResourceLocation("shaders/post/creeper.json"), new ResourceLocation("shaders/post/spider.json")};
    public static final int f_109056_ = f_109051_.length;
    private int f_109052_ = f_109056_;
    private boolean f_109053_;
    private final Camera f_109054_ = new Camera();
    public ShaderInstance f_282124_;
    private final Map<String, ShaderInstance> f_282071_ = Maps.newHashMap();
    @Nullable
    private static ShaderInstance f_282072_;
    @Nullable
    private static ShaderInstance f_282073_;
    @Nullable
    private static ShaderInstance f_282074_;
    @Nullable
    private static ShaderInstance f_282075_;
    @Nullable
    private static ShaderInstance f_282076_;
    @Nullable
    private static ShaderInstance f_282077_;
    @Nullable
    private static ShaderInstance f_282078_;
    @Nullable
    private static ShaderInstance f_282079_;
    @Nullable
    private static ShaderInstance f_282080_;
    @Nullable
    private static ShaderInstance f_282081_;
    @Nullable
    private static ShaderInstance f_282082_;
    @Nullable
    private static ShaderInstance f_282083_;
    @Nullable
    private static ShaderInstance f_282084_;
    @Nullable
    private static ShaderInstance f_282085_;
    @Nullable
    private static ShaderInstance f_282086_;
    @Nullable
    private static ShaderInstance f_282087_;
    @Nullable
    private static ShaderInstance f_282098_;
    @Nullable
    private static ShaderInstance f_282099_;
    @Nullable
    private static ShaderInstance f_282100_;
    @Nullable
    private static ShaderInstance f_282101_;
    @Nullable
    private static ShaderInstance f_282102_;
    @Nullable
    private static ShaderInstance f_282103_;
    @Nullable
    private static ShaderInstance f_282104_;
    @Nullable
    private static ShaderInstance f_282105_;
    @Nullable
    private static ShaderInstance f_282106_;
    @Nullable
    private static ShaderInstance f_282107_;
    @Nullable
    private static ShaderInstance f_282108_;
    @Nullable
    private static ShaderInstance f_282109_;
    @Nullable
    private static ShaderInstance f_282110_;
    @Nullable
    private static ShaderInstance f_282111_;
    @Nullable
    private static ShaderInstance f_282112_;
    @Nullable
    private static ShaderInstance f_282113_;
    @Nullable
    private static ShaderInstance f_282114_;
    @Nullable
    private static ShaderInstance f_282115_;
    @Nullable
    private static ShaderInstance f_282116_;
    @Nullable
    private static ShaderInstance f_282117_;
    @Nullable
    private static ShaderInstance f_282118_;
    @Nullable
    private static ShaderInstance f_282119_;
    @Nullable
    private static ShaderInstance f_282120_;
    @Nullable
    private static ShaderInstance f_282121_;
    @Nullable
    private static ShaderInstance f_282122_;
    @Nullable
    private static ShaderInstance f_282123_;
    @Nullable
    private static ShaderInstance f_282088_;
    @Nullable
    private static ShaderInstance f_282089_;
    @Nullable
    private static ShaderInstance f_282090_;
    @Nullable
    private static ShaderInstance f_315868_;
    @Nullable
    private static ShaderInstance f_282091_;
    @Nullable
    private static ShaderInstance f_315869_;
    @Nullable
    private static ShaderInstance f_282092_;
    @Nullable
    private static ShaderInstance f_282093_;
    @Nullable
    private static ShaderInstance f_282094_;
    @Nullable
    private static ShaderInstance f_282095_;
    @Nullable
    private static ShaderInstance f_282096_;
    @Nullable
    private static ShaderInstance f_282097_;
    private boolean initialized = false;
    private Level updatedWorld = null;
    private float clipDistance = 128.0f;
    private long lastServerTime = 0L;
    private int lastServerTicks = 0;
    private int serverWaitTime = 0;
    private int serverWaitTimeCurrent = 0;
    private float avgServerTimeDiff = 0.0f;
    private float avgServerTickDiff = 0.0f;
    private PostChain[] fxaaShaders = new PostChain[10];
    private boolean guiLoadingVisible = false;

    public GameRenderer(Minecraft mcIn, ResourceManager resourceManagerIn, RenderBuffers renderTypeBuffersIn) {
        this.f_109059_ = mcIn;
        this.f_109060_ = resourceManagerIn;
        this.f_109055_ = mcIn.m_91292_();
        this.f_109063_ = new MapRenderer(mcIn.m_91097_());
        this.f_109074_ = new LightTexture(this, mcIn);
        this.f_109064_ = renderTypeBuffersIn;
        this.f_109050_ = null;
    }

    @Override
    public void close() {
        this.f_109074_.close();
        this.f_109063_.close();
        this.f_109075_.close();
        this.m_109086_();
        this.m_282203_();
        if (this.f_282124_ != null) {
            this.f_282124_.close();
        }
    }

    public void m_315942_(boolean renderHandIn) {
        this.f_109070_ = renderHandIn;
    }

    public void m_315963_(boolean renderOutlineIn) {
        this.f_109071_ = renderOutlineIn;
    }

    public void m_315967_(boolean debugViewIn) {
        this.f_109076_ = debugViewIn;
    }

    public boolean m_315925_() {
        return this.f_109076_;
    }

    public void m_109086_() {
        if (this.f_109050_ != null) {
            this.f_109050_.close();
        }
        this.f_109050_ = null;
        this.f_109052_ = f_109056_;
    }

    public void m_109130_() {
        this.f_109053_ = !this.f_109053_;
    }

    public void m_109106_(@Nullable Entity entityIn) {
        if (this.f_109050_ != null) {
            this.f_109050_.close();
        }
        this.f_109050_ = null;
        if (entityIn instanceof Creeper) {
            this.m_109128_(new ResourceLocation("shaders/post/creeper.json"));
        } else if (entityIn instanceof Spider) {
            this.m_109128_(new ResourceLocation("shaders/post/spider.json"));
        } else if (entityIn instanceof EnderMan) {
            this.m_109128_(new ResourceLocation("shaders/post/invert.json"));
        } else if (Reflector.ForgeHooksClient_loadEntityShader.exists()) {
            Reflector.call(Reflector.ForgeHooksClient_loadEntityShader, entityIn, this);
        }
    }

    public void m_315971_() {
        if (this.f_109059_.m_91288_() instanceof Player) {
            if (this.f_109050_ != null) {
                this.f_109050_.close();
            }
            this.f_109052_ = (this.f_109052_ + 1) % (f_109051_.length + 1);
            if (this.f_109052_ == f_109056_) {
                this.f_109050_ = null;
            } else {
                this.m_109128_(f_109051_[this.f_109052_]);
            }
        }
    }

    private void m_109128_(ResourceLocation resourceLocationIn) {
        if (!GLX.isUsingFBOs()) {
            return;
        }
        if (this.f_109050_ != null) {
            this.f_109050_.close();
        }
        try {
            this.f_109050_ = new PostChain(this.f_109059_.m_91097_(), this.f_109060_, this.f_109059_.m_91385_(), resourceLocationIn);
            this.f_109050_.m_110025_(this.f_109059_.m_91268_().m_85441_(), this.f_109059_.m_91268_().m_85442_());
            this.f_109053_ = true;
        }
        catch (IOException ioexception) {
            f_109058_.warn("Failed to load shader: {}", (Object)resourceLocationIn, (Object)ioexception);
            this.f_109052_ = f_109056_;
            this.f_109053_ = false;
        }
        catch (JsonSyntaxException jsonsyntaxexception) {
            f_109058_.warn("Failed to parse shader: {}", (Object)resourceLocationIn, (Object)jsonsyntaxexception);
            this.f_109052_ = f_109056_;
            this.f_109053_ = false;
        }
    }

    public void m_6213_(ResourceManager resourceManager) {
        this.m_282207_(resourceManager);
        if (this.f_109050_ != null) {
            this.f_109050_.close();
        }
        this.f_109050_ = null;
        if (this.f_109052_ == f_109056_) {
            this.m_109106_(this.f_109059_.m_91288_());
        } else {
            this.m_109128_(f_109051_[this.f_109052_]);
        }
    }

    public void m_282168_(ResourceProvider providerIn) {
        if (this.f_282124_ != null) {
            throw new RuntimeException("Blit shader already preloaded");
        }
        try {
            this.f_282124_ = new ShaderInstance(providerIn, "blit_screen", DefaultVertexFormat.f_268508_);
        }
        catch (IOException ioexception) {
            throw new RuntimeException("could not preload blit shader", ioexception);
        }
        f_282072_ = this.m_315930_(providerIn, "position", DefaultVertexFormat.f_85814_);
        f_282073_ = this.m_315930_(providerIn, "position_color", DefaultVertexFormat.f_85815_);
        f_282074_ = this.m_315930_(providerIn, "position_color_tex", DefaultVertexFormat.f_85818_);
        f_282075_ = this.m_315930_(providerIn, "position_tex", DefaultVertexFormat.f_85817_);
        f_282076_ = this.m_315930_(providerIn, "position_tex_color", DefaultVertexFormat.f_85819_);
        f_282090_ = this.m_315930_(providerIn, "rendertype_text", DefaultVertexFormat.f_85820_);
    }

    private ShaderInstance m_315930_(ResourceProvider providerIn, String nameIn, VertexFormat formatIn) {
        try {
            ShaderInstance shaderinstance = new ShaderInstance(providerIn, nameIn, formatIn);
            this.f_282071_.put(nameIn, shaderinstance);
            return shaderinstance;
        }
        catch (Exception exception) {
            throw new IllegalStateException("could not preload shader " + nameIn, exception);
        }
    }

    public void m_282207_(ResourceManager providerIn) {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
        ArrayList list = Lists.newArrayList();
        list.addAll(Program.Type.FRAGMENT.m_85570_().values());
        list.addAll(Program.Type.VERTEX.m_85570_().values());
        list.forEach(Program::m_85543_);
        ArrayList list1 = Lists.newArrayListWithCapacity((int)this.f_282071_.size());
        try {
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "block", DefaultVertexFormat.f_85811_), p_315946_0_ -> {
                f_282077_ = p_315946_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "new_entity", DefaultVertexFormat.f_85812_), p_315944_0_ -> {
                f_282078_ = p_315944_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "particle", DefaultVertexFormat.f_85813_), p_315923_0_ -> {
                f_282079_ = p_315923_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "position", DefaultVertexFormat.f_85814_), p_315921_0_ -> {
                f_282072_ = p_315921_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "position_color", DefaultVertexFormat.f_85815_), p_315919_0_ -> {
                f_282073_ = p_315919_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "position_color_lightmap", DefaultVertexFormat.f_85816_), p_315917_0_ -> {
                f_282080_ = p_315917_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "position_color_tex", DefaultVertexFormat.f_85818_), p_315915_0_ -> {
                f_282074_ = p_315915_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "position_color_tex_lightmap", DefaultVertexFormat.f_85820_), p_315913_0_ -> {
                f_282081_ = p_315913_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "position_tex", DefaultVertexFormat.f_85817_), p_315911_0_ -> {
                f_282075_ = p_315911_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "position_tex_color", DefaultVertexFormat.f_85819_), p_315909_0_ -> {
                f_282076_ = p_315909_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "position_tex_color_normal", DefaultVertexFormat.f_85822_), p_315907_0_ -> {
                f_282082_ = p_315907_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "position_tex_lightmap_color", DefaultVertexFormat.f_85821_), p_315905_0_ -> {
                f_282083_ = p_315905_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_solid", DefaultVertexFormat.f_85811_), p_315903_0_ -> {
                f_282084_ = p_315903_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_cutout_mipped", DefaultVertexFormat.f_85811_), p_315901_0_ -> {
                f_282085_ = p_315901_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_cutout", DefaultVertexFormat.f_85811_), p_315899_0_ -> {
                f_282086_ = p_315899_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_translucent", DefaultVertexFormat.f_85811_), p_315897_0_ -> {
                f_282087_ = p_315897_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_translucent_moving_block", DefaultVertexFormat.f_85811_), p_315895_0_ -> {
                f_282098_ = p_315895_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_translucent_no_crumbling", DefaultVertexFormat.f_85811_), p_315893_0_ -> {
                f_282099_ = p_315893_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_armor_cutout_no_cull", DefaultVertexFormat.f_85812_), p_315891_0_ -> {
                f_282100_ = p_315891_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_entity_solid", DefaultVertexFormat.f_85812_), p_315889_0_ -> {
                f_282101_ = p_315889_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_entity_cutout", DefaultVertexFormat.f_85812_), p_315887_0_ -> {
                f_282102_ = p_315887_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_entity_cutout_no_cull", DefaultVertexFormat.f_85812_), p_315885_0_ -> {
                f_282103_ = p_315885_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_entity_cutout_no_cull_z_offset", DefaultVertexFormat.f_85812_), p_315883_0_ -> {
                f_282104_ = p_315883_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_item_entity_translucent_cull", DefaultVertexFormat.f_85812_), p_315881_0_ -> {
                f_282105_ = p_315881_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_entity_translucent_cull", DefaultVertexFormat.f_85812_), p_315879_0_ -> {
                f_282106_ = p_315879_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_entity_translucent", DefaultVertexFormat.f_85812_), p_315877_0_ -> {
                f_282107_ = p_315877_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_entity_smooth_cutout", DefaultVertexFormat.f_85812_), p_315875_0_ -> {
                f_282108_ = p_315875_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_beacon_beam", DefaultVertexFormat.f_85811_), p_315873_0_ -> {
                f_282109_ = p_315873_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_entity_decal", DefaultVertexFormat.f_85812_), p_316015_0_ -> {
                f_282110_ = p_316015_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_entity_no_outline", DefaultVertexFormat.f_85812_), p_316013_0_ -> {
                f_282111_ = p_316013_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_entity_shadow", DefaultVertexFormat.f_85812_), p_316011_0_ -> {
                f_282112_ = p_316011_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_entity_alpha", DefaultVertexFormat.f_85812_), p_316009_0_ -> {
                f_282113_ = p_316009_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_eyes", DefaultVertexFormat.f_85812_), p_316007_0_ -> {
                f_282114_ = p_316007_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_energy_swirl", DefaultVertexFormat.f_85812_), p_316005_0_ -> {
                f_282115_ = p_316005_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_leash", DefaultVertexFormat.f_85816_), p_316003_0_ -> {
                f_282116_ = p_316003_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_water_mask", DefaultVertexFormat.f_85814_), p_316001_0_ -> {
                f_282117_ = p_316001_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_outline", DefaultVertexFormat.f_85818_), p_315999_0_ -> {
                f_282118_ = p_315999_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_armor_glint", DefaultVertexFormat.f_85817_), p_315997_0_ -> {
                f_282119_ = p_315997_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_armor_entity_glint", DefaultVertexFormat.f_85817_), p_315995_0_ -> {
                f_282120_ = p_315995_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_glint_translucent", DefaultVertexFormat.f_85817_), p_315993_0_ -> {
                f_282121_ = p_315993_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_glint", DefaultVertexFormat.f_85817_), p_315991_0_ -> {
                f_282122_ = p_315991_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_glint_direct", DefaultVertexFormat.f_85817_), p_315989_0_ -> {
                f_282123_ = p_315989_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_entity_glint", DefaultVertexFormat.f_85817_), p_315987_0_ -> {
                f_282088_ = p_315987_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_entity_glint_direct", DefaultVertexFormat.f_85817_), p_315985_0_ -> {
                f_282089_ = p_315985_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_text", DefaultVertexFormat.f_85820_), p_315982_0_ -> {
                f_282090_ = p_315982_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_text_intensity", DefaultVertexFormat.f_85820_), p_315980_0_ -> {
                f_315868_ = p_315980_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_text_see_through", DefaultVertexFormat.f_85820_), p_315978_0_ -> {
                f_282091_ = p_315978_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_text_intensity_see_through", DefaultVertexFormat.f_85820_), p_315976_0_ -> {
                f_315869_ = p_315976_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_lightning", DefaultVertexFormat.f_85815_), p_315974_0_ -> {
                f_282092_ = p_315974_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_tripwire", DefaultVertexFormat.f_85811_), p_315972_0_ -> {
                f_282093_ = p_315972_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_end_portal", DefaultVertexFormat.f_85814_), p_315969_0_ -> {
                f_282094_ = p_315969_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_end_gateway", DefaultVertexFormat.f_85814_), p_315965_0_ -> {
                f_282095_ = p_315965_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_lines", DefaultVertexFormat.f_268509_), p_315961_0_ -> {
                f_282096_ = p_315961_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance((ResourceProvider)providerIn, "rendertype_crumbling", DefaultVertexFormat.f_85811_), p_315938_0_ -> {
                f_282097_ = p_315938_0_;
            }));
            ReflectorForge.postModLoaderEvent(Reflector.RegisterShadersEvent_Constructor, providerIn, list1);
        }
        catch (IOException ioexception) {
            list1.forEach(p_315959_0_ -> ((ShaderInstance)p_315959_0_.getFirst()).close());
            throw new RuntimeException("could not reload shaders", ioexception);
        }
        this.m_282203_();
        list1.forEach(p_315934_1_ -> {
            ShaderInstance shaderinstance = (ShaderInstance)p_315934_1_.getFirst();
            this.f_282071_.put(shaderinstance.m_316317_(), shaderinstance);
            ((Consumer)p_315934_1_.getSecond()).accept(shaderinstance);
        });
    }

    private void m_282203_() {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
        this.f_282071_.values().forEach(ShaderInstance::close);
        this.f_282071_.clear();
    }

    @Nullable
    public ShaderInstance m_315940_(@Nullable String nameIn) {
        return nameIn == null ? null : this.f_282071_.get(nameIn);
    }

    public void m_109148_() {
        this.m_109156_();
        this.f_109074_.m_109880_();
        if (this.f_109059_.m_91288_() == null) {
            this.f_109059_.m_91118_((Entity)this.f_109059_.f_91074_);
        }
        this.f_109054_.m_90565_();
        ++this.f_109065_;
        this.f_109055_.m_109311_();
        this.f_109059_.f_91060_.m_109693_(this.f_109054_);
        this.f_109069_ = this.f_109068_;
        if (this.f_109059_.f_91065_.m_93090_().m_93714_()) {
            this.f_109068_ += 0.05f;
            if (this.f_109068_ > 1.0f) {
                this.f_109068_ = 1.0f;
            }
        } else if (this.f_109068_ > 0.0f) {
            this.f_109068_ -= 0.0125f;
        }
        if (this.f_109047_ > 0) {
            --this.f_109047_;
            if (this.f_109047_ == 0) {
                this.f_109080_ = null;
            }
        }
    }

    @Nullable
    public PostChain m_109149_() {
        return this.f_109050_;
    }

    public void m_109097_(int width, int height) {
        if (this.f_109050_ != null) {
            this.f_109050_.m_110025_(width, height);
        }
        this.f_109059_.f_91060_.m_109487_(width, height);
    }

    public void m_109087_(float partialTicks) {
        Entity entity = this.f_109059_.m_91288_();
        if (entity != null && this.f_109059_.f_91073_ != null) {
            this.f_109059_.m_91307_().m_6180_("pick");
            this.f_109059_.f_91076_ = null;
            double d0 = this.f_109059_.f_91072_.m_105286_();
            this.f_109059_.f_91077_ = entity.m_19907_(d0, partialTicks, false);
            Vec3 vec3 = entity.m_20299_(partialTicks);
            boolean flag = false;
            int i = 3;
            double d1 = d0;
            if (this.f_109059_.f_91072_.m_105291_()) {
                d0 = d1 = 6.0;
            } else if (d0 > 3.0) {
                flag = true;
            }
            d1 *= d1;
            if (this.f_109059_.f_91077_ != null) {
                d1 = this.f_109059_.f_91077_.m_82450_().m_82557_(vec3);
            }
            Vec3 vec31 = entity.m_20252_(1.0f);
            Vec3 vec32 = vec3.m_82520_(vec31.f_82479_ * d0, vec31.f_82480_ * d0, vec31.f_82481_ * d0);
            float f = 1.0f;
            AABB aabb = entity.m_141786_().m_82369_(vec31.m_82490_(d0)).m_82377_(1.0, 1.0, 1.0);
            EntityHitResult entityhitresult = ProjectileUtil.m_37287_((Entity)entity, (Vec3)vec3, (Vec3)vec32, (AABB)aabb, entityIn -> !entityIn.m_5833_() && entityIn.m_6087_(), (double)d1);
            if (entityhitresult != null) {
                Entity entity1 = entityhitresult.m_82443_();
                Vec3 vec33 = entityhitresult.m_82450_();
                double d2 = vec3.m_82557_(vec33);
                if (flag && d2 > 9.0) {
                    this.f_109059_.f_91077_ = BlockHitResult.m_82426_((Vec3)vec33, (Direction)Direction.m_122366_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_), (BlockPos)new BlockPos(vec33));
                } else if (d2 < d1 || this.f_109059_.f_91077_ == null) {
                    this.f_109059_.f_91077_ = entityhitresult;
                    if (entity1 instanceof LivingEntity || entity1 instanceof ItemFrame) {
                        this.f_109059_.f_91076_ = entity1;
                    }
                }
            }
            this.f_109059_.m_91307_().m_7238_();
        }
    }

    private void m_109156_() {
        float f = 1.0f;
        if (this.f_109059_.m_91288_() instanceof AbstractClientPlayer) {
            AbstractClientPlayer abstractclientplayer = (AbstractClientPlayer)this.f_109059_.m_91288_();
            f = abstractclientplayer.m_108565_();
        }
        this.f_109067_ = this.f_109066_;
        this.f_109066_ += (f - this.f_109066_) * 0.5f;
        if (this.f_109066_ > 1.5f) {
            this.f_109066_ = 1.5f;
        }
        if (this.f_109066_ < 0.1f) {
            this.f_109066_ = 0.1f;
        }
    }

    private double m_109141_(Camera activeRenderInfoIn, float partialTicks, boolean useFOVSetting) {
        FogType fogtype;
        if (this.f_109076_) {
            return 90.0;
        }
        double d0 = 70.0;
        if (useFOVSetting) {
            boolean playerScoping;
            d0 = this.f_109059_.f_91066_.f_92068_;
            boolean bl = playerScoping = this.f_109059_.m_91288_() instanceof AbstractClientPlayer && ((AbstractClientPlayer)this.f_109059_.m_91288_()).m_158009_();
            if (Config.isDynamicFov() || playerScoping) {
                d0 *= (double)Mth.m_14179_(partialTicks, this.f_109067_, this.f_109066_);
            }
        }
        boolean zoomActive = false;
        if (this.f_109059_.f_91080_ == null) {
            zoomActive = this.f_109059_.f_91066_.ofKeyBindZoom.m_90857_();
        }
        if (zoomActive) {
            if (!Config.zoomMode) {
                Config.zoomMode = true;
                Config.zoomSmoothCamera = this.f_109059_.f_91066_.f_92067_;
                this.f_109059_.f_91066_.f_92067_ = true;
                this.f_109059_.f_91060_.m_109826_();
            }
            if (Config.zoomMode) {
                d0 /= 4.0;
            }
        } else if (Config.zoomMode) {
            Config.zoomMode = false;
            this.f_109059_.f_91066_.f_92067_ = Config.zoomSmoothCamera;
            this.f_109059_.f_91060_.m_109826_();
        }
        if (activeRenderInfoIn.m_90592_() instanceof LivingEntity && ((LivingEntity)activeRenderInfoIn.m_90592_()).m_21224_()) {
            float f = Math.min((float)((LivingEntity)activeRenderInfoIn.m_90592_()).f_20919_ + partialTicks, 20.0f);
            d0 /= (double)((1.0f - 500.0f / (f + 500.0f)) * 2.0f + 1.0f);
        }
        if ((fogtype = activeRenderInfoIn.m_192938_()) == FogType.LAVA || fogtype == FogType.WATER) {
            d0 *= (double)Mth.m_14179_(this.f_109059_.f_91066_.f_92070_, 1.0f, 0.85714287f);
        }
        if (Reflector.ForgeHooksClient_getFOVModifier.exists()) {
            return Reflector.callDouble(Reflector.ForgeHooksClient_getFOVModifier, this, activeRenderInfoIn, Float.valueOf(partialTicks), d0);
        }
        return d0;
    }

    private void m_109117_(PoseStack matrixStackIn, float partialTicks) {
        if (this.f_109059_.m_91288_() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)this.f_109059_.m_91288_();
            float f = (float)livingentity.f_20916_ - partialTicks;
            if (livingentity.m_21224_()) {
                float f1 = Math.min((float)livingentity.f_20919_ + partialTicks, 20.0f);
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(40.0f - 8000.0f / (f1 + 200.0f)));
            }
            if (f < 0.0f) {
                return;
            }
            f /= (float)livingentity.f_20917_;
            f = Mth.m_14031_(f * f * f * f * (float)Math.PI);
            float f2 = livingentity.f_20918_;
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(-f2));
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(-f * 14.0f));
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(f2));
        }
    }

    private void m_109138_(PoseStack matrixStackIn, float partialTicks) {
        if (this.f_109059_.m_91288_() instanceof Player) {
            Player player = (Player)this.f_109059_.m_91288_();
            float f = player.f_19787_ - player.f_19867_;
            float f1 = -(player.f_19787_ + f * partialTicks);
            float f2 = Mth.m_14179_(partialTicks, player.f_36099_, player.f_36100_);
            matrixStackIn.m_85837_(Mth.m_14031_(f1 * (float)Math.PI) * f2 * 0.5f, -Math.abs(Mth.m_14089_(f1 * (float)Math.PI) * f2), 0.0);
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14031_(f1 * (float)Math.PI) * f2 * 3.0f));
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(Math.abs(Mth.m_14089_(f1 * (float)Math.PI - 0.2f) * f2) * 5.0f));
        }
    }

    public void m_315926_(float zoomIn, float yawIn, float pitchIn) {
        this.f_109077_ = zoomIn;
        this.f_109078_ = yawIn;
        this.f_109079_ = pitchIn;
        this.m_315963_(false);
        this.m_315942_(false);
        this.m_109089_(1.0f, 0L, new PoseStack());
        this.f_109077_ = 1.0f;
    }

    private void m_109120_(PoseStack matrixStackIn, Camera activeRenderInfoIn, float partialTicks) {
        this.renderHand(matrixStackIn, activeRenderInfoIn, partialTicks, true, true, false);
    }

    public void renderHand(PoseStack matrixStackIn, Camera activeRenderInfoIn, float partialTicks, boolean renderItem, boolean renderOverlay, boolean renderTranslucent) {
        if (!this.f_109076_) {
            Shaders.beginRenderFirstPersonHand(renderTranslucent);
            this.m_109111_(this.m_205465_(this.m_109141_(activeRenderInfoIn, partialTicks, false)));
            PoseStack.Pose posestack$pose = matrixStackIn.m_85850_();
            posestack$pose.m_85861_().m_27624_();
            posestack$pose.m_85864_().m_8180_();
            boolean flag = false;
            if (renderItem) {
                matrixStackIn.m_85836_();
                this.m_109117_(matrixStackIn, partialTicks);
                if (this.f_109059_.f_91066_.f_92080_) {
                    this.m_109138_(matrixStackIn, partialTicks);
                }
                boolean bl = flag = this.f_109059_.m_91288_() instanceof LivingEntity && ((LivingEntity)this.f_109059_.m_91288_()).m_5803_();
                if (this.f_109059_.f_91066_.m_92176_().m_90612_() && !flag && !this.f_109059_.f_91066_.f_92062_ && this.f_109059_.f_91072_.m_105295_() != GameType.SPECTATOR) {
                    this.f_109074_.m_109896_();
                    if (Config.isShaders()) {
                        ShadersRender.renderItemFP((ItemInHandRenderer)this.f_109055_, (float)partialTicks, (PoseStack)matrixStackIn, (MultiBufferSource.BufferSource)this.f_109064_.m_110104_(), (LocalPlayer)this.f_109059_.f_91074_, (int)this.f_109059_.m_91290_().m_114394_(this.f_109059_.f_91074_, partialTicks), (boolean)renderTranslucent);
                    } else {
                        this.f_109055_.m_109314_(partialTicks, matrixStackIn, this.f_109064_.m_110104_(), this.f_109059_.f_91074_, this.f_109059_.m_91290_().m_114394_(this.f_109059_.f_91074_, partialTicks));
                    }
                    this.f_109074_.m_109891_();
                }
                matrixStackIn.m_85849_();
            }
            Shaders.endRenderFirstPersonHand();
            if (!renderOverlay) {
                return;
            }
            this.f_109074_.m_109891_();
            if (this.f_109059_.f_91066_.m_92176_().m_90612_() && !flag) {
                ScreenEffectRenderer.m_110718_(this.f_109059_, matrixStackIn);
                this.m_109117_(matrixStackIn, partialTicks);
            }
            if (this.f_109059_.f_91066_.f_92080_) {
                this.m_109138_(matrixStackIn, partialTicks);
            }
        }
    }

    public void m_109111_(Matrix4f matrixIn) {
        RenderSystem.m_256234_((Matrix4f)matrixIn);
    }

    public Matrix4f m_205465_(double fovModifierIn) {
        PoseStack posestack = new PoseStack();
        posestack.m_85850_().m_85861_().m_27624_();
        if (Config.isShaders() && Shaders.isRenderingFirstPersonHand()) {
            Shaders.applyHandDepth((PoseStack)posestack);
        }
        this.clipDistance = this.f_109062_ + 1024.0f;
        if (this.f_109077_ != 1.0f) {
            posestack.m_85837_(this.f_109078_, -this.f_109079_, 0.0);
            posestack.m_85841_(this.f_109077_, this.f_109077_, 1.0f);
        }
        posestack.m_85850_().m_85861_().m_27644_(Matrix4f.m_27625_(fovModifierIn, (float)this.f_109059_.m_91268_().m_85441_() / (float)this.f_109059_.m_91268_().m_85442_(), 0.05f, this.clipDistance));
        return posestack.m_85850_().m_85861_();
    }

    public float m_205502_() {
        return this.f_109062_ * 4.0f;
    }

    public static float m_109108_(LivingEntity livingEntityIn, float entitylivingbaseIn) {
        int i = livingEntityIn.m_21124_(MobEffects.f_19611_).m_19557_();
        return i > 200 ? 1.0f : 0.7f + Mth.m_14031_(((float)i - entitylivingbaseIn) * (float)Math.PI * 0.2f) * 0.3f;
    }

    public void m_109093_(float partialTicks, long nanoTime, boolean renderWorldIn) {
        this.frameInit();
        if (!(this.f_109059_.m_91302_() || !this.f_109059_.f_91066_.f_92126_ || this.f_109059_.f_91066_.f_92051_ && this.f_109059_.f_91067_.m_91584_())) {
            if (Util.m_137550_() - this.f_109073_ > 500L) {
                this.f_109059_.m_91358_(false);
            }
        } else {
            this.f_109073_ = Util.m_137550_();
        }
        if (!this.f_109059_.f_91079_) {
            int i = (int)(this.f_109059_.f_91067_.m_91589_() * (double)this.f_109059_.m_91268_().m_85445_() / (double)this.f_109059_.m_91268_().m_85443_());
            int j = (int)(this.f_109059_.f_91067_.m_91594_() * (double)this.f_109059_.m_91268_().m_85446_() / (double)this.f_109059_.m_91268_().m_85444_());
            if (renderWorldIn && this.f_109059_.f_91073_ != null && !Config.isReloadingResources()) {
                this.f_109059_.m_91307_().m_6180_("level");
                this.m_109089_(partialTicks, nanoTime, new PoseStack());
                this.m_321128_();
                this.f_109059_.f_91060_.m_109769_();
                if (this.f_109050_ != null && this.f_109053_) {
                    RenderSystem.m_69461_();
                    RenderSystem.m_69465_();
                    RenderSystem.m_69493_();
                    RenderSystem.m_256230_();
                    this.f_109050_.m_110023_(partialTicks);
                    RenderSystem.m_69493_();
                }
                this.f_109059_.m_91385_().m_83947_(true);
            } else {
                RenderSystem.m_69949_((int)0, (int)0, (int)this.f_109059_.m_91268_().m_85441_(), (int)this.f_109059_.m_91268_().m_85442_());
            }
            Window window = this.f_109059_.m_91268_();
            RenderSystem.m_69421_((int)256, (boolean)Minecraft.f_91002_);
            Matrix4f matrix4f = Matrix4f.m_234156_(0.0f, (float)((double)window.m_85441_() / window.m_85449_()), 0.0f, (float)((double)window.m_85442_() / window.m_85449_()), 1000.0f, 3000.0f);
            RenderSystem.m_256234_((Matrix4f)matrix4f);
            PoseStack posestack = RenderSystem.m_255945_();
            posestack.m_268524_();
            posestack.m_85837_(0.0, 0.0, -2000.0);
            RenderSystem.m_255902_();
            Lighting.m_84931_();
            PoseStack posestack1 = new PoseStack();
            if (this.f_109074_.isCustom()) {
                this.f_109074_.setAllowed(false);
            }
            if (renderWorldIn && this.f_109059_.f_91073_ != null) {
                float f;
                this.f_109059_.m_91307_().m_6182_("gui");
                if (this.f_109059_.f_91074_ != null && (f = Mth.m_14179_(partialTicks, this.f_109059_.f_91074_.f_108590_, this.f_109059_.f_91074_.f_108589_)) > 0.0f && this.f_109059_.f_91074_.m_21023_(MobEffects.f_19604_) && this.f_109059_.f_91066_.f_92069_ < 1.0f) {
                    this.m_109145_(f * (1.0f - this.f_109059_.f_91066_.f_92069_));
                }
                if (!this.f_109059_.f_91066_.f_92062_ || this.f_109059_.f_91080_ != null) {
                    this.m_109100_(this.f_109059_.m_91268_().m_85445_(), this.f_109059_.m_91268_().m_85446_(), partialTicks);
                    this.f_109059_.f_91065_.m_93030_(posestack1, partialTicks);
                    if (this.f_109059_.f_91066_.ofShowFps && !this.f_109059_.f_91066_.f_92063_) {
                        Config.drawFps((PoseStack)posestack1);
                    }
                    if (this.f_109059_.f_91066_.f_92063_) {
                        Lagometer.showLagometer((PoseStack)posestack1, (int)((int)this.f_109059_.m_91268_().m_85449_()));
                    }
                    RenderSystem.m_69421_((int)256, (boolean)Minecraft.f_91002_);
                }
                this.f_109059_.m_91307_().m_7238_();
            }
            if (this.guiLoadingVisible != (this.f_109059_.m_91265_() != null)) {
                if (this.f_109059_.m_91265_() != null) {
                    LoadingOverlay.m_96189_(this.f_109059_);
                    if (this.f_109059_.m_91265_() instanceof LoadingOverlay) {
                        LoadingOverlay rlpg = (LoadingOverlay)this.f_109059_.m_91265_();
                        rlpg.update();
                    }
                }
                boolean bl = this.guiLoadingVisible = this.f_109059_.m_91265_() != null;
            }
            if (this.f_109059_.m_91265_() != null) {
                try {
                    this.f_109059_.m_91265_().m_6305_(posestack1, i, j, this.f_109059_.m_91297_());
                }
                catch (Throwable throwable2) {
                    CrashReport crashreport = CrashReport.m_127521_(throwable2, "Rendering overlay");
                    CrashReportCategory crashreportcategory = crashreport.m_127514_("Overlay render details");
                    crashreportcategory.m_128165_("Overlay name", () -> this.f_109059_.m_91265_().getClass().getCanonicalName());
                    throw new ReportedException(crashreport);
                }
            }
            if (this.f_109059_.f_91080_ != null) {
                try {
                    if (Config.isCustomEntityModels()) {
                        CustomEntityModels.onRenderScreen((Screen)this.f_109059_.f_91080_);
                    }
                    if (Reflector.ForgeHooksClient_drawScreen.exists()) {
                        Reflector.callVoid(Reflector.ForgeHooksClient_drawScreen, this.f_109059_.f_91080_, posestack1, i, j, Float.valueOf(this.f_109059_.m_91297_()));
                    } else {
                        this.f_109059_.f_91080_.m_6305_(posestack1, i, j, this.f_109059_.m_91297_());
                    }
                }
                catch (Throwable throwable1) {
                    CrashReport crashreport1 = CrashReport.m_127521_(throwable1, "Rendering screen");
                    CrashReportCategory crashreportcategory1 = crashreport1.m_127514_("Screen render details");
                    crashreportcategory1.m_128165_("Screen name", () -> this.f_109059_.f_91080_.getClass().getCanonicalName());
                    crashreportcategory1.m_128165_("Mouse location", () -> String.format(Locale.ROOT, "Scaled: (%d, %d). Absolute: (%f, %f)", i, j, this.f_109059_.f_91067_.m_91589_(), this.f_109059_.f_91067_.m_91594_()));
                    crashreportcategory1.m_128165_("Screen size", () -> String.format(Locale.ROOT, "Scaled: (%d, %d). Absolute: (%d, %d). Scale factor of %f", this.f_109059_.m_91268_().m_85445_(), this.f_109059_.m_91268_().m_85446_(), this.f_109059_.m_91268_().m_85441_(), this.f_109059_.m_91268_().m_85442_(), this.f_109059_.m_91268_().m_85449_()));
                    throw new ReportedException(crashreport1);
                }
                try {
                    if (this.f_109059_.f_91080_ != null) {
                        this.f_109059_.f_91080_.m_314589_();
                    }
                }
                catch (Throwable throwable) {
                    CrashReport crashreport2 = CrashReport.m_127521_(throwable, "Narrating screen");
                    CrashReportCategory crashreportcategory2 = crashreport2.m_127514_("Screen details");
                    crashreportcategory2.m_128165_("Screen name", () -> this.f_109059_.f_91080_.getClass().getCanonicalName());
                    throw new ReportedException(crashreport2);
                }
            }
            this.f_109074_.setAllowed(true);
        }
        this.frameFinish();
        this.waitForServerThread();
        MemoryMonitor.update();
        Lagometer.updateLagometer();
        if (this.f_109059_.f_91066_.ofProfiler) {
            this.f_109059_.f_91066_.f_92064_ = true;
        }
    }

    private void m_321128_() {
        long i;
        if (!this.f_321122_ && this.f_109059_.m_91090_() && (i = Util.m_137550_()) - this.f_109072_ >= 1000L) {
            this.f_109072_ = i;
            IntegratedServer integratedserver = this.f_109059_.m_91092_();
            if (integratedserver != null && !integratedserver.m_129918_()) {
                integratedserver.m_321133_().ifPresent(p_321129_1_ -> {
                    if (Files.isRegularFile(p_321129_1_, new LinkOption[0])) {
                        this.f_321122_ = true;
                    } else {
                        this.m_321126_((Path)p_321129_1_);
                    }
                });
            }
        }
    }

    private void m_321126_(Path p_321126_1_) {
        if (this.f_109059_.f_91060_.m_109821_() > 10 && this.f_109059_.f_91060_.m_109825_()) {
            NativeImage nativeimage = Screenshot.m_321024_(this.f_109059_.m_91385_());
            Util.m_137579_().execute(() -> {
                int i = nativeimage.m_84982_();
                int j = nativeimage.m_85084_();
                int k = 0;
                int l = 0;
                if (i > j) {
                    k = (i - j) / 2;
                    i = j;
                } else {
                    l = (j - i) / 2;
                    j = i;
                }
                try (NativeImage nativeimage1 = new NativeImage(64, 64, false);){
                    nativeimage.m_85034_(k, l, i, j, nativeimage1);
                    nativeimage1.m_85066_(p_321126_1_);
                }
                catch (IOException ioexception) {
                    f_109058_.warn("Couldn't save auto screenshot", (Throwable)ioexception);
                }
                finally {
                    nativeimage.close();
                }
            });
        }
    }

    private boolean m_109158_() {
        boolean flag;
        if (!this.f_109071_) {
            return false;
        }
        Entity entity = this.f_109059_.m_91288_();
        boolean bl = flag = entity instanceof Player && !this.f_109059_.f_91066_.f_92062_;
        if (flag && !((Player)entity).m_158008_().f_35938_) {
            ItemStack itemstack = ((LivingEntity)entity).m_21205_();
            HitResult hitresult = this.f_109059_.f_91077_;
            if (hitresult != null && hitresult.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos blockpos = ((BlockHitResult)hitresult).m_82425_();
                BlockState blockstate = this.f_109059_.f_91073_.m_8055_(blockpos);
                if (this.f_109059_.f_91072_.m_105295_() == GameType.SPECTATOR) {
                    flag = blockstate.m_60750_(this.f_109059_.f_91073_, blockpos) != null;
                } else {
                    BlockInWorld blockinworld = new BlockInWorld((LevelReader)this.f_109059_.f_91073_, blockpos, false);
                    flag = !itemstack.m_41619_() && (itemstack.m_41633_(this.f_109059_.f_91073_.m_5999_(), blockinworld) || itemstack.m_41723_(this.f_109059_.f_91073_.m_5999_(), blockinworld));
                }
            }
        }
        return flag;
    }

    public void m_109089_(float partialTicks, long finishTimeNano, PoseStack matrixStackIn) {
        float f;
        this.f_109074_.m_109881_(partialTicks);
        if (this.f_109059_.m_91288_() == null) {
            this.f_109059_.m_91118_((Entity)this.f_109059_.f_91074_);
        }
        this.m_109087_(partialTicks);
        if (Config.isShaders()) {
            Shaders.beginRender((Minecraft)this.f_109059_, (Camera)this.f_109054_, (float)partialTicks, (long)finishTimeNano);
        }
        this.f_109059_.m_91307_().m_6180_("center");
        boolean isShaders = Config.isShaders();
        if (isShaders) {
            Shaders.beginRenderPass(partialTicks, finishTimeNano);
        }
        boolean flag = this.m_109158_();
        this.f_109059_.m_91307_().m_6182_("camera");
        Camera camera = this.f_109054_;
        this.f_109062_ = this.f_109059_.f_91066_.f_92106_ * 16;
        if (Config.isFogOn()) {
            this.f_109062_ *= 0.95f;
        }
        PoseStack posestack = new PoseStack();
        double d0 = this.m_109141_(camera, partialTicks, true);
        posestack.m_85850_().m_85861_().m_27644_(this.m_205465_(d0));
        PoseStack matrixStackProjection = posestack;
        if (Shaders.isEffectsModelView()) {
            posestack = matrixStackIn;
        }
        this.m_109117_(posestack, partialTicks);
        if (this.f_109059_.f_91066_.f_92080_) {
            this.m_109138_(posestack, partialTicks);
        }
        if ((f = Mth.m_14179_(partialTicks, this.f_109059_.f_91074_.f_108590_, this.f_109059_.f_91074_.f_108589_) * this.f_109059_.f_91066_.f_92069_ * this.f_109059_.f_91066_.f_92069_) > 0.0f) {
            int i = this.f_109059_.f_91074_.m_21023_(MobEffects.f_19604_) ? 7 : 20;
            float f1 = 5.0f / (f * f + 5.0f) - f * 0.04f;
            f1 *= f1;
            Vector3f vector3f = new Vector3f(0.0f, Mth.f_13994_ / 2.0f, Mth.f_13994_ / 2.0f);
            posestack.m_85845_(vector3f.m_122240_(((float)this.f_109065_ + partialTicks) * (float)i));
            posestack.m_85841_(1.0f / f1, 1.0f, 1.0f);
            float f2 = -((float)this.f_109065_ + partialTicks) * (float)i;
            posestack.m_85845_(vector3f.m_122240_(f2));
        }
        if (Shaders.isEffectsModelView()) {
            posestack = matrixStackProjection;
        }
        Matrix4f matrix4f = posestack.m_85850_().m_85861_();
        this.m_109111_(matrix4f);
        camera.m_90575_((BlockGetter)this.f_109059_.f_91073_, (Entity)(this.f_109059_.m_91288_() == null ? this.f_109059_.f_91074_ : this.f_109059_.m_91288_()), !this.f_109059_.f_91066_.m_92176_().m_90612_(), this.f_109059_.f_91066_.m_92176_().m_90613_(), partialTicks);
        if (Reflector.ForgeHooksClient_onCameraSetup.exists()) {
            Object cameraSetup = Reflector.ForgeHooksClient_onCameraSetup.call(this, camera, Float.valueOf(partialTicks));
            float cameraSetupYaw = Reflector.callFloat(cameraSetup, Reflector.EntityViewRenderEvent_CameraSetup_getYaw, new Object[0]);
            float cameraSetupPitch = Reflector.callFloat(cameraSetup, Reflector.EntityViewRenderEvent_CameraSetup_getPitch, new Object[0]);
            float cameraSetupRoll = Reflector.callFloat(cameraSetup, Reflector.EntityViewRenderEvent_CameraSetup_getRoll, new Object[0]);
            camera.setAnglesInternal(cameraSetupYaw, cameraSetupPitch);
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(cameraSetupRoll));
        }
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(camera.m_90589_()));
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(camera.m_90590_() + 180.0f));
        this.f_109059_.f_91060_.m_205731_(matrixStackIn, camera.m_90583_(), this.m_205465_(Math.max(d0, this.f_109059_.f_91066_.f_92068_)));
        this.f_109059_.f_91060_.m_109599_(matrixStackIn, partialTicks, finishTimeNano, flag, camera, this, this.f_109074_, matrix4f);
        if (Reflector.ForgeHooksClient_dispatchRenderLast.exists()) {
            this.f_109059_.m_91307_().m_6182_("forge_render_last");
            Reflector.callVoid(Reflector.ForgeHooksClient_dispatchRenderLast, this.f_109059_.f_91060_, matrixStackIn, Float.valueOf(partialTicks), matrix4f, finishTimeNano);
        }
        this.f_109059_.m_91307_().m_6182_("hand");
        if (this.f_109070_ && !Shaders.isShadowPass) {
            if (isShaders) {
                ShadersRender.renderHand1((GameRenderer)this, (PoseStack)matrixStackIn, (Camera)camera, (float)partialTicks);
                Shaders.renderCompositeFinal();
            }
            RenderSystem.m_69421_((int)256, (boolean)Minecraft.f_91002_);
            if (isShaders) {
                ShadersRender.renderFPOverlay((GameRenderer)this, (PoseStack)matrixStackIn, (Camera)camera, (float)partialTicks);
            } else {
                this.m_109120_(matrixStackIn, camera, partialTicks);
            }
        }
        if (isShaders) {
            Shaders.endRender();
        }
        this.f_109059_.m_91307_().m_7238_();
    }

    public void m_109150_() {
        this.f_109080_ = null;
        this.f_109063_.m_93260_();
        this.f_109054_.m_90598_();
        this.f_321122_ = false;
    }

    public MapRenderer m_109151_() {
        return this.f_109063_;
    }

    private void waitForServerThread() {
        this.serverWaitTimeCurrent = 0;
        if (!Config.isSmoothWorld() || !Config.isSingleProcessor()) {
            this.lastServerTime = 0L;
            this.lastServerTicks = 0;
            return;
        }
        if (!this.f_109059_.m_91090_()) {
            return;
        }
        IntegratedServer srv = this.f_109059_.m_91092_();
        if (srv == null) {
            return;
        }
        boolean paused = this.f_109059_.m_91104_();
        if (paused || this.f_109059_.f_91080_ instanceof ReceivingLevelScreen) {
            if (this.f_109059_.f_91080_ instanceof ReceivingLevelScreen) {
                Config.sleep(20L);
            }
            this.lastServerTime = 0L;
            this.lastServerTicks = 0;
            return;
        }
        if (this.serverWaitTime > 0) {
            Lagometer.timerServer.start();
            Config.sleep(this.serverWaitTime);
            Lagometer.timerServer.end();
            this.serverWaitTimeCurrent = this.serverWaitTime;
        }
        long timeNow = System.nanoTime() / 1000000L;
        if (this.lastServerTime == 0L || this.lastServerTicks == 0) {
            this.lastServerTime = timeNow;
            this.lastServerTicks = srv.m_129921_();
            this.avgServerTickDiff = 1.0f;
            this.avgServerTimeDiff = 50.0f;
            return;
        }
        long timeDiff = timeNow - this.lastServerTime;
        if (timeDiff < 0L) {
            this.lastServerTime = timeNow;
            timeDiff = 0L;
        }
        if (timeDiff < 50L) {
            return;
        }
        this.lastServerTime = timeNow;
        int ticks = srv.m_129921_();
        int tickDiff = ticks - this.lastServerTicks;
        if (tickDiff < 0) {
            this.lastServerTicks = ticks;
            tickDiff = 0;
        }
        if (tickDiff < 1 && this.serverWaitTime < 100) {
            this.serverWaitTime += 2;
        }
        if (tickDiff > 1 && this.serverWaitTime > 0) {
            --this.serverWaitTime;
        }
        this.lastServerTicks = ticks;
    }

    private void frameInit() {
        ClientLevel world;
        Config.frameStart();
        GlErrors.frameStart();
        if (!this.initialized) {
            ReflectorResolver.resolve();
            if (Config.getBitsOs() == 64 && Config.getBitsJre() == 32) {
                Config.setNotify64BitJava(true);
            }
            this.initialized = true;
        }
        if ((world = this.f_109059_.f_91073_) != null) {
            if (Config.getNewRelease() != null) {
                String userEdition = "HD_U".replace("HD_U", "HD Ultra").replace("L", "Light");
                String fullNewVer = userEdition + " " + Config.getNewRelease();
                TextComponent msg = new TextComponent(I18n.m_118938_((String)"of.message.newVersion", (Object[])new Object[]{"\u00a7n" + fullNewVer + "\u00a7r"}));
                msg.m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://optifine.net/downloads")));
                this.f_109059_.f_91065_.m_93076_().m_93785_((Component)msg);
                Config.setNewRelease(null);
            }
            if (Config.isNotify64BitJava()) {
                Config.setNotify64BitJava(false);
                TextComponent msg = new TextComponent(I18n.m_118938_((String)"of.message.java64Bit", (Object[])new Object[0]));
                this.f_109059_.f_91065_.m_93076_().m_93785_((Component)msg);
            }
        }
        if (this.updatedWorld != world) {
            RandomEntities.worldChanged((Level)this.updatedWorld, (Level)world);
            Config.updateThreadPriorities();
            this.lastServerTime = 0L;
            this.lastServerTicks = 0;
            this.updatedWorld = world;
        }
        if (!this.setFxaaShader(Shaders.configAntialiasingLevel)) {
            Shaders.configAntialiasingLevel = 0;
        }
        if (this.f_109059_.f_91080_ != null && this.f_109059_.f_91080_.getClass() == ChatScreen.class) {
            this.f_109059_.m_91152_((Screen)new GuiChatOF((ChatScreen)this.f_109059_.f_91080_));
        }
    }

    private void frameFinish() {
        int err;
        if (this.f_109059_.f_91073_ != null && Config.isShowGlErrors() && TimedEvent.isActive("CheckGlErrorFrameFinish", 10000L) && (err = GlStateManager.m_84118_()) != 0 && GlErrors.isEnabled(err)) {
            String text = Config.getGlErrorString(err);
            TextComponent msg = new TextComponent(I18n.m_118938_((String)"of.message.openglError", (Object[])new Object[]{err, text}));
            this.f_109059_.f_91065_.m_93076_().m_93785_((Component)msg);
        }
    }

    public boolean setFxaaShader(int fxaaLevel) {
        if (!GLX.isUsingFBOs()) {
            return false;
        }
        if (this.f_109050_ != null && this.f_109050_ != this.fxaaShaders[2] && this.f_109050_ != this.fxaaShaders[4]) {
            return true;
        }
        if (fxaaLevel == 2 || fxaaLevel == 4) {
            if (this.f_109050_ != null && this.f_109050_ == this.fxaaShaders[fxaaLevel]) {
                return true;
            }
            if (this.f_109059_.f_91073_ == null) {
                return true;
            }
            this.m_109128_(new ResourceLocation("shaders/post/fxaa_of_" + fxaaLevel + "x.json"));
            this.fxaaShaders[fxaaLevel] = this.f_109050_;
            return this.f_109053_;
        }
        if (this.f_109050_ == null) {
            return true;
        }
        this.f_109050_.close();
        this.f_109050_ = null;
        return true;
    }

    public IResourceType getResourceType() {
        return VanillaResourceType.SHADERS;
    }

    public void m_109113_(ItemStack stack) {
        this.f_109080_ = stack;
        this.f_109047_ = 40;
        this.f_109048_ = this.f_109061_.nextFloat() * 2.0f - 1.0f;
        this.f_109049_ = this.f_109061_.nextFloat() * 2.0f - 1.0f;
    }

    private void m_109100_(int widthsp, int heightScaled, float partialTicks) {
        if (this.f_109080_ != null && this.f_109047_ > 0) {
            int i = 40 - this.f_109047_;
            float f = ((float)i + partialTicks) / 40.0f;
            float f1 = f * f;
            float f2 = f * f1;
            float f3 = 10.25f * f2 * f1 - 24.95f * f1 * f1 + 25.5f * f2 - 13.8f * f1 + 4.0f * f;
            float f4 = f3 * (float)Math.PI;
            float f5 = this.f_109048_ * (float)(widthsp / 4);
            float f6 = this.f_109049_ * (float)(heightScaled / 4);
            RenderSystem.m_69482_();
            RenderSystem.m_69464_();
            PoseStack posestack = new PoseStack();
            posestack.m_85836_();
            posestack.m_85837_((float)(widthsp / 2) + f5 * Mth.m_14154_(Mth.m_14031_(f4 * 2.0f)), (float)(heightScaled / 2) + f6 * Mth.m_14154_(Mth.m_14031_(f4 * 2.0f)), -50.0);
            float f7 = 50.0f + 175.0f * Mth.m_14031_(f4);
            posestack.m_85841_(f7, -f7, f7);
            posestack.m_85845_(Vector3f.f_122225_.m_122240_(900.0f * Mth.m_14154_(Mth.m_14031_(f4))));
            posestack.m_85845_(Vector3f.f_122223_.m_122240_(6.0f * Mth.m_14089_(f * 8.0f)));
            posestack.m_85845_(Vector3f.f_122227_.m_122240_(6.0f * Mth.m_14089_(f * 8.0f)));
            MultiBufferSource.BufferSource multibuffersource$buffersource = this.f_109064_.m_110104_();
            this.f_109059_.m_91291_().m_209365_(this.f_109080_, ItemTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.f_118083_, posestack, multibuffersource$buffersource, 0);
            posestack.m_85849_();
            multibuffersource$buffersource.m_109911_();
            RenderSystem.m_69481_();
            RenderSystem.m_69465_();
        }
    }

    private void m_109145_(float scaleIn) {
        int i = this.f_109059_.m_91268_().m_85445_();
        int j = this.f_109059_.m_91268_().m_85446_();
        double d0 = Mth.m_14139_(scaleIn, 2.0, 1.0);
        float f = 0.2f * scaleIn;
        float f1 = 0.4f * scaleIn;
        float f2 = 0.2f * scaleIn;
        double d1 = (double)i * d0;
        double d2 = (double)j * d0;
        double d3 = ((double)i - d1) / 2.0;
        double d4 = ((double)j - d2) / 2.0;
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.m_256242_((float)f, (float)f1, (float)f2, (float)1.0f);
        RenderSystem.m_256236_(GameRenderer::m_282216_);
        RenderSystem.m_256269_((int)0, (ResourceLocation)f_109057_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_190458_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_5483_(d3, d4 + d2, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_(d3 + d1, d4 + d2, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_(d3 + d1, d4, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_5483_(d3, d4, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_256242_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69453_();
        RenderSystem.m_69461_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
    }

    public Minecraft m_315984_() {
        return this.f_109059_;
    }

    public float m_109131_(float partialTicks) {
        return Mth.m_14179_(partialTicks, this.f_109069_, this.f_109068_);
    }

    public float m_109152_() {
        return this.f_109062_;
    }

    public Camera m_109153_() {
        return this.f_109054_;
    }

    public LightTexture m_109154_() {
        return this.f_109074_;
    }

    public OverlayTexture m_109155_() {
        return this.f_109075_;
    }

    @Nullable
    public static ShaderInstance m_282213_() {
        return f_282072_;
    }

    @Nullable
    public static ShaderInstance m_282214_() {
        return f_282073_;
    }

    @Nullable
    public static ShaderInstance m_282215_() {
        return f_282074_;
    }

    @Nullable
    public static ShaderInstance m_282216_() {
        return f_282075_;
    }

    @Nullable
    public static ShaderInstance m_282217_() {
        return f_282076_;
    }

    @Nullable
    public static ShaderInstance m_282218_() {
        return f_282077_;
    }

    @Nullable
    public static ShaderInstance m_282219_() {
        return f_282078_;
    }

    @Nullable
    public static ShaderInstance m_282220_() {
        return f_282079_;
    }

    @Nullable
    public static ShaderInstance m_282221_() {
        return f_282080_;
    }

    @Nullable
    public static ShaderInstance m_282222_() {
        return f_282081_;
    }

    @Nullable
    public static ShaderInstance m_282223_() {
        return f_282082_;
    }

    @Nullable
    public static ShaderInstance m_315872_() {
        return f_282083_;
    }

    @Nullable
    public static ShaderInstance m_282128_() {
        return f_282084_;
    }

    @Nullable
    public static ShaderInstance m_282129_() {
        return f_282085_;
    }

    @Nullable
    public static ShaderInstance m_282130_() {
        return f_282086_;
    }

    @Nullable
    public static ShaderInstance m_282131_() {
        return f_282087_;
    }

    @Nullable
    public static ShaderInstance m_282132_() {
        return f_282098_;
    }

    @Nullable
    public static ShaderInstance m_282133_() {
        return f_282099_;
    }

    @Nullable
    public static ShaderInstance m_282134_() {
        return f_282100_;
    }

    @Nullable
    public static ShaderInstance m_282135_() {
        return f_282101_;
    }

    @Nullable
    public static ShaderInstance m_282136_() {
        return f_282102_;
    }

    @Nullable
    public static ShaderInstance m_282137_() {
        return f_282103_;
    }

    @Nullable
    public static ShaderInstance m_282138_() {
        return f_282104_;
    }

    @Nullable
    public static ShaderInstance m_282139_() {
        return f_282105_;
    }

    @Nullable
    public static ShaderInstance m_282140_() {
        return f_282106_;
    }

    @Nullable
    public static ShaderInstance m_282141_() {
        return f_282107_;
    }

    @Nullable
    public static ShaderInstance m_282142_() {
        return f_282108_;
    }

    @Nullable
    public static ShaderInstance m_282143_() {
        return f_282109_;
    }

    @Nullable
    public static ShaderInstance m_282144_() {
        return f_282110_;
    }

    @Nullable
    public static ShaderInstance m_282145_() {
        return f_282111_;
    }

    @Nullable
    public static ShaderInstance m_282146_() {
        return f_282112_;
    }

    @Nullable
    public static ShaderInstance m_282147_() {
        return f_282113_;
    }

    @Nullable
    public static ShaderInstance m_282148_() {
        return f_282114_;
    }

    @Nullable
    public static ShaderInstance m_282149_() {
        return f_282115_;
    }

    @Nullable
    public static ShaderInstance m_282150_() {
        return f_282116_;
    }

    @Nullable
    public static ShaderInstance m_282151_() {
        return f_282117_;
    }

    @Nullable
    public static ShaderInstance m_282152_() {
        return f_282118_;
    }

    @Nullable
    public static ShaderInstance m_282153_() {
        return f_282119_;
    }

    @Nullable
    public static ShaderInstance m_282189_() {
        return f_282120_;
    }

    @Nullable
    public static ShaderInstance m_282190_() {
        return f_282121_;
    }

    @Nullable
    public static ShaderInstance m_282191_() {
        return f_282122_;
    }

    @Nullable
    public static ShaderInstance m_282192_() {
        return f_282123_;
    }

    @Nullable
    public static ShaderInstance m_282193_() {
        return f_282088_;
    }

    @Nullable
    public static ShaderInstance m_282194_() {
        return f_282089_;
    }

    @Nullable
    public static ShaderInstance m_282195_() {
        return f_282090_;
    }

    @Nullable
    public static ShaderInstance m_315948_() {
        return f_315868_;
    }

    @Nullable
    public static ShaderInstance m_282196_() {
        return f_282091_;
    }

    @Nullable
    public static ShaderInstance m_315949_() {
        return f_315869_;
    }

    @Nullable
    public static ShaderInstance m_282197_() {
        return f_282092_;
    }

    @Nullable
    public static ShaderInstance m_282198_() {
        return f_282093_;
    }

    @Nullable
    public static ShaderInstance m_282199_() {
        return f_282094_;
    }

    @Nullable
    public static ShaderInstance m_282200_() {
        return f_282095_;
    }

    @Nullable
    public static ShaderInstance m_282201_() {
        return f_282096_;
    }

    @Nullable
    public static ShaderInstance m_282202_() {
        return f_282097_;
    }
}

