/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockTintCache;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.particle.FireworkParticles;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagContainer;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.EmptyTickList;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.TickList;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.TransientEntitySectionManager;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.Scoreboard;
import net.optifine.Config;
import net.optifine.CustomGuis;
import net.optifine.DynamicLights;
import net.optifine.RandomEntities;
import net.optifine.override.PlayerControllerOF;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.shaders.Shaders;

public class ClientLevel
extends Level {
    private static final double f_315475_ = 0.05;
    final EntityTickList f_201980_ = new EntityTickList();
    private final TransientEntitySectionManager<Entity> f_201981_ = new TransientEntitySectionManager<Entity>(Entity.class, new EntityCallbacks());
    private final ClientPacketListener f_104561_;
    private final LevelRenderer f_104562_;
    private final ClientLevelData f_104563_;
    private final DimensionSpecialEffects f_104564_;
    private final Minecraft f_104565_ = Minecraft.m_91087_();
    final List<AbstractClientPlayer> f_104566_ = Lists.newArrayList();
    private Scoreboard f_104555_ = new Scoreboard();
    private final Map<String, MapItemSavedData> f_104556_ = Maps.newHashMap();
    private static final long f_315474_ = 0xFFFFFFL;
    private int f_104557_;
    private final Object2ObjectArrayMap<ColorResolver, BlockTintCache> f_104558_ = Util.m_137469_(new Object2ObjectArrayMap(3), mapIn -> {
        mapIn.put((Object)BiomeColors.f_108789_, (Object)new BlockTintCache());
        mapIn.put((Object)BiomeColors.f_108790_, (Object)new BlockTintCache());
        mapIn.put((Object)BiomeColors.f_108791_, (Object)new BlockTintCache());
    });
    private final ClientChunkCache f_104559_;
    private boolean playerUpdate = false;

    public ClientLevel(ClientPacketListener netHandler, ClientLevelData worldInfoIn, ResourceKey<Level> keyWorld, DimensionType dimensionTypeIn, int viewDistance, Supplier<ProfilerFiller> profilerIn, LevelRenderer worldRendererIn, boolean debugIn, long seedIn) {
        super((WritableLevelData)worldInfoIn, keyWorld, dimensionTypeIn, profilerIn, true, debugIn, seedIn);
        this.f_104561_ = netHandler;
        this.f_104559_ = new ClientChunkCache(this, viewDistance);
        this.f_104563_ = worldInfoIn;
        this.f_104562_ = worldRendererIn;
        this.f_104564_ = DimensionSpecialEffects.m_108876_((DimensionType)dimensionTypeIn);
        this.m_104752_(new BlockPos(8, 64, 8), 0.0f);
        this.m_46465_();
        this.m_46466_();
        if (Reflector.CapabilityProvider_gatherCapabilities.exists()) {
            Reflector.call((Object)this, Reflector.CapabilityProvider_gatherCapabilities, new Object[0]);
        }
        Reflector.postForgeBusEvent(Reflector.WorldEvent_Load_Constructor, new Object[]{this});
        if (this.f_104565_.f_91072_ != null && this.f_104565_.f_91072_.getClass() == MultiPlayerGameMode.class) {
            this.f_104565_.f_91072_ = new PlayerControllerOF(this.f_104565_, this.f_104561_);
            CustomGuis.setPlayerControllerOF((PlayerControllerOF)this.f_104565_.f_91072_);
        }
    }

    public DimensionSpecialEffects m_104583_() {
        return this.f_104564_;
    }

    public void m_104726_(BooleanSupplier p_104726_1_) {
        this.m_6857_().m_61969_();
        this.m_104826_();
        this.m_46473_().m_6180_("blocks");
        this.f_104559_.m_299757_(p_104726_1_);
        this.m_46473_().m_7238_();
    }

    private void m_104826_() {
        this.m_104637_(this.f_46442_.m_6793_() + 1L);
        if (this.f_46442_.m_5470_().m_46207_(GameRules.f_46140_)) {
            this.m_104746_(this.f_46442_.m_6792_() + 1L);
        }
    }

    public void m_104637_(long timeIn) {
        this.f_104563_.m_104849_(timeIn);
    }

    public void m_104746_(long time) {
        if (time < 0L) {
            time = -time;
            ((GameRules.BooleanValue)this.m_46469_().m_46170_(GameRules.f_46140_)).m_46246_(false, (MinecraftServer)null);
        } else {
            ((GameRules.BooleanValue)this.m_46469_().m_46170_(GameRules.f_46140_)).m_46246_(true, (MinecraftServer)null);
        }
        this.f_104563_.m_104863_(time);
    }

    public Iterable<Entity> m_104735_() {
        return this.m_141693_().m_141652_();
    }

    public void m_104804_() {
        ProfilerFiller profilerfiller = this.m_46473_();
        profilerfiller.m_6180_("entities");
        this.f_201980_.m_175669_(entityIn -> {
            if (!entityIn.m_149649_() && !entityIn.m_20159_()) {
                this.m_46653_(this::m_104639_, (Entity)entityIn);
            }
        });
        profilerfiller.m_7238_();
        this.m_46463_();
    }

    public void m_104639_(Entity entityIn) {
        entityIn.m_149566_();
        ++entityIn.f_19797_;
        this.m_46473_().m_6521_(() -> Registry.f_122826_.m_7981_((Object)entityIn.m_6095_()).toString());
        if (ReflectorForge.canUpdate((Entity)entityIn)) {
            entityIn.m_8119_();
        }
        if (entityIn.m_149649_()) {
            this.onEntityRemoved(entityIn);
        }
        this.m_46473_().m_7238_();
        for (Entity entity : entityIn.m_20197_()) {
            this.m_104641_(entityIn, entity);
        }
    }

    private void m_104641_(Entity entityIn, Entity entityPassangerIn) {
        if (!entityPassangerIn.m_149649_() && entityPassangerIn.m_20202_() == entityIn) {
            if (entityPassangerIn instanceof Player || this.f_201980_.m_175673_(entityPassangerIn)) {
                entityPassangerIn.m_149566_();
                ++entityPassangerIn.f_19797_;
                entityPassangerIn.m_6083_();
                for (Entity entity : entityPassangerIn.m_20197_()) {
                    this.m_104641_(entityPassangerIn, entity);
                }
            }
        } else {
            entityPassangerIn.m_8127_();
        }
    }

    public void m_104665_(LevelChunk chunkIn) {
        chunkIn.m_174653_();
        this.f_104559_.m_7827_().m_299393_(chunkIn.m_7697_(), false);
        this.f_201981_.m_175918_(chunkIn.m_7697_());
    }

    public void m_202142_(ChunkPos chunkPosIn) {
        this.f_104558_.forEach((resolverIn, tintCacheIn) -> tintCacheIn.m_92655_(chunkPosIn.f_45578_, chunkPosIn.f_45579_));
        this.f_201981_.m_175905_(chunkPosIn);
    }

    public void m_104810_() {
        this.f_104558_.forEach((resolverIn, tintCacheIn) -> tintCacheIn.m_92654_());
    }

    public boolean m_7232_(int chunkX, int chunkZ) {
        return true;
    }

    public int m_104813_() {
        return this.f_201981_.m_175917_();
    }

    public void m_104630_(int playerId, AbstractClientPlayer playerEntityIn) {
        this.m_104739_(playerId, (Entity)playerEntityIn);
    }

    public void m_104627_(int entityIdIn, Entity entityToSpawn) {
        this.m_104739_(entityIdIn, entityToSpawn);
    }

    private void m_104739_(int entityIdIn, Entity entityToSpawn) {
        if (Reflector.EntityJoinWorldEvent_Constructor.exists() && Reflector.postForgeBusEvent(Reflector.EntityJoinWorldEvent_Constructor, new Object[]{entityToSpawn, this})) {
            return;
        }
        this.m_202026_(entityIdIn, Entity.RemovalReason.DISCARDED);
        this.f_201981_.m_175907_(entityToSpawn);
        if (Reflector.IForgeEntity_onAddedToWorld.exists()) {
            Reflector.call(entityToSpawn, Reflector.IForgeEntity_onAddedToWorld, new Object[0]);
        }
        this.onEntityAdded(entityToSpawn);
    }

    public void m_202026_(int entityIdIn, Entity.RemovalReason reasonIn) {
        Entity entity = (Entity)this.m_141693_().m_141642_(entityIdIn);
        if (entity != null) {
            entity.m_141936_(reasonIn);
            entity.m_299463_();
        }
    }

    @Nullable
    public Entity m_6815_(int id) {
        return (Entity)this.m_141693_().m_141642_(id);
    }

    public void m_104755_(BlockPos pos, BlockState state) {
        this.m_7731_(pos, state, 19);
    }

    public void m_7462_() {
        this.f_104561_.m_6198_().m_129507_((Component)new TranslatableComponent("multiplayer.status.quitting"));
    }

    public void m_104784_(int posX, int posY, int posZ) {
        int i = 32;
        Random random = new Random();
        MarkerParticleStatus clientlevel$markerparticlestatus = this.m_315487_();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j = 0; j < 667; ++j) {
            this.m_315476_(posX, posY, posZ, 16, random, clientlevel$markerparticlestatus, blockpos$mutableblockpos);
            this.m_315476_(posX, posY, posZ, 32, random, clientlevel$markerparticlestatus, blockpos$mutableblockpos);
        }
    }

    @Nullable
    private MarkerParticleStatus m_315487_() {
        if (this.f_104565_.f_91072_.m_105295_() == GameType.CREATIVE) {
            ItemStack itemstack = this.f_104565_.f_91074_.m_21205_();
            if (itemstack.m_41720_() == Items.f_42127_) {
                return MarkerParticleStatus.BARRIER;
            }
            if (itemstack.m_41720_() == Items.f_305312_) {
                return MarkerParticleStatus.LIGHT;
            }
        }
        return null;
    }

    public void m_315476_(int x, int y, int z, int offset, Random random, @Nullable MarkerParticleStatus particleStatus, BlockPos.MutableBlockPos pos) {
        int i = x + this.f_46441_.nextInt(offset) - this.f_46441_.nextInt(offset);
        int j = y + this.f_46441_.nextInt(offset) - this.f_46441_.nextInt(offset);
        int k = z + this.f_46441_.nextInt(offset) - this.f_46441_.nextInt(offset);
        pos.m_122178_(i, j, k);
        BlockState blockstate = this.m_8055_((BlockPos)pos);
        blockstate.m_60734_().m_7100_(blockstate, (Level)this, (BlockPos)pos, random);
        FluidState fluidstate = this.m_6425_((BlockPos)pos);
        if (!fluidstate.m_76178_()) {
            fluidstate.m_76166_((Level)this, (BlockPos)pos, random);
            ParticleOptions particleoptions = fluidstate.m_76189_();
            if (particleoptions != null && this.f_46441_.nextInt(10) == 0) {
                boolean flag = blockstate.m_60783_((BlockGetter)this, (BlockPos)pos, Direction.DOWN);
                BlockPos blockpos = pos.m_7495_();
                this.m_104689_(blockpos, this.m_8055_(blockpos), particleoptions, flag);
            }
        }
        if (particleStatus != null && blockstate.m_60734_() == particleStatus.f_315492_) {
            this.m_7106_(particleStatus.f_315493_, (double)i + 0.5, (double)j + 0.5, (double)k + 0.5, 0.0, 0.0, 0.0);
        }
        if (!blockstate.m_60838_((BlockGetter)this, (BlockPos)pos)) {
            this.m_46857_((BlockPos)pos).m_47562_().ifPresent(settingsIn -> {
                if (settingsIn.m_47424_(this.f_46441_)) {
                    this.m_7106_(settingsIn.m_47419_(), (double)pos.m_123341_() + this.f_46441_.nextDouble(), (double)pos.m_123342_() + this.f_46441_.nextDouble(), (double)pos.m_123343_() + this.f_46441_.nextDouble(), 0.0, 0.0, 0.0);
                }
            });
        }
    }

    private void m_104689_(BlockPos blockPosIn, BlockState blockStateIn, ParticleOptions particleDataIn, boolean shapeDownSolid) {
        if (blockStateIn.m_60819_().m_76178_()) {
            VoxelShape voxelshape = blockStateIn.m_60812_((BlockGetter)this, blockPosIn);
            double d0 = voxelshape.m_83297_(Direction.Axis.Y);
            if (d0 < 1.0) {
                if (shapeDownSolid) {
                    this.m_104592_(blockPosIn.m_123341_(), blockPosIn.m_123341_() + 1, blockPosIn.m_123343_(), blockPosIn.m_123343_() + 1, (double)(blockPosIn.m_123342_() + 1) - 0.05, particleDataIn);
                }
            } else if (!blockStateIn.m_60620_((Tag)BlockTags.f_13049_)) {
                double d1 = voxelshape.m_83288_(Direction.Axis.Y);
                if (d1 > 0.0) {
                    this.m_104694_(blockPosIn, particleDataIn, voxelshape, (double)blockPosIn.m_123342_() + d1 - 0.05);
                } else {
                    BlockPos blockpos = blockPosIn.m_7495_();
                    BlockState blockstate = this.m_8055_(blockpos);
                    VoxelShape voxelshape1 = blockstate.m_60812_((BlockGetter)this, blockpos);
                    double d2 = voxelshape1.m_83297_(Direction.Axis.Y);
                    if (d2 < 1.0 && blockstate.m_60819_().m_76178_()) {
                        this.m_104694_(blockPosIn, particleDataIn, voxelshape, (double)blockPosIn.m_123342_() - 0.05);
                    }
                }
            }
        }
    }

    private void m_104694_(BlockPos posIn, ParticleOptions particleDataIn, VoxelShape voxelShapeIn, double y) {
        this.m_104592_((double)posIn.m_123341_() + voxelShapeIn.m_83288_(Direction.Axis.X), (double)posIn.m_123341_() + voxelShapeIn.m_83297_(Direction.Axis.X), (double)posIn.m_123343_() + voxelShapeIn.m_83288_(Direction.Axis.Z), (double)posIn.m_123343_() + voxelShapeIn.m_83297_(Direction.Axis.Z), y, particleDataIn);
    }

    private void m_104592_(double xStart, double xEnd, double zStart, double zEnd, double y, ParticleOptions particleDataIn) {
        this.m_7106_(particleDataIn, Mth.m_14139_(this.f_46441_.nextDouble(), xStart, xEnd), y, Mth.m_14139_(this.f_46441_.nextDouble(), zStart, zEnd), 0.0, 0.0, 0.0);
    }

    public CrashReportCategory m_6026_(CrashReport report) {
        CrashReportCategory crashreportcategory = super.m_6026_(report);
        crashreportcategory.m_128165_("Server brand", () -> this.f_104565_.f_91074_.m_108629_());
        crashreportcategory.m_128165_("Server type", () -> this.f_104565_.m_91092_() == null ? "Non-integrated multiplayer server" : "Integrated singleplayer server");
        return crashreportcategory;
    }

    public void m_6263_(@Nullable Player player, double x, double y, double z, SoundEvent soundIn, SoundSource category, float volume, float pitch) {
        if (Reflector.ForgeEventFactory_onPlaySoundAtEntity.exists()) {
            Object event = Reflector.ForgeEventFactory_onPlaySoundAtEntity.call(player, soundIn, category, Float.valueOf(volume), Float.valueOf(pitch));
            if (Reflector.callBoolean(event, Reflector.Event_isCanceled, new Object[0]) || Reflector.call(event, Reflector.PlaySoundAtEntityEvent_getSound, new Object[0]) == null) {
                return;
            }
            soundIn = (SoundEvent)Reflector.call(event, Reflector.PlaySoundAtEntityEvent_getSound, new Object[0]);
            category = (SoundSource)Reflector.call(event, Reflector.PlaySoundAtEntityEvent_getCategory, new Object[0]);
            volume = Reflector.callFloat(event, Reflector.PlaySoundAtEntityEvent_getVolume, new Object[0]);
        }
        if (player == this.f_104565_.f_91074_) {
            this.m_7785_(x, y, z, soundIn, category, volume, pitch, false);
        }
    }

    public void m_6269_(@Nullable Player playerIn, Entity entityIn, SoundEvent eventIn, SoundSource categoryIn, float volume, float pitch) {
        if (Reflector.ForgeEventFactory_onPlaySoundAtEntity.exists()) {
            Object event = Reflector.ForgeEventFactory_onPlaySoundAtEntity.call(playerIn, eventIn, categoryIn, Float.valueOf(volume), Float.valueOf(pitch));
            if (Reflector.callBoolean(event, Reflector.Event_isCanceled, new Object[0]) || Reflector.call(event, Reflector.PlaySoundAtEntityEvent_getSound, new Object[0]) == null) {
                return;
            }
            eventIn = (SoundEvent)Reflector.call(event, Reflector.PlaySoundAtEntityEvent_getSound, new Object[0]);
            categoryIn = (SoundSource)Reflector.call(event, Reflector.PlaySoundAtEntityEvent_getCategory, new Object[0]);
            volume = Reflector.callFloat(event, Reflector.PlaySoundAtEntityEvent_getVolume, new Object[0]);
        }
        if (playerIn == this.f_104565_.f_91074_) {
            this.f_104565_.m_91106_().m_120367_((SoundInstance)new EntityBoundSoundInstance(eventIn, categoryIn, volume, pitch, entityIn));
        }
    }

    public void m_104677_(BlockPos pos, SoundEvent soundIn, SoundSource category, float volume, float pitch, boolean distanceDelay) {
        this.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, soundIn, category, volume, pitch, distanceDelay);
    }

    public void m_7785_(double x, double y, double z, SoundEvent soundIn, SoundSource category, float volume, float pitch, boolean distanceDelay) {
        double d0 = this.f_104565_.f_91063_.m_109153_().m_90583_().m_82531_(x, y, z);
        SimpleSoundInstance simplesoundinstance = new SimpleSoundInstance(soundIn, category, volume, pitch, x, y, z);
        if (distanceDelay && d0 > 100.0) {
            double d1 = Math.sqrt(d0) / 40.0;
            this.f_104565_.m_91106_().m_120369_((SoundInstance)simplesoundinstance, (int)(d1 * 20.0));
        } else {
            this.f_104565_.m_91106_().m_120367_((SoundInstance)simplesoundinstance);
        }
    }

    public void m_7228_(double x, double y, double z, double motionX, double motionY, double motionZ, @Nullable CompoundTag compound) {
        this.f_104565_.f_91061_.m_107344_((Particle)new FireworkParticles.Starter(this, x, y, z, motionX, motionY, motionZ, this.f_104565_.f_91061_, compound));
    }

    public void m_5503_(Packet<?> packetIn) {
        this.f_104561_.m_104955_(packetIn);
    }

    public RecipeManager m_7465_() {
        return this.f_104561_.m_105141_();
    }

    public void m_104669_(Scoreboard scoreboardIn) {
        this.f_104555_ = scoreboardIn;
    }

    public TickList<Block> m_6219_() {
        return EmptyTickList.m_45888_();
    }

    public TickList<Fluid> m_6217_() {
        return EmptyTickList.m_45888_();
    }

    public ClientChunkCache m_7726_() {
        return this.f_104559_;
    }

    public boolean m_7731_(BlockPos pos, BlockState newState, int flags) {
        this.playerUpdate = this.isPlayerActing();
        boolean res = super.m_7731_(pos, newState, flags);
        this.playerUpdate = false;
        return res;
    }

    private boolean isPlayerActing() {
        if (this.f_104565_.f_91072_ instanceof PlayerControllerOF) {
            PlayerControllerOF pcof = (PlayerControllerOF)this.f_104565_.f_91072_;
            return pcof.isActing();
        }
        return false;
    }

    public boolean isPlayerUpdate() {
        return this.playerUpdate;
    }

    public void onEntityAdded(Entity entityIn) {
        RandomEntities.entityLoaded((Entity)entityIn, (Level)this);
        if (Config.isDynamicLights()) {
            DynamicLights.entityAdded((Entity)entityIn, (LevelRenderer)Config.getRenderGlobal());
        }
    }

    public void onEntityRemoved(Entity entityIn) {
        RandomEntities.entityUnloaded((Entity)entityIn, (Level)this);
        if (Config.isDynamicLights()) {
            DynamicLights.entityRemoved((Entity)entityIn, (LevelRenderer)Config.getRenderGlobal());
        }
    }

    @Nullable
    public MapItemSavedData m_7489_(String mapName) {
        return this.f_104556_.get(mapName);
    }

    public void m_142027_(String nameIn, MapItemSavedData mapDataIn) {
        this.f_104556_.put(nameIn, mapDataIn);
    }

    public int m_7354_() {
        return 0;
    }

    public Scoreboard m_6188_() {
        return this.f_104555_;
    }

    public TagContainer m_5999_() {
        return this.f_104561_.m_105148_();
    }

    public RegistryAccess m_5962_() {
        return this.f_104561_.m_105152_();
    }

    public void m_7260_(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
        this.f_104562_.m_109544_((BlockGetter)this, pos, oldState, newState, flags);
    }

    public void m_6550_(BlockPos blockPosIn, BlockState oldState, BlockState newState) {
        this.f_104562_.m_109721_(blockPosIn, oldState, newState);
    }

    public void m_104793_(int sectionX, int sectionY, int sectionZ) {
        this.f_104562_.m_109490_(sectionX, sectionY, sectionZ);
    }

    public void m_6801_(int breakerId, BlockPos pos, int progress) {
        this.f_104562_.m_109774_(breakerId, pos, progress);
    }

    public void m_6798_(int id, BlockPos pos, int data) {
        this.f_104562_.m_109506_(id, pos, data);
    }

    public void m_5898_(@Nullable Player player, int type, BlockPos pos, int data) {
        try {
            this.f_104562_.m_109532_(player, type, pos, data);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_(throwable, "Playing level event");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Level event being played");
            crashreportcategory.m_128159_("Block coordinates", (Object)CrashReportCategory.m_216868_((LevelHeightAccessor)this, (BlockPos)pos));
            crashreportcategory.m_128159_("Event source", (Object)player);
            crashreportcategory.m_128159_("Event type", (Object)type);
            crashreportcategory.m_128159_("Event data", (Object)data);
            throw new ReportedException(crashreport);
        }
    }

    public void m_7106_(ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.f_104562_.m_109743_(particleData, particleData.m_6012_().m_123742_(), x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void m_6493_(ParticleOptions particleData, boolean forceAlwaysRender, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.f_104562_.m_109743_(particleData, particleData.m_6012_().m_123742_() || forceAlwaysRender, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void m_7107_(ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.f_104562_.m_109752_(particleData, false, true, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void m_6485_(ParticleOptions particleData, boolean ignoreRange, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.f_104562_.m_109752_(particleData, particleData.m_6012_().m_123742_() || ignoreRange, true, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public List<AbstractClientPlayer> m_6907_() {
        return this.f_104566_;
    }

    public Biome m_6159_(int x, int y, int z) {
        return (Biome)this.m_5962_().m_213953_(Registry.f_122885_).m_123013_(Biomes.f_48202_);
    }

    public float m_104805_(float partialTicks) {
        float f = this.m_46942_(partialTicks);
        float f1 = 1.0f - (Mth.m_14089_(f * ((float)Math.PI * 2)) * 2.0f + 0.2f);
        f1 = Mth.m_14036_(f1, 0.0f, 1.0f);
        f1 = 1.0f - f1;
        f1 = (float)((double)f1 * (1.0 - (double)(this.m_46722_(partialTicks) * 5.0f) / 16.0));
        f1 = (float)((double)f1 * (1.0 - (double)(this.m_46661_(partialTicks) * 5.0f) / 16.0));
        return f1 * 0.8f + 0.2f;
    }

    public Vec3 m_202072_(Vec3 posIn, float partialTicksIn) {
        float f9;
        float f = this.m_46942_(partialTicksIn);
        Vec3 vec3 = posIn.m_82492_(2.0, 2.0, 2.0).m_82490_(0.25);
        BiomeManager biomemanager = this.m_7062_();
        Vec3 vec31 = CubicSampler.m_130038_((Vec3)vec3, (xIn, yIn, zIn) -> Vec3.m_82501_((int)biomemanager.m_47873_(xIn, yIn, zIn).m_47463_()));
        float f1 = Mth.m_14089_(f * ((float)Math.PI * 2)) * 2.0f + 0.5f;
        f1 = Mth.m_14036_(f1, 0.0f, 1.0f);
        float f2 = (float)vec31.f_82479_ * f1;
        float f3 = (float)vec31.f_82480_ * f1;
        float f4 = (float)vec31.f_82481_ * f1;
        float f5 = this.m_46722_(partialTicksIn);
        if (f5 > 0.0f) {
            float f6 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.6f;
            float f7 = 1.0f - f5 * 0.75f;
            f2 = f2 * f7 + f6 * (1.0f - f7);
            f3 = f3 * f7 + f6 * (1.0f - f7);
            f4 = f4 * f7 + f6 * (1.0f - f7);
        }
        if ((f9 = this.m_46661_(partialTicksIn)) > 0.0f) {
            float f10 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.2f;
            float f8 = 1.0f - f9 * 0.75f;
            f2 = f2 * f8 + f10 * (1.0f - f8);
            f3 = f3 * f8 + f10 * (1.0f - f8);
            f4 = f4 * f8 + f10 * (1.0f - f8);
        }
        if (this.f_104557_ > 0) {
            float f11 = (float)this.f_104557_ - partialTicksIn;
            if (f11 > 1.0f) {
                f11 = 1.0f;
            }
            f2 = f2 * (1.0f - (f11 *= 0.45f)) + 0.8f * f11;
            f3 = f3 * (1.0f - f11) + 0.8f * f11;
            f4 = f4 * (1.0f - f11) + 1.0f * f11;
        }
        return new Vec3((double)f2, (double)f3, (double)f4);
    }

    public Vec3 m_104808_(float partialTicks) {
        float f = this.m_46942_(partialTicks);
        float f1 = Mth.m_14089_(f * ((float)Math.PI * 2)) * 2.0f + 0.5f;
        f1 = Mth.m_14036_(f1, 0.0f, 1.0f);
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 1.0f;
        float f5 = this.m_46722_(partialTicks);
        if (f5 > 0.0f) {
            float f6 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.6f;
            float f7 = 1.0f - f5 * 0.95f;
            f2 = f2 * f7 + f6 * (1.0f - f7);
            f3 = f3 * f7 + f6 * (1.0f - f7);
            f4 = f4 * f7 + f6 * (1.0f - f7);
        }
        f2 *= f1 * 0.9f + 0.1f;
        f3 *= f1 * 0.9f + 0.1f;
        f4 *= f1 * 0.85f + 0.15f;
        float f9 = this.m_46661_(partialTicks);
        if (f9 > 0.0f) {
            float f10 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.2f;
            float f8 = 1.0f - f9 * 0.95f;
            f2 = f2 * f8 + f10 * (1.0f - f8);
            f3 = f3 * f8 + f10 * (1.0f - f8);
            f4 = f4 * f8 + f10 * (1.0f - f8);
        }
        return new Vec3((double)f2, (double)f3, (double)f4);
    }

    public float m_104811_(float partialTicks) {
        float f = this.m_46942_(partialTicks);
        float f1 = 1.0f - (Mth.m_14089_(f * ((float)Math.PI * 2)) * 2.0f + 0.25f);
        f1 = Mth.m_14036_(f1, 0.0f, 1.0f);
        return f1 * f1 * 0.5f;
    }

    public int m_104819_() {
        return this.f_104557_;
    }

    public void m_6580_(int timeFlashIn) {
        this.f_104557_ = timeFlashIn;
    }

    public float m_7717_(Direction directionIn, boolean shadeIn) {
        boolean flag = this.m_104583_().m_108885_();
        boolean shaders = Config.isShaders();
        if (!shadeIn) {
            return flag ? 0.9f : 1.0f;
        }
        switch (directionIn) {
            case DOWN: {
                return flag ? 0.9f : (shaders ? Shaders.blockLightLevel05 : 0.5f);
            }
            case UP: {
                return flag ? 0.9f : 1.0f;
            }
            case NORTH: 
            case SOUTH: {
                if (Config.isShaders()) {
                    return Shaders.blockLightLevel08;
                }
                return 0.8f;
            }
            case WEST: 
            case EAST: {
                if (Config.isShaders()) {
                    return Shaders.blockLightLevel06;
                }
                return 0.6f;
            }
        }
        return 1.0f;
    }

    public int m_6171_(BlockPos blockPosIn, ColorResolver colorResolverIn) {
        BlockTintCache blocktintcache = (BlockTintCache)this.f_104558_.get((Object)colorResolverIn);
        return blocktintcache.m_92658_(blockPosIn, () -> this.m_104762_(blockPosIn, colorResolverIn));
    }

    public int m_104762_(BlockPos blockPosIn, ColorResolver colorResolverIn) {
        int i = Minecraft.m_91087_().f_91066_.f_92032_;
        if (i == 0) {
            return colorResolverIn.m_130045_(this.m_46857_(blockPosIn), blockPosIn.m_123341_(), blockPosIn.m_123343_());
        }
        int j = (i * 2 + 1) * (i * 2 + 1);
        int k = 0;
        int l = 0;
        int i1 = 0;
        Cursor3D cursor3d = new Cursor3D(blockPosIn.m_123341_() - i, blockPosIn.m_123342_(), blockPosIn.m_123343_() - i, blockPosIn.m_123341_() + i, blockPosIn.m_123342_(), blockPosIn.m_123343_() + i);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        while (cursor3d.m_122304_()) {
            blockpos$mutableblockpos.m_122178_(cursor3d.m_122305_(), cursor3d.m_122306_(), cursor3d.m_122307_());
            int j1 = colorResolverIn.m_130045_(this.m_46857_((BlockPos)blockpos$mutableblockpos), blockpos$mutableblockpos.m_123341_(), blockpos$mutableblockpos.m_123343_());
            k += (j1 & 0xFF0000) >> 16;
            l += (j1 & 0xFF00) >> 8;
            i1 += j1 & 0xFF;
        }
        return (k / j & 0xFF) << 16 | (l / j & 0xFF) << 8 | i1 / j & 0xFF;
    }

    public BlockPos m_104822_() {
        BlockPos blockpos = new BlockPos(this.f_46442_.m_6789_(), this.f_46442_.m_6527_(), this.f_46442_.m_6526_());
        if (!this.m_6857_().m_61937_(blockpos)) {
            blockpos = this.m_5452_(Heightmap.Types.MOTION_BLOCKING, new BlockPos(this.m_6857_().m_6347_(), 0.0, this.m_6857_().m_6345_()));
        }
        return blockpos;
    }

    public float m_104823_() {
        return this.f_46442_.m_6790_();
    }

    public void m_104752_(BlockPos blockPosIn, float angleIn) {
        this.f_46442_.m_7250_(blockPosIn, angleIn);
    }

    public String toString() {
        return "ClientLevel";
    }

    public ClientLevelData m_6106_() {
        return this.f_104563_;
    }

    public void m_141929_(@Nullable Entity entityIn, GameEvent eventIn, BlockPos posIn) {
    }

    protected Map<String, MapItemSavedData> m_315486_() {
        return ImmutableMap.copyOf(this.f_104556_);
    }

    protected void m_315484_(Map<String, MapItemSavedData> mapDataIn) {
        this.f_104556_.putAll(mapDataIn);
    }

    protected LevelEntityGetter<Entity> m_141693_() {
        return this.f_201981_.m_175899_();
    }

    public String m_299808_() {
        return "Chunks[C] W: " + this.f_104559_.m_6754_() + " E: " + this.f_201981_.m_175926_();
    }

    public void m_141878_(BlockPos blockPosIn, BlockState stateIn) {
        this.f_104565_.f_91061_.m_107355_(blockPosIn, stateIn);
    }

    public TransientEntitySectionManager getEntityStorage() {
        return this.f_201981_;
    }

    static enum MarkerParticleStatus {
        BARRIER(Blocks.f_50375_, (ParticleOptions)ParticleTypes.f_123793_),
        LIGHT(Blocks.f_305965_, (ParticleOptions)ParticleTypes.f_317363_);

        final Block f_315492_;
        final ParticleOptions f_315493_;

        private MarkerParticleStatus(Block blockIn, ParticleOptions optionsIn) {
            this.f_315492_ = blockIn;
            this.f_315493_ = optionsIn;
        }
    }

    final class EntityCallbacks
    implements LevelCallback<Entity> {
        EntityCallbacks() {
        }

        public void m_141447_(Entity entityIn) {
        }

        public void m_141448_(Entity entityIn) {
        }

        public void m_141451_(Entity entityIn) {
            ClientLevel.this.f_201980_.m_175667_(entityIn);
        }

        public void m_141446_(Entity entityIn) {
            ClientLevel.this.f_201980_.m_175671_(entityIn);
        }

        public void m_141443_(Entity entityIn) {
            if (entityIn instanceof AbstractClientPlayer) {
                ClientLevel.this.f_104566_.add((AbstractClientPlayer)entityIn);
            }
        }

        public void m_141444_(Entity entityIn) {
            entityIn.m_19877_();
            ClientLevel.this.f_104566_.remove(entityIn);
            if (Reflector.IForgeEntity_onRemovedFromWorld.exists()) {
                Reflector.call(entityIn, Reflector.IForgeEntity_onRemovedFromWorld, new Object[0]);
            }
            if (Reflector.EntityLeaveWorldEvent_Constructor.exists()) {
                Reflector.postForgeBusEvent(Reflector.EntityLeaveWorldEvent_Constructor, new Object[]{entityIn, ClientLevel.this});
            }
            ClientLevel.this.onEntityRemoved(entityIn);
        }
    }

    public static class ClientLevelData
    implements WritableLevelData {
        private final boolean f_104830_;
        private final GameRules f_104831_;
        private final boolean f_104832_;
        private int f_104833_;
        private int f_104834_;
        private int f_104835_;
        private float f_104836_;
        private long f_104837_;
        private long f_104838_;
        private boolean f_104839_;
        private Difficulty f_104840_;
        private boolean f_104841_;

        public ClientLevelData(Difficulty p_i104842_1_, boolean p_i104842_2_, boolean p_i104842_3_) {
            this.f_104840_ = p_i104842_1_;
            this.f_104830_ = p_i104842_2_;
            this.f_104832_ = p_i104842_3_;
            this.f_104831_ = new GameRules();
        }

        public int m_6789_() {
            return this.f_104833_;
        }

        public int m_6527_() {
            return this.f_104834_;
        }

        public int m_6526_() {
            return this.f_104835_;
        }

        public float m_6790_() {
            return this.f_104836_;
        }

        public long m_6793_() {
            return this.f_104837_;
        }

        public long m_6792_() {
            return this.f_104838_;
        }

        public void m_6395_(int x) {
            this.f_104833_ = x;
        }

        public void m_6397_(int y) {
            this.f_104834_ = y;
        }

        public void m_6400_(int z) {
            this.f_104835_ = z;
        }

        public void m_7113_(float angleIn) {
            this.f_104836_ = angleIn;
        }

        public void m_104849_(long timeIn) {
            this.f_104837_ = timeIn;
        }

        public void m_104863_(long timeIn) {
            this.f_104838_ = timeIn;
        }

        public void m_7250_(BlockPos spawnPoint, float angleIn) {
            this.f_104833_ = spawnPoint.m_123341_();
            this.f_104834_ = spawnPoint.m_123342_();
            this.f_104835_ = spawnPoint.m_123343_();
            this.f_104836_ = angleIn;
        }

        public boolean m_6534_() {
            return false;
        }

        public boolean m_6533_() {
            return this.f_104839_;
        }

        public void m_5565_(boolean isRaining) {
            this.f_104839_ = isRaining;
        }

        public boolean m_5466_() {
            return this.f_104830_;
        }

        public GameRules m_5470_() {
            return this.f_104831_;
        }

        public Difficulty m_5472_() {
            return this.f_104840_;
        }

        public boolean m_5474_() {
            return this.f_104841_;
        }

        public void m_141645_(CrashReportCategory categoryIn, LevelHeightAccessor heightIn) {
            super.m_141645_(categoryIn, heightIn);
        }

        public void m_104851_(Difficulty difficultyIn) {
            Reflector.ForgeHooks_onDifficultyChange.callVoid(difficultyIn, this.f_104840_);
            this.f_104840_ = difficultyIn;
        }

        public void m_104858_(boolean lockedIn) {
            this.f_104841_ = lockedIn;
        }

        public double m_315488_(LevelHeightAccessor accessorIn) {
            return this.f_104832_ ? (double)accessorIn.m_141493_() : 63.0;
        }

        public double m_104876_() {
            return this.f_104832_ ? 1.0 : 0.03125;
        }
    }
}

