/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.resources.metadata.texture.TextureMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import net.optifine.render.GlBlendState;
import net.optifine.shaders.config.ShaderPackParser;
import net.optifine.util.PropertiesOrdered;

public class LoadingOverlay
extends Overlay {
    static final ResourceLocation f_96160_ = new ResourceLocation("textures/gui/title/mojangstudios.png");
    private static final int f_314508_ = FastColor.ARGB32.m_13660_((int)255, (int)239, (int)50, (int)61);
    private static final int f_314509_ = FastColor.ARGB32.m_13660_((int)255, (int)0, (int)0, (int)0);
    private static final IntSupplier f_96161_ = () -> Minecraft.m_91087_().f_91066_.f_313923_ ? f_314509_ : f_314508_;
    private static final int f_314510_ = 240;
    private static final float f_314511_ = 60.0f;
    private static final int f_314512_ = 60;
    private static final int f_314513_ = 120;
    private static final float f_314514_ = 0.0625f;
    private static final float f_314515_ = 0.95f;
    public static final long f_314506_ = 1000L;
    public static final long f_314507_ = 500L;
    private final Minecraft f_96163_;
    private final ReloadInstance f_96164_;
    private final Consumer<Optional<Throwable>> f_96165_;
    private final boolean f_96166_;
    private float f_96167_;
    private long f_96168_ = -1L;
    private long f_96169_ = -1L;
    private int colorBackground = f_96161_.getAsInt();
    private int colorBar = f_96161_.getAsInt();
    private int colorOutline = 0xFFFFFF;
    private int colorProgress = 0xFFFFFF;
    private GlBlendState blendState = null;
    private boolean fadeOut = false;

    public LoadingOverlay(Minecraft p_i96171_1_, ReloadInstance p_i96171_2_, Consumer<Optional<Throwable>> p_i96171_3_, boolean p_i96171_4_) {
        this.f_96163_ = p_i96171_1_;
        this.f_96164_ = p_i96171_2_;
        this.f_96165_ = p_i96171_3_;
        this.f_96166_ = false;
    }

    public static void m_96189_(Minecraft mc) {
        mc.m_91097_().m_118495_(f_96160_, new LogoTexture());
    }

    private static int m_314516_(int colorIn, int alphaIn) {
        return colorIn & 0xFFFFFF | alphaIn << 24;
    }

    public void m_6305_(PoseStack matrixStackIn, int mouseX, int mouseY, float partialTicks) {
        float f2;
        float f1;
        int i = this.f_96163_.m_91268_().m_85445_();
        int j = this.f_96163_.m_91268_().m_85446_();
        long k = Util.m_137550_();
        if (this.f_96166_ && this.f_96169_ == -1L) {
            this.f_96169_ = k;
        }
        float f = this.f_96168_ > -1L ? (float)(k - this.f_96168_) / 1000.0f : -1.0f;
        float f3 = f1 = this.f_96169_ > -1L ? (float)(k - this.f_96169_) / 500.0f : -1.0f;
        if (f >= 1.0f) {
            this.fadeOut = true;
            if (this.f_96163_.f_91080_ != null) {
                this.f_96163_.f_91080_.m_6305_(matrixStackIn, 0, 0, partialTicks);
            }
            int l = Mth.m_14167_((1.0f - Mth.m_14036_(f - 1.0f, 0.0f, 1.0f)) * 255.0f);
            LoadingOverlay.m_93172_((PoseStack)matrixStackIn, (int)0, (int)0, (int)i, (int)j, (int)LoadingOverlay.m_314516_(this.colorBackground, l));
            f2 = 1.0f - Mth.m_14036_(f - 1.0f, 0.0f, 1.0f);
        } else if (this.f_96166_) {
            if (this.f_96163_.f_91080_ != null && f1 < 1.0f) {
                this.f_96163_.f_91080_.m_6305_(matrixStackIn, mouseX, mouseY, partialTicks);
            }
            int l1 = Mth.m_14165_(Mth.m_14008_(f1, 0.15, 1.0) * 255.0);
            LoadingOverlay.m_93172_((PoseStack)matrixStackIn, (int)0, (int)0, (int)i, (int)j, (int)LoadingOverlay.m_314516_(this.colorBackground, l1));
            f2 = Mth.m_14036_(f1, 0.0f, 1.0f);
        } else {
            int i2 = this.colorBackground;
            float f32 = (float)(i2 >> 16 & 0xFF) / 255.0f;
            float f4 = (float)(i2 >> 8 & 0xFF) / 255.0f;
            float f5 = (float)(i2 & 0xFF) / 255.0f;
            GlStateManager.m_84318_((float)f32, (float)f4, (float)f5, (float)1.0f);
            GlStateManager.m_84266_((int)16384, (boolean)Minecraft.f_91002_);
            f2 = 1.0f;
        }
        int j2 = (int)((double)this.f_96163_.m_91268_().m_85445_() * 0.5);
        int k2 = (int)((double)this.f_96163_.m_91268_().m_85446_() * 0.5);
        double d1 = Math.min((double)this.f_96163_.m_91268_().m_85445_() * 0.75, (double)this.f_96163_.m_91268_().m_85446_()) * 0.25;
        int i1 = (int)(d1 * 0.5);
        double d0 = d1 * 4.0;
        int j1 = (int)(d0 * 0.5);
        RenderSystem.m_256269_((int)0, (ResourceLocation)f_96160_);
        RenderSystem.m_69478_();
        RenderSystem.m_69403_((int)32774);
        RenderSystem.m_69405_((int)770, (int)1);
        RenderSystem.m_256236_(GameRenderer::m_282216_);
        RenderSystem.m_256242_((float)1.0f, (float)1.0f, (float)1.0f, (float)f2);
        boolean renderLogo = true;
        if (this.blendState != null) {
            this.blendState.apply();
            if (!this.blendState.isEnabled() && this.fadeOut) {
                renderLogo = false;
            }
        }
        if (renderLogo) {
            LoadingOverlay.m_93160_((PoseStack)matrixStackIn, (int)(j2 - j1), (int)(k2 - i1), (int)j1, (int)((int)d1), (float)-0.0625f, (float)0.0f, (int)120, (int)60, (int)120, (int)120);
            LoadingOverlay.m_93160_((PoseStack)matrixStackIn, (int)j2, (int)(k2 - i1), (int)j1, (int)((int)d1), (float)0.0625f, (float)60.0f, (int)120, (int)60, (int)120, (int)120);
        }
        RenderSystem.m_69453_();
        RenderSystem.m_69461_();
        int k1 = (int)((double)this.f_96163_.m_91268_().m_85446_() * 0.8325);
        float f6 = this.f_96164_.m_7750_();
        this.f_96167_ = Mth.m_14036_(this.f_96167_ * 0.95f + f6 * 0.050000012f, 0.0f, 1.0f);
        Reflector.ClientModLoader_renderProgressText.call(new Object[0]);
        if (f < 1.0f) {
            this.m_96182_(matrixStackIn, i / 2 - j1, k1 - 5, i / 2 + j1, k1 + 5, 1.0f - Mth.m_14036_(f, 0.0f, 1.0f));
        }
        if (f >= 2.0f) {
            this.f_96163_.m_91150_((Overlay)null);
        }
        if (this.f_96168_ == -1L && this.f_96164_.m_7746_() && (!this.f_96166_ || f1 >= 2.0f)) {
            this.f_96168_ = Util.m_137550_();
            try {
                this.f_96164_.m_7748_();
                this.f_96165_.accept(Optional.empty());
            }
            catch (Throwable throwable) {
                this.f_96165_.accept(Optional.of(throwable));
            }
            if (this.f_96163_.f_91080_ != null) {
                this.f_96163_.f_91080_.m_6575_(this.f_96163_, this.f_96163_.m_91268_().m_85445_(), this.f_96163_.m_91268_().m_85446_());
            }
        }
    }

    private void m_96182_(PoseStack matrixStackIn, int left, int top, int right, int bottom, float alpha) {
        int i = Mth.m_14167_((float)(right - left - 2) * this.f_96167_);
        int j = Math.round(alpha * 255.0f);
        if (this.colorBar != this.colorBackground) {
            int colBgR = this.colorBar >> 16 & 0xFF;
            int colBgG = this.colorBar >> 8 & 0xFF;
            int colBgB = this.colorBar & 0xFF;
            int colBg = FastColor.ARGB32.m_13660_((int)j, (int)colBgR, (int)colBgG, (int)colBgB);
            LoadingOverlay.m_93172_((PoseStack)matrixStackIn, (int)left, (int)top, (int)right, (int)bottom, (int)colBg);
        }
        int colProgR = this.colorProgress >> 16 & 0xFF;
        int colProgG = this.colorProgress >> 8 & 0xFF;
        int colProgB = this.colorProgress & 0xFF;
        int k = FastColor.ARGB32.m_13660_((int)j, (int)colProgR, (int)colProgG, (int)colProgB);
        LoadingOverlay.m_93172_((PoseStack)matrixStackIn, (int)(left + 2), (int)(top + 2), (int)(left + i), (int)(bottom - 2), (int)k);
        int colOutR = this.colorOutline >> 16 & 0xFF;
        int colOutG = this.colorOutline >> 8 & 0xFF;
        int colOutB = this.colorOutline & 0xFF;
        k = FastColor.ARGB32.m_13660_((int)j, (int)colOutR, (int)colOutG, (int)colOutB);
        LoadingOverlay.m_93172_((PoseStack)matrixStackIn, (int)(left + 1), (int)top, (int)(right - 1), (int)(top + 1), (int)k);
        LoadingOverlay.m_93172_((PoseStack)matrixStackIn, (int)(left + 1), (int)bottom, (int)(right - 1), (int)(bottom - 1), (int)k);
        LoadingOverlay.m_93172_((PoseStack)matrixStackIn, (int)left, (int)top, (int)(left + 1), (int)bottom, (int)k);
        LoadingOverlay.m_93172_((PoseStack)matrixStackIn, (int)right, (int)top, (int)(right - 1), (int)bottom, (int)k);
    }

    public boolean m_7859_() {
        return true;
    }

    public void update() {
        this.colorBackground = f_96161_.getAsInt();
        this.colorBar = f_96161_.getAsInt();
        this.colorOutline = 0xFFFFFF;
        this.colorProgress = 0xFFFFFF;
        if (!Config.isCustomColors()) {
            return;
        }
        try {
            String fileName = "optifine/color.properties";
            ResourceLocation loc = new ResourceLocation(fileName);
            if (!Config.hasResource((ResourceLocation)loc)) {
                return;
            }
            InputStream in = Config.getResourceStream((ResourceLocation)loc);
            Config.dbg("Loading " + fileName);
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            this.colorBackground = LoadingOverlay.readColor(props, "screen.loading", this.colorBackground);
            this.colorOutline = LoadingOverlay.readColor(props, "screen.loading.outline", this.colorOutline);
            this.colorBar = LoadingOverlay.readColor(props, "screen.loading.bar", this.colorBar);
            this.colorProgress = LoadingOverlay.readColor(props, "screen.loading.progress", this.colorProgress);
            this.blendState = ShaderPackParser.parseBlendState(props.getProperty("screen.loading.blend"));
        }
        catch (Exception e) {
            Config.warn("" + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private static int readColor(Properties props, String name, int colDef) {
        String str = props.getProperty(name);
        if (str == null) {
            return colDef;
        }
        int color = LoadingOverlay.parseColor(str = str.trim(), colDef);
        if (color < 0) {
            Config.warn("Invalid color: " + name + " = " + str);
            return color;
        }
        Config.dbg(name + " = " + str);
        return color;
    }

    private static int parseColor(String str, int colDef) {
        if (str == null) {
            return colDef;
        }
        str = str.trim();
        try {
            int val = Integer.parseInt(str, 16) & 0xFFFFFF;
            return val;
        }
        catch (NumberFormatException e) {
            return colDef;
        }
    }

    public boolean isFadeOut() {
        return this.fadeOut;
    }

    static class LogoTexture
    extends SimpleTexture {
        public LogoTexture() {
            super(f_96160_);
        }

        @Override
        protected SimpleTexture.TextureImage m_6335_(ResourceManager resourceManager) {
            Minecraft minecraft = Minecraft.m_91087_();
            VanillaPackResources vanillapackresources = minecraft.m_91100_().m_118555_();
            try {
                SimpleTexture.TextureImage simpletexture$textureimage;
                try (InputStream inputstream = LogoTexture.getLogoInputStream(resourceManager, vanillapackresources);){
                    simpletexture$textureimage = new SimpleTexture.TextureImage(new TextureMetadataSection(true, true), NativeImage.m_85058_(inputstream));
                }
                return simpletexture$textureimage;
            }
            catch (IOException ioexception) {
                return new SimpleTexture.TextureImage(ioexception);
            }
        }

        private static InputStream getLogoInputStream(ResourceManager resourceManager, VanillaPackResources vanillapack) throws IOException {
            if (resourceManager.m_7165_(f_96160_)) {
                return resourceManager.m_223800_(f_96160_).m_6679_();
            }
            return vanillapack.m_8031_(PackType.CLIENT_RESOURCES, f_96160_);
        }
    }
}

