/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.reflect.Reflector;

public class BossHealthOverlay
extends GuiComponent {
    private static final ResourceLocation f_93697_ = new ResourceLocation("textures/gui/bars.png");
    private static final int f_314151_ = 182;
    private static final int f_314152_ = 5;
    private static final int f_314153_ = 80;
    private final Minecraft f_93698_;
    final Map<UUID, LerpingBossEvent> f_93699_ = Maps.newLinkedHashMap();

    public BossHealthOverlay(Minecraft clientIn) {
        this.f_93698_ = clientIn;
    }

    public void m_93704_(PoseStack p_93704_1_) {
        if (!this.f_93699_.isEmpty()) {
            int i = this.f_93698_.m_91268_().m_85445_();
            int j = 12;
            for (LerpingBossEvent lerpingbossevent : this.f_93699_.values()) {
                int k = i / 2 - 91;
                RenderSystem.m_256242_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean render = true;
                int increment = 19;
                if (Reflector.ForgeHooksClient_bossBarRenderPre.exists()) {
                    Object event = Reflector.ForgeHooksClient_bossBarRenderPre.call(p_93704_1_, this.f_93698_.m_91268_(), lerpingbossevent, k, j, 10 + this.f_93698_.f_91062_.f_92710_);
                    render = !Reflector.callBoolean(event, Reflector.Event_isCanceled, new Object[0]);
                    increment = Reflector.callInt(event, Reflector.RenderGameOverlayEvent_BossInfo_getIncrement, new Object[0]);
                }
                if (render) {
                    RenderSystem.m_256269_((int)0, (ResourceLocation)f_93697_);
                    this.m_93706_(p_93704_1_, k, j, (BossEvent)lerpingbossevent);
                    Component component = lerpingbossevent.m_18861_();
                    int l = this.f_93698_.f_91062_.m_92852_((FormattedText)component);
                    int i1 = i / 2 - l / 2;
                    int j1 = j - 9;
                    int col = 0xFFFFFF;
                    if (Config.isCustomColors()) {
                        col = CustomColors.getBossTextColor(col);
                    }
                    this.f_93698_.f_91062_.m_92763_(p_93704_1_, component, i1, j1, col);
                }
                Reflector.ForgeHooksClient_bossBarRenderPost.callVoid(p_93704_1_, this.f_93698_.m_91268_());
                if ((j += increment) < this.f_93698_.m_91268_().m_85446_() / 3) continue;
                break;
            }
        }
    }

    private void m_93706_(PoseStack p_93706_1_, int p_93706_2_, int p_93706_3_, BossEvent p_93706_4_) {
        int i;
        this.m_93228_(p_93706_1_, p_93706_2_, p_93706_3_, 0, p_93706_4_.m_18862_().ordinal() * 5 * 2, 182, 5);
        if (p_93706_4_.m_18863_() != BossEvent.BossBarOverlay.PROGRESS) {
            this.m_93228_(p_93706_1_, p_93706_2_, p_93706_3_, 0, 80 + (p_93706_4_.m_18863_().ordinal() - 1) * 5 * 2, 182, 5);
        }
        if ((i = (int)(p_93706_4_.m_142050_() * 183.0f)) > 0) {
            this.m_93228_(p_93706_1_, p_93706_2_, p_93706_3_, 0, p_93706_4_.m_18862_().ordinal() * 5 * 2 + 5, i, 5);
            if (p_93706_4_.m_18863_() != BossEvent.BossBarOverlay.PROGRESS) {
                this.m_93228_(p_93706_1_, p_93706_2_, p_93706_3_, 0, 80 + (p_93706_4_.m_18863_().ordinal() - 1) * 5 * 2 + 5, i, 5);
            }
        }
    }

    public void m_93711_(ClientboundBossEventPacket packetIn) {
        packetIn.m_219089_(new ClientboundBossEventPacket.Handler(){

            public void m_141654_(UUID p_141654_1_, Component p_141654_2_, float p_141654_3_, BossEvent.BossBarColor p_141654_4_, BossEvent.BossBarOverlay p_141654_5_, boolean p_141654_6_, boolean p_141654_7_, boolean p_141654_8_) {
                BossHealthOverlay.this.f_93699_.put(p_141654_1_, new LerpingBossEvent(p_141654_1_, p_141654_2_, p_141654_3_, p_141654_4_, p_141654_5_, p_141654_6_, p_141654_7_, p_141654_8_));
            }

            public void m_141918_(UUID p_141918_1_) {
                BossHealthOverlay.this.f_93699_.remove(p_141918_1_);
            }

            public void m_141477_(UUID p_141477_1_, float p_141477_2_) {
                BossHealthOverlay.this.f_93699_.get(p_141477_1_).m_141469_(p_141477_2_);
            }

            public void m_141995_(UUID p_141995_1_, Component p_141995_2_) {
                BossHealthOverlay.this.f_93699_.get(p_141995_1_).m_6456_(p_141995_2_);
            }

            public void m_141449_(UUID p_141449_1_, BossEvent.BossBarColor p_141449_2_, BossEvent.BossBarOverlay p_141449_3_) {
                LerpingBossEvent lerpingbossevent = BossHealthOverlay.this.f_93699_.get(p_141449_1_);
                lerpingbossevent.m_6451_(p_141449_2_);
                lerpingbossevent.m_5648_(p_141449_3_);
            }

            public void m_142051_(UUID p_142051_1_, boolean p_142051_2_, boolean p_142051_3_, boolean p_142051_4_) {
                LerpingBossEvent lerpingbossevent = BossHealthOverlay.this.f_93699_.get(p_142051_1_);
                lerpingbossevent.m_7003_(p_142051_2_);
                lerpingbossevent.m_7005_(p_142051_3_);
                lerpingbossevent.m_7006_(p_142051_4_);
            }
        });
    }

    public void m_93703_() {
        this.f_93699_.clear();
    }

    public boolean m_93713_() {
        if (!this.f_93699_.isEmpty()) {
            for (BossEvent bossEvent : this.f_93699_.values()) {
                if (!bossEvent.m_18865_()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_93714_() {
        if (!this.f_93699_.isEmpty()) {
            for (BossEvent bossEvent : this.f_93699_.values()) {
                if (!bossEvent.m_18864_()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_93715_() {
        if (!this.f_93699_.isEmpty()) {
            for (BossEvent bossEvent : this.f_93699_.values()) {
                if (!bossEvent.m_18866_()) continue;
                return true;
            }
        }
        return false;
    }
}

