/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Screenshot {
    private static final Logger f_92276_ = LogManager.getLogger();
    private static final DateFormat f_92277_ = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private int f_313973_;
    private final DataOutputStream f_313974_;
    private final byte[] f_313975_;
    private final int f_313976_;
    private final int f_313977_;
    private File f_313978_;

    public static void m_321026_(File gameDirectory, RenderTarget buffer, Consumer<Component> messageConsumer) {
        Screenshot.m_321030_(gameDirectory, null, buffer, messageConsumer);
    }

    public static void m_321030_(File gameDirectory, @Nullable String screenshotName, RenderTarget buffer, Consumer<Component> messageConsumer) {
        if (!RenderSystem.m_69586_()) {
            RenderSystem.m_69879_(() -> Screenshot.m_321035_(gameDirectory, screenshotName, buffer, messageConsumer));
        } else {
            Screenshot.m_321035_(gameDirectory, screenshotName, buffer, messageConsumer);
        }
    }

    private static void m_321035_(File gameDirectory, @Nullable String screenshotName, RenderTarget buffer, Consumer<Component> messageConsumer) {
        boolean resize;
        Minecraft mc = Config.getMinecraft();
        Window mainWindow = mc.m_91268_();
        Options gameSettings = Config.getGameSettings();
        int fbWidth = mainWindow.m_85441_();
        int fbHeight = mainWindow.m_85442_();
        int guiScaleOld = gameSettings.f_92072_;
        int guiScale = mainWindow.m_85385_(mc.f_91066_.f_92072_, mc.f_91066_.f_92043_);
        int mul = Config.getScreenshotSize();
        boolean bl = resize = GLX.isUsingFBOs() && mul > 1;
        if (resize) {
            gameSettings.f_92072_ = guiScale * mul;
            mainWindow.resizeFramebuffer(fbWidth * mul, fbHeight * mul);
            GlStateManager.clear(16640);
            mc.m_91385_().m_83947_(true);
            GlStateManager.m_84109_();
            RenderSystem.m_255945_().m_85836_();
            mc.f_91063_.m_109093_(mc.m_91296_(), System.nanoTime(), true);
            RenderSystem.m_255945_().m_85849_();
            RenderSystem.m_255902_();
        }
        NativeImage nativeimage = Screenshot.m_321024_(buffer);
        if (resize) {
            mc.m_91385_().m_83970_();
            Config.getGameSettings().f_92072_ = guiScaleOld;
            mainWindow.resizeFramebuffer(fbWidth, fbHeight);
        }
        File file1 = new File(gameDirectory, "screenshots");
        file1.mkdir();
        File file2 = screenshotName == null ? Screenshot.m_92287_(file1) : new File(file1, screenshotName);
        Object event = null;
        if (Reflector.ForgeHooksClient_onScreenshot.exists()) {
            event = Reflector.call(Reflector.ForgeHooksClient_onScreenshot, nativeimage, file2);
            if (Reflector.callBoolean(event, Reflector.Event_isCanceled, new Object[0])) {
                Component msg = (Component)Reflector.call(event, Reflector.ScreenshotEvent_getCancelMessage, new Object[0]);
                messageConsumer.accept(msg);
                return;
            }
            file2 = (File)Reflector.call(event, Reflector.ScreenshotEvent_getScreenshotFile, new Object[0]);
        }
        File target = file2;
        Object eventF = event;
        Util.m_137579_().execute(() -> {
            try {
                nativeimage.m_85056_(target);
                MutableComponent component = new TextComponent(target.getName()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(p_313985_1_ -> p_313985_1_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, target.getAbsolutePath())));
                if (eventF != null && Reflector.call(eventF, Reflector.ScreenshotEvent_getResultMessage, new Object[0]) != null) {
                    messageConsumer.accept((Component)Reflector.call(eventF, Reflector.ScreenshotEvent_getResultMessage, new Object[0]));
                } else {
                    messageConsumer.accept((Component)new TranslatableComponent("screenshot.success", new Object[]{component}));
                }
            }
            catch (Exception exception) {
                f_92276_.warn("Couldn't save screenshot", (Throwable)exception);
                messageConsumer.accept((Component)new TranslatableComponent("screenshot.failure", new Object[]{exception.getMessage()}));
            }
            finally {
                nativeimage.close();
            }
        });
    }

    public static NativeImage m_321024_(RenderTarget framebufferIn) {
        if (!GLX.isUsingFBOs()) {
            NativeImage nativeimage = new NativeImage(framebufferIn.f_83915_, framebufferIn.f_83916_, false);
            nativeimage.downloadFromFramebuffer(true);
            nativeimage.m_85122_();
            return nativeimage;
        }
        int i = framebufferIn.f_83915_;
        int j = framebufferIn.f_83916_;
        NativeImage nativeimage = new NativeImage(i, j, false);
        RenderSystem.m_69396_((int)framebufferIn.m_83975_());
        nativeimage.m_85045_(0, true);
        nativeimage.m_85122_();
        return nativeimage;
    }

    private static File m_92287_(File gameDirectory) {
        String s = f_92277_.format(new Date());
        int i = 1;
        File file1;
        while ((file1 = new File(gameDirectory, s + (i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file1;
    }

    public Screenshot(File fileIn, int widthIn, int heightIn, int rowHeightIn) throws IOException {
        this.f_313976_ = widthIn;
        this.f_313977_ = heightIn;
        this.f_313973_ = rowHeightIn;
        File file1 = new File(fileIn, "screenshots");
        file1.mkdir();
        DateFormat dateformat = f_92277_;
        String s = "huge_" + dateformat.format(new Date());
        int i = 1;
        while ((this.f_313978_ = new File(file1, s + (i == 1 ? "" : "_" + i) + ".tga")).exists()) {
            ++i;
        }
        byte[] abyte = new byte[18];
        abyte[2] = 2;
        abyte[12] = (byte)(widthIn % 256);
        abyte[13] = (byte)(widthIn / 256);
        abyte[14] = (byte)(heightIn % 256);
        abyte[15] = (byte)(heightIn / 256);
        abyte[16] = 24;
        this.f_313975_ = new byte[widthIn * rowHeightIn * 3];
        this.f_313974_ = new DataOutputStream(new FileOutputStream(this.f_313978_));
        this.f_313974_.write(abyte);
    }

    public void m_313988_(ByteBuffer p_313988_1_, int p_313988_2_, int p_313988_3_, int p_313988_4_, int p_313988_5_) {
        int i = p_313988_4_;
        int j = p_313988_5_;
        if (p_313988_4_ > this.f_313976_ - p_313988_2_) {
            i = this.f_313976_ - p_313988_2_;
        }
        if (p_313988_5_ > this.f_313977_ - p_313988_3_) {
            j = this.f_313977_ - p_313988_3_;
        }
        this.f_313973_ = j;
        for (int k = 0; k < j; ++k) {
            p_313988_1_.position((p_313988_5_ - j) * p_313988_4_ * 3 + k * p_313988_4_ * 3);
            int l = (p_313988_2_ + k * this.f_313976_) * 3;
            p_313988_1_.get(this.f_313975_, l, i * 3);
        }
    }

    public void m_313984_() throws IOException {
        this.f_313974_.write(this.f_313975_, 0, this.f_313976_ * 3 * this.f_313973_);
    }

    public File m_313994_() throws IOException {
        this.f_313974_.close();
        return this.f_313978_;
    }
}

