/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_290;
import net.minecraft.class_796;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.IVertexProducer;
import net.optifine.Config;
import net.optifine.model.BakedQuadRetextured;
import net.optifine.model.QuadBounds;
import net.optifine.reflect.Reflector;
import net.optifine.render.QuadVertexPositions;
import net.optifine.render.VertexPosition;

public class class_777
implements IVertexProducer {
    protected int[] field_4175;
    protected final int field_4174;
    protected class_2350 field_4173;
    protected class_1058 field_4176;
    private final boolean field_22441;
    private int[] vertexDataSingle = null;
    private QuadBounds quadBounds;
    private boolean quadEmissiveChecked;
    private class_777 quadEmissive;
    private QuadVertexPositions quadVertexPositions;

    public class_777(int[] vertexDataIn, int tintIndexIn, class_2350 faceIn, class_1058 spriteIn, boolean shadeIn) {
        this.field_4175 = vertexDataIn;
        this.field_4174 = tintIndexIn;
        this.field_4173 = faceIn;
        this.field_4176 = spriteIn;
        this.field_22441 = shadeIn;
        this.fixVertexData();
    }

    public class_1058 method_35788() {
        if (this.field_4176 == null) {
            this.field_4176 = class_777.getSpriteByUv(this.method_3357());
        }
        return this.field_4176;
    }

    public int[] method_3357() {
        this.fixVertexData();
        return this.field_4175;
    }

    public boolean method_3360() {
        return this.field_4174 != -1;
    }

    public int method_3359() {
        return this.field_4174;
    }

    public class_2350 method_3358() {
        if (this.field_4173 == null) {
            this.field_4173 = class_796.method_3467(this.method_3357());
        }
        return this.field_4173;
    }

    public boolean method_24874() {
        return this.field_22441;
    }

    public int[] getVertexDataSingle() {
        if (this.vertexDataSingle == null) {
            this.vertexDataSingle = class_777.makeVertexDataSingle(this.method_3357(), this.method_35788());
        }
        if (this.vertexDataSingle.length != this.method_3357().length) {
            this.vertexDataSingle = class_777.makeVertexDataSingle(this.method_3357(), this.method_35788());
        }
        return this.vertexDataSingle;
    }

    private static int[] makeVertexDataSingle(int[] vd, class_1058 sprite) {
        int[] vdSingle = (int[])vd.clone();
        int step = vdSingle.length / 4;
        for (int i = 0; i < 4; ++i) {
            int pos = i * step;
            float tu = Float.intBitsToFloat(vdSingle[pos + 4]);
            float tv = Float.intBitsToFloat(vdSingle[pos + 4 + 1]);
            float u = sprite.toSingleU(tu);
            float v = sprite.toSingleV(tv);
            vdSingle[pos + 4] = Float.floatToRawIntBits(u);
            vdSingle[pos + 4 + 1] = Float.floatToRawIntBits(v);
        }
        return vdSingle;
    }

    @Override
    public void pipe(IVertexConsumer consumer) {
        Reflector.callVoid(Reflector.LightUtil_putBakedQuad, consumer, this);
    }

    private static class_1058 getSpriteByUv(int[] vertexData) {
        float uMin = 1.0f;
        float vMin = 1.0f;
        float uMax = 0.0f;
        float vMax = 0.0f;
        int step = vertexData.length / 4;
        for (int i = 0; i < 4; ++i) {
            int pos = i * step;
            float tu = Float.intBitsToFloat(vertexData[pos + 4]);
            float tv = Float.intBitsToFloat(vertexData[pos + 4 + 1]);
            uMin = Math.min(uMin, tu);
            vMin = Math.min(vMin, tv);
            uMax = Math.max(uMax, tu);
            vMax = Math.max(vMax, tv);
        }
        float uMid = (uMin + uMax) / 2.0f;
        float vMid = (vMin + vMax) / 2.0f;
        class_1058 spriteUv = Config.getTextureMap().getIconByUV(uMid, vMid);
        return spriteUv;
    }

    protected void fixVertexData() {
        if (Config.isShaders()) {
            if (this.field_4175.length == class_290.BLOCK_VANILLA_SIZE) {
                this.field_4175 = class_777.fixVertexDataSize(this.field_4175, class_290.BLOCK_SHADERS_SIZE);
            }
        } else if (this.field_4175.length == class_290.BLOCK_SHADERS_SIZE) {
            this.field_4175 = class_777.fixVertexDataSize(this.field_4175, class_290.BLOCK_VANILLA_SIZE);
        }
    }

    private static int[] fixVertexDataSize(int[] vd, int sizeNew) {
        int step = vd.length / 4;
        int stepNew = sizeNew / 4;
        int[] vdNew = new int[stepNew * 4];
        for (int i = 0; i < 4; ++i) {
            int len = Math.min(step, stepNew);
            System.arraycopy(vd, i * step, vdNew, i * stepNew, len);
        }
        return vdNew;
    }

    public QuadBounds getQuadBounds() {
        if (this.quadBounds == null) {
            this.quadBounds = new QuadBounds(this.method_3357());
        }
        return this.quadBounds;
    }

    public float getMidX() {
        QuadBounds qb = this.getQuadBounds();
        return (qb.getMaxX() + qb.getMinX()) / 2.0f;
    }

    public double getMidY() {
        QuadBounds qb = this.getQuadBounds();
        return (qb.getMaxY() + qb.getMinY()) / 2.0f;
    }

    public double getMidZ() {
        QuadBounds qb = this.getQuadBounds();
        return (qb.getMaxZ() + qb.getMinZ()) / 2.0f;
    }

    public boolean isFaceQuad() {
        QuadBounds qb = this.getQuadBounds();
        return qb.isFaceQuad(this.field_4173);
    }

    public boolean isFullQuad() {
        QuadBounds qb = this.getQuadBounds();
        return qb.isFullQuad(this.field_4173);
    }

    public boolean isFullFaceQuad() {
        return this.isFullQuad() && this.isFaceQuad();
    }

    public class_777 getQuadEmissive() {
        if (this.quadEmissiveChecked) {
            return this.quadEmissive;
        }
        if (this.quadEmissive == null && this.field_4176 != null && this.field_4176.spriteEmissive != null) {
            this.quadEmissive = new BakedQuadRetextured(this, this.field_4176.spriteEmissive);
        }
        this.quadEmissiveChecked = true;
        return this.quadEmissive;
    }

    public VertexPosition[] getVertexPositions(int key) {
        if (this.quadVertexPositions == null) {
            this.quadVertexPositions = new QuadVertexPositions();
        }
        return (VertexPosition[])this.quadVertexPositions.get(key);
    }

    public String toString() {
        return "vertexData: " + this.field_4175.length + ", tint: " + this.field_4174 + ", facing: " + this.field_4173 + ", sprite: " + this.field_4176;
    }
}

