/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_3176;
import net.minecraft.class_3309;
import net.minecraft.class_3317;
import net.minecraft.class_3320;
import net.minecraft.class_3324;
import net.minecraft.class_3326;
import net.minecraft.class_3327;
import net.minecraft.class_3335;
import net.minecraft.class_3336;
import net.minecraft.class_3337;
import net.minecraft.class_3340;
import net.minecraft.class_3544;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class class_3321 {
    static final Logger field_14326 = LogManager.getLogger();
    public static final File field_14324 = new File("banned-ips.txt");
    public static final File field_14328 = new File("banned-players.txt");
    public static final File field_14327 = new File("ops.txt");
    public static final File field_14325 = new File("white-list.txt");

    static List<String> method_14543(File file, Map<String, String[]> map) throws IOException {
        List list = Files.readLines((File)file, (Charset)StandardCharsets.UTF_8);
        for (String string : list) {
            if ((string = string.trim()).startsWith("#") || string.length() < 1) continue;
            String[] stringArray = string.split("\\|");
            map.put(stringArray[0].toLowerCase(Locale.ROOT), stringArray);
        }
        return list;
    }

    private static void method_14538(MinecraftServer minecraftServer, Collection<String> collection, ProfileLookupCallback profileLookupCallback) {
        String[] stringArray = (String[])collection.stream().filter(string -> !class_3544.method_15438(string)).toArray(String[]::new);
        if (minecraftServer.method_3828()) {
            minecraftServer.method_3719().findProfilesByNames(stringArray, Agent.MINECRAFT, profileLookupCallback);
        } else {
            for (String string2 : stringArray) {
                UUID uUID = class_1657.method_7271(new GameProfile(null, string2));
                GameProfile \u00e2\u02dc\u01922 = new GameProfile(uUID, string2);
                profileLookupCallback.onProfileLookupSucceeded(\u00e2\u02dc\u01922);
            }
        }
    }

    public static boolean method_14547(final MinecraftServer minecraftServer) {
        final class_3335 class_33352 = new class_3335(class_3324.field_14355);
        if (field_14328.exists() && field_14328.isFile()) {
            if (class_33352.method_14643().exists()) {
                try {
                    class_33352.method_14630();
                }
                catch (IOException iOException) {
                    field_14326.warn("Could not load existing file {}", (Object)class_33352.method_14643().getName(), (Object)iOException);
                }
            }
            try {
                final HashMap hashMap = Maps.newHashMap();
                class_3321.method_14543(field_14328, hashMap);
                ProfileLookupCallback \u00e2\u02dc\u01922 = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameProfile) {
                        minecraftServer.method_3793().method_14508(gameProfile);
                        String[] stringArray = (String[])hashMap.get(gameProfile.getName().toLowerCase(Locale.ROOT));
                        if (stringArray == null) {
                            field_14326.warn("Could not convert user banlist entry for {}", (Object)gameProfile.getName());
                            throw new class_3322("Profile not in the conversionlist");
                        }
                        Date \u00e2\u02dc\u01922 = stringArray.length > 1 ? class_3321.method_14535(stringArray[1], null) : null;
                        String \u00e2\u02dc\u01923 = stringArray.length > 2 ? stringArray[2] : null;
                        Date \u00e2\u02dc\u01924 = stringArray.length > 3 ? class_3321.method_14535(stringArray[3], null) : null;
                        String \u00e2\u02dc\u01925 = stringArray.length > 4 ? stringArray[4] : null;
                        class_33352.method_14633(new class_3336(gameProfile, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925));
                    }

                    public void onProfileLookupFailed(GameProfile gameProfile, Exception exception) {
                        field_14326.warn("Could not lookup user banlist entry for {}", (Object)gameProfile.getName(), (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new class_3322("Could not request user " + gameProfile.getName() + " from backend systems", exception);
                        }
                    }
                };
                class_3321.method_14538(minecraftServer, hashMap.keySet(), \u00e2\u02dc\u01922);
                class_33352.method_14629();
                class_3321.method_14549(field_14328);
            }
            catch (IOException iOException) {
                field_14326.warn("Could not read old user banlist to convert it!", (Throwable)iOException);
                return false;
            }
            catch (class_3322 class_33222) {
                field_14326.error("Conversion failed, please try again later", (Throwable)class_33222);
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean method_14545(MinecraftServer minecraftServer) {
        class_3317 class_33172 = new class_3317(class_3324.field_14364);
        if (field_14324.exists() && field_14324.isFile()) {
            if (class_33172.method_14643().exists()) {
                try {
                    class_33172.method_14630();
                }
                catch (IOException iOException) {
                    field_14326.warn("Could not load existing file {}", (Object)class_33172.method_14643().getName(), (Object)iOException);
                }
            }
            try {
                HashMap hashMap = Maps.newHashMap();
                class_3321.method_14543(field_14324, hashMap);
                for (String string : hashMap.keySet()) {
                    String[] stringArray = (String[])hashMap.get(string);
                    Date \u00e2\u02dc\u01922 = stringArray.length > 1 ? class_3321.method_14535(stringArray[1], null) : null;
                    String \u00e2\u02dc\u01923 = stringArray.length > 2 ? stringArray[2] : null;
                    Date \u00e2\u02dc\u01924 = stringArray.length > 3 ? class_3321.method_14535(stringArray[3], null) : null;
                    String \u00e2\u02dc\u01925 = stringArray.length > 4 ? stringArray[4] : null;
                    class_33172.method_14633(new class_3320(string, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925));
                }
                class_33172.method_14629();
                class_3321.method_14549(field_14324);
            }
            catch (IOException iOException) {
                field_14326.warn("Could not parse old ip banlist to convert it!", (Throwable)iOException);
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean method_14539(final MinecraftServer minecraftServer) {
        final class_3326 class_33262 = new class_3326(class_3324.field_14348);
        if (field_14327.exists() && field_14327.isFile()) {
            if (class_33262.method_14643().exists()) {
                try {
                    class_33262.method_14630();
                }
                catch (IOException iOException) {
                    field_14326.warn("Could not load existing file {}", (Object)class_33262.method_14643().getName(), (Object)iOException);
                }
            }
            try {
                List list = Files.readLines((File)field_14327, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback \u00e2\u02dc\u01922 = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameProfile) {
                        minecraftServer.method_3793().method_14508(gameProfile);
                        class_33262.method_14633(new class_3327(gameProfile, minecraftServer.method_3798(), false));
                    }

                    public void onProfileLookupFailed(GameProfile gameProfile, Exception exception) {
                        field_14326.warn("Could not lookup oplist entry for {}", (Object)gameProfile.getName(), (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new class_3322("Could not request user " + gameProfile.getName() + " from backend systems", exception);
                        }
                    }
                };
                class_3321.method_14538(minecraftServer, list, \u00e2\u02dc\u01922);
                class_33262.method_14629();
                class_3321.method_14549(field_14327);
            }
            catch (IOException iOException) {
                field_14326.warn("Could not read old oplist to convert it!", (Throwable)iOException);
                return false;
            }
            catch (class_3322 class_33222) {
                field_14326.error("Conversion failed, please try again later", (Throwable)class_33222);
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean method_14533(final MinecraftServer minecraftServer) {
        final class_3337 class_33372 = new class_3337(class_3324.field_14343);
        if (field_14325.exists() && field_14325.isFile()) {
            if (class_33372.method_14643().exists()) {
                try {
                    class_33372.method_14630();
                }
                catch (IOException iOException) {
                    field_14326.warn("Could not load existing file {}", (Object)class_33372.method_14643().getName(), (Object)iOException);
                }
            }
            try {
                List list = Files.readLines((File)field_14325, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback \u00e2\u02dc\u01922 = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameProfile) {
                        minecraftServer.method_3793().method_14508(gameProfile);
                        class_33372.method_14633(new class_3340(gameProfile));
                    }

                    public void onProfileLookupFailed(GameProfile gameProfile, Exception exception) {
                        field_14326.warn("Could not lookup user whitelist entry for {}", (Object)gameProfile.getName(), (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new class_3322("Could not request user " + gameProfile.getName() + " from backend systems", exception);
                        }
                    }
                };
                class_3321.method_14538(minecraftServer, list, \u00e2\u02dc\u01922);
                class_33372.method_14629();
                class_3321.method_14549(field_14325);
            }
            catch (IOException iOException) {
                field_14326.warn("Could not read old whitelist to convert it!", (Throwable)iOException);
                return false;
            }
            catch (class_3322 class_33222) {
                field_14326.error("Conversion failed, please try again later", (Throwable)class_33222);
                return false;
            }
            return true;
        }
        return true;
    }

    @Nullable
    public static UUID method_14546(final MinecraftServer minecraftServer2, String string) {
        MinecraftServer minecraftServer2;
        if (class_3544.method_15438(string) || string.length() > 16) {
            try {
                return UUID.fromString(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        Optional<UUID> \u00e2\u02dc\u01922 = minecraftServer2.method_3793().method_14515(string).map(GameProfile::getId);
        if (\u00e2\u02dc\u01922.isPresent()) {
            return \u00e2\u02dc\u01922.get();
        }
        if (minecraftServer2.method_3724() || !minecraftServer2.method_3828()) {
            return class_1657.method_7271(new GameProfile(null, string));
        }
        final ArrayList \u00e2\u02dc\u01923 = Lists.newArrayList();
        ProfileLookupCallback \u00e2\u02dc\u01924 = new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile gameProfile) {
                minecraftServer2.method_3793().method_14508(gameProfile);
                \u00e2\u02dc\u01923.add(gameProfile);
            }

            public void onProfileLookupFailed(GameProfile gameProfile, Exception exception) {
                field_14326.warn("Could not lookup user whitelist entry for {}", (Object)gameProfile.getName(), (Object)exception);
            }
        };
        class_3321.method_14538(minecraftServer2, Lists.newArrayList((Object[])new String[]{string}), \u00e2\u02dc\u01924);
        if (!\u00e2\u02dc\u01923.isEmpty() && ((GameProfile)\u00e2\u02dc\u01923.get(0)).getId() != null) {
            return ((GameProfile)\u00e2\u02dc\u01923.get(0)).getId();
        }
        return null;
    }

    public static boolean method_14550(final class_3176 class_31762) {
        final File file = class_3321.method_14536(class_31762);
        \u00e2\u02dc\u0192 = new File(file.getParentFile(), "playerdata");
        \u00e2\u02dc\u0192 = new File(file.getParentFile(), "unknownplayers");
        if (!file.exists() || !file.isDirectory()) {
            return true;
        }
        File[] \u00e2\u02dc\u01922 = file.listFiles();
        ArrayList \u00e2\u02dc\u01923 = Lists.newArrayList();
        for (File file2 : \u00e2\u02dc\u01922) {
            String string = file2.getName();
            if (!string.toLowerCase(Locale.ROOT).endsWith(".dat") || (\u00e2\u02dc\u0192 = string.substring(0, string.length() - ".dat".length())).isEmpty()) continue;
            \u00e2\u02dc\u01923.add(\u00e2\u02dc\u0192);
        }
        try {
            Object[] objectArray = \u00e2\u02dc\u01923.toArray(new String[\u00e2\u02dc\u01923.size()]);
            ProfileLookupCallback \u00e2\u02dc\u01924 = new ProfileLookupCallback(){
                final /* synthetic */ String[] field_14340;
                {
                    this.field_14340 = stringArray;
                }

                public void onProfileLookupSucceeded(GameProfile gameProfile) {
                    class_31762.method_3793().method_14508(gameProfile);
                    UUID uUID = gameProfile.getId();
                    if (uUID == null) {
                        throw new class_3322("Missing UUID for user profile " + gameProfile.getName());
                    }
                    this.method_14553(\u00e2\u02dc\u0192, this.method_14554(gameProfile), uUID.toString());
                }

                public void onProfileLookupFailed(GameProfile gameProfile, Exception exception) {
                    field_14326.warn("Could not lookup user uuid for {}", (Object)gameProfile.getName(), (Object)exception);
                    if (!(exception instanceof ProfileNotFoundException)) {
                        throw new class_3322("Could not request user " + gameProfile.getName() + " from backend systems", exception);
                    }
                    String string = this.method_14554(gameProfile);
                    this.method_14553(\u00e2\u02dc\u0192, string, string);
                }

                private void method_14553(File file3, String string, String string2) {
                    File file2 = new File(file, string + ".dat");
                    \u00e2\u02dc\u0192 = new File(file3, string2 + ".dat");
                    class_3321.method_14534(file3);
                    if (!file2.renameTo(\u00e2\u02dc\u0192)) {
                        throw new class_3322("Could not convert file for " + string);
                    }
                }

                private String method_14554(GameProfile gameProfile) {
                    String string = null;
                    for (String string2 : this.field_14340) {
                        if (string2 == null || !string2.equalsIgnoreCase(gameProfile.getName())) continue;
                        string = string2;
                        break;
                    }
                    if (string == null) {
                        throw new class_3322("Could not find the filename for " + gameProfile.getName() + " anymore");
                    }
                    return string;
                }
            };
            class_3321.method_14538(class_31762, Lists.newArrayList((Object[])objectArray), \u00e2\u02dc\u01924);
        }
        catch (class_3322 class_33222) {
            field_14326.error("Conversion failed, please try again later", (Throwable)class_33222);
            return false;
        }
        return true;
    }

    static void method_14534(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                return;
            }
            throw new class_3322("Can't create directory " + file.getName() + " in world save directory.");
        }
        if (!file.mkdirs()) {
            throw new class_3322("Can't create directory " + file.getName() + " in world save directory.");
        }
    }

    public static boolean method_14540(MinecraftServer minecraftServer) {
        boolean bl = class_3321.method_14541();
        bl = bl && class_3321.method_14542(minecraftServer);
        return bl;
    }

    private static boolean method_14541() {
        boolean bl = false;
        if (field_14328.exists() && field_14328.isFile()) {
            bl = true;
        }
        \u00e2\u02dc\u0192 = false;
        if (field_14324.exists() && field_14324.isFile()) {
            \u00e2\u02dc\u0192 = true;
        }
        \u00e2\u02dc\u0192 = false;
        if (field_14327.exists() && field_14327.isFile()) {
            \u00e2\u02dc\u0192 = true;
        }
        \u00e2\u02dc\u0192 = false;
        if (field_14325.exists() && field_14325.isFile()) {
            \u00e2\u02dc\u0192 = true;
        }
        if (bl || \u00e2\u02dc\u0192 || \u00e2\u02dc\u0192 || \u00e2\u02dc\u0192) {
            field_14326.warn("**** FAILED TO START THE SERVER AFTER ACCOUNT CONVERSION!");
            field_14326.warn("** please remove the following files and restart the server:");
            if (bl) {
                field_14326.warn("* {}", (Object)field_14328.getName());
            }
            if (\u00e2\u02dc\u0192) {
                field_14326.warn("* {}", (Object)field_14324.getName());
            }
            if (\u00e2\u02dc\u0192) {
                field_14326.warn("* {}", (Object)field_14327.getName());
            }
            if (\u00e2\u02dc\u0192) {
                field_14326.warn("* {}", (Object)field_14325.getName());
            }
            return false;
        }
        return true;
    }

    private static boolean method_14542(MinecraftServer minecraftServer) {
        File file = class_3321.method_14536(minecraftServer);
        if (file.exists() && file.isDirectory() && (file.list().length > 0 || !file.delete())) {
            field_14326.warn("**** DETECTED OLD PLAYER DIRECTORY IN THE WORLD SAVE");
            field_14326.warn("**** THIS USUALLY HAPPENS WHEN THE AUTOMATIC CONVERSION FAILED IN SOME WAY");
            field_14326.warn("** please restart the server and if the problem persists, remove the directory '{}'", (Object)file.getPath());
            return false;
        }
        return true;
    }

    private static File method_14536(MinecraftServer minecraftServer) {
        return minecraftServer.method_27050(class_5218.field_24183).toFile();
    }

    private static void method_14549(File file) {
        \u00e2\u02dc\u0192 = new File(file.getName() + ".converted");
        file.renameTo(\u00e2\u02dc\u0192);
    }

    static Date method_14535(String string, Date date) {
        Date date2;
        try {
            date2 = class_3309.field_14308.parse(string);
        }
        catch (ParseException parseException) {
            date2 = date;
        }
        return date2;
    }

    static class class_3322
    extends RuntimeException {
        class_3322(String string, Throwable throwable) {
            super(string, throwable);
        }

        class_3322(String string) {
            super(string);
        }
    }
}

