/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.class_1130;
import net.minecraft.class_1133;
import net.minecraft.class_1266;
import net.minecraft.class_1276;
import net.minecraft.class_128;
import net.minecraft.class_155;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3283;
import net.minecraft.class_3312;
import net.minecraft.class_3468;
import net.minecraft.class_3695;
import net.minecraft.class_3950;
import net.minecraft.class_5219;
import net.minecraft.class_5350;
import net.minecraft.class_5455;
import net.minecraft.class_6396;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.server.MinecraftServer;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class class_1132
extends MinecraftServer {
    public static final int field_33015 = -1;
    private static final Logger field_5520 = LogManager.getLogger();
    private final class_310 field_5518;
    private boolean field_5524;
    private int field_5522 = -1;
    @Nullable
    private class_1934 field_28075;
    private class_1133 field_5519;
    private UUID field_5521;
    private long ticksSaveLast = 0L;
    public class_1937 difficultyUpdateWorld = null;
    public class_2338 difficultyUpdatePos = null;
    public class_1266 difficultyLast = null;

    public class_1132(Thread threadIn, class_310 mcIn, class_5455.class_5457 regImplIn, class_32.class_5143 levelSaveIn, class_3283 resPackListIn, class_5350 dataPackRegIn, class_5219 serverConfigIn, MinecraftSessionService sessionServiceIn, GameProfileRepository profileRepositoryIn, class_3312 profileCacheIn, class_3950 listenerFactoryIn) {
        super(threadIn, regImplIn, levelSaveIn, serverConfigIn, resPackListIn, mcIn.method_1487(), mcIn.method_1543(), dataPackRegIn, sessionServiceIn, profileRepositoryIn, profileCacheIn, listenerFactoryIn);
        this.method_3849(mcIn.method_1548().method_1676());
        this.method_3730(mcIn.method_1530());
        this.method_3846(new class_1130(this, this.field_25132, this.field_24371));
        this.field_5518 = mcIn;
    }

    @Override
    public boolean method_3823() {
        field_5520.info("Starting integrated minecraft server version {}", (Object)class_155.method_16673().getName());
        this.method_3864(true);
        this.method_3815(true);
        this.method_3745(true);
        this.method_31400();
        if (Reflector.ServerLifecycleHooks_handleServerAboutToStart.exists() && !Reflector.callBoolean(Reflector.ServerLifecycleHooks_handleServerAboutToStart, this)) {
            return false;
        }
        this.method_3735();
        this.method_3834(this.method_3811() + " - " + this.method_27728().method_150());
        if (Reflector.ServerLifecycleHooks_handleServerStarting.exists()) {
            return Reflector.callBoolean(Reflector.ServerLifecycleHooks_handleServerStarting, this);
        }
        return true;
    }

    @Override
    public void method_3748(BooleanSupplier hasTimeLeft) {
        this.onTick();
        boolean flag = this.field_5524;
        this.field_5524 = class_310.method_1551().method_1562() != null && class_310.method_1551().method_1493();
        class_3695 profilerfiller = this.method_16044();
        if (!flag && this.field_5524) {
            profilerfiller.method_15396("autoSave");
            field_5520.info("Saving and pausing game...");
            this.method_3760().method_14617();
            this.method_3723(false, false, false);
            profilerfiller.method_15407();
        }
        if (this.field_5524) {
            this.method_36439();
        } else {
            super.method_3748(hasTimeLeft);
            int i = Math.max(2, this.field_5518.field_1690.field_1870 + -1);
            if (i != this.method_3760().method_14568()) {
                field_5520.info("Changing view distance to {}, from {}", (Object)i, (Object)this.method_3760().method_14568());
                this.method_3760().method_14608(i);
            }
        }
    }

    private void method_36439() {
        for (class_3222 serverplayer : this.method_3760().method_14571()) {
            serverplayer.method_7281(class_3468.field_33558);
        }
    }

    @Override
    public boolean method_3732() {
        return true;
    }

    @Override
    public boolean method_9201() {
        return true;
    }

    @Override
    public File method_3831() {
        return this.field_5518.field_1697;
    }

    @Override
    public boolean method_3816() {
        return false;
    }

    @Override
    public int method_30612() {
        return 0;
    }

    @Override
    public boolean method_3759() {
        return false;
    }

    @Override
    public void method_3744(class_128 report) {
        this.field_5518.method_1494(report);
    }

    @Override
    public class_6396 method_3859(class_6396 report) {
        report.method_37122("Type", "Integrated Server (map_client.txt)");
        report.method_37123("Is Modded", () -> this.method_24307().orElse("Probably not. Jar signature remains and both client + server brands are untouched."));
        return report;
    }

    @Override
    public Optional<String> method_24307() {
        String s = ClientBrandRetriever.getClientModName();
        if (!s.equals("vanilla")) {
            return Optional.of("Definitely; Client brand changed to '" + s + "'");
        }
        s = this.getServerModName();
        if (!"vanilla".equals(s)) {
            return Optional.of("Definitely; Server brand changed to '" + s + "'");
        }
        return class_310.class.getSigners() == null ? Optional.of("Very likely; Jar signature invalidated") : Optional.empty();
    }

    @Override
    public void method_5495(class_1276 snooper) {
        super.method_5495(snooper);
        snooper.method_5481("snooper_partner", this.field_5518.method_1552().method_5479());
    }

    @Override
    public boolean method_35033() {
        return class_310.method_1551().method_35033();
    }

    @Override
    public boolean method_3763(@Nullable class_1934 gameMode, boolean cheats, int port) {
        try {
            this.method_3787().method_14354(null, port);
            field_5520.info("Started serving on {}", (Object)port);
            this.field_5522 = port;
            this.field_5519 = new class_1133(this.method_3818(), "" + port);
            this.field_5519.start();
            this.field_28075 = gameMode;
            this.method_3760().method_14607(cheats);
            int i = this.method_3835(this.field_5518.field_1724.method_7334());
            this.field_5518.field_1724.method_3147(i);
            for (class_3222 serverplayer : this.method_3760().method_14571()) {
                this.method_3734().method_9241(serverplayer);
            }
            return true;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    @Override
    public void method_3782() {
        super.method_3782();
        if (this.field_5519 != null) {
            this.field_5519.interrupt();
            this.field_5519 = null;
        }
    }

    @Override
    public void method_3747(boolean waitForServer) {
        if (!Reflector.MinecraftForge.exists() || this.method_3806()) {
            this.method_19537(() -> {
                for (class_3222 serverplayer : Lists.newArrayList(this.method_3760().method_14571())) {
                    if (serverplayer.method_5667().equals(this.field_5521)) continue;
                    this.method_3760().method_14611(serverplayer);
                }
            });
        }
        super.method_3747(waitForServer);
        if (this.field_5519 != null) {
            this.field_5519.interrupt();
            this.field_5519 = null;
        }
    }

    @Override
    public boolean method_3860() {
        return this.field_5522 > -1;
    }

    @Override
    public int method_3756() {
        return this.field_5522;
    }

    @Override
    public void method_3838(class_1934 gameMode) {
        super.method_3838(gameMode);
        this.field_28075 = null;
    }

    @Override
    public boolean method_3812() {
        return true;
    }

    @Override
    public int method_3798() {
        return 2;
    }

    @Override
    public int method_21714() {
        return 2;
    }

    public void method_4817(UUID uuid) {
        this.field_5521 = uuid;
    }

    @Override
    public boolean method_19466(GameProfile profileIn) {
        return profileIn.getName().equalsIgnoreCase(this.method_3811());
    }

    @Override
    public int method_27903(int distanceIn) {
        return (int)(this.field_5518.field_1690.field_24214 * (float)distanceIn);
    }

    @Override
    public boolean method_27051() {
        return this.field_5518.field_1690.field_25623;
    }

    @Override
    @Nullable
    public class_1934 method_3761() {
        return this.method_3860() ? (class_1934)((Object)MoreObjects.firstNonNull((Object)((Object)this.field_28075), (Object)((Object)this.field_24372.method_210()))) : null;
    }

    private void onTick() {
        Iterable<class_3218> iws = this.method_3738();
        for (class_3218 ws : iws) {
            this.onTick(ws);
        }
    }

    private void onTick(class_3218 ws) {
        if (!Config.isTimeDefault()) {
            this.fixWorldTime(ws);
        }
        if (!Config.isWeatherEnabled()) {
            this.fixWorldWeather(ws);
        }
        if (this.difficultyUpdateWorld == ws && this.difficultyUpdatePos != null) {
            this.difficultyLast = ws.method_8404(this.difficultyUpdatePos);
            this.difficultyUpdateWorld = null;
            this.difficultyUpdatePos = null;
        }
    }

    public class_1266 getDifficultyAsync(class_1937 world, class_2338 blockPos) {
        this.difficultyUpdateWorld = world;
        this.difficultyUpdatePos = blockPos;
        return this.difficultyLast;
    }

    private void fixWorldWeather(class_3218 ws) {
        if (ws.method_8430(1.0f) > 0.0f || ws.method_8546()) {
            ws.method_27910(6000, 0, false, false);
        }
    }

    private void fixWorldTime(class_3218 ws) {
        if (this.method_3790() != class_1934.field_9220) {
            return;
        }
        long time = ws.method_8532();
        long timeOfDay = time % 24000L;
        if (Config.isTimeDayOnly()) {
            if (timeOfDay <= 1000L) {
                ws.method_29199(time - timeOfDay + 1001L);
            }
            if (timeOfDay >= 11000L) {
                ws.method_29199(time - timeOfDay + 24001L);
            }
        }
        if (Config.isTimeNightOnly()) {
            if (timeOfDay <= 14000L) {
                ws.method_29199(time - timeOfDay + 14001L);
            }
            if (timeOfDay >= 22000L) {
                ws.method_29199(time - timeOfDay + 24000L + 14001L);
            }
        }
    }

    @Override
    public boolean method_3723(boolean silentIn, boolean flushIn, boolean commandIn) {
        if (silentIn) {
            int ticksSaveInterval;
            int ticks = this.method_3780();
            if ((long)ticks < this.ticksSaveLast + (long)(ticksSaveInterval = this.field_5518.field_1690.ofAutoSaveTicks)) {
                return false;
            }
            this.ticksSaveLast = ticks;
        }
        return super.method_3723(silentIn, flushIn, commandIn);
    }
}

