/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.Hash;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CharPredicate;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Bootstrap;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.level.block.state.properties.Property;
import net.optifine.SmartExecutorService;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Util {
    private static final AtomicInteger f_137442_ = new AtomicInteger(1);
    private static final ExecutorService f_137443_ = Util.m_137477_("Bootstrap");
    private static final ExecutorService f_137444_ = Util.m_137477_("Main");
    private static final ExecutorService f_137445_ = Util.m_137586_();
    public static LongSupplier f_137440_ = System::nanoTime;
    public static final UUID f_137441_ = new UUID(0L, 0L);
    public static final FileSystemProvider f_300565_ = FileSystemProvider.installedProviders().stream().filter(p_300575_0_ -> p_300575_0_.getScheme().equalsIgnoreCase("jar")).findFirst().orElseThrow(() -> new IllegalStateException("No jar file system provider found"));
    static final Logger f_137446_ = LogManager.getLogger();
    private static Exception exceptionOpenUrl;
    private static final ExecutorService CAPE_EXECUTOR;
    private static LongSupplier INNER_CLASS_SHIFT;

    public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, Map<K, V>> m_137448_() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T extends Comparable<T>> String m_137453_(Property<T> property, Object value) {
        return property.m_6940_((Comparable)value);
    }

    public static String m_137492_(String type, @Nullable ResourceLocation id) {
        return id == null ? type + ".unregistered_sadface" : type + "." + id.m_135827_() + "." + id.m_135815_().replace('/', '.');
    }

    public static long m_137550_() {
        return Util.m_137569_() / 1000000L;
    }

    public static long m_137569_() {
        return f_137440_.getAsLong();
    }

    public static long m_137574_() {
        return Instant.now().toEpochMilli();
    }

    private static ExecutorService m_137477_(String nameIn) {
        int i = Mth.m_14045_(Runtime.getRuntime().availableProcessors() - 1, 1, 7);
        Object executorservice = i <= 0 ? MoreExecutors.newDirectExecutorService() : new ForkJoinPool(i, p_300572_1_ -> {
            ForkJoinWorkerThread forkjoinworkerthread = new ForkJoinWorkerThread(p_300572_1_){

                @Override
                protected void onTermination(Throwable p_onTermination_1_) {
                    if (p_onTermination_1_ != null) {
                        f_137446_.warn("{} died", (Object)this.getName(), (Object)p_onTermination_1_);
                    } else {
                        f_137446_.debug("{} shutdown", (Object)this.getName());
                    }
                    super.onTermination(p_onTermination_1_);
                }
            };
            forkjoinworkerthread.setName("Worker-" + nameIn + "-" + f_137442_.getAndIncrement());
            if (nameIn.equals("Bootstrap")) {
                forkjoinworkerthread.setPriority(1);
            }
            return forkjoinworkerthread;
        }, Util::m_137495_, true);
        if (nameIn.equals("Bootstrap")) {
            executorservice = Util.createSmartExecutor((ExecutorService)executorservice);
        }
        return executorservice;
    }

    private static ExecutorService createSmartExecutor(ExecutorService executor) {
        int cpus = Runtime.getRuntime().availableProcessors();
        if (cpus <= 1) {
            return executor;
        }
        SmartExecutorService smartExecutor = new SmartExecutorService(executor);
        return smartExecutor;
    }

    public static Executor m_137577_() {
        return f_137443_;
    }

    public static Executor m_137578_() {
        return f_137444_;
    }

    public static Executor m_137579_() {
        return f_137445_;
    }

    public static void m_137580_() {
        Util.m_137531_(f_137444_);
        Util.m_137531_(f_137445_);
        Util.m_137531_(CAPE_EXECUTOR);
    }

    private static void m_137531_(ExecutorService serviceIn) {
        boolean flag;
        serviceIn.shutdown();
        try {
            flag = serviceIn.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedexception) {
            flag = false;
        }
        if (!flag) {
            serviceIn.shutdownNow();
        }
    }

    private static ExecutorService m_137586_() {
        return Executors.newCachedThreadPool(p_300570_0_ -> {
            Thread thread = new Thread(p_300570_0_);
            thread.setName("IO-Worker-" + f_137442_.getAndIncrement());
            thread.setUncaughtExceptionHandler(Util::m_137495_);
            return thread;
        });
    }

    public static <T> CompletableFuture<T> m_137498_(Throwable throwableIn) {
        CompletableFuture completablefuture = new CompletableFuture();
        completablefuture.completeExceptionally(throwableIn);
        return completablefuture;
    }

    public static void m_137559_(Throwable throwableIn) {
        throw throwableIn instanceof RuntimeException ? (RuntimeException)throwableIn : new RuntimeException(throwableIn);
    }

    private static void m_137495_(Thread p_137495_0_, Throwable p_137495_1_) {
        Util.m_137570_(p_137495_1_);
        if (p_137495_1_ instanceof CompletionException) {
            p_137495_1_ = p_137495_1_.getCause();
        }
        if (p_137495_1_ instanceof ReportedException) {
            Bootstrap.m_135875_((String)((ReportedException)p_137495_1_).m_134761_().m_127526_());
            System.exit(-1);
        }
        f_137446_.error(String.format("Caught exception in thread %s", p_137495_0_), p_137495_1_);
    }

    @Nullable
    public static Type<?> m_137456_(DSL.TypeReference p_137456_0_, String p_137456_1_) {
        return !SharedConstants.f_136182_ ? null : Util.m_137551_(p_137456_0_, p_137456_1_);
    }

    @Nullable
    private static Type<?> m_137551_(DSL.TypeReference p_137551_0_, String p_137551_1_) {
        Type type;
        block2: {
            type = null;
            try {
                type = DataFixers.m_14512_().getSchema(DataFixUtils.makeKey((int)SharedConstants.m_136187_().getWorldVersion())).getChoiceType(p_137551_0_, p_137551_1_);
            }
            catch (IllegalArgumentException illegalargumentexception) {
                f_137446_.debug("No data fixer registered for {}", (Object)p_137551_1_);
                if (!SharedConstants.f_136183_) break block2;
                throw illegalargumentexception;
            }
        }
        return type;
    }

    public static Runnable m_221726_(String p_221726_0_, Runnable p_221726_1_) {
        return SharedConstants.f_136183_ ? () -> {
            Thread thread = Thread.currentThread();
            String s = thread.getName();
            thread.setName(p_221726_0_);
            try {
                p_221726_1_.run();
            }
            finally {
                thread.setName(s);
            }
        } : p_221726_1_;
    }

    public static OS m_137581_() {
        String s = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (s.contains("win")) {
            return OS.WINDOWS;
        }
        if (s.contains("mac")) {
            return OS.OSX;
        }
        if (s.contains("solaris")) {
            return OS.SOLARIS;
        }
        if (s.contains("sunos")) {
            return OS.SOLARIS;
        }
        if (s.contains("linux")) {
            return OS.LINUX;
        }
        return s.contains("unix") ? OS.LINUX : OS.UNKNOWN;
    }

    public static Stream<String> m_137582_() {
        RuntimeMXBean runtimemxbean = ManagementFactory.getRuntimeMXBean();
        return runtimemxbean.getInputArguments().stream().filter(p_300614_0_ -> p_300614_0_.startsWith("-X"));
    }

    public static <T> T m_137509_(List<T> listIn) {
        return listIn.get(listIn.size() - 1);
    }

    public static <T> T m_137466_(Iterable<T> iterable, @Nullable T element) {
        Iterator<T> iterator = iterable.iterator();
        T t = iterator.next();
        if (element != null) {
            T t1 = t;
            while (t1 != element) {
                if (!iterator.hasNext()) continue;
                t1 = iterator.next();
            }
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        return t;
    }

    public static <T> T m_137554_(Iterable<T> iterable, @Nullable T current) {
        Iterator<T> iterator = iterable.iterator();
        T t = null;
        while (iterator.hasNext()) {
            T t1 = iterator.next();
            if (t1 == current) {
                if (t != null) break;
                t = (T)(iterator.hasNext() ? Iterators.getLast(iterator) : current);
                break;
            }
            t = t1;
        }
        return t;
    }

    public static <T> T m_137537_(Supplier<T> supplier) {
        return supplier.get();
    }

    public static <T> T m_137469_(T object, Consumer<T> consumer) {
        consumer.accept(object);
        return object;
    }

    public static <K> Hash.Strategy<K> m_137583_() {
        return IdentityStrategy.INSTANCE;
    }

    public static <V> CompletableFuture<List<V>> m_137567_(List<? extends CompletableFuture<? extends V>> futuresIn) {
        return futuresIn.stream().reduce(CompletableFuture.completedFuture(Lists.newArrayList()), (p_221769_0_, p_221769_1_) -> p_221769_1_.thenCombine((CompletionStage)p_221769_0_, (p_300567_0_, p_300567_1_) -> {
            ArrayList list = Lists.newArrayListWithCapacity((int)(p_300567_1_.size() + 1));
            list.addAll(p_300567_1_);
            list.add(p_300567_0_);
            return list;
        }), (p_300597_0_, p_300597_1_) -> p_300597_0_.thenCombine((CompletionStage)p_300597_1_, (p_300583_0_, p_300583_1_) -> {
            ArrayList list = Lists.newArrayListWithCapacity((int)(p_300583_0_.size() + p_300583_1_.size()));
            list.addAll(p_300583_0_);
            list.addAll(p_300583_1_);
            return list;
        }));
    }

    public static <V> CompletableFuture<List<V>> m_221809_(List<? extends CompletableFuture<? extends V>> p_221809_0_) {
        ArrayList list = Lists.newArrayListWithCapacity((int)p_221809_0_.size());
        CompletableFuture[] completablefuture = new CompletableFuture[p_221809_0_.size()];
        CompletableFuture completablefuture1 = new CompletableFuture();
        p_221809_0_.forEach(p_300586_3_ -> {
            int i = list.size();
            list.add(null);
            completablefuture[i] = p_300586_3_.whenComplete((p_300591_3_, p_300591_4_) -> {
                if (p_300591_4_ != null) {
                    completablefuture1.completeExceptionally((Throwable)p_300591_4_);
                } else {
                    list.set(i, p_300591_3_);
                }
            });
        });
        return CompletableFuture.allOf(completablefuture).applyToEither((CompletionStage)completablefuture1, p_300580_1_ -> list);
    }

    public static <T> Stream<T> m_137519_(Optional<? extends T> optionalIn) {
        Optional<T> optionalT = optionalIn;
        return optionalT.isPresent() ? Stream.of(optionalT.get()) : Stream.empty();
    }

    public static Exception getExceptionOpenUrl() {
        return exceptionOpenUrl;
    }

    public static void setExceptionOpenUrl(Exception exceptionOpenUrl) {
        Util.exceptionOpenUrl = exceptionOpenUrl;
    }

    public static ExecutorService getCapeExecutor() {
        return CAPE_EXECUTOR;
    }

    public static <T> Optional<T> m_137521_(Optional<T> opt, Consumer<T> consumer, Runnable orElse) {
        if (opt.isPresent()) {
            consumer.accept(opt.get());
        } else {
            orElse.run();
        }
        return opt;
    }

    public static Runnable m_137474_(Runnable runnableIn, Supplier<String> supplierIn) {
        return runnableIn;
    }

    public static void m_221719_(String logTextIn) {
        f_137446_.error(logTextIn);
        if (SharedConstants.f_136183_) {
            Util.m_221812_();
        }
    }

    public static <T extends Throwable> T m_137570_(T throwableIn) {
        if (SharedConstants.f_136183_) {
            f_137446_.error("Trying to throw a fatal exception, pausing in IDE", throwableIn);
            Util.m_221812_();
        }
        return throwableIn;
    }

    private static void m_221812_() {
        try {
            while (true) {
                Thread.sleep(1000L);
                f_137446_.error("paused");
            }
        }
        catch (InterruptedException interruptedexception) {
            return;
        }
    }

    public static String m_137575_(Throwable throwableIn) {
        if (throwableIn.getCause() != null) {
            return Util.m_137575_(throwableIn.getCause());
        }
        return throwableIn.getMessage() != null ? throwableIn.getMessage() : throwableIn.toString();
    }

    public static <T> T m_137545_(T[] valuesIn, Random randomIn) {
        return valuesIn[randomIn.nextInt(valuesIn.length)];
    }

    public static int m_137542_(int[] valuesIn, Random randomIn) {
        return valuesIn[randomIn.nextInt(valuesIn.length)];
    }

    public static <T> T m_221751_(List<T> p_221751_0_, Random p_221751_1_) {
        return p_221751_0_.get(p_221751_1_.nextInt(p_221751_0_.size()));
    }

    private static BooleanSupplier m_137502_(final Path p_137502_0_, final Path p_137502_1_) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    Files.move(p_137502_0_, p_137502_1_, new CopyOption[0]);
                    return true;
                }
                catch (IOException ioexception) {
                    f_137446_.error("Failed to rename", (Throwable)ioexception);
                    return false;
                }
            }

            public String toString() {
                return "rename " + p_137502_0_ + " to " + p_137502_1_;
            }
        };
    }

    private static BooleanSupplier m_137500_(final Path p_137500_0_) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    Files.deleteIfExists(p_137500_0_);
                    return true;
                }
                catch (IOException ioexception) {
                    f_137446_.warn("Failed to delete", (Throwable)ioexception);
                    return false;
                }
            }

            public String toString() {
                return "delete old " + p_137500_0_;
            }
        };
    }

    private static BooleanSupplier m_137561_(final Path p_137561_0_) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return !Files.exists(p_137561_0_, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + p_137561_0_ + " is deleted";
            }
        };
    }

    private static BooleanSupplier m_137572_(final Path p_137572_0_) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return Files.isRegularFile(p_137572_0_, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + p_137572_0_ + " is present";
            }
        };
    }

    private static boolean m_137548_(BooleanSupplier ... p_137548_0_) {
        for (BooleanSupplier booleansupplier : p_137548_0_) {
            if (booleansupplier.getAsBoolean()) continue;
            f_137446_.warn("Failed to execute {}", (Object)booleansupplier);
            return false;
        }
        return true;
    }

    private static boolean m_137449_(int p_137449_0_, String p_137449_1_, BooleanSupplier ... p_137449_2_) {
        for (int i = 0; i < p_137449_0_; ++i) {
            if (Util.m_137548_(p_137449_2_)) {
                return true;
            }
            f_137446_.error("Failed to {}, retrying {}/{}", (Object)p_137449_1_, (Object)i, (Object)p_137449_0_);
        }
        f_137446_.error("Failed to {}, aborting, progress might be lost", (Object)p_137449_1_);
        return false;
    }

    public static void m_137462_(File p_137462_0_, File p_137462_1_, File p_137462_2_) {
        Util.m_137505_(p_137462_0_.toPath(), p_137462_1_.toPath(), p_137462_2_.toPath());
    }

    public static void m_137505_(Path p_137505_0_, Path p_137505_1_, Path p_137505_2_) {
        int i = 10;
        if ((!Files.exists(p_137505_0_, new LinkOption[0]) || Util.m_137449_(10, "create backup " + p_137505_2_, Util.m_137500_(p_137505_2_), Util.m_137502_(p_137505_0_, p_137505_2_), Util.m_137572_(p_137505_2_))) && Util.m_137449_(10, "remove old " + p_137505_0_, Util.m_137500_(p_137505_0_), Util.m_137561_(p_137505_0_)) && !Util.m_137449_(10, "replace " + p_137505_0_ + " with " + p_137505_1_, Util.m_137502_(p_137505_1_, p_137505_0_), Util.m_137572_(p_137505_0_))) {
            Util.m_137449_(10, "restore " + p_137505_0_ + " from " + p_137505_2_, Util.m_137502_(p_137505_2_, p_137505_0_), Util.m_137572_(p_137505_0_));
        }
    }

    public static int m_137479_(String p_137479_0_, int p_137479_1_, int p_137479_2_) {
        int i = p_137479_0_.length();
        if (p_137479_2_ >= 0) {
            for (int j = 0; p_137479_1_ < i && j < p_137479_2_; ++j) {
                if (!Character.isHighSurrogate(p_137479_0_.charAt(p_137479_1_++)) || p_137479_1_ >= i || !Character.isLowSurrogate(p_137479_0_.charAt(p_137479_1_))) continue;
                ++p_137479_1_;
            }
        } else {
            for (int k = p_137479_2_; p_137479_1_ > 0 && k < 0; ++k) {
                if (!Character.isLowSurrogate(p_137479_0_.charAt(--p_137479_1_)) || p_137479_1_ <= 0 || !Character.isHighSurrogate(p_137479_0_.charAt(p_137479_1_ - 1))) continue;
                --p_137479_1_;
            }
        }
        return p_137479_1_;
    }

    public static Consumer<String> m_137489_(String p_137489_0_, Consumer<String> p_137489_1_) {
        return p_300602_2_ -> p_137489_1_.accept(p_137489_0_ + p_300602_2_);
    }

    public static DataResult<int[]> m_137539_(IntStream p_137539_0_, int p_137539_1_) {
        int[] aint = p_137539_0_.limit(p_137539_1_ + 1).toArray();
        if (aint.length != p_137539_1_) {
            String s = "Input is not a list of " + p_137539_1_ + " ints";
            return aint.length >= p_137539_1_ ? DataResult.error((String)s, (Object)Arrays.copyOf(aint, p_137539_1_)) : DataResult.error((String)s);
        }
        return DataResult.success((Object)aint);
    }

    public static <T> DataResult<List<T>> m_300577_(List<T> p_300577_0_, int p_300577_1_) {
        if (p_300577_0_.size() != p_300577_1_) {
            String s = "Input is not a list of " + p_300577_1_ + " elements";
            return p_300577_0_.size() >= p_300577_1_ ? DataResult.error((String)s, p_300577_0_.subList(0, p_300577_1_)) : DataResult.error((String)s);
        }
        return DataResult.success(p_300577_0_);
    }

    public static void m_137584_() {
        Thread thread = new Thread("Timer hack thread"){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(Integer.MAX_VALUE);
                    }
                }
                catch (InterruptedException interruptedexception) {
                    f_137446_.warn("Timer hack thread interrupted, that really should not happen");
                    return;
                }
            }
        };
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(f_137446_));
        thread.start();
    }

    public static void m_137563_(Path p_137563_0_, Path p_137563_1_, Path p_137563_2_) throws IOException {
        Path path = p_137563_0_.relativize(p_137563_2_);
        Path path1 = p_137563_1_.resolve(path);
        Files.copy(p_137563_2_, path1, new CopyOption[0]);
    }

    public static String m_137483_(String p_137483_0_, CharPredicate p_137483_1_) {
        return p_137483_0_.toLowerCase(Locale.ROOT).chars().mapToObj(p_300608_1_ -> p_137483_1_.m_125854_((char)p_300608_1_) ? Character.toString((char)p_300608_1_) : "_").collect(Collectors.joining());
    }

    public static <T, R> Function<T, R> m_300606_(final Function<T, R> p_300606_0_) {
        return new Function<T, R>(){
            private final Map<T, R> cache = Maps.newHashMap();

            @Override
            public R apply(T p_apply_1_) {
                return this.cache.computeIfAbsent(p_apply_1_, p_300606_0_);
            }

            public String toString() {
                return "memoize/1[function=" + p_300606_0_ + ", size=" + this.cache.size() + "]";
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> m_300600_(final BiFunction<T, U, R> p_300600_0_) {
        return new BiFunction<T, U, R>(){
            private final Map<Pair<T, U>, R> f_300618_ = Maps.newHashMap();

            @Override
            public R apply(T p_apply_1_, U p_apply_2_) {
                return this.f_300618_.computeIfAbsent(Pair.of(p_apply_1_, p_apply_2_), p_300628_1_ -> p_300600_0_.apply(p_300628_1_.getFirst(), p_300628_1_.getSecond()));
            }

            public String toString() {
                return "memoize/2[function=" + p_300600_0_ + ", size=" + this.f_300618_.size() + "]";
            }
        };
    }

    static {
        CAPE_EXECUTOR = Util.m_137477_("Cape");
        INNER_CLASS_SHIFT = () -> 0L;
    }

    public static enum OS {
        LINUX,
        SOLARIS,
        WINDOWS{

            @Override
            protected String[] m_6868_(URL url) {
                return new String[]{"rundll32", "url.dll,FileProtocolHandler", url.toString()};
            }
        }
        ,
        OSX{

            @Override
            protected String[] m_6868_(URL url) {
                return new String[]{"open", url.toString()};
            }
        }
        ,
        UNKNOWN;


        public void m_137650_(URL url) {
            try {
                Process process = AccessController.doPrivileged(() -> Runtime.getRuntime().exec(this.m_6868_(url)));
                for (String s : IOUtils.readLines((InputStream)process.getErrorStream())) {
                    f_137446_.error(s);
                }
                process.getInputStream().close();
                process.getErrorStream().close();
                process.getOutputStream().close();
            }
            catch (IOException | PrivilegedActionException privilegedactionexception) {
                f_137446_.error("Couldn't open url '{}'", (Object)url, (Object)privilegedactionexception);
                exceptionOpenUrl = privilegedactionexception;
            }
        }

        public void m_137648_(URI uri) {
            try {
                this.m_137650_(uri.toURL());
            }
            catch (MalformedURLException malformedurlexception) {
                f_137446_.error("Couldn't open uri '{}'", (Object)uri, (Object)malformedurlexception);
            }
        }

        public void m_137644_(File fileIn) {
            try {
                this.m_137650_(fileIn.toURI().toURL());
            }
            catch (MalformedURLException malformedurlexception) {
                f_137446_.error("Couldn't open file '{}'", (Object)fileIn, (Object)malformedurlexception);
            }
        }

        protected String[] m_6868_(URL url) {
            String s = url.toString();
            if ("file".equals(url.getProtocol())) {
                s = s.replace("file:", "file://");
            }
            return new String[]{"xdg-open", s};
        }

        public void m_137646_(String uri) {
            try {
                this.m_137650_(new URI(uri).toURL());
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException urisyntaxexception) {
                f_137446_.error("Couldn't open uri '{}'", (Object)uri, (Object)urisyntaxexception);
            }
        }
    }

    static enum IdentityStrategy implements Hash.Strategy<Object>
    {
        INSTANCE;


        public int hashCode(Object p_hashCode_1_) {
            return System.identityHashCode(p_hashCode_1_);
        }

        public boolean equals(Object p_equals_1_, Object p_equals_2_) {
            return p_equals_1_ == p_equals_2_;
        }
    }
}

