/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1008;
import net.minecraft.class_1041;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_6177;
import net.minecraft.class_757;
import net.optifine.Config;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.Version;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;

@class_6177
public class GLX {
    private static final Logger LOGGER = LogManager.getLogger();
    private static String cpuInfo;

    public static String getOpenGLVersionString() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GLFW.glfwGetCurrentContext() == 0L ? "NO CONTEXT" : GlStateManager._getString(7937) + " GL version " + GlStateManager._getString(7938) + ", " + GlStateManager._getString(7936);
    }

    public static int _getRefreshRate(class_1041 windowIn) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        long i = GLFW.glfwGetWindowMonitor((long)windowIn.method_4490());
        if (i == 0L) {
            i = GLFW.glfwGetPrimaryMonitor();
        }
        GLFWVidMode glfwvidmode = i == 0L ? null : GLFW.glfwGetVideoMode((long)i);
        return glfwvidmode == null ? 0 : glfwvidmode.refreshRate();
    }

    public static String _getLWJGLVersion() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return Version.getVersion();
    }

    public static LongSupplier _initGlfw() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        class_1041.method_4492((errorIn, errorTextIn) -> {
            throw new IllegalStateException(String.format("GLFW error before init: [0x%X]%s", errorIn, errorTextIn));
        });
        ArrayList list = Lists.newArrayList();
        GLFWErrorCallback glfwerrorcallback = GLFW.glfwSetErrorCallback((errorIn, errorTextIn) -> list.add(String.format("GLFW error during init: [0x%X]%s", errorIn, errorTextIn)));
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Failed to initialize GLFW, errors: " + Joiner.on((String)",").join((Iterable)list));
        }
        LongSupplier longsupplier = () -> (long)(GLFW.glfwGetTime() * 1.0E9);
        for (String s : list) {
            LOGGER.error("GLFW error collected during initialization: {}", (Object)s);
        }
        RenderSystem.setErrorCallback((GLFWErrorCallbackI)glfwerrorcallback);
        return longsupplier;
    }

    public static void _setGlfwErrorCallback(GLFWErrorCallbackI errorCallbackIn) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLFWErrorCallback glfwerrorcallback = GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)errorCallbackIn);
        if (glfwerrorcallback != null) {
            glfwerrorcallback.free();
        }
    }

    public static boolean _shouldClose(class_1041 windowIn) {
        return GLFW.glfwWindowShouldClose((long)windowIn.method_4490());
    }

    public static void _init(int debugVerbosityIn, boolean debugSyncIn) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLCapabilities glcapabilities = GL.getCapabilities();
        GlStateManager.init(glcapabilities);
        try {
            CentralProcessor centralprocessor = new SystemInfo().getHardware().getProcessor();
            cpuInfo = String.format("%dx %s", centralprocessor.getLogicalProcessorCount(), centralprocessor.getProcessorIdentifier().getName()).replaceAll("\\s+", " ");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        class_1008.method_4227(debugVerbosityIn, debugSyncIn);
    }

    public static String _getCpuInfo() {
        return cpuInfo == null ? "<unknown>" : cpuInfo;
    }

    public static void _renderCrosshair(int sizeIn, boolean drawX, boolean drawY, boolean drawZ) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager._disableTexture();
        GlStateManager._depthMask(false);
        GlStateManager._disableCull();
        RenderSystem.setShader(class_757::method_34535);
        class_289 tesselator = RenderSystem.renderThreadTesselator();
        class_287 bufferbuilder = tesselator.method_1349();
        RenderSystem.lineWidth(4.0f);
        bufferbuilder.method_1328(class_293.class_5596.field_27377, class_290.field_29337);
        if (drawX) {
            bufferbuilder.method_22912(0.0, 0.0, 0.0).method_1336(0, 0, 0, 255).method_22914(1.0f, 0.0f, 0.0f).method_1344();
            bufferbuilder.method_22912(sizeIn, 0.0, 0.0).method_1336(0, 0, 0, 255).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        }
        if (drawY) {
            bufferbuilder.method_22912(0.0, 0.0, 0.0).method_1336(0, 0, 0, 255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
            bufferbuilder.method_22912(0.0, sizeIn, 0.0).method_1336(0, 0, 0, 255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        }
        if (drawZ) {
            bufferbuilder.method_22912(0.0, 0.0, 0.0).method_1336(0, 0, 0, 255).method_22914(0.0f, 0.0f, 1.0f).method_1344();
            bufferbuilder.method_22912(0.0, 0.0, sizeIn).method_1336(0, 0, 0, 255).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        }
        tesselator.method_1350();
        RenderSystem.lineWidth(2.0f);
        bufferbuilder.method_1328(class_293.class_5596.field_27377, class_290.field_29337);
        if (drawX) {
            bufferbuilder.method_22912(0.0, 0.0, 0.0).method_1336(255, 0, 0, 255).method_22914(1.0f, 0.0f, 0.0f).method_1344();
            bufferbuilder.method_22912(sizeIn, 0.0, 0.0).method_1336(255, 0, 0, 255).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        }
        if (drawY) {
            bufferbuilder.method_22912(0.0, 0.0, 0.0).method_1336(0, 255, 0, 255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
            bufferbuilder.method_22912(0.0, sizeIn, 0.0).method_1336(0, 255, 0, 255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        }
        if (drawZ) {
            bufferbuilder.method_22912(0.0, 0.0, 0.0).method_1336(127, 127, 255, 255).method_22914(0.0f, 0.0f, 1.0f).method_1344();
            bufferbuilder.method_22912(0.0, 0.0, sizeIn).method_1336(127, 127, 255, 255).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        }
        tesselator.method_1350();
        RenderSystem.lineWidth(1.0f);
        GlStateManager._enableCull();
        GlStateManager._depthMask(true);
        GlStateManager._enableTexture();
    }

    public static <T> T make(Supplier<T> supplierIn) {
        return supplierIn.get();
    }

    public static <T> T make(T objIn, Consumer<T> consumerIn) {
        consumerIn.accept(objIn);
        return objIn;
    }

    public static boolean isUsingFBOs() {
        return !Config.isAntialiasing();
    }

    public static boolean useVbo() {
        return true;
    }
}

