/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_1767;
import net.minecraft.class_2484;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_437;
import net.minecraft.class_486;
import net.minecraft.class_557;
import net.minecraft.class_5598;
import net.minecraft.class_5602;
import net.minecraft.class_613;
import net.minecraft.class_630;
import net.minecraft.class_756;
import net.minecraft.class_824;
import net.minecraft.class_827;
import net.minecraft.class_828;
import net.minecraft.class_836;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_922;
import net.minecraft.class_955;
import net.optifine.Config;
import net.optifine.Log;
import net.optifine.entity.model.CustomEntityModelParser;
import net.optifine.entity.model.CustomEntityRenderer;
import net.optifine.entity.model.CustomModelRegistry;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.anim.ModelResolver;
import net.optifine.entity.model.anim.ModelUpdater;
import net.optifine.reflect.Reflector;
import net.optifine.util.Either;
import net.optifine.util.StrUtils;

public class CustomEntityModels {
    private static boolean active = false;
    private static Map<class_1299, class_897> originalEntityRenderMap = null;
    private static Map<class_2591, class_827> originalTileEntityRenderMap = null;
    private static Map<class_2484.class_2485, class_5598> originalSkullModelMap = null;
    private static List<class_2591> customTileEntityTypes = new ArrayList<class_2591>();
    private static class_557 customBookModel;
    private static boolean debugModels;

    public static void update() {
        Map<class_1299, class_897> entityRenderMap = CustomEntityModels.getEntityRenderMap();
        Map<class_2591, class_827> tileEntityRenderMap = CustomEntityModels.getTileEntityRenderMap();
        Map<class_2484.class_2485, class_5598> skullModelMap = CustomEntityModels.getSkullModelMap();
        if (entityRenderMap == null) {
            Config.warn("Entity render map not found, custom entity models are DISABLED.");
            return;
        }
        if (tileEntityRenderMap == null) {
            Config.warn("Tile entity render map not found, custom entity models are DISABLED.");
            return;
        }
        active = false;
        entityRenderMap.clear();
        tileEntityRenderMap.clear();
        skullModelMap.clear();
        customTileEntityTypes.clear();
        entityRenderMap.putAll(originalEntityRenderMap);
        tileEntityRenderMap.putAll(originalTileEntityRenderMap);
        skullModelMap.putAll(originalSkullModelMap);
        class_756 blockEntityRenderer = class_310.method_1551().method_1480().getBlockEntityRenderer();
        blockEntityRenderer.field_3985 = new class_613(ModelAdapter.bakeModelLayer(class_5602.field_27668));
        customBookModel = null;
        class_827.CACHED_TYPES.clear();
        if (!Config.isCustomEntityModels()) {
            return;
        }
        class_2960[] locs = CustomEntityModels.getModelLocations();
        for (int i = 0; i < locs.length; ++i) {
            class_2960 loc = locs[i];
            Config.dbg("CustomEntityModel: " + loc.method_12832());
            IEntityRenderer rc = CustomEntityModels.parseEntityRender(loc);
            if (rc == null) continue;
            Either<class_1299, class_2591> type = rc.getType();
            if (rc instanceof class_897) {
                class_955 tr;
                class_613 tm;
                entityRenderMap.put(type.getLeft().get(), (class_897)rc);
                if (rc instanceof class_955 && (tm = (class_613)Reflector.getFieldValue(tr = (class_955)rc, Reflector.RenderTrident_modelTrident)) != null) {
                    blockEntityRenderer.field_3985 = tm;
                }
            } else if (rc instanceof class_827) {
                tileEntityRenderMap.put(type.getRight().get(), (class_827)rc);
                if (rc instanceof class_828) {
                    class_828 etr = (class_828)rc;
                    class_557 bm = (class_557)Reflector.getFieldValue(etr, Reflector.TileEntityEnchantmentTableRenderer_modelBook);
                    CustomEntityModels.setEnchantmentScreenBookModel(bm);
                }
                customTileEntityTypes.add(type.getRight().get());
            } else {
                Config.warn("Unknown renderer type: " + rc.getClass().getName());
            }
            active = true;
        }
    }

    private static void setEnchantmentScreenBookModel(class_557 bookModel) {
        customBookModel = bookModel;
    }

    private static Map<class_1299, class_897> getEntityRenderMap() {
        class_898 rm = class_310.method_1551().method_1561();
        Map entityRenderMap = rm.getEntityRenderMap();
        if (entityRenderMap == null) {
            return null;
        }
        if (originalEntityRenderMap == null) {
            originalEntityRenderMap = new HashMap<class_1299, class_897>(entityRenderMap);
        }
        return entityRenderMap;
    }

    private static Map<class_2591, class_827> getTileEntityRenderMap() {
        class_824 blockEntityRenderDispatcher = class_310.method_1551().method_31975();
        Map tileEntityRenderMap = blockEntityRenderDispatcher.getBlockEntityRenderMap();
        if (originalTileEntityRenderMap == null) {
            originalTileEntityRenderMap = new HashMap<class_2591, class_827>(tileEntityRenderMap);
        }
        return tileEntityRenderMap;
    }

    private static Map<class_2484.class_2485, class_5598> getSkullModelMap() {
        HashMap skullModelMap = class_836.models;
        if (skullModelMap == null) {
            Config.warn("Field not found: SkullBlockRenderer.MODELS");
            skullModelMap = new HashMap();
        }
        if (originalSkullModelMap == null) {
            originalSkullModelMap = new HashMap<class_2484.class_2485, class_5598>(skullModelMap);
        }
        return skullModelMap;
    }

    private static class_2960[] getModelLocations() {
        String prefix = "optifine/cem/";
        String suffix = ".jem";
        ArrayList<class_2960> resourceLocations = new ArrayList<class_2960>();
        String[] names = CustomModelRegistry.getModelNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String path = prefix + name + suffix;
            class_2960 loc = new class_2960(path);
            if (!Config.hasResource(loc) && !debugModels) continue;
            resourceLocations.add(loc);
        }
        class_2960[] locs = resourceLocations.toArray(new class_2960[resourceLocations.size()]);
        return locs;
    }

    private static IEntityRenderer parseEntityRender(class_2960 location) {
        try {
            if (debugModels) {
                return CustomEntityModels.makeDebugEntityRenderer(location);
            }
            JsonObject jo = CustomEntityModelParser.loadJson(location);
            IEntityRenderer render = CustomEntityModels.parseEntityRender(jo, location.method_12832());
            return render;
        }
        catch (IOException e) {
            Config.error("" + e.getClass().getName() + ": " + e.getMessage());
            return null;
        }
        catch (JsonParseException e) {
            Config.error("" + ((Object)((Object)e)).getClass().getName() + ": " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            Log.warn("Error loading CEM: " + location, e);
            return null;
        }
    }

    private static IEntityRenderer makeDebugEntityRenderer(class_2960 loc) {
        String path = loc.method_12832();
        String nameJem = StrUtils.removePrefix(path, "optifine/cem/");
        String name = StrUtils.removeSuffix(nameJem, ".jem");
        ModelAdapter ma = CustomModelRegistry.getModelAdapter(name);
        class_3879 model = ma.makeModel();
        class_1767[] colors = class_1767.values();
        int offset = Math.abs(loc.hashCode()) % 256;
        String[] partNames = ma.getModelRendererNames();
        for (int i = 0; i < partNames.length; ++i) {
            String partName = partNames[i];
            class_630 part = ma.getModelRenderer(model, partName);
            if (part == null) continue;
            class_1767 col = colors[(i + offset) % colors.length];
            class_2960 locTexture = new class_2960("textures/block/" + col.method_15434() + "_stained_glass.png");
            part.setTextureLocation(locTexture);
            Config.dbg("  " + partName + ": " + col.method_15434());
        }
        IEntityRenderer er = ma.makeEntityRender(model, ma.getShadowSize());
        if (er == null) {
            return null;
        }
        er.setType(ma.getType());
        return er;
    }

    private static IEntityRenderer parseEntityRender(JsonObject obj, String path) {
        CustomEntityRenderer cer = CustomEntityModelParser.parseEntityRender(obj, path);
        String name = cer.getName();
        ModelAdapter modelAdapter = CustomModelRegistry.getModelAdapter(name);
        CustomEntityModels.checkNull(modelAdapter, "Entity not found: " + name);
        Either<class_1299, class_2591> type = modelAdapter.getType();
        CustomEntityModels.checkNull(type, "Entity type not found: " + name);
        IEntityRenderer render = CustomEntityModels.makeEntityRender(modelAdapter, cer);
        if (render == null) {
            return null;
        }
        render.setType(type);
        return render;
    }

    private static IEntityRenderer makeEntityRender(ModelAdapter modelAdapter, CustomEntityRenderer cer) {
        class_3879 model;
        class_2960 textureLocation = cer.getTextureLocation();
        CustomModelRenderer[] modelRenderers = cer.getCustomModelRenderers();
        float shadowSize = cer.getShadowSize();
        if (shadowSize < 0.0f) {
            shadowSize = modelAdapter.getShadowSize();
        }
        if ((model = modelAdapter.makeModel()) == null) {
            return null;
        }
        ModelResolver mr = new ModelResolver(modelAdapter, model, modelRenderers);
        if (!CustomEntityModels.modifyModel(modelAdapter, model, modelRenderers, mr)) {
            return null;
        }
        IEntityRenderer r = modelAdapter.makeEntityRender(model, shadowSize);
        if (r == null) {
            throw new JsonParseException("Entity renderer is null, model: " + modelAdapter.getName() + ", adapter: " + modelAdapter.getClass().getName());
        }
        if (textureLocation != null) {
            CustomEntityModels.setTextureLocation(modelAdapter, model, r, textureLocation);
        }
        return r;
    }

    private static void setTextureLocation(ModelAdapter modelAdapter, class_3879 model, IEntityRenderer er, class_2960 textureLocation) {
        if (modelAdapter.setTextureLocation(er, textureLocation)) {
            return;
        }
        if (er instanceof class_922) {
            er.setLocationTextureCustom(textureLocation);
            return;
        }
        CustomEntityModels.setTextureTopModelRenderers(modelAdapter, model, textureLocation);
    }

    public static void setTextureTopModelRenderers(ModelAdapter modelAdapter, class_3879 model, class_2960 textureLocation) {
        String[] parts = modelAdapter.getModelRendererNames();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            class_630 modelRenderer = modelAdapter.getModelRenderer(model, part);
            if (modelRenderer == null || modelRenderer.getTextureLocation() != null) continue;
            modelRenderer.setTextureLocation(textureLocation);
        }
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, class_3879 model, CustomModelRenderer[] modelRenderers, ModelResolver mr) {
        for (int i = 0; i < modelRenderers.length; ++i) {
            CustomModelRenderer cmr = modelRenderers[i];
            if (CustomEntityModels.modifyModel(modelAdapter, model, cmr, mr)) continue;
            return false;
        }
        return true;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, class_3879 model, CustomModelRenderer customModelRenderer, ModelResolver modelResolver) {
        String modelPart = customModelRenderer.getModelPart();
        class_630 parent = modelAdapter.getModelRenderer(model, modelPart);
        if (parent == null) {
            Config.warn("Model part not found: " + modelPart + ", model: " + model);
            return false;
        }
        if (!customModelRenderer.isAttach()) {
            if (parent.field_3663 != null) {
                parent.field_3663.clear();
            }
            if (parent.spriteList != null) {
                parent.spriteList.clear();
            }
            if (parent.field_3661 != null) {
                class_630[] mrs = modelAdapter.getModelRenderers(model);
                Set setMrs = Collections.newSetFromMap(new IdentityHashMap());
                setMrs.addAll(Arrays.asList(mrs));
                HashSet childModelKeys = new HashSet(parent.field_3661.keySet());
                for (String key : childModelKeys) {
                    class_630 mr = (class_630)parent.field_3661.get(key);
                    if (setMrs.contains(mr)) continue;
                    parent.field_3661.remove(key);
                }
            }
        }
        parent.addChildModel("CEM-" + modelPart, customModelRenderer.getModelRenderer());
        ModelUpdater mu = customModelRenderer.getModelUpdater();
        if (mu != null) {
            modelResolver.setThisModelRenderer(customModelRenderer.getModelRenderer());
            modelResolver.setPartModelRenderer(parent);
            if (!mu.initialize(modelResolver)) {
                return false;
            }
            customModelRenderer.getModelRenderer().setModelUpdater(mu);
        }
        return true;
    }

    private static void checkNull(Object obj, String msg) {
        if (obj == null) {
            throw new JsonParseException(msg);
        }
    }

    public static boolean isActive() {
        return active;
    }

    public static boolean isCustomModel(class_2680 blockStateIn) {
        for (int i = 0; i < customTileEntityTypes.size(); ++i) {
            class_2591 type = customTileEntityTypes.get(i);
            if (!type.method_20526(blockStateIn)) continue;
            return true;
        }
        return false;
    }

    public static void onRenderScreen(class_437 screen) {
        if (customBookModel != null && screen instanceof class_486) {
            class_486 es = (class_486)screen;
            Reflector.GuiEnchantment_bookModel.setValue(es, customBookModel);
        }
    }

    static {
        debugModels = Boolean.getBoolean("cem.debug.models");
    }
}

