/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.config;

import java.util.Arrays;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.optifine.Config;
import net.optifine.util.StrUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class NbtTagValue {
    private String[] parents = null;
    private String name = null;
    private boolean negative = false;
    private int type = 0;
    private String value = null;
    private int valueFormat = 0;
    private static final int TYPE_TEXT = 0;
    private static final int TYPE_PATTERN = 1;
    private static final int TYPE_IPATTERN = 2;
    private static final int TYPE_REGEX = 3;
    private static final int TYPE_IREGEX = 4;
    private static final String PREFIX_PATTERN = "pattern:";
    private static final String PREFIX_IPATTERN = "ipattern:";
    private static final String PREFIX_REGEX = "regex:";
    private static final String PREFIX_IREGEX = "iregex:";
    private static final int FORMAT_DEFAULT = 0;
    private static final int FORMAT_HEX_COLOR = 1;
    private static final String PREFIX_HEX_COLOR = "#";
    private static final Pattern PATTERN_HEX_COLOR = Pattern.compile("^#[0-9a-f]{6}+$");

    public NbtTagValue(String tag, String value) {
        String[] names = Config.tokenize(tag, ".");
        this.parents = Arrays.copyOfRange(names, 0, names.length - 1);
        this.name = names[names.length - 1];
        if (value.startsWith("!")) {
            this.negative = true;
            value = value.substring(1);
        }
        if (value.startsWith(PREFIX_PATTERN)) {
            this.type = 1;
            value = value.substring(PREFIX_PATTERN.length());
        } else if (value.startsWith(PREFIX_IPATTERN)) {
            this.type = 2;
            value = value.substring(PREFIX_IPATTERN.length()).toLowerCase();
        } else if (value.startsWith(PREFIX_REGEX)) {
            this.type = 3;
            value = value.substring(PREFIX_REGEX.length());
        } else if (value.startsWith(PREFIX_IREGEX)) {
            this.type = 4;
            value = value.substring(PREFIX_IREGEX.length()).toLowerCase();
        } else {
            this.type = 0;
        }
        value = StringEscapeUtils.unescapeJava((String)value);
        if (this.type == 0 && PATTERN_HEX_COLOR.matcher(value).matches()) {
            this.valueFormat = 1;
        }
        this.value = value;
    }

    public boolean matches(class_2487 nbt) {
        if (this.negative) {
            return !this.matchesCompound(nbt);
        }
        return this.matchesCompound(nbt);
    }

    public boolean matchesCompound(class_2487 nbt) {
        if (nbt == null) {
            return false;
        }
        class_2487 tagBase = nbt;
        for (int i = 0; i < this.parents.length; ++i) {
            String tag = this.parents[i];
            if ((tagBase = NbtTagValue.getChildTag((class_2520)tagBase, tag)) != null) continue;
            return false;
        }
        if (this.name.equals("*")) {
            return this.matchesAnyChild((class_2520)tagBase);
        }
        if ((tagBase = NbtTagValue.getChildTag((class_2520)tagBase, this.name)) == null) {
            return false;
        }
        return this.matchesBase((class_2520)tagBase);
    }

    private boolean matchesAnyChild(class_2520 tagBase) {
        if (tagBase instanceof class_2487) {
            class_2487 tagCompound = (class_2487)tagBase;
            Set nbtKeySet = tagCompound.method_10541();
            for (String key : nbtKeySet) {
                class_2520 nbtBase = tagCompound.method_10580(key);
                if (!this.matchesBase(nbtBase)) continue;
                return true;
            }
        }
        if (tagBase instanceof class_2499) {
            class_2499 tagList = (class_2499)tagBase;
            int count = tagList.size();
            for (int i = 0; i < count; ++i) {
                class_2520 nbtBase = tagList.method_10534(i);
                if (!this.matchesBase(nbtBase)) continue;
                return true;
            }
        }
        return false;
    }

    private static class_2520 getChildTag(class_2520 tagBase, String tag) {
        if (tagBase instanceof class_2487) {
            class_2487 tagCompound = (class_2487)tagBase;
            return tagCompound.method_10580(tag);
        }
        if (tagBase instanceof class_2499) {
            class_2499 tagList = (class_2499)tagBase;
            if (tag.equals("count")) {
                return class_2497.method_23247((int)tagList.size());
            }
            int index = Config.parseInt(tag, -1);
            if (index < 0 || index >= tagList.size()) {
                return null;
            }
            return tagList.method_10534(index);
        }
        return null;
    }

    public boolean matchesBase(class_2520 nbtBase) {
        if (nbtBase == null) {
            return false;
        }
        String nbtValue = NbtTagValue.getNbtString(nbtBase, this.valueFormat);
        return this.matchesValue(nbtValue);
    }

    public boolean matchesValue(String nbtValue) {
        if (nbtValue == null) {
            return false;
        }
        switch (this.type) {
            case 0: {
                return nbtValue.equals(this.value);
            }
            case 1: {
                return this.matchesPattern(nbtValue, this.value);
            }
            case 2: {
                return this.matchesPattern(nbtValue.toLowerCase(), this.value);
            }
            case 3: {
                return this.matchesRegex(nbtValue, this.value);
            }
            case 4: {
                return this.matchesRegex(nbtValue.toLowerCase(), this.value);
            }
        }
        throw new IllegalArgumentException("Unknown NbtTagValue type: " + this.type);
    }

    private boolean matchesPattern(String str, String pattern) {
        return StrUtils.equalsMask(str, pattern, '*', '?');
    }

    private boolean matchesRegex(String str, String regex) {
        return str.matches(regex);
    }

    private static String getNbtString(class_2520 nbtBase, int format) {
        if (nbtBase == null) {
            return null;
        }
        if (nbtBase instanceof class_2519) {
            class_2519 nbtString = (class_2519)nbtBase;
            String text = nbtString.method_10714();
            if (text.startsWith("{") && text.endsWith("}")) {
                text = NbtTagValue.getMergedJsonText(text);
            } else if (text.startsWith("[{") && text.endsWith("}]")) {
                text = NbtTagValue.getMergedJsonText(text);
            }
            return text;
        }
        if (nbtBase instanceof class_2497) {
            class_2497 i = (class_2497)nbtBase;
            if (format == 1) {
                return PREFIX_HEX_COLOR + StrUtils.fillLeft(Integer.toHexString(i.method_10701()), 6, '0');
            }
            return Integer.toString(i.method_10701());
        }
        if (nbtBase instanceof class_2481) {
            class_2481 b = (class_2481)nbtBase;
            return Byte.toString(b.method_10698());
        }
        if (nbtBase instanceof class_2516) {
            class_2516 s = (class_2516)nbtBase;
            return Short.toString(s.method_10696());
        }
        if (nbtBase instanceof class_2503) {
            class_2503 l = (class_2503)nbtBase;
            return Long.toString(l.method_10699());
        }
        if (nbtBase instanceof class_2494) {
            class_2494 f = (class_2494)nbtBase;
            return Float.toString(f.method_10700());
        }
        if (nbtBase instanceof class_2489) {
            class_2489 d = (class_2489)nbtBase;
            return Double.toString(d.method_10697());
        }
        return nbtBase.toString();
    }

    private static String getMergedJsonText(String text) {
        StringBuilder sb = new StringBuilder();
        String TOKEN_TEXT = "\"text\":\"";
        int pos = -1;
        while ((pos = text.indexOf(TOKEN_TEXT, pos + 1)) >= 0) {
            String str = NbtTagValue.parseString(text, pos + TOKEN_TEXT.length());
            if (str == null) continue;
            sb.append(str);
        }
        return sb.toString();
    }

    private static String parseString(String text, int pos) {
        StringBuilder sb = new StringBuilder();
        boolean escapeMode = false;
        for (int i = pos; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (escapeMode) {
                if (ch == 'b') {
                    sb.append('\b');
                } else if (ch == 'f') {
                    sb.append('\f');
                } else if (ch == 'n') {
                    sb.append('\n');
                } else if (ch == 'r') {
                    sb.append('\r');
                } else if (ch == 't') {
                    sb.append('\t');
                } else {
                    sb.append(ch);
                }
                escapeMode = false;
                continue;
            }
            if (ch == '\\') {
                escapeMode = true;
                continue;
            }
            if (ch == '\"') break;
            sb.append(ch);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.parents.length; ++i) {
            String parent = this.parents[i];
            if (i > 0) {
                sb.append(".");
            }
            sb.append(parent);
        }
        if (sb.length() > 0) {
            sb.append(".");
        }
        sb.append(this.name);
        sb.append(" = ");
        sb.append(this.value);
        return sb.toString();
    }
}

