/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1471;
import net.minecraft.class_1498;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_761;
import net.minecraft.class_824;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntity;
import net.optifine.RandomEntityProperties;
import net.optifine.RandomTileEntity;
import net.optifine.reflect.ReflectorRaw;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;

public class RandomEntities {
    private static Map<String, RandomEntityProperties> mapProperties = new HashMap<String, RandomEntityProperties>();
    private static boolean active = false;
    private static class_761 renderGlobal;
    private static RandomEntity randomEntity;
    private static class_824 tileEntityRendererDispatcher;
    private static RandomTileEntity randomTileEntity;
    private static boolean working;
    public static final String SUFFIX_PNG = ".png";
    public static final String SUFFIX_PROPERTIES = ".properties";
    public static final String PREFIX_TEXTURES_ENTITY = "textures/entity/";
    public static final String PREFIX_TEXTURES_PAINTING = "textures/painting/";
    public static final String PREFIX_TEXTURES = "textures/";
    public static final String PREFIX_OPTIFINE_RANDOM = "optifine/random/";
    public static final String PREFIX_OPTIFINE_MOB = "optifine/mob/";
    private static final String[] DEPENDANT_SUFFIXES;
    private static final String PREFIX_DYNAMIC_TEXTURE_HORSE = "horse/";
    private static final String[] HORSE_TEXTURES;
    private static final String[] HORSE_TEXTURES_ABBR;

    public static void entityLoaded(class_1297 entity, class_1937 world) {
        if (world == null) {
            return;
        }
        class_2945 edm = entity.method_5841();
        edm.spawnPosition = entity.method_24515();
        edm.spawnBiome = world.method_23753(edm.spawnPosition);
        if (entity instanceof class_1471) {
            class_1471 esr = (class_1471)entity;
            RandomEntities.checkEntityShoulder(esr, false);
        }
    }

    public static void entityUnloaded(class_1297 entity, class_1937 world) {
        if (entity instanceof class_1471) {
            class_1471 esr = (class_1471)entity;
            RandomEntities.checkEntityShoulder(esr, true);
        }
    }

    private static void checkEntityShoulder(class_1471 entity, boolean attach) {
        class_1309 owner = entity.method_6177();
        if (owner == null) {
            owner = Config.getMinecraft().field_1724;
        }
        if (!(owner instanceof class_742)) {
            return;
        }
        class_742 player = (class_742)owner;
        UUID entityUuid = entity.method_5667();
        if (attach) {
            class_2487 nbtRight;
            class_2487 nbtLeft = player.method_7356();
            if (nbtLeft != null && nbtLeft.method_10545("UUID") && Config.equals(nbtLeft.method_25926("UUID"), entityUuid)) {
                player.entityShoulderLeft = entity;
            }
            if ((nbtRight = player.method_7308()) != null && nbtRight.method_10545("UUID") && Config.equals(nbtRight.method_25926("UUID"), entityUuid)) {
                player.entityShoulderRight = entity;
            }
        } else {
            class_2945 edm = entity.method_5841();
            if (player.entityShoulderLeft != null && Config.equals(player.entityShoulderLeft.method_5667(), entityUuid)) {
                class_2945 edmShoulderLeft = player.entityShoulderLeft.method_5841();
                edm.spawnPosition = edmShoulderLeft.spawnPosition;
                edm.spawnBiome = edmShoulderLeft.spawnBiome;
                player.entityShoulderLeft = null;
            }
            if (player.entityShoulderRight != null && Config.equals(player.entityShoulderRight.method_5667(), entityUuid)) {
                class_2945 edmShoulderRight = player.entityShoulderRight.method_5841();
                edm.spawnPosition = edmShoulderRight.spawnPosition;
                edm.spawnBiome = edmShoulderRight.spawnBiome;
                player.entityShoulderRight = null;
            }
        }
    }

    public static void worldChanged(class_1937 oldWorld, class_1937 newWorld) {
        if (newWorld instanceof class_638) {
            class_638 newWorldClient = (class_638)newWorld;
            Iterable entities = newWorldClient.method_18112();
            for (class_1297 entity : entities) {
                RandomEntities.entityLoaded(entity, newWorld);
            }
        }
        randomEntity.setEntity(null);
        randomTileEntity.setTileEntity(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static class_2960 getTextureLocation(class_2960 loc) {
        if (!active) {
            return loc;
        }
        if (working) {
            return loc;
        }
        try {
            working = true;
            IRandomEntity re = RandomEntities.getRandomEntityRendered();
            if (re == null) {
                class_2960 class_29602 = loc;
                return class_29602;
            }
            String name = loc.method_12832();
            if (name.startsWith(PREFIX_DYNAMIC_TEXTURE_HORSE)) {
                name = RandomEntities.getHorseTexturePath(name, PREFIX_DYNAMIC_TEXTURE_HORSE.length());
            }
            if (!name.startsWith(PREFIX_TEXTURES_ENTITY) && !name.startsWith(PREFIX_TEXTURES_PAINTING)) {
                class_2960 class_29603 = loc;
                return class_29603;
            }
            RandomEntityProperties props = mapProperties.get(name);
            if (props == null) {
                class_2960 class_29604 = loc;
                return class_29604;
            }
            class_2960 class_29605 = props.getTextureLocation(loc, re);
            return class_29605;
        }
        finally {
            working = false;
        }
    }

    private static String getHorseTexturePath(String path, int pos) {
        if (HORSE_TEXTURES == null || HORSE_TEXTURES_ABBR == null) {
            return path;
        }
        for (int i = 0; i < HORSE_TEXTURES_ABBR.length; ++i) {
            String abbr = HORSE_TEXTURES_ABBR[i];
            if (!path.startsWith(abbr, pos)) continue;
            return HORSE_TEXTURES[i];
        }
        return path;
    }

    public static IRandomEntity getRandomEntityRendered() {
        if (RandomEntities.renderGlobal.renderedEntity != null) {
            randomEntity.setEntity(RandomEntities.renderGlobal.renderedEntity);
            return randomEntity;
        }
        if (class_824.tileEntityRendered != null) {
            class_2586 te = class_824.tileEntityRendered;
            if (te.method_10997() != null) {
                randomTileEntity.setTileEntity(te);
                return randomTileEntity;
            }
        }
        return null;
    }

    private static RandomEntityProperties makeProperties(class_2960 loc, boolean optifine) {
        RandomEntityProperties props;
        String path = loc.method_12832();
        class_2960 locProps = RandomEntities.getLocationProperties(loc, optifine);
        if (locProps != null && (props = RandomEntities.parseProperties(locProps, loc)) != null) {
            return props;
        }
        class_2960[] variants = RandomEntities.getLocationsVariants(loc, optifine);
        if (variants == null) {
            return null;
        }
        return new RandomEntityProperties(path, variants);
    }

    private static RandomEntityProperties parseProperties(class_2960 propLoc, class_2960 resLoc) {
        try {
            String path = propLoc.method_12832();
            RandomEntities.dbg(resLoc.method_12832() + ", properties: " + path);
            InputStream in = Config.getResourceStream(propLoc);
            if (in == null) {
                RandomEntities.warn("Properties not found: " + path);
                return null;
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            RandomEntityProperties rmp = new RandomEntityProperties(props, path, resLoc);
            if (!rmp.isValid(path)) {
                return null;
            }
            return rmp;
        }
        catch (FileNotFoundException e) {
            RandomEntities.warn("File not found: " + resLoc.method_12832());
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class_2960 getLocationProperties(class_2960 loc, boolean optifine) {
        String path;
        String pathBase;
        String pathProps;
        class_2960 locMcp = RandomEntities.getLocationRandom(loc, optifine);
        if (locMcp == null) {
            return null;
        }
        String domain = locMcp.method_12836();
        class_2960 locProps = new class_2960(domain, pathProps = (pathBase = StrUtils.removeSuffix(path = locMcp.method_12832(), SUFFIX_PNG)) + SUFFIX_PROPERTIES);
        if (Config.hasResource(locProps)) {
            return locProps;
        }
        String pathParent = RandomEntities.getParentTexturePath(pathBase);
        if (pathParent == null) {
            return null;
        }
        class_2960 locParentProps = new class_2960(domain, pathParent + SUFFIX_PROPERTIES);
        if (Config.hasResource(locParentProps)) {
            return locParentProps;
        }
        return null;
    }

    protected static class_2960 getLocationRandom(class_2960 loc, boolean optifine) {
        String domain = loc.method_12836();
        String path = loc.method_12832();
        String prefixTextures = PREFIX_TEXTURES;
        String prefixRandom = PREFIX_OPTIFINE_RANDOM;
        if (optifine) {
            prefixTextures = PREFIX_TEXTURES_ENTITY;
            prefixRandom = PREFIX_OPTIFINE_MOB;
        }
        if (!path.startsWith(prefixTextures)) {
            return null;
        }
        String pathRandom = StrUtils.replacePrefix(path, prefixTextures, prefixRandom);
        return new class_2960(domain, pathRandom);
    }

    private static String getPathBase(String pathRandom) {
        if (pathRandom.startsWith(PREFIX_OPTIFINE_RANDOM)) {
            return StrUtils.replacePrefix(pathRandom, PREFIX_OPTIFINE_RANDOM, PREFIX_TEXTURES);
        }
        if (pathRandom.startsWith(PREFIX_OPTIFINE_MOB)) {
            return StrUtils.replacePrefix(pathRandom, PREFIX_OPTIFINE_MOB, PREFIX_TEXTURES_ENTITY);
        }
        return null;
    }

    protected static class_2960 getLocationIndexed(class_2960 loc, int index) {
        if (loc == null) {
            return null;
        }
        String path = loc.method_12832();
        int pos = path.lastIndexOf(46);
        if (pos < 0) {
            return null;
        }
        String prefix = path.substring(0, pos);
        String suffix = path.substring(pos);
        String pathNew = prefix + index + suffix;
        class_2960 locNew = new class_2960(loc.method_12836(), pathNew);
        return locNew;
    }

    private static String getParentTexturePath(String path) {
        for (int i = 0; i < DEPENDANT_SUFFIXES.length; ++i) {
            String suffix = DEPENDANT_SUFFIXES[i];
            if (!path.endsWith(suffix)) continue;
            String pathParent = StrUtils.removeSuffix(path, suffix);
            return pathParent;
        }
        return null;
    }

    private static class_2960[] getLocationsVariants(class_2960 loc, boolean optifine) {
        ArrayList<class_2960> list = new ArrayList<class_2960>();
        list.add(loc);
        class_2960 locRandom = RandomEntities.getLocationRandom(loc, optifine);
        if (locRandom == null) {
            return null;
        }
        for (int i = 1; i < list.size() + 10; ++i) {
            int index = i + 1;
            class_2960 locIndex = RandomEntities.getLocationIndexed(locRandom, index);
            if (!Config.hasResource(locIndex)) continue;
            list.add(locIndex);
        }
        if (list.size() <= 1) {
            return null;
        }
        class_2960[] locs = list.toArray(new class_2960[list.size()]);
        RandomEntities.dbg(loc.method_12832() + ", variants: " + locs.length);
        return locs;
    }

    public static void update() {
        mapProperties.clear();
        active = false;
        if (!Config.isRandomEntities()) {
            return;
        }
        RandomEntities.initialize();
    }

    private static void initialize() {
        renderGlobal = Config.getRenderGlobal();
        tileEntityRendererDispatcher = class_310.method_1551().method_31975();
        String[] prefixes = new String[]{PREFIX_OPTIFINE_RANDOM, PREFIX_OPTIFINE_MOB};
        String[] suffixes = new String[]{SUFFIX_PNG, SUFFIX_PROPERTIES};
        String[] pathsRandom = ResUtils.collectFiles(prefixes, suffixes);
        HashSet<String> basePathsChecked = new HashSet<String>();
        for (int i = 0; i < pathsRandom.length; ++i) {
            RandomEntityProperties props;
            String path = pathsRandom[i];
            path = StrUtils.removeSuffix(path, suffixes);
            path = StrUtils.trimTrailing(path, "0123456789");
            String pathBase = RandomEntities.getPathBase(path = path + SUFFIX_PNG);
            if (basePathsChecked.contains(pathBase)) continue;
            basePathsChecked.add(pathBase);
            class_2960 locBase = new class_2960(pathBase);
            if (!Config.hasResource(locBase) || (props = mapProperties.get(pathBase)) != null) continue;
            props = RandomEntities.makeProperties(locBase, false);
            if (props == null) {
                props = RandomEntities.makeProperties(locBase, true);
            }
            if (props == null) continue;
            mapProperties.put(pathBase, props);
        }
        active = !mapProperties.isEmpty();
    }

    public static void dbg(String str) {
        Config.dbg("RandomEntities: " + str);
    }

    public static void warn(String str) {
        Config.warn("RandomEntities: " + str);
    }

    static {
        randomEntity = new RandomEntity();
        randomTileEntity = new RandomTileEntity();
        working = false;
        DEPENDANT_SUFFIXES = new String[]{"_armor", "_eyes", "_exploding", "_shooting", "_fur", "_eyes", "_invulnerable", "_angry", "_tame", "_collar"};
        HORSE_TEXTURES = (String[])ReflectorRaw.getFieldValue(null, class_1498.class, String[].class, 0);
        HORSE_TEXTURES_ABBR = (String[])ReflectorRaw.getFieldValue(null, class_1498.class, String[].class, 1);
    }
}

