/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry.sync;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.fabric.impl.registry.sync.RemapException;
import net.fabricmc.fabric.impl.registry.sync.RemappableRegistry;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentDynamicRegistryHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void remapDynamicRegistries(class_5455.class_5457 dynamicRegistryManager, Path saveDir) {
        class_2487 registryData;
        LOGGER.debug("Starting registry remap");
        try {
            registryData = PersistentDynamicRegistryHandler.remapDynamicRegistries(dynamicRegistryManager, PersistentDynamicRegistryHandler.readCompoundTag(PersistentDynamicRegistryHandler.getDataPath(saveDir)));
        }
        catch (IOException | RemapException e) {
            throw new RuntimeException("Failed to read dynamic registry data", e);
        }
        PersistentDynamicRegistryHandler.writeCompoundTag(registryData, PersistentDynamicRegistryHandler.getDataPath(saveDir));
    }

    @NotNull
    private static class_2487 remapDynamicRegistries(class_5455.class_5457 dynamicRegistryManager, @Nullable class_2487 existingTag) throws RemapException {
        class_2487 registries = new class_2487();
        class_2487 biomeRegistryData = null;
        if (existingTag != null) {
            biomeRegistryData = existingTag.method_10562(class_2378.field_25114.method_29177().toString());
        }
        class_2385 registry = (class_2385)dynamicRegistryManager.method_30530(class_2378.field_25114);
        class_2487 biomeIdMap = PersistentDynamicRegistryHandler.remapRegistry(class_2378.field_25114.method_29177(), registry, biomeRegistryData);
        registries.method_10566(class_2378.field_25114.method_29177().toString(), (class_2520)biomeIdMap);
        return registries;
    }

    private static <T> class_2487 remapRegistry(class_2960 registryId, class_2385<T> registry, @Nullable class_2487 existingTag) throws RemapException {
        if (!(registry instanceof RemappableRegistry)) {
            throw new UnsupportedOperationException("Cannot remap un re-mappable registry: " + registryId.toString());
        }
        boolean isModified = registry.method_10235().stream().anyMatch(id -> !id.method_12836().equals("minecraft"));
        if (existingTag != null && !isModified) {
            isModified = existingTag.method_10541().stream().map(arg_0 -> ((class_2487)existingTag).method_10558(arg_0)).map(class_2960::new).anyMatch(id -> !id.method_12836().equals("minecraft"));
        }
        if (LOGGER.isDebugEnabled()) {
            if (existingTag == null) {
                LOGGER.debug("No existing data found, assuming new registry with {} entries. modded = {}", (Object)registry.method_10235().size(), (Object)isModified);
            } else {
                LOGGER.debug("Existing registry data found. modded = {}", (Object)isModified);
                for (Object entry : registry) {
                    class_2960 id2 = registry.method_10221(entry);
                    int rawId = registry.method_10206(entry);
                    if (id2 == null || rawId < 0) continue;
                    if (existingTag.method_10541().contains(id2.toString())) {
                        int existingRawId = existingTag.method_10550(id2.toString());
                        if (rawId != existingRawId) {
                            LOGGER.debug("Remapping {} {} -> {}", (Object)id2.toString(), (Object)rawId, (Object)existingRawId);
                            continue;
                        }
                        LOGGER.debug("Using existing id for {} {}", (Object)id2.toString(), (Object)rawId);
                        continue;
                    }
                    LOGGER.debug("Found new registry entry {}", (Object)id2.toString());
                }
            }
        }
        if (existingTag != null && isModified) {
            LOGGER.debug("Remapping {} with {} entries", (Object)registryId, (Object)registry.method_10235().size());
            Object2IntOpenHashMap idMap = new Object2IntOpenHashMap();
            for (String key : existingTag.method_10541()) {
                idMap.put((Object)new class_2960(key), existingTag.method_10550(key));
            }
            ((RemappableRegistry)registry).remap(registryId.toString(), (Object2IntMap<class_2960>)idMap, RemappableRegistry.RemapMode.AUTHORITATIVE);
        } else {
            LOGGER.debug("Skipping remap of {}", (Object)registryId);
        }
        class_2487 registryTag = new class_2487();
        for (Object entry : registry) {
            class_2960 id3 = registry.method_10221(entry);
            if (id3 == null) continue;
            int rawId = registry.method_10206(entry);
            registryTag.method_10569(id3.toString(), rawId);
        }
        if (existingTag != null) {
            for (String key : existingTag.method_10541()) {
                if (registryTag.method_10545(key)) continue;
                LOGGER.debug("Saving orphaned registry entry: " + key);
                registryTag.method_10569(key, existingTag.method_10550(key));
            }
        }
        return registryTag;
    }

    private static Path getDataPath(Path saveDir) {
        return saveDir.resolve("data").resolve("fabricDynamicRegistry.dat");
    }

    @Nullable
    private static class_2487 readCompoundTag(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            class_2487 compoundTag = class_2507.method_10629((InputStream)inputStream);
            if (!compoundTag.method_10545("version") || !compoundTag.method_10545("registries") || compoundTag.method_10550("version") != 1) {
                throw new UnsupportedOperationException("Unsupported dynamic registry data format. Try updating?");
            }
            class_2487 class_24872 = compoundTag.method_10562("registries");
            return class_24872;
        }
    }

    private static void writeCompoundTag(class_2487 compoundTag, Path path) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.CREATE);){
                class_2487 outputTag = new class_2487();
                outputTag.method_10569("version", 1);
                outputTag.method_10566("registries", (class_2520)compoundTag);
                class_2507.method_10634((class_2487)outputTag, (OutputStream)outputStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

